@Echo off
ECHO Setting up ICAT Debug Information

rem  CATDEBUG.CMD - ICAT debug output settings

rem  Typically, the only recognized settings for any of the CAT_DEBUG
rem  environment variables are ALL and/or ON.  Any other setting will
rem  cause the environment variable to be ignored.

rem  CAT_DEBUG - recognized settings are:
rem    ALL - all other settings are ignored and *everything* is output
rem    ON - use the individual settings which follow

SET CAT_DEBUG=ON

rem  CAT_DEBUG.IPROBECALLS - recognized settings are:
rem    ALL - individual CAT_DEBUG.IPROBECALL* settings are ignored and
rem            all are assumed ON
rem    ON - use the individual settings for each CAT_DEBUG.IPROBE_CALL*
rem            environment variable

SET CAT_DEBUG.IPROBECALLS=ON

rem  The only recognized setting for Individual CAT_DEBUG.IPROBECALL*
rem  variables is ON.  Note that non-SUCCESS return codes are always
rem  output as long as CAT_DEBUG.IPROBECALLS is ALL or ON.
rem    CAT_DEBUG.IPROBECALLBEEP - beep on each iprobe call
rem    CAT_DEBUG.IPROBECALLINPUT - display iprobe_* call input
rem    CAT_DEBUG.IPROBECALLOUTPUT - display iprobe_* call output
rem    CAT_DEBUG.IPROBECALLRC - display all iprobe_* call return codes
rem    CAT_DEBUG.IPROBECALLTIMER - display iprobe_* call elapsed time

SET CAT_DEBUG.IPROBECALLBEEP=OFF
SET CAT_DEBUG.IPROBECALLINPUT=ON
SET CAT_DEBUG.IPROBECALLOUTPUT=ON
SET CAT_DEBUG.IPROBECALLRC=ON
SET CAT_DEBUG.IPROBECALLTIMER=OFF

rem  The following environment variables control how much info is output
rem  to the debug file during debug file initialization.  The only
rem  recognized setting for each is ON.
rem    CAT_DEBUG.ENVIRONMENT - display ICAT environment variables
rem    CAT_DEBUG.SYSINFO - display ICAT host IP address and OS/2 version

SET CAT_DEBUG.ENVIRONMENT=ON
SET CAT_DEBUG.SYSINFO=ON

rem  The following environment variables control whether or not the debug
rem  engine can output certain messages.  The only recognized setting for
rem  each is ON.

SET CAT_DEBUG.MESSAGE=ON
SET CAT_DEBUG.MODULEINFO=ON
SET CAT_DEBUG.OBJECTINFO=ON
SET CAT_DEBUG.THREADINFO=ON
SET CAT_DEBUG.CALLFNINFO=ON

