/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FATTRS;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int tabs;
    int oldStart;
    int oldEnd;
    short textLimit = 0;
    boolean doubleClick;
    boolean ignoreVerify;
    boolean ignoreCharacter;
    public static final int LIMIT = Short.MAX_VALUE;
    public static final String DELIMITER = "\r\n";
    static final int EditProc;
    static final int FieldProc;
    static final PSZ EditClass;
    static final PSZ FieldClass;

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 2) != 0) {
            return OS.WinCallWindowProc(EditProc, this.handle, msg, mp1, mp2);
        }
        return OS.WinCallWindowProc(FieldProc, this.handle, msg, mp1, mp2);
    }

    void createHandle() {
        super.createHandle();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 432, -1, 0);
        } else {
            OS.WinSendMsg(this.handle, 323, LIMIT, 0);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        int length = OS.WinQueryWindowTextLength(this.handle);
        if (this.hooks(25) && (string = this.verifyText(string, length, length)) == null) {
            return;
        }
        PSZ buffer = new PSZ(string);
        int newlength = length + buffer.toString().length();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 458, length, length);
            OS.WinSendMsg(this.handle, 457, buffer, 0);
        } else {
            OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)length, (short)length), 0);
            OS.WinSetWindowText(this.handle, buffer);
            OS.WinSendMsg(this.handle, 329, (int)((short)newlength), 0);
        }
    }

    static int checkStyle(int style) {
        if ((style & 4) != 0) {
            style &= 0xFFFFFCFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 458, -1, 0);
        } else {
            OS.WinSendMsg(this.handle, 322, 0, 0);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.setBounds(x, y, Math.max(0, width), Math.max(0, height), 3);
        } else {
            this.setBounds(x + 3, y + 3, Math.max(0, width - 6), Math.max(0, height - 6), 3);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int newHeight;
        this.checkWidget();
        int count = this.getLineCount();
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        int height = count * this.getLineHeight();
        int width = 0;
        boolean wrap = (this.style & 2) != 0 && (this.style & 0x40) != 0;
        int length = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 448, 0, 0) : OS.WinQueryWindowTextLength(this.handle);
        byte[] text = null;
        text = this.getText().getBytes();
        int[] pnts = new int[10];
        OS.GpiQueryTextBox(hps, length, text, 5, pnts);
        width = Math.max(width, pnts[4] - pnts[0]);
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        if (wrap && hHint == -1 && (newHeight = pnts[1] - pnts[3]) != 0) {
            height = newHeight;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if ((this.style & 0x200) != 0) {
            width += OS.WinQuerySysValue(1, 22);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.WinQuerySysValue(1, 23);
            if ((this.style & 0x800) == 0) {
                ++width;
            }
        }
        if ((this.style & 0x800) != 0) {
            int border = this.getBorderWidth();
            width += border * 2 + 1;
            height += border * 2 + 2;
        }
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 473, 0, 0);
        } else {
            OS.WinSendMsg(this.handle, 325, 0, 0);
        }
    }

    void createWidget() {
        super.createWidget();
        this.doubleClick = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 472, 0, 0);
        } else {
            OS.WinSendMsg(this.handle, 324, 0, 0);
        }
    }

    int defaultBackground() {
        if ((this.style & 2) != 0) {
            if (OS.IsWarp3) {
                return OS.WinSendMsg(this.handle, 469, 0, 0);
            }
            return OS.WinSendMsg(this.handle, 469, 1, 0);
        }
        return OS.WinQuerySysColor(this.handle, -47, 0);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return OS.WinSendMsg(this.handle, 445, -1, 0);
        }
        return 1;
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return null;
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            int min = OS.WinSendMsg(this.handle, 459, 1, 0);
            int max = OS.WinSendMsg(this.handle, 459, 2, 0);
            int startLine = OS.WinSendMsg(this.handle, 446, min, 0);
            int caretPos = OS.WinSendMsg(this.handle, 445, -1, 0);
            int caretLine = OS.WinSendMsg(this.handle, 446, caretPos, 0);
            int caret = max;
            if (caretLine == startLine) {
                caret = min;
            }
            return caret;
        }
        int pos = OS.WinSendMsg(this.handle, 321, 0, 0);
        return OS.SHORT1FROMMP(pos);
    }

    public int getCharCount() {
        this.checkWidget();
        int length = 0;
        length = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 448, 0, 0) : OS.WinQueryWindowTextLength(this.handle);
        return length;
    }

    String getClipboardText() {
        String string = "";
        int hab = this.parent.getDisplay().hab;
        if (OS.WinOpenClipbrd(hab)) {
            int pText = OS.WinQueryClipbrdData(hab, 1);
            if (pText != 0) {
                byte[] buffer = new byte[OS.strlen(pText)];
                OS.objcpy(buffer, pText);
                PSZ text = new PSZ(buffer);
                string = text.toString();
            }
            OS.WinCloseClipbrd(hab);
        }
        return string;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return '*';
    }

    public boolean getEditable() {
        this.checkWidget();
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        if ((this.style & 2) != 0) {
            return (bits & 0x10) == 0;
        }
        return (bits & 0x20) == 0;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return OS.WinSendMsg(this.handle, 444, 0, 0);
        }
        return 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            FATTRS hFont = new FATTRS();
            OS.WinSendMsg(this.handle, 464, hFont, 0);
            return hFont.lMaxBaselineExt + 4;
        }
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        OS.WinReleasePS(hps);
        return fm.lMaxBaselineExt + 4;
    }

    public Point getSelection() {
        this.checkWidget();
        int pos = 0;
        pos = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 459, 0, 0) : OS.WinSendMsg(this.handle, 321, 0, 0);
        return new Point(OS.SHORT1FROMMP(pos), OS.SHORT2FROMMP(pos));
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return selection.y - selection.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        int dx = 0;
        int[] pnts = new int[10];
        PSZ buffer = new PSZ(" ");
        OS.GpiQueryTextBox(hps, 1, buffer.getBytes(), 5, pnts);
        dx = pnts[4] - pnts[0];
        OS.WinReleasePS(hps);
        return dx;
    }

    public String getText() {
        int length;
        this.checkWidget();
        int n = length = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 448, 0, 0) : OS.WinQueryWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        PSZ buffer = new PSZ(length);
        OS.WinQueryWindowText(this.handle, length + 1, buffer);
        return buffer.toString();
    }

    public String getText(int start, int end) {
        this.checkWidget();
        return this.getText().substring(start, end + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return OS.WinSendMsg(this.handle, 433, 0, 0);
        }
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return 0;
        }
        int pos = OS.WinSendMsg(this.handle, 470, 0, 0);
        return OS.WinSendMsg(this.handle, 446, pos, 0);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopIndex() * this.getLineHeight();
    }

    boolean getWrap() {
        this.checkWidget();
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        if ((this.style & 2) == 0) {
            return false;
        }
        return (bits & 8) == 0;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if ((this.style & 2) != 0) {
            int max;
            int min;
            if (this.hooks(25) && (string = this.verifyText(string, min = OS.WinSendMsg(this.handle, 459, 1, 0), max = OS.WinSendMsg(this.handle, 459, 2, 0))) == null) {
                return;
            }
            PSZ buffer = new PSZ(string);
            OS.WinSendMsg(this.handle, 457, buffer, 0);
        } else {
            int pos;
            if (this.hooks(25) && (string = this.verifyText(string, OS.SHORT1FROMMP(pos = OS.WinSendMsg(this.handle, 321, 0, 0)), OS.SHORT2FROMMP(pos))) == null) {
                return;
            }
            PSZ buffer = new PSZ(string);
            OS.WinSetWindowText(this.handle, buffer);
        }
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 474, 0, 0);
        } else {
            OS.WinSendMsg(this.handle, 327, 0, 0);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)0, this.textLimit), 0);
    }

    boolean sendKeyEvent(int type, int msg, int mp1, int mp2, Event event) {
        String newText;
        if (!super.sendKeyEvent(type, msg, mp1, mp2, event)) {
            return false;
        }
        if (this.ignoreVerify) {
            return true;
        }
        if (type != 1) {
            return true;
        }
        if (msg != 122) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25)) {
            return true;
        }
        char key = event.character;
        int stateMask = event.stateMask;
        switch (msg) {
            case 122: {
                if (key != '\b' && key != '\u007f' && key != '\r' && key != '\t' && key != '\n' || (stateMask & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.WinGetKeyState(1, 1) < 0) {
            return true;
        }
        String oldText = "";
        int start = 0;
        int end = 0;
        int pos = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 459, 0, 0) : OS.WinSendMsg(this.handle, 321, 0, 0);
        start = OS.SHORT1FROMMP(pos);
        end = OS.SHORT2FROMMP(pos);
        switch (key) {
            case '\b': {
                int lineStart;
                if (start != end) break;
                if (start == 0) {
                    return true;
                }
                int n = lineStart = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 445, -1, 0) : OS.WinSendMsg(this.handle, 328, 0, 0);
                start = start == lineStart ? (start -= DELIMITER.length()) : --start;
                start = Math.max(start, 0);
                break;
            }
            case '\u007f': {
                int lineStart;
                if (start != end) break;
                int length = OS.WinQueryWindowTextLength(this.handle);
                if (start == length) {
                    return true;
                }
                int line = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 446, end, 0) : 1;
                int n = lineStart = (this.style & 2) != 0 ? OS.WinSendMsg(this.handle, 445, line + 1, 0) : OS.WinSendMsg(this.handle, 328, 0, 0);
                end = end == lineStart - DELIMITER.length() ? (end += DELIMITER.length()) : ++end;
                end = Math.min(end, length);
                break;
            }
            case '\r': {
                if ((this.style & 2) == 0) {
                    return true;
                }
                oldText = DELIMITER;
                break;
            }
            default: {
                if (key != '\t' && key < ' ') {
                    return true;
                }
                oldText = new String(new char[]{key});
            }
        }
        if ((newText = this.verifyText(oldText, start, end, event)) == null) {
            return false;
        }
        if (newText == oldText) {
            return true;
        }
        newText = Display.withCrLf(newText);
        PSZ buffer = new PSZ(newText);
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 458, start, end);
            OS.WinSendMsg(this.handle, 457, buffer, 0);
        } else {
            int length = OS.WinQueryWindowTextLength(this.handle);
            int newlength = length + buffer.toString().length();
            OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)start, (short)end), 0);
            OS.WinSetWindowText(this.handle, buffer);
            OS.WinSendMsg(this.handle, 329, (int)((short)newlength), 0);
        }
        return false;
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 440, editable ? 0 : 1, 0);
        } else {
            OS.WinSendMsg(this.handle, 331, editable ? 0 : 1, 0);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.setTabStops(this.tabs);
    }

    public void setSelection(int start) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 458, start, start);
        } else {
            OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)start, (short)start), 0);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 458, start, end);
        } else {
            OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)start, (short)end), 0);
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        int width = this.getTabWidth(tabs);
        OS.WinSendMsg(this.handle, 438, width, 0);
    }

    public void setText(String string) {
        int length;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if (this.hooks(25) && (string = this.verifyText(string, 0, length = OS.WinQueryWindowTextLength(this.handle))) == null) {
            return;
        }
        PSZ buffer = new PSZ(string);
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 457, buffer, 0);
            OS.WinSendMsg(this.handle, 458, 0, 0);
        } else {
            OS.WinSetWindowText(this.handle, buffer);
            OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)0, (short)0), 0);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 432, limit, 0);
        } else {
            OS.WinSendMsg(this.handle, 323, limit, 0);
            this.textLimit = (short)limit;
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        int count = OS.WinSendMsg(this.handle, 444, 0, 0);
        index = Math.min(Math.max(index, 0), count - 1);
        int topIndex = OS.WinSendMsg(this.handle, 470, 0, 0);
        OS.WinSendMsg(this.handle, 458, topIndex, topIndex);
    }

    void setWrap(boolean wrap) {
        if (wrap == this.getWrap()) {
            return;
        }
        this.style &= 0xFFFFFFBF;
        if (wrap) {
            this.style |= 0x40;
        }
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            int pos = OS.WinSendMsg(this.handle, 459, 3, 0);
            OS.WinSendMsg(this.handle, 458, pos, pos);
        } else {
            int pos = OS.WinSendMsg(this.handle, 321, 0, 0);
            OS.WinSendMsg(this.handle, 471, (int)OS.SHORT1FROMMP(pos), 0);
        }
    }

    String verifyText(String string, int start, int end) {
        return this.verifyText(string, start, end, null);
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        if (this.ignoreVerify) {
            return string;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 2) != 0) {
            if ((this.style & 8) != 0) {
                bits |= 0x10;
            }
            if ((this.style & 0x40) != 0) {
                bits |= 1;
            }
            if ((this.style & 0x200) != 0) {
                bits |= 4;
            }
            if ((this.style & 0x100) != 0) {
                bits |= 8;
            }
            if ((this.style & 0x800) != 0) {
                bits |= 2;
            }
            return bits | Integer.MIN_VALUE | 0x10000 | 0x20000 | 0x80;
        }
        bits &= 0xFFFFFDF7;
        if ((this.style & 8) != 0) {
            bits |= 0x20;
        }
        if ((this.style & 0x800) != 0) {
            bits |= 8;
        }
        return bits | Integer.MIN_VALUE | 4 | 0 | 0x20000;
    }

    PSZ windowClass() {
        if ((this.style & 2) != 0) {
            return EditClass;
        }
        return FieldClass;
    }

    int windowProc() {
        if ((this.style & 2) != 0) {
            return EditProc;
        }
        return FieldProc;
    }

    MRESULT WM_CHAR(int mp1, int mp2) {
        if (this.ignoreCharacter) {
            return null;
        }
        MRESULT result = super.WM_CHAR(mp1, mp2);
        if (result != null) {
            return result;
        }
        return result;
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        int code = mp1 >> 16;
        switch (code) {
            case 7: {
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return MRESULT.ZERO;
            }
            case 4: {
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return MRESULT.ZERO;
            }
        }
        return super.wmControlChild(mp1, mp2);
    }

    MRESULT wmScroll(int msg, int mp1, int mp2) {
        int code = this.callWindowProc(msg, mp1, mp2);
        if (code == 0) {
            return MRESULT.ZERO;
        }
        return new MRESULT(code);
    }

    static {
        EditClass = PSZ.getAtom(-65526);
        FieldClass = PSZ.getAtom(-65530);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, EditClass, pclsiClassInfo);
        EditProc = pclsiClassInfo.pfnWindowProc;
        CLASSINFO pclsiClassInfoF = new CLASSINFO();
        OS.WinQueryClassInfo(0, FieldClass, pclsiClassInfoF);
        FieldProc = pclsiClassInfoF.pfnWindowProc;
    }
}

