/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.SLDCDATA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Scale
extends Control {
    int maxRange;
    int minRange;
    int increment;
    int pixelRange;
    static final int TrackBarProc;
    static final PSZ TrackBarClass;

    public Scale(Composite parent, int style) {
        this.parent = parent;
        this.style = Scale.checkStyle(style);
        this.maxRange = 100;
        this.minRange = 0;
        this.increment = 10;
        SLDCDATA sldcData = new SLDCDATA();
        sldcData.usScale1Increments = (short)10;
        sldcData.usScale1Spacing = 0;
        this.handle = OS.WinCreateWindow(parent.handle, this.windowClass(), this.windowTitle(), this.widgetStyle(), 0, parent.getHeight(), 0, 0, parent.handle, 4, 0, sldcData, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.WinSetWindowUShort(this.handle, -1, (short)(this.handle & 0xFFFF));
        OS.WinSendMsg(this.handle, 882, OS.MPFROM2SHORT((short)-1, (short)6), 0);
        super.subclass();
        super.setDefaultFont();
        super.setForegroundPixel(-3);
        super.setBackgroundPixel(-3);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(TrackBarProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        int shaftLength = OS.WinSendMsg(this.handle, 876, OS.MPFROM2SHORT((short)0, (short)0), 0);
        int arm = OS.WinSendMsg(this.handle, 876, OS.MPFROM2SHORT((short)2, (short)0), 0);
        int tick = OS.WinSendMsg(this.handle, 878, 1, 0);
        if ((this.style & 0x100) != 0) {
            width += OS.WinQuerySysValue(1, 25) * 10;
            height += OS.WinQuerySysValue(1, 23) + tick + OS.SHORT2FROMMP(arm);
        } else {
            width += OS.WinQuerySysValue(1, 22) + tick + OS.SHORT2FROMMP(arm);
            height += OS.WinQuerySysValue(1, 24) * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle() {
        super.createHandle();
    }

    int defaultForeground() {
        return OS.WinQuerySysColor(this.handle, -17, 0);
    }

    public int getIncrement() {
        this.checkWidget();
        return 1;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maxRange;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minRange;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getSelection() {
        this.checkWidget();
        int pixelInfo = OS.WinSendMsg(this.handle, 876, OS.MPFROM2SHORT((short)3, (short)0), 0);
        short posPixels = OS.SHORT1FROMMP(pixelInfo);
        int totalPixels = OS.SHORT2FROMMP(pixelInfo) - 1;
        int pos = this.maxRange * posPixels / totalPixels;
        return pos;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        if (increment < 1) {
            return;
        }
        int maximum = this.maxRange;
        int minimum = this.minRange;
        if (increment > maximum - minimum) {
            return;
        }
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (0 <= this.minRange && this.minRange < value) {
            this.maxRange = value;
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (0 <= value && value < this.maxRange) {
            this.maxRange = value;
        }
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement < 1) {
            return;
        }
        int maximum = this.maxRange;
        int minimum = this.minRange;
        if (pageIncrement > maximum - minimum) {
            return;
        }
        this.increment = pageIncrement;
    }

    public void setSelection(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int pixels = OS.WinSendMsg(this.handle, 876, OS.MPFROM2SHORT((short)3, (short)0), 0);
        int totalPixels = OS.SHORT2FROMMP(pixels) - 1;
        int pixelPos = value * totalPixels / this.maxRange;
        OS.WinSendMsg(this.handle, 881, OS.MPFROM2SHORT((short)3, (short)0), pixelPos);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0 | 0 | 0x20000;
        if ((this.style & 0x100) != 0) {
            return bits | 0 | 0;
        }
        return bits | 1 | 0x200;
    }

    PSZ windowClass() {
        return TrackBarClass;
    }

    int windowProc() {
        return TrackBarProc;
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        short code = OS.SHORT2FROMMP(mp1);
        int pos = mp2;
        Event event = new Event();
        switch (code) {
            case 2: {
                event.detail = 1;
                break;
            }
            case 3: 
            case 4: {
                this.sendEvent(code == 3 ? 15 : 16);
                if (!this.isDisposed()) break;
                return MRESULT.ZERO;
            }
        }
        this.sendEvent(13, event);
        return null;
    }

    static {
        TrackBarClass = PSZ.getAtom(-65498);
        CLASSINFO lpWndClass = new CLASSINFO();
        OS.WinQueryClassInfo(0, TrackBarClass, lpWndClass);
        TrackBarProc = lpWndClass.pfnWindowProc;
    }
}

