/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class TextTab
extends ScrollableTab {
    Text text;
    StyledText styledText;
    Group textGroup;
    Group styledTextGroup;
    Group styledTextStyleGroup;
    Button wrapButton;
    Button readOnlyButton;
    Button boldButton;
    Button redButton;
    Button yellowButton;
    Image boldImage;
    Image redImage;
    Image yellowImage;
    static /* synthetic */ Class class$0;

    TextTab(ControlExample instance) {
        super(instance);
    }

    Image createBitmapImage(Display display, String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData source = new ImageData(clazz.getResourceAsStream(String.valueOf(name) + ".bmp"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData mask = new ImageData(clazz2.getResourceAsStream(String.valueOf(name) + "_mask.bmp"));
        return new Image((Device)display, source, mask);
    }

    void createControlWidgets() {
        super.createControlWidgets();
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.textGroup = new Group((Composite)this.exampleGroup, 0);
        this.textGroup.setLayout((Layout)new GridLayout());
        this.textGroup.setLayoutData((Object)new GridData(784));
        this.textGroup.setText("Text");
        this.styledTextGroup = new Group((Composite)this.exampleGroup, 0);
        this.styledTextGroup.setLayout((Layout)new GridLayout());
        this.styledTextGroup.setLayoutData((Object)new GridData(784));
        this.styledTextGroup.setText("StyledText");
    }

    void createExampleWidgets() {
        int style = 0;
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            style |= 8;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.text = new Text((Composite)this.textGroup, style);
        this.text.setText(String.valueOf(ControlExample.getResourceString("Example_string")) + Text.DELIMITER + ControlExample.getResourceString("One_Two_Three"));
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
    }

    void createStyledTextStyleGroup() {
        Display display = this.controlGroup.getDisplay();
        this.styledTextStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.styledTextStyleGroup.setText(ControlExample.getResourceString("StyledText_Styles"));
        this.styledTextStyleGroup.setLayout((Layout)new GridLayout(2, false));
        this.styledTextStyleGroup.setLayoutData((Object)new GridData(256));
        this.boldImage = this.createBitmapImage(display, "bold");
        this.redImage = this.createBitmapImage(display, "red");
        this.yellowImage = this.createBitmapImage(display, "yellow");
        Label label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("StyledText_Style_Instructions"));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Bold"));
        this.boldButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.boldButton.setImage(this.boldImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Foreground_Style"));
        this.redButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.redButton.setImage(this.redImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Background_Style"));
        this.yellowButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.yellowButton.setImage(this.yellowImage);
        this.yellowButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextTab.this.boldImage.dispose();
                TextTab.this.redImage.dispose();
                TextTab.this.yellowImage.dispose();
            }
        });
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.text};
    }

    String getTabText() {
        return "Text";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.text.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.text.getStyle() & 8) != 0);
    }
}

