/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;

class SliderTab
extends RangeTab {
    Scale scale1;
    Slider slider1;
    Group sliderGroup;
    Group scaleGroup;
    Scale incrementScale;
    Scale pageIncrementScale;
    Scale thumbScale;
    boolean defaultColor = true;

    SliderTab(ControlExample instance) {
        super(instance);
    }

    void createControlWidgets() {
        super.createControlWidgets();
        this.createThumbGroup();
        this.createIncrementGroup();
        this.createPageIncrementGroup();
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.sliderGroup = new Group((Composite)this.exampleGroup, 0);
        this.sliderGroup.setLayout((Layout)new GridLayout());
        this.sliderGroup.setLayoutData((Object)new GridData(784));
        this.sliderGroup.setText("Slider");
        this.scaleGroup = new Group((Composite)this.exampleGroup, 0);
        this.scaleGroup.setLayout((Layout)new GridLayout());
        this.scaleGroup.setLayoutData((Object)new GridData(784));
        this.scaleGroup.setText("Scale");
    }

    void createExampleWidgets() {
        int style = 0;
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.scale1 = new Scale((Composite)this.scaleGroup, style);
        this.scale1.setMaximum(100);
        this.scale1.setSelection(50);
        this.scale1.setIncrement(5);
        this.scale1.setPageIncrement(10);
        this.slider1 = new Slider((Composite)this.sliderGroup, style);
        this.slider1.setMaximum(100);
        this.slider1.setSelection(50);
        this.slider1.setIncrement(5);
        this.slider1.setPageIncrement(10);
        this.slider1.setThumb(10);
    }

    void createIncrementGroup() {
        Group incrementGroup = new Group((Composite)this.controlGroup, 0);
        incrementGroup.setLayout((Layout)new GridLayout());
        incrementGroup.setText(ControlExample.getResourceString("Increment"));
        incrementGroup.setLayoutData((Object)new GridData(768));
        this.incrementScale = new Scale((Composite)incrementGroup, 0);
        this.incrementScale.setMaximum(100);
        this.incrementScale.setSelection(5);
        this.incrementScale.setPageIncrement(10);
        this.incrementScale.setIncrement(5);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.incrementScale.setLayoutData((Object)data);
        this.incrementScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SliderTab.this.setWidgetIncrement();
            }
        });
    }

    void createPageIncrementGroup() {
        Group pageIncrementGroup = new Group((Composite)this.controlGroup, 0);
        pageIncrementGroup.setLayout((Layout)new GridLayout());
        pageIncrementGroup.setText(ControlExample.getResourceString("Page_Increment"));
        pageIncrementGroup.setLayoutData((Object)new GridData(768));
        this.pageIncrementScale = new Scale((Composite)pageIncrementGroup, 0);
        this.pageIncrementScale.setMaximum(100);
        this.pageIncrementScale.setSelection(10);
        this.pageIncrementScale.setPageIncrement(10);
        this.pageIncrementScale.setIncrement(5);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.pageIncrementScale.setLayoutData((Object)data);
        this.pageIncrementScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SliderTab.this.setWidgetPageIncrement();
            }
        });
    }

    void createThumbGroup() {
        Group thumbGroup = new Group((Composite)this.controlGroup, 0);
        thumbGroup.setLayout((Layout)new GridLayout());
        thumbGroup.setText(ControlExample.getResourceString("Thumb"));
        thumbGroup.setLayoutData((Object)new GridData(768));
        this.thumbScale = new Scale((Composite)thumbGroup, 0);
        this.thumbScale.setMaximum(100);
        this.thumbScale.setSelection(10);
        this.thumbScale.setPageIncrement(10);
        this.thumbScale.setIncrement(5);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.thumbScale.setLayoutData((Object)data);
        this.thumbScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SliderTab.this.setWidgetThumb();
            }
        });
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.scale1, this.slider1};
    }

    String getTabText() {
        return ControlExample.getResourceString("Slider_and_Scale");
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setWidgetIncrement();
        this.setWidgetPageIncrement();
        this.setWidgetThumb();
    }

    void setWidgetIncrement() {
        this.slider1.setIncrement(this.incrementScale.getSelection());
        this.scale1.setIncrement(this.incrementScale.getSelection());
    }

    void setWidgetMaximum() {
        this.slider1.setMaximum(this.maximumScale.getSelection());
        this.scale1.setMaximum(this.maximumScale.getSelection());
    }

    void setWidgetMinimum() {
        this.slider1.setMinimum(this.minimumScale.getSelection());
        this.scale1.setMinimum(this.minimumScale.getSelection());
    }

    void setWidgetPageIncrement() {
        this.slider1.setPageIncrement(this.pageIncrementScale.getSelection());
        this.scale1.setPageIncrement(this.pageIncrementScale.getSelection());
    }

    void setWidgetSelection() {
        this.slider1.setSelection(this.selectionScale.getSelection());
        this.scale1.setSelection(this.selectionScale.getSelection());
    }

    void setWidgetThumb() {
        this.slider1.setThumb(this.thumbScale.getSelection());
    }
}

