/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class DialogTab
extends Tab {
    Group dialogStyleGroup;
    Group resultGroup;
    Text textWidget;
    Combo dialogCombo;
    Button okButton;
    Button cancelButton;
    Button yesButton;
    Button noButton;
    Button retryButton;
    Button abortButton;
    Button ignoreButton;
    Button iconErrorButton;
    Button iconInformationButton;
    Button iconQuestionButton;
    Button iconWarningButton;
    Button iconWorkingButton;
    Button modelessButton;
    Button primaryModalButton;
    Button applicationModalButton;
    Button systemModalButton;
    Button saveButton;
    Button openButton;
    static String[] FilterExtensions = new String[]{".txt.", ".bat", ".doc"};
    static String[] FilterNames = new String[]{ControlExample.getResourceString("FilterName_0"), ControlExample.getResourceString("FilterName_1"), ControlExample.getResourceString("FilterName_2")};

    DialogTab(ControlExample instance) {
        super(instance);
    }

    void buttonStyleSelected(SelectionEvent event) {
        this.okButton.setEnabled(!this.yesButton.getSelection() && !this.noButton.getSelection() && !this.retryButton.getSelection() && !this.abortButton.getSelection() && !this.ignoreButton.getSelection());
        this.cancelButton.setEnabled(!this.abortButton.getSelection() && !this.ignoreButton.getSelection());
        this.yesButton.setEnabled(!this.okButton.getSelection() && !this.retryButton.getSelection() && !this.abortButton.getSelection() && !this.ignoreButton.getSelection());
        this.noButton.setEnabled(!this.okButton.getSelection() && !this.retryButton.getSelection() && !this.abortButton.getSelection() && !this.ignoreButton.getSelection());
        this.retryButton.setEnabled(!this.okButton.getSelection() && !this.yesButton.getSelection() && !this.noButton.getSelection());
        this.abortButton.setEnabled(!this.okButton.getSelection() && !this.cancelButton.getSelection() && !this.yesButton.getSelection() && !this.noButton.getSelection());
        this.ignoreButton.setEnabled(!this.okButton.getSelection() && !(this.cancelButton.getSelection() | this.yesButton.getSelection()) && !this.noButton.getSelection());
    }

    void createButtonSelected(SelectionEvent event) {
        int style = 0;
        if (this.okButton.getEnabled() && this.okButton.getSelection()) {
            style |= 0x20;
        }
        if (this.cancelButton.getEnabled() && this.cancelButton.getSelection()) {
            style |= 0x100;
        }
        if (this.yesButton.getEnabled() && this.yesButton.getSelection()) {
            style |= 0x40;
        }
        if (this.noButton.getEnabled() && this.noButton.getSelection()) {
            style |= 0x80;
        }
        if (this.retryButton.getEnabled() && this.retryButton.getSelection()) {
            style |= 0x400;
        }
        if (this.abortButton.getEnabled() && this.abortButton.getSelection()) {
            style |= 0x200;
        }
        if (this.ignoreButton.getEnabled() && this.ignoreButton.getSelection()) {
            style |= 0x800;
        }
        if (this.iconErrorButton.getEnabled() && this.iconErrorButton.getSelection()) {
            style |= 1;
        }
        if (this.iconInformationButton.getEnabled() && this.iconInformationButton.getSelection()) {
            style |= 2;
        }
        if (this.iconQuestionButton.getEnabled() && this.iconQuestionButton.getSelection()) {
            style |= 4;
        }
        if (this.iconWarningButton.getEnabled() && this.iconWarningButton.getSelection()) {
            style |= 8;
        }
        if (this.iconWorkingButton.getEnabled() && this.iconWorkingButton.getSelection()) {
            style |= 0x10;
        }
        if (this.primaryModalButton.getEnabled() && this.primaryModalButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.applicationModalButton.getEnabled() && this.applicationModalButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.systemModalButton.getEnabled() && this.systemModalButton.getSelection()) {
            style |= 0x20000;
        }
        if (this.saveButton.getEnabled() && this.saveButton.getSelection()) {
            style |= 0x2000;
        }
        if (this.openButton.getEnabled() && this.openButton.getSelection()) {
            style |= 0x1000;
        }
        String name = this.dialogCombo.getText();
        Shell shell = this.tabFolderPage.getShell();
        if (name.equals(ControlExample.getResourceString("ColorDialog"))) {
            ColorDialog dialog = new ColorDialog(shell, style);
            dialog.setRGB(new RGB(100, 100, 100));
            dialog.setText(ControlExample.getResourceString("Title"));
            RGB result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("ColorDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{"" + result})) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (name.equals(ControlExample.getResourceString("FileDialog"))) {
            FileDialog dialog = new FileDialog(shell, style);
            dialog.setFileName(ControlExample.getResourceString("readme_txt"));
            dialog.setFilterNames(FilterNames);
            dialog.setFilterExtensions(FilterExtensions);
            dialog.setText(ControlExample.getResourceString("Title"));
            String result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("FileDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{"" + result})) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (name.equals(ControlExample.getResourceString("FontDialog"))) {
            FontDialog dialog = new FontDialog(shell, style);
            dialog.setText(ControlExample.getResourceString("Title"));
            FontData result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("FontDialog")) + Text.DELIMITER);
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("Result", new String[]{"" + result})) + Text.DELIMITER + Text.DELIMITER);
            return;
        }
        if (name.equals(ControlExample.getResourceString("MessageBox"))) {
            MessageBox dialog = new MessageBox(shell, style);
            dialog.setMessage(ControlExample.getResourceString("Example_string"));
            dialog.setText(ControlExample.getResourceString("Title"));
            int result = dialog.open();
            this.textWidget.append(String.valueOf(ControlExample.getResourceString("MessageBox")) + Text.DELIMITER);
            switch (result) {
                case 32: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.OK"}));
                    break;
                }
                case 64: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.YES"}));
                    break;
                }
                case 128: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.NO"}));
                    break;
                }
                case 256: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.CANCEL"}));
                    break;
                }
                case 512: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.ABORT"}));
                    break;
                }
                case 1024: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.RETRY"}));
                    break;
                }
                case 2048: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"SWT.IGNORE"}));
                    break;
                }
                default: {
                    this.textWidget.append(ControlExample.getResourceString("Result", new String[]{"" + result}));
                }
            }
            this.textWidget.append(String.valueOf(Text.DELIMITER) + Text.DELIMITER);
        }
    }

    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.controlGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.dialogStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.dialogStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(64);
        gridData.horizontalSpan = 2;
        this.dialogStyleGroup.setLayoutData((Object)gridData);
        this.dialogStyleGroup.setText(ControlExample.getResourceString("Dialog_Type"));
    }

    void createControlWidgets() {
        String[] strings = new String[]{ControlExample.getResourceString("ColorDialog"), ControlExample.getResourceString("FileDialog"), ControlExample.getResourceString("FontDialog"), ControlExample.getResourceString("MessageBox")};
        this.dialogCombo = new Combo((Composite)this.dialogStyleGroup, 8);
        this.dialogCombo.setItems(strings);
        this.dialogCombo.setText(strings[0]);
        Button createButton = new Button((Composite)this.dialogStyleGroup, 0);
        createButton.setText(ControlExample.getResourceString("Create_Dialog"));
        createButton.setLayoutData((Object)new GridData(64));
        Group buttonStyleGroup = new Group((Composite)this.controlGroup, 0);
        buttonStyleGroup.setLayout((Layout)new GridLayout());
        buttonStyleGroup.setLayoutData((Object)new GridData(272));
        buttonStyleGroup.setText(ControlExample.getResourceString("Button_Styles"));
        this.okButton = new Button((Composite)buttonStyleGroup, 32);
        this.okButton.setText("SWT.OK");
        this.cancelButton = new Button((Composite)buttonStyleGroup, 32);
        this.cancelButton.setText("SWT.CANCEL");
        this.yesButton = new Button((Composite)buttonStyleGroup, 32);
        this.yesButton.setText("SWT.YES");
        this.noButton = new Button((Composite)buttonStyleGroup, 32);
        this.noButton.setText("SWT.NO");
        this.retryButton = new Button((Composite)buttonStyleGroup, 32);
        this.retryButton.setText("SWT.RETRY");
        this.abortButton = new Button((Composite)buttonStyleGroup, 32);
        this.abortButton.setText("SWT.ABORT");
        this.ignoreButton = new Button((Composite)buttonStyleGroup, 32);
        this.ignoreButton.setText("SWT.IGNORE");
        Group iconStyleGroup = new Group((Composite)this.controlGroup, 0);
        iconStyleGroup.setLayout((Layout)new GridLayout());
        iconStyleGroup.setLayoutData((Object)new GridData(272));
        iconStyleGroup.setText(ControlExample.getResourceString("Icon_Styles"));
        this.iconErrorButton = new Button((Composite)iconStyleGroup, 16);
        this.iconErrorButton.setText("SWT.ICON_ERROR");
        this.iconInformationButton = new Button((Composite)iconStyleGroup, 16);
        this.iconInformationButton.setText("SWT.ICON_INFORMATION");
        this.iconQuestionButton = new Button((Composite)iconStyleGroup, 16);
        this.iconQuestionButton.setText("SWT.ICON_QUESTION");
        this.iconWarningButton = new Button((Composite)iconStyleGroup, 16);
        this.iconWarningButton.setText("SWT.ICON_WARNING");
        this.iconWorkingButton = new Button((Composite)iconStyleGroup, 16);
        this.iconWorkingButton.setText("SWT.ICON_WORKING");
        Group modalStyleGroup = new Group((Composite)this.controlGroup, 0);
        modalStyleGroup.setLayout((Layout)new GridLayout());
        modalStyleGroup.setLayoutData((Object)new GridData(272));
        modalStyleGroup.setText(ControlExample.getResourceString("Modal_Styles"));
        this.modelessButton = new Button((Composite)modalStyleGroup, 16);
        this.modelessButton.setText("SWT.MODELESS");
        this.primaryModalButton = new Button((Composite)modalStyleGroup, 16);
        this.primaryModalButton.setText("SWT.PRIMARY_MODAL");
        this.applicationModalButton = new Button((Composite)modalStyleGroup, 16);
        this.applicationModalButton.setText("SWT.APPLICATION_MODAL");
        this.systemModalButton = new Button((Composite)modalStyleGroup, 16);
        this.systemModalButton.setText("SWT.SYSTEM_MODAL");
        Group fileDialogStyleGroup = new Group((Composite)this.controlGroup, 0);
        fileDialogStyleGroup.setLayout((Layout)new GridLayout());
        fileDialogStyleGroup.setLayoutData((Object)new GridData(272));
        fileDialogStyleGroup.setText(ControlExample.getResourceString("File_Dialog_Styles"));
        this.saveButton = new Button((Composite)fileDialogStyleGroup, 16);
        this.saveButton.setText("SWT.SAVE");
        this.openButton = new Button((Composite)fileDialogStyleGroup, 16);
        this.openButton.setText("SWT.OPEN");
        this.dialogCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogTab.this.dialogSelected(event);
            }
        });
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogTab.this.createButtonSelected(event);
            }
        });
        SelectionAdapter buttonStyleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogTab.this.buttonStyleSelected(event);
            }
        };
        this.okButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.cancelButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.yesButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.noButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.retryButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.abortButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.ignoreButton.addSelectionListener((SelectionListener)buttonStyleListener);
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.yesButton.setEnabled(false);
        this.noButton.setEnabled(false);
        this.retryButton.setEnabled(false);
        this.abortButton.setEnabled(false);
        this.ignoreButton.setEnabled(false);
        this.iconErrorButton.setEnabled(false);
        this.iconInformationButton.setEnabled(false);
        this.iconQuestionButton.setEnabled(false);
        this.iconWarningButton.setEnabled(false);
        this.iconWorkingButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.openButton.setSelection(true);
        this.iconInformationButton.setSelection(true);
        this.modelessButton.setSelection(true);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.resultGroup = new Group((Composite)this.exampleGroup, 0);
        this.resultGroup.setLayout((Layout)new GridLayout());
        this.resultGroup.setLayoutData((Object)new GridData(1808));
        this.resultGroup.setText(ControlExample.getResourceString("Dialog_Result"));
    }

    void createExampleWidgets() {
        this.textWidget = new Text((Composite)this.resultGroup, 2816);
        GridData gridData = new GridData(1808);
        this.textWidget.setLayoutData((Object)gridData);
    }

    void dialogSelected(SelectionEvent event) {
        String name = this.dialogCombo.getText();
        boolean isMessageBox = name.equals(ControlExample.getResourceString("MessageBox"));
        boolean isFileDialog = name.equals(ControlExample.getResourceString("FileDialog"));
        this.okButton.setEnabled(isMessageBox);
        this.cancelButton.setEnabled(isMessageBox);
        this.yesButton.setEnabled(isMessageBox);
        this.noButton.setEnabled(isMessageBox);
        this.retryButton.setEnabled(isMessageBox);
        this.abortButton.setEnabled(isMessageBox);
        this.ignoreButton.setEnabled(isMessageBox);
        this.iconErrorButton.setEnabled(isMessageBox);
        this.iconInformationButton.setEnabled(isMessageBox);
        this.iconQuestionButton.setEnabled(isMessageBox);
        this.iconWarningButton.setEnabled(isMessageBox);
        this.iconWorkingButton.setEnabled(isMessageBox);
        this.saveButton.setEnabled(isFileDialog);
        this.openButton.setEnabled(isFileDialog);
        if (!isMessageBox) {
            this.okButton.setSelection(false);
            this.cancelButton.setSelection(false);
            this.yesButton.setSelection(false);
            this.noButton.setSelection(false);
            this.retryButton.setSelection(false);
            this.abortButton.setSelection(false);
            this.ignoreButton.setSelection(false);
        }
    }

    Control[] getExampleWidgets() {
        return new Control[0];
    }

    String getTabText() {
        return "Dialog";
    }
}

