/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class CoolBarTab
extends Tab {
    Button dropDownButton;
    Button lockedButton;
    CoolBar coolBar;
    CoolItem pushItem;
    CoolItem dropDownItem;
    CoolItem radioItem;
    CoolItem checkItem;
    Group coolBarGroup;
    Point[] sizes;
    int[] wrapIndices;
    int[] order;

    CoolBarTab(ControlExample instance) {
        super(instance);
    }

    void createDisplayGroup() {
        super.createDisplayGroup();
        this.lockedButton = new Button((Composite)this.displayGroup, 32);
        this.lockedButton.setText(ControlExample.getResourceString("Locked"));
        this.lockedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CoolBarTab.this.setWidgetLocked();
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.coolBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.coolBarGroup.setLayout((Layout)new GridLayout());
        this.coolBarGroup.setLayoutData((Object)new GridData(784));
        this.coolBarGroup.setText("CoolBar");
    }

    void createExampleWidgets() {
        int style = 0;
        int itemStyle = 0;
        int toolBarStyle = 0x800000;
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.dropDownButton.getSelection()) {
            itemStyle |= 4;
        }
        this.coolBar = new CoolBar((Composite)this.coolBarGroup, style);
        ToolBar toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 2);
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.PUSH");
        item = new ToolItem(toolBar, 8);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.PUSH");
        this.pushItem = new CoolItem(this.coolBar, itemStyle);
        this.pushItem.setControl((Control)toolBar);
        Point pushSize = toolBar.computeSize(-1, -1);
        pushSize = this.pushItem.computeSize(pushSize.x, pushSize.y);
        this.pushItem.setSize(pushSize);
        this.pushItem.setMinimumSize(item.getWidth(), pushSize.y);
        this.pushItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        item = new ToolItem(toolBar, 4);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        item = new ToolItem(toolBar, 4);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.DROP_DOWN");
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener());
        this.dropDownItem = new CoolItem(this.coolBar, itemStyle);
        this.dropDownItem.setControl((Control)toolBar);
        Point dropSize = toolBar.computeSize(-1, -1);
        dropSize = this.dropDownItem.computeSize(dropSize.x, dropSize.y);
        this.dropDownItem.setSize(dropSize);
        this.dropDownItem.setMinimumSize(item.getWidth(), dropSize.y);
        this.dropDownItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        item = new ToolItem(toolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(toolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        item = new ToolItem(toolBar, 16);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.RADIO");
        this.radioItem = new CoolItem(this.coolBar, itemStyle);
        this.radioItem.setControl((Control)toolBar);
        Point radioSize = toolBar.computeSize(-1, -1);
        radioSize = this.radioItem.computeSize(radioSize.x, radioSize.y);
        this.radioItem.setSize(radioSize);
        this.radioItem.setMinimumSize(item.getWidth(), radioSize.y);
        this.radioItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        toolBar = new ToolBar((Composite)this.coolBar, toolBarStyle);
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[0]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[1]);
        item.setToolTipText("SWT.CHECK");
        item = new ToolItem(toolBar, 32);
        item.setImage(this.instance.images[2]);
        item.setToolTipText("SWT.CHECK");
        this.checkItem = new CoolItem(this.coolBar, itemStyle);
        this.checkItem.setControl((Control)toolBar);
        Point checkSize = toolBar.computeSize(-1, -1);
        checkSize = this.checkItem.computeSize(checkSize.x, checkSize.y);
        this.checkItem.setSize(checkSize);
        this.checkItem.setMinimumSize(item.getWidth(), checkSize.y);
        this.checkItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
        if (this.order != null) {
            this.coolBar.setItemLayout(this.order, this.wrapIndices, this.sizes);
            this.pushItem.setPreferredSize(pushSize);
            this.dropDownItem.setPreferredSize(dropSize);
            this.radioItem.setPreferredSize(radioSize);
            this.checkItem.setPreferredSize(checkSize);
        } else {
            this.coolBar.setWrapIndices(new int[]{1, 3});
        }
        this.coolBar.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CoolBarTab.this.exampleGroup.layout();
            }
        });
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        Group itemGroup = new Group((Composite)this.styleGroup, 0);
        itemGroup.setLayout((Layout)new GridLayout());
        itemGroup.setLayoutData((Object)new GridData(272));
        itemGroup.setText(ControlExample.getResourceString("Item_Styles"));
        this.dropDownButton = new Button((Composite)itemGroup, 32);
        this.dropDownButton.setText("SWT.DROP_DOWN");
        this.dropDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CoolBarTab.this.recreateExampleWidgets();
            }
        });
    }

    void disposeExampleWidgets() {
        if (this.coolBar != null) {
            this.sizes = this.coolBar.getItemSizes();
            this.wrapIndices = this.coolBar.getWrapIndices();
            this.order = this.coolBar.getItemOrder();
        }
        super.disposeExampleWidgets();
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.coolBar};
    }

    String getTabText() {
        return "CoolBar";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.borderButton.setSelection((this.coolBar.getStyle() & 0x800) != 0);
        this.dropDownButton.setSelection((this.coolBar.getItem(0).getStyle() & 4) != 0);
        this.setWidgetLocked();
    }

    void setWidgetLocked() {
        this.coolBar.setLocked(this.lockedButton.getSelection());
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;
        private boolean visible = false;

        DropDownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.menu == null) {
                Shell shell = CoolBarTab.this.tabFolderPage.getShell();
                this.menu = new Menu((Control)shell);
                int i = 0;
                while (i < 9) {
                    MenuItem menuItem;
                    String text = ControlExample.getResourceString("DropDownData_" + i);
                    if (text.length() != 0) {
                        menuItem = new MenuItem(this.menu, 0);
                        menuItem.setText(text);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                            private final /* synthetic */ DropDownSelectionListener this$1;
                            {
                                this.this$1 = dropDownSelectionListener;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                DropDownSelectionListener.access$0(this.this$1, false);
                            }
                        });
                    } else {
                        menuItem = new MenuItem(this.menu, 2);
                    }
                    ++i;
                }
            }
            if (event.detail == 4) {
                if (this.visible) {
                    this.setMenuVisible(false);
                } else {
                    ToolItem toolItem = (ToolItem)event.widget;
                    ToolBar toolBar = toolItem.getParent();
                    Rectangle toolItemBounds = toolItem.getBounds();
                    Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                    this.menu.setLocation(point.x, point.y + toolItemBounds.height);
                    this.setMenuVisible(true);
                }
            }
        }

        private void setMenuVisible(boolean visible) {
            this.menu.setVisible(visible);
            this.visible = visible;
        }

        static /* synthetic */ void access$0(DropDownSelectionListener dropDownSelectionListener, boolean bl) {
            dropDownSelectionListener.setMenuVisible(bl);
        }
    }

    class CoolItemSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;

        CoolItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                    return;
                }
                CoolItem coolItem = (CoolItem)event.widget;
                Rectangle itemBounds = coolItem.getBounds();
                Point pt = CoolBarTab.this.coolBar.toDisplay(new Point(itemBounds.x, itemBounds.y));
                itemBounds.x = pt.x;
                itemBounds.y = pt.y;
                ToolBar toolBar = (ToolBar)coolItem.getControl();
                ToolItem[] tools = toolBar.getItems();
                int toolCount = tools.length;
                int i = 0;
                while (i < toolCount) {
                    Rectangle toolBounds = tools[i].getBounds();
                    pt = toolBar.toDisplay(new Point(toolBounds.x, toolBounds.y));
                    toolBounds.x = pt.x;
                    toolBounds.y = pt.y;
                    Rectangle intersection = itemBounds.intersection(toolBounds);
                    if (!intersection.equals((Object)toolBounds)) break;
                    ++i;
                }
                this.menu = new Menu((Control)CoolBarTab.this.coolBar);
                int j = i;
                while (j < toolCount) {
                    MenuItem menuItem;
                    ToolItem tool = tools[j];
                    Image image = tool.getImage();
                    if (image == null) {
                        new MenuItem(this.menu, 2);
                    } else if ((tool.getStyle() & 4) != 0) {
                        menuItem = new MenuItem(this.menu, 64);
                        menuItem.setImage(image);
                        Menu m = new Menu(this.menu);
                        menuItem.setMenu(m);
                        int k = 0;
                        while (k < 9) {
                            String text = ControlExample.getResourceString("DropDownData_" + k);
                            if (text.length() != 0) {
                                MenuItem mi = new MenuItem(m, 0);
                                mi.setText(text);
                            } else {
                                new MenuItem(m, 2);
                            }
                            ++k;
                        }
                    } else {
                        menuItem = new MenuItem(this.menu, 0);
                        menuItem.setImage(image);
                    }
                    ++j;
                }
                pt = CoolBarTab.this.coolBar.toDisplay(new Point(event.x, event.y));
                this.menu.setLocation(pt.x, pt.y);
                this.menu.setVisible(true);
                Display display = CoolBarTab.this.coolBar.getDisplay();
                while (this.menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        }
    }
}

