/****************************** Module Header ******************************\
*
* Module Name: settcls.c
*
* WPS class source of test class of
* Source settings and details manager WPS sample
*
* Copyright (c) WPS Toolkit Project - Christian Langanke 2000
*
* $Id: settcls.c,v 1.9 2006/12/04 21:29:31 cla Exp $
*
* ===========================================================================
*
* This file is part of the WPS Toolkit package and is free software.  You can
* redistribute it and/or modify it under the terms of the GNU Library General
* Public License as published by the Free Software Foundation, in version 2
* as it comes in the "COPYING.LIB" file of the WPS Toolkit main distribution.
* This library is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
* License for more details.
*
\***************************************************************************/

/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.43
 */


#pragma info( nogen )
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_settcls_Source
#define SOM_Module_settcls_Source
#endif
#define SettingsClass_Class_Source
#define M_SettingsClass_Class_Source

#include "settcls.ih"

/* WPS Toolkit */
#define INCL_WTK
#include <wtk.h>

#include "settcb.h"
#include "settdlg.h"
#include "settdlg.rch"


SOM_Scope ULONG  SOMLINK SET_tstInsertWelcomePage(SettingsClass *somSelf,
                                                  HWND hwndDlg)
{
    PAGEINFO  pi;

    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_tstInsertWelcomePage");

    memset( (PCH) &pi, 0, sizeof( PAGEINFO ) );
    pi.cb                  = sizeof( PAGEINFO );
    pi.hwndPage            = NULLHANDLE;
    pi.usPageStyleFlags    = BKA_MAJOR;
    pi.usPageInsertFlags   = BKA_FIRST;
    pi.pfnwp               = SettingsPageProc;
    pi.resid               = WtkGetModuleHandle( (PFN)__FUNCTION__);
    pi.dlgid               = IDDLG_DLG_CONNECTION_WELCOME;
    pi.pszName             = "~Welcome";
    pi.pCreateParams       = (PVOID) _hvt;
    pi.pszHelpLibraryName  = NULL;

    return _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
}

SOM_Scope ULONG  SOMLINK SET_tstInsertLoginPage(SettingsClass *somSelf,
                                                HWND hwndDlg)
{
    PAGEINFO  pi;

    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_tstInsertLoginPage");

    memset( (PCH) &pi, 0, sizeof( PAGEINFO ) );
    pi.cb                  = sizeof( PAGEINFO );
    pi.hwndPage            = NULLHANDLE;
    pi.usPageStyleFlags    = BKA_MAJOR;
    pi.usPageInsertFlags   = BKA_FIRST;
    pi.pfnwp               = SettingsPageProc;
    pi.resid               = WtkGetModuleHandle( (PFN)__FUNCTION__);
    pi.dlgid               = IDDLG_DLG_CONNECTION_LOGIN;
    pi.pszName             = "~Login";
    pi.pCreateParams       = (PVOID) _hvt;
    pi.pszHelpLibraryName  = NULL;

    return _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
}

SOM_Scope ULONG  SOMLINK SET_tstInsertConnectPage(SettingsClass *somSelf,
                                                  HWND hwndDlg)
{
    PAGEINFO  pi;

    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_tstInsertConnectPage");

    memset( (PCH) &pi, 0, sizeof( PAGEINFO ) );
    pi.cb                  = sizeof( PAGEINFO );
    pi.hwndPage            = NULLHANDLE;
    pi.usPageStyleFlags    = BKA_MAJOR;
    pi.usPageInsertFlags   = BKA_FIRST;
    pi.pfnwp               = SettingsPageProc;
    pi.resid               = WtkGetModuleHandle( (PFN)__FUNCTION__);
    pi.dlgid               = IDDLG_DLG_CONNECTION_CONNECT;
    pi.pszName             = "~Connect";
    pi.pCreateParams       = (PVOID) _hvt;
    pi.pszHelpLibraryName  = NULL;

    return _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
}

SOM_Scope ULONG  SOMLINK SET_tstInsertModemPage(SettingsClass *somSelf,
                                                HWND hwndDlg)
{

    PAGEINFO  pi;

    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_tstInsertModemPage");

    memset( (PCH) &pi, 0, sizeof( PAGEINFO ) );
    pi.cb                  = sizeof( PAGEINFO );
    pi.hwndPage            = NULLHANDLE;
    pi.usPageStyleFlags    = BKA_MAJOR;
    pi.usPageInsertFlags   = BKA_FIRST;
    pi.pfnwp               = SettingsPageProc;
    pi.resid               = WtkGetModuleHandle( (PFN)__FUNCTION__);
    pi.dlgid               = IDDLG_DLG_CONNECTION_MODEM;
    pi.pszName             = "~Modem";
    pi.pCreateParams       = (PVOID) _hvt;
    pi.pszHelpLibraryName  = NULL;

    return _wpInsertSettingsPage( somSelf, hwndDlg, &pi );
}

SOM_Scope void  SOMLINK SET_wpInitData(SettingsClass *somSelf)
{
    LHANDLE  hst;
static PSZ pszEmptyAdress = "0.0.0.0";

    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpInitData");

    SettingsClass_parent_WPAbstract_wpInitData(somSelf);

    {
    // get temporary access to metaclass data
    // use brackets to "redefine" somThis (being used in macro _hst)
    M_SettingsClassData *somThis = M_SettingsClassGetData( _SettingsClass);
    hst = _hst;
    }

    // initialize variables
    _szUser[ 0]        = 0;
    _szPassword[ 0]    = 0;
    _szPhoneNumber[ 0] = 0;
    _ulConfigType      = 0;
    strcpy( _szLocalIp, pszEmptyAdress);
    strcpy( _szGatewayIp, pszEmptyAdress);
    strcpy( _szNetmaskIp, "255.255.255.0");
    _ulMTU             = 1500;
    _szNameserver[ 0]  = 0;
    _fDefaultRoute     = TRUE;
    strcpy( _szModemName, "<none>");
    WtkTimeToCDateTime( NULL, &_cdateLastWritten, &_ctimeLastWritten);

    // create value table for settings
    _hvt = WtkCreateObjectValueTable( hst, somSelf, somThis);

}

SOM_Scope void  SOMLINK SET_wpUnInitData(SettingsClass *somSelf)
{
    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpUnInitData");

    // destroy settings value table
    WtkDestroyObjectValueTable( _hvt);

    SettingsClass_parent_WPAbstract_wpUnInitData(somSelf);
}

SOM_Scope BOOL  SOMLINK SET_wpSaveState(SettingsClass *somSelf)
{
    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpSaveState");

    WtkSaveObjectState( _hvt, "SettingsClass");

    return (SettingsClass_parent_WPAbstract_wpSaveState(somSelf));
}

SOM_Scope BOOL  SOMLINK SET_wpRestoreState(SettingsClass *somSelf,
                                           ULONG ulReserved)
{
    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpRestoreState");

    WtkRestoreObjectState( _hvt, "SettingsClass");

    return (SettingsClass_parent_WPAbstract_wpRestoreState(somSelf,
                                                       ulReserved));
}

SOM_Scope BOOL  SOMLINK SET_wpAddSettingsPages(SettingsClass *somSelf,
                                               HWND hwndNotebook)
{
    BOOL fResult;

    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpAddSettingsPages");

    fResult = SettingsClass_parent_WPAbstract_wpAddSettingsPages(somSelf,
                                                           hwndNotebook);
    _tstInsertModemPage( somSelf, hwndNotebook);
    _tstInsertConnectPage( somSelf, hwndNotebook);
    _tstInsertLoginPage( somSelf, hwndNotebook);
    _tstInsertWelcomePage( somSelf, hwndNotebook);

    // register notebook to settings manager
    WtkRegisterSettingsNotebook( _hvt, hwndNotebook);

    return fResult;
}

SOM_Scope ULONG  SOMLINK SET_wpAddObjectWindowPage(SettingsClass *somSelf,
                                                   HWND hwndNotebook)
{
    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpAddObjectWindowPage");

    return SETTINGS_PAGE_REMOVED;
}

SOM_Scope BOOL  SOMLINK SET_wpSetup(SettingsClass *somSelf, PSZ pszSetupString)
{
    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpSetup");

    // evaluate settings string
    WtkEvaluateObjectSettings( _hvt, pszSetupString);

    return (SettingsClass_parent_WPAbstract_wpSetup(somSelf, pszSetupString));
}


SOM_Scope ULONG  SOMLINK SET_wpQueryDetailsData(SettingsClass *somSelf,
                                                PVOID* ppDetailsData,
                                                PULONG pcp)
{
    SettingsClassData *somThis = SettingsClassGetData(somSelf);
    SettingsClassMethodDebug("SettingsClass","SET_wpQueryDetailsData");

    SettingsClass_parent_WPAbstract_wpQueryDetailsData(somSelf,
                                                       ppDetailsData,
                                                       pcp);

    return WtkQueryObjectDetailsData( _hvt, ppDetailsData, pcp);

}


SOM_Scope void  SOMLINK MSET_wpclsInitData(M_SettingsClass *somSelf)
{
    M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf);
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsInitData");

    M_SettingsClass_parent_M_WPAbstract_wpclsInitData(somSelf);

    // create settings table and add all required settings
    _hst = WtkCreateClassSettingsTable( somSelf, SettingsCallbackProc);
    if (_hst)
       {
       // settings for login page
       WtkAddClassSetting( _hst, IDSET_USERNAME,     "USER=;", 1);
       WtkAddClassSetting( _hst, IDSET_PASSWORD,     "PASSWORD=;", 1);
       WtkAddClassSetting( _hst, IDSET_PHONENUMBER,  "PHONENUMBER=;", 1);

       // settings for connect page
       WtkAddClassSetting( _hst, IDSET_IPCONFIG,     "IPCONFIG=DYNAMIC;", 1);
       WtkAddClassSetting( _hst, IDSET_LOCALIP,      "LOCALIP=;", 1);
       WtkAddClassSetting( _hst, IDSET_GATEWAY,      "GATEWAY=;", 1);
       WtkAddClassSetting( _hst, IDSET_NETMASK,      "NETMASK=;", 1);
       WtkAddClassSetting( _hst, IDSET_MTU,          "MTU=1500;", 1);
       WtkAddClassSetting( _hst, IDSET_NAMESERVER,   "NAMESERVER=;", 1);
       WtkAddClassSetting( _hst, IDSET_DEFAULTROUTE, "DEFAULTROUTE=YES", 1);

       // settings for modem page
       WtkAddClassSetting( _hst, IDSET_MODEMTYPE,    "MODEM=<none>;", 1);

       // add some details not being included on a
       // settings notebook page and not being modified by
       // setup strings
       WtkAddClassDetail( _hst, IDDETAIL_LASTSAVED_TIME);
       WtkAddClassDetail( _hst, IDDETAIL_LASTSAVED_DATE);

       // no more settings to add
       WtkCloseClassSettingsTable( _hst);
       }
}

SOM_Scope void  SOMLINK MSET_wpclsUnInitData(M_SettingsClass *somSelf)
{
    M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf);
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsUnInitData");

    // cleanup
    WtkDestroyClassSettingsTable( _hst);

    M_SettingsClass_parent_M_WPAbstract_wpclsUnInitData(somSelf);
}

SOM_Scope ULONG  SOMLINK MSET_wpclsQueryIconData(M_SettingsClass *somSelf,
                                                 PICONINFO pIconInfo)
{
    /* M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf); */
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsQueryIconData");

    // return our icon
    return WtkQueryIconData( pIconInfo,
                             WtkGetModuleHandle( (PFN)__FUNCTION__),
                             IDRES_ICON);
}

SOM_Scope PSZ  SOMLINK MSET_wpclsQueryTitle(M_SettingsClass *somSelf)
{
    /* M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf); */
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsQueryTitle");

    return "Dial-Up Connection";
}

SOM_Scope ULONG  SOMLINK MSET_wpclsQueryStyle(M_SettingsClass *somSelf)
{
    /* M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf); */
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsQueryStyle");

    return (M_SettingsClass_parent_M_WPAbstract_wpclsQueryStyle( somSelf) |
            /* CLSSTYLE_NEVERMOVE | */ CLSSTYLE_NEVERPRINT);
}

SOM_Scope BOOL  SOMLINK MSET_wpclsCreateDefaultTemplates(M_SettingsClass *somSelf,
                                                         WPObject* Folder)
{
    /* M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf); */
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsCreateDefaultTemplates");

    return TRUE; // do not create default template in template folder,
                 // we create our own in a different folder
}

SOM_Scope ULONG  SOMLINK MSET_wpclsQueryDefaultView(M_SettingsClass *somSelf)
{
    M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf);
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsQueryDefaultView");

    // make sure that the "open" menu is not available,
    // thus the menu item for "settings/properties" will be the default
    return OPEN_SETTINGS;
}


SOM_Scope ULONG  SOMLINK MSET_wpclsQueryDetailsInfo(M_SettingsClass *somSelf,
                                                    PCLASSFIELDINFO* ppClassFieldInfo,
                                                    PULONG pSize)
{
    M_SettingsClassData *somThis = M_SettingsClassGetData(somSelf);
    M_SettingsClassMethodDebug("M_SettingsClass","MSET_wpclsQueryDetailsInfo");

    return WtkQueryClassDetailsInfo( _hst,
                                    (PVOID) ppClassFieldInfo,
                                    pSize,
                                    M_SettingsClass_parent_M_WPAbstract_wpclsQueryDetailsInfo( somSelf,
                                                                                               ppClassFieldInfo,
                                                                                               pSize));
}

#pragma info( nouse )

