//
//	***********************************************************************
//					   JdeBP's 32-bit C++ Standard library
//	(c) Copyright 2000,2008 Jonathan de Boyne Pollard.
//	***********************************************************************
//
//	SUBSIDIARY OS/2 API (CONSOLE API) HEADER
//

#if !defined(OS2_CONSOLE_H_INCLUDED)
#define OS2_CONSOLE_H_INCLUDED

#if defined(__IBMC__)
#	pragma checkout( suspend )
#	ifndef __CHKHDR__
#		pragma checkout( suspend )
#	endif
#	pragma checkout( resume )
#elif defined(__IBMCPP__)
#	pragma info( none )
#	ifndef __CHKHDR__
#		pragma info( none )
#	endif
#	pragma info( restore )
#endif

#if defined(__BORLANDC__)
#	pragma option -a1
#elif defined(__IBMCPP__)
#	pragma pack(1)
#endif

//#if !defined(___STDDEF_H_INCLUDED)
//#include <_stddef.h>
//#endif

//
//	Shift state flags
//
enum {
	CON_KBD_LEFT_SHIFT_PRESSED		= 0x00000001 ,
	CON_KBD_RIGHT_SHIFT_PRESSED 	= 0x00000002 ,
	CON_KBD_FAKE_SHIFT_PRESSED		= 0x00000004 ,
	CON_KBD_LEFT_CTRL_PRESSED		= 0x00000010 ,
	CON_KBD_RIGHT_CTRL_PRESSED		= 0x00000020 ,
	CON_KBD_FAKE_CTRL_PRESSED		= 0x00000040 ,
	CON_KBD_LEFT_ALT_PRESSED		= 0x00000100 ,
	CON_KBD_RIGHT_ALT_PRESSED		= 0x00000200 ,
	CON_KBD_LEFT_WIN_PRESSED		= 0x00001000 ,
	CON_KBD_RIGHT_WIN_PRESSED		= 0x00002000 ,

	CON_KBD_ANY_SHIFT_PRESSED		= 0x00000007 ,
	CON_KBD_ANY_CTRL_PRESSED		= 0x00000070 ,
	CON_KBD_ANY_ALT_PRESSED 		= 0x00000300 ,
	CON_KBD_ANY_WIN_PRESSED 		= 0x00003000 ,

	CON_KBD_SCROLL_LOCK_PRESSED 	= 0x00010000 ,
	CON_KBD_NUM_LOCK_PRESSED		= 0x00020000 ,
	CON_KBD_CAPS_LOCK_PRESSED		= 0x00040000 ,

	CON_KBD_SCROLL_LOCK_ON			= 0x01000000 ,
	CON_KBD_NUM_LOCK_ON 			= 0x02000000 ,
	CON_KBD_CAPS_LOCK_ON			= 0x04000000 ,
	CON_KBD_INSERT_MODE_ON			= 0x08000000 //,
} ;

//
//	Flags for keyboard events
//
enum {
	CON_KBD_EVENT_IS_RELEASE		= 0x0001 ,
	CON_KBD_EVENT_HAS_VKEY			= 0x0002 ,
	CON_KBD_EVENT_HAS_CHAR			= 0x0008 ,
	CON_KBD_EVENT_HAS_SCAN			= 0x0004 //,
} ;

//
//	Keyboard virtual key numbers
//
enum {
	CON_KBD_KEY_SYSRQ				= 1 ,
	CON_KBD_KEY_PAUSE				= 2 ,
	CON_KBD_KEY_BREAK				= 3 ,
	CON_KBD_KEY_PRINTSCREEN ,
	CON_KBD_KEY_CAPSLOCK ,
	CON_KBD_KEY_NUMLOCK ,
	CON_KBD_KEY_SCRLLOCK ,
	CON_KBD_KEY_BACKSPACE			= '\b' ,
	CON_KBD_KEY_TAB 				= '\t' ,
	CON_KBD_KEY_ENTER				= 10 ,	// USB ID 07/58
	CON_KBD_KEY_RETURN				= '\r' ,// USB ID 07/28
	CON_KBD_KEY_BACKTAB 			= 14 ,
	CON_KBD_KEY_CLEAR 				= 15 ,	// USB ID 07/9C
	CON_KBD_KEY_HOME ,						// USB ID 07/4A
	CON_KBD_KEY_END ,						// USB ID 07/4D
	CON_KBD_KEY_LEFT ,						// USB ID 07/50
	CON_KBD_KEY_RIGHT ,						// USB ID 07/4F
	CON_KBD_KEY_DOWN ,						// USB ID 07/51
	CON_KBD_KEY_UP ,						// USB ID 07/52
	CON_KBD_KEY_PAGEDOWN ,					// USB ID 07/4E
	CON_KBD_KEY_PAGEUP ,					// USB ID 07/4B
	CON_KBD_KEY_INSERT ,					// USB ID 07/49
	CON_KBD_KEY_DELETE ,					// USB ID 07/4C
	CON_KBD_KEY_MENU ,
	CON_KBD_KEY_ESC 				= 27 ,
	CON_KBD_KEY_ALT ,
	CON_KBD_KEY_CTRL ,
	CON_KBD_KEY_SHIFT ,

	// Single-character punctuation keys
	CON_KBD_KEY_SPACE				= ' ' , // USB ID 07/2C
	CON_KBD_KEY_LPAREN				= '(' , // [ ( ]
	CON_KBD_KEY_RPAREN				= ')' , // [ ) ]
	CON_KBD_KEY_ASTERISK			= '*' , // USB ID 07/55
	CON_KBD_KEY_PLUS				= '+' , // USB ID 07/57
	CON_KBD_KEY_MINUS				= '-' , // USB ID 07/56
	CON_KBD_KEY_DECIMAL 			= '.' , // USB ID 07/63
	CON_KBD_KEY_DIVIDE				= '/' , // USB ID 07/54
	CON_KBD_KEY_EQUALS				= '=' , // USB ID 07/67 [ = ]

	// Double-character punctuation keys
	CON_KBD_KEY_PUNCT_COLON 		= ':' , // USB ID 07/33 [ ;: ]
	CON_KBD_KEY_PUNCT_LESS			= '<' , // USB ID 07/36 [ ,< ]
	CON_KBD_KEY_PUNCT_PLUSEQUALS	= 114 , // USB ID 07/2E [ =+ ]
	CON_KBD_KEY_PUNCT_GREATER		= '>' , // USB ID 07/37 [ .> ]
	CON_KBD_KEY_PUNCT_QUERY 		= '?' , // USB ID 07/38 [ /? ]
	CON_KBD_KEY_PUNCT_QUOTE 		= '\'', // USB ID 07/34 [ '@ ] or [ '" ]
	CON_KBD_KEY_PUNCT_LBRACKET		= '[' , // USB ID 07/2F [ [{ ]
	CON_KBD_KEY_PUNCT_EUROPE2		= '#' , // USB ID 07/64 EUROPE 2 or [ #~ ]
	CON_KBD_KEY_PUNCT_RBRACKET		= ']' , // USB ID 07/30 [ }] ]
	CON_KBD_KEY_PUNCT_VBAR			= 116 , // USB ID 07/31 [ \ ]
	CON_KBD_KEY_PUNCT_EUROPE1		= '\\' ,// USB ID 07/32 EUROPE 1
	CON_KBD_KEY_PUNCT_LSQUOTE		= 115 , // USB ID 07/35 [ `| ] or [ `~ ]
	CON_KBD_KEY_PUNCT_UNDERSCORE	= '_' , // USB ID 07/2D [ -_ ]

	// Typewriter top row digit keys
	CON_KBD_KEY_0					= '0' ,
	CON_KBD_KEY_1 ,
	CON_KBD_KEY_2 ,
	CON_KBD_KEY_3 ,
	CON_KBD_KEY_4 ,
	CON_KBD_KEY_5 ,
	CON_KBD_KEY_6 ,
	CON_KBD_KEY_7 ,
	CON_KBD_KEY_8 ,
	CON_KBD_KEY_9 ,

	// English alphabet keys
	CON_KBD_KEY_A					= 'A' ,
	CON_KBD_KEY_B ,
	CON_KBD_KEY_C ,
	CON_KBD_KEY_D ,
	CON_KBD_KEY_E ,
	CON_KBD_KEY_F ,
	CON_KBD_KEY_G ,
	CON_KBD_KEY_H ,
	CON_KBD_KEY_I ,
	CON_KBD_KEY_J ,
	CON_KBD_KEY_K ,
	CON_KBD_KEY_L ,
	CON_KBD_KEY_M ,
	CON_KBD_KEY_N ,
	CON_KBD_KEY_O ,
	CON_KBD_KEY_P ,
	CON_KBD_KEY_Q ,
	CON_KBD_KEY_R ,
	CON_KBD_KEY_S ,
	CON_KBD_KEY_T ,
	CON_KBD_KEY_U ,
	CON_KBD_KEY_V ,
	CON_KBD_KEY_W ,
	CON_KBD_KEY_X ,
	CON_KBD_KEY_Y ,
	CON_KBD_KEY_Z ,

	// Numeric keypad digit keys
	CON_KBD_KEY_NUMPAD_0			= 96 ,
	CON_KBD_KEY_NUMPAD_1 ,
	CON_KBD_KEY_NUMPAD_2 ,
	CON_KBD_KEY_NUMPAD_3 ,
	CON_KBD_KEY_NUMPAD_4 ,
	CON_KBD_KEY_NUMPAD_5 ,
	CON_KBD_KEY_NUMPAD_6 ,
	CON_KBD_KEY_NUMPAD_7 ,
	CON_KBD_KEY_NUMPAD_8 ,
	CON_KBD_KEY_NUMPAD_9 ,

	CON_KBD_KEY_WINDOW1 			= 112 ,
	CON_KBD_KEY_WINDOW2 ,

	// Function keys (bank of 64)
	CON_KBD_KEY_F1					= 0x80 ,
	CON_KBD_KEY_F2 ,
	CON_KBD_KEY_F3 ,
	CON_KBD_KEY_F4 ,
	CON_KBD_KEY_F5 ,
	CON_KBD_KEY_F6 ,
	CON_KBD_KEY_F7 ,
	CON_KBD_KEY_F8 ,
	CON_KBD_KEY_F9 ,
	CON_KBD_KEY_F10 ,
	CON_KBD_KEY_F11 ,
	CON_KBD_KEY_F12 ,
	CON_KBD_KEY_F13 ,
	CON_KBD_KEY_F14 ,
	CON_KBD_KEY_F15 ,
	CON_KBD_KEY_F16 ,
	CON_KBD_KEY_F17 ,
	CON_KBD_KEY_F18 ,
	CON_KBD_KEY_F19 ,
	CON_KBD_KEY_F20 ,
	CON_KBD_KEY_F21 ,
	CON_KBD_KEY_F22 ,
	CON_KBD_KEY_F23 ,
	CON_KBD_KEY_F24 ,
	CON_KBD_KEY_F25 ,
	CON_KBD_KEY_F26 ,
	CON_KBD_KEY_F27 ,
	CON_KBD_KEY_F28 ,
	CON_KBD_KEY_F29 ,
	CON_KBD_KEY_F30 ,
	CON_KBD_KEY_F31 ,
	CON_KBD_KEY_F32 ,
	CON_KBD_KEY_F33 ,
	CON_KBD_KEY_F34 ,
	CON_KBD_KEY_F35 ,
	CON_KBD_KEY_F36 ,
	CON_KBD_KEY_F37 ,
	CON_KBD_KEY_F38 ,
	CON_KBD_KEY_F39 ,
	CON_KBD_KEY_F40 ,
	CON_KBD_KEY_F41 ,
	CON_KBD_KEY_F42 ,
	CON_KBD_KEY_F43 ,
	CON_KBD_KEY_F44 ,
	CON_KBD_KEY_F45 ,
	CON_KBD_KEY_F46 ,
	CON_KBD_KEY_F47 ,
	CON_KBD_KEY_F48 ,

	// System keys (bank of 8)
	CON_KBD_KEY_POWER				= 0xC0 ,	// Standard power key, USB ID 01/81
	CON_KBD_KEY_SLEEP , 						// Standard sleep key, USB ID 01/82
	CON_KBD_KEY_WAKE ,							// Standard wake key, USB ID 01/83
	CON_KBD_KEY_LOGOFF ,

	// Media player application buttons (bank of 32)
	CON_KBD_KEY_PREV_TRACK			= 0x100 ,	// USB ID 0C/B5
	CON_KBD_KEY_NEXT_TRACK ,					// USB ID 0C/B6
	CON_KBD_KEY_PLAYER_STOP ,					// USB ID 0C/B7
	CON_KBD_KEY_PLAY_PAUSE ,					// USB ID 0C/CD
	CON_KBD_KEY_MUTE ,							// USB ID 0C/E2
	CON_KBD_KEY_BASS_BOOST ,					// USB ID 0C/E5
	CON_KBD_KEY_LOUDNESS ,						// USB ID 0C/E7
	CON_KBD_KEY_VOLUME_DOWN ,					// USB ID 0C/E9
	CON_KBD_KEY_VOLUME_UP , 					// USB ID 0C/EA
	CON_KBD_KEY_BASS_UP ,						// USB ID 0C/0152
	CON_KBD_KEY_BASS_DOWN , 					// USB ID 0C/0153
	CON_KBD_KEY_TREBLE_UP , 					// USB ID 0C/0154
	CON_KBD_KEY_TREBLE_DOWN ,					// USB ID 0C/0155

	// WWW browser application buttons (bank of 16)
	CON_KBD_KEY_WWW_SEARCH			= 0x120 ,	// USB ID 0C/0221
	CON_KBD_KEY_WWW_HOME ,						// USB ID 0C/0223
	CON_KBD_KEY_WWW_BACK ,						// USB ID 0C/0224
	CON_KBD_KEY_WWW_FORWARD ,					// USB ID 0C/0225
	CON_KBD_KEY_WWW_REFRESH ,					// USB ID 0C/0226
	CON_KBD_KEY_WWW_STOP ,						// USB ID 0C/0227
	CON_KBD_KEY_WWW_BOOKMARKS , 				// USB ID 0C/022A

	// Electronic mail application buttons (bank of 8)
	CON_KBD_KEY_REPLY				= 0x130 ,
	CON_KBD_KEY_MAIL_FORWARD ,
	CON_KBD_KEY_SEND ,

	// Document application buttons (bank of 8)
	CON_KBD_KEY_DOC_NEW 			= 0x138 ,
	CON_KBD_KEY_DOC_OPEN ,
	CON_KBD_KEY_DOC_CLOSE ,
	CON_KBD_KEY_SPELL ,
	CON_KBD_KEY_SAVE ,
	CON_KBD_KEY_PRINT ,

	// General application operations (bank of 64)
	CON_KBD_KEY_EXECUTE 			= 0x140 ,	// USB ID 07/74
	CON_KBD_KEY_HELP ,							// USB ID 07/75
	CON_KBD_KEY_APP_MENU ,						// USB ID 07/76
	CON_KBD_KEY_SELECT ,						// USB ID 07/77
	CON_KBD_KEY_STOP ,							// USB ID 07/78
	CON_KBD_KEY_AGAIN , 						// USB ID 07/79
	CON_KBD_KEY_REDO ,
	CON_KBD_KEY_UNDO ,							// USB ID 07/7A
	CON_KBD_KEY_CUT ,							// USB ID 07/7B
	CON_KBD_KEY_COPY ,							// USB ID 07/7C
	CON_KBD_KEY_PASTE , 						// USB ID 07/7D
	CON_KBD_KEY_FIND ,							// USB ID 07/7E
	CON_KBD_KEY_CANCEL ,						// USB ID 07/9B
	CON_KBD_KEY_PRIOR , 						// USB ID 07/9D
	CON_KBD_KEY_APP_RETURN ,					// USB ID 07/9E

	// Application launchers (bank of 32)
	CON_KBD_KEY_MESSENGER			= 0x180 ,
	CON_KBD_KEY_WORDPROCESSOR ,
	CON_KBD_KEY_SPREADSHEET ,
	CON_KBD_KEY_CALENDAR ,
	CON_KBD_KEY_FAVOURITE_APP ,
	CON_KBD_KEY_CALCULATOR ,					// USB ID 0C/0192
	CON_KBD_KEY_WWW_BROWSER ,
	CON_KBD_KEY_OFFICE_HOME ,
	CON_KBD_KEY_OFFICE ,
	CON_KBD_KEY_FAVOURITES ,
	CON_KBD_KEY_MY_MUSIC ,
	CON_KBD_KEY_MY_COMPUTER ,					// USB ID 0C/0194
	CON_KBD_KEY_MAIL ,							// USB ID 0C/018A

	CON_KBD_KEY_MEDIA_SELECT		= 0x1A0 ,	// USB ID 0C/0183
	CON_KBD_KEY_APP_LEFT ,
	CON_KBD_KEY_APP_RIGHT ,
	CON_KBD_KEY_WHEEL_UP ,
	CON_KBD_KEY_WHEEL_DOWN //,

} ;

//
//	Console mode flags
//
enum {
	CON_DISABLE_ANSI_CSI_SEQUENCES	= 0x0001 ,
	CON_DISABLE_ANSI_CONTROL_CHARS	= 0x0002 ,
	CON_DISABLE_WRAP_AT_EOL 		= 0x0004 ,
	CON_ENABLE_UTF8_OUTPUT			= 0x0008 ,
	CON_DISABLE_EDITING_KEYS		= 0x0010 ,
	CON_DISABLE_LINE_INPUT			= 0x0020 ,
	CON_DISABLE_LINE_INPUT_ECHO 	= 0x0040 ,
	CON_ENABLE_PASSWORD_MODE		= 0x0080 ,
	CON_ENABLE_UTF8_INPUT			= 0x0100 ,
	CON_ENABLE_SHIFT_EVENTS 		= 0x1000 ,
	CON_ENABLE_MOUSE_EVENTS 		= 0x2000 ,
	CON_ENABLE_SIZE_EVENTS			= 0x4000 //,
} ;

typedef unsigned short CONSOLE_UNICHAR ;			// UCS-2 character

#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
_Packed
#endif
struct CONSOLE_INPUT_EVENT {
	enum { NONE, KEY, MOUSE, WINDOW_SIZE, MENU, FOCUS } ;
	USHORT Type ;
#if defined(__HIGHC__) || defined(__WATCOMC__)
	unsigned long long TimeStamp ;
#else
	unsigned long TimeStampLo, TimeStampHi ;
#endif

	union {
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			uint32_t Flags ;
			uint16_t RepeatCount ;
			uint16_t VirtualKeyCode ;
			uint16_t ScanCode ;
			CONSOLE_UNICHAR Character ;
			uint32_t ShiftState ;
		} KeyEvent ;
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			size_t Row, Column ;
			uint32_t ButtonState ;
			uint32_t ShiftState ;
			enum { CLICK, DOUBLE_CLICK, MOTION } ;
			uint32_t EventType ;
		} MouseEvent ;
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			size_t Width, Height ;
		} OutputBufferSizeEvent ;
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			char reserved[32] ;
		} NullEvent ;
	} ;
} ;

#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
_Packed
#endif
struct CONSOLE_CELL {
	CONSOLE_UNICHAR Char ;
	unsigned char Attr ;

	CONSOLE_CELL () {}
	CONSOLE_CELL ( CONSOLE_UNICHAR c, unsigned char a ) : Char(c), Attr(a) {}
} ;

enum {
	CON_ATTR_BLACK,
	CON_ATTR_BLUE,
	CON_ATTR_GREEN,
	CON_ATTR_CYAN,
	CON_ATTR_RED,
	CON_ATTR_MAGENTA,
	CON_ATTR_YELLOW,
	CON_ATTR_WHITE,
	CON_ATTR_BRIGHT//,
} ;

#if defined(__IBMCPP__)
inline
#else
extern inline
#endif
unsigned char
CONSOLE_MAKE_ATTR ( unsigned char brfg, unsigned char fg, unsigned char brbg, unsigned char bg )
{
	return ((
			(brbg ? CON_ATTR_BRIGHT : 0) | (bg & 7)
			) << 4)
			|
			(brfg ? CON_ATTR_BRIGHT : 0) | (fg & 7) ;
}

extern "C" {

APIRET APIENTRY DosWriteConsoleOutputCellStr		( HFILE Handle, const CONSOLE_CELL * PtrCellStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputCharStr		( HFILE Handle, const CONSOLE_UNICHAR * PtrCharStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputAttrStr		( HFILE Handle, const unsigned char * PtrAttrStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputCharStrAttr	( HFILE Handle, const CONSOLE_UNICHAR * PtrCharStr, size_t Cells, size_t Row, size_t Col, unsigned char Attr ) ;
APIRET APIENTRY DosWriteConsoleOutputNAttr			( HFILE Handle, unsigned char Attr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputNCell			( HFILE Handle, const CONSOLE_CELL & Cell, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputNChar			( HFILE Handle, CONSOLE_UNICHAR Char, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosReadConsoleOutputCellStr 		( HFILE Handle, CONSOLE_CELL * PtrCellStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosReadConsoleOutputCharStr 		( HFILE Handle, CONSOLE_UNICHAR * PtrCharStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosReadConsoleOutputAttrStr 		( HFILE Handle, unsigned char * PtrAttrStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosScrollConsoleUp					( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosScrollConsoleDown				( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosScrollConsoleLeft				( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosScrollConsoleRight				( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosSetConsoleCursorPos				( HFILE Handle, size_t Row, size_t Col ) ;
APIRET APIENTRY DosQueryConsoleCursorPos			( HFILE Handle, size_t & Row, size_t & Col ) ;
APIRET APIENTRY DosSetConsoleCursorSize 			( HFILE Handle, unsigned int PercentStart, unsigned int PercentEnd, BOOL Visible ) ;
APIRET APIENTRY DosQueryConsoleCursorSize			( HFILE Handle, unsigned int & PercentStart, unsigned int & PercentEnd, BOOL & Visible ) ;
APIRET APIENTRY DosSetConsoleShiftState 			( HFILE Handle, ULONG ShiftState ) ;
APIRET APIENTRY DosQueryConsoleShiftState			( HFILE Handle, ULONG & ShiftState ) ;
APIRET APIENTRY DosSetConsoleSize					( HFILE Handle, size_t Rows, size_t Cols ) ;
APIRET APIENTRY DosQueryConsoleSize 				( HFILE Handle, size_t & Rows, size_t & Cols ) ;
APIRET APIENTRY DosQueryConsoleMaximumSize			( HFILE Handle, size_t & Rows, size_t & Cols ) ;
APIRET APIENTRY DosSetConsoleWindow					( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width ) ;
APIRET APIENTRY DosQueryConsoleWindow	 			( HFILE Handle, size_t & Top, size_t & Left, size_t & Height, size_t & Width ) ;
APIRET APIENTRY DosQueryConsoleMaximumWindowSize	( HFILE Handle, size_t & Rows, size_t & Cols ) ;
APIRET APIENTRY DosSetConsoleMode					( HFILE Handle, ULONG Flags ) ;
APIRET APIENTRY DosQueryConsoleMode 				( HFILE Handle, ULONG & Flags ) ;
APIRET APIENTRY DosSetConsoleOutputAttr 			( HFILE Handle, unsigned char OutputAttr, unsigned char ScrollAttr ) ;
APIRET APIENTRY DosSetConsoleOutputFocus			( HFILE Handle ) ;
APIRET APIENTRY DosSetConsoleInputFocus 			( HFILE Handle ) ;
APIRET APIENTRY DosSetConsoleOutputCodePage 		( HFILE Handle, unsigned int CodePage ) ;
APIRET APIENTRY DosQueryConsoleOutputCodePage		( HFILE Handle, unsigned int & CodePage ) ;
APIRET APIENTRY DosSetConsoleInputCodePage			( HFILE Handle, unsigned int CodePage ) ;
APIRET APIENTRY DosQueryConsoleInputCodePage		( HFILE Handle, unsigned int & CodePage ) ;
APIRET APIENTRY DosReadConsoleInputEvent			( HFILE Handle, CONSOLE_INPUT_EVENT * Events, size_t MaxEvents, size_t & NumEvents, BOOL remove ) ;
APIRET APIENTRY DosWriteConsoleInputEvent 			( HFILE Handle, CONSOLE_INPUT_EVENT * Events, size_t MaxEvents, size_t & NumEvents ) ;
APIRET APIENTRY DosQueryConsoleInputEventCount		( HFILE Handle, size_t & NumEvents ) ;
APIRET APIENTRY DosFlushConsoleInputEvents			( HFILE Handle ) ;
APIRET APIENTRY DosQueryConsoleNumberOfMouseButtons ( HFILE Handle, size_t & Buttons ) ;
//APIRET APIENTRY DosSetConsoleTitle					( HFILE Handle, const CONSOLE_UNICHAR * PtrTitleStr ) ;
//APIRET APIENTRY DosQueryConsoleTitle					( HFILE Handle, CONSOLE_UNICHAR * PtrTitleStr, size_t BufLen, size_t & Length ) ;

}

#if defined(__BORLANDC__)
#	pragma option -a.
#elif defined(__IBMCPP__)
#	pragma pack()
#endif

#if defined(__IBMC__)
#	pragma checkout( suspend )
#	ifndef __CHKHDR__
#		pragma checkout( resume )
#	endif
#	pragma checkout( resume )
#elif defined(__IBMCPP__)
#	pragma info( none )
#	ifndef __CHKHDR__
#		pragma info( restore )
#	endif
#	pragma info( restore )
#endif

#endif /*!defined(OS2_CONSOLE_H_INCLUDED)*/
