#
#
# Recipes for gcc 3.x under OS/2.
#
#	Jon Saxton, March 2004
#
# It is a common convention on UNIX systems that .c files are C sources
# and .C files are to be compiled as C++ source.  Since that is not
# portable to case-preserving but case-insensitive systems like Windows
# and OS/2, I do not use that convention on  ANY platform.  All my
# source files have lower-case extensions.
#
# I have adopted a few conventions of my own.  Sometimes I need to build
# dynamically linkable libraries (.DLL on Windows and OS/2, .so on UNIX)
# and typically these builds require compilation with a different set of
# switches from those used when building for
#
#
#
# .cpp and .c files are compiled for DLL inclusion.
# .cxx and .cx files are compiled for linking to executables.
#
# .cc files are a special case.  They are like .cxx files and are
#	compiled as exectables but they are intended for inclusion
#	in statically linkable libraries.
#
#

$(OBJ)/%$O : %.cpp ; $(CCC) -c $(CFLAGS) $(GENDLL) $(OPUT)$@ $<

$(OBJ)/%$O : %.c ; $(CC) -c $(CFLAGS) $(GENDLL) $(OPUT)$@ $<

$(OBJ)/%$O : %.cc ; $(CCC) -c $(CFLAGX) $(GENEXE) $(OPUT)$@ $<

$(OBJ)/%$O : %.cx ; $(CC) -c -x c $(CFLAGX) $(GENEXE) $(OPUT)$@ $<

$(OBJ)/%$O : %.cxx ; $(CCC) -c $(CFLAGS) $(GENEXE) $(OPUT)$@ $<

# This only for OS/2    $(OBJ)/%$O : %.asm ; alp +Od -Fdo:$(OBJ) $<
