# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
# This is a secondary configuration file for dmake.  It is the first one
# included from startup.mk.
#
#	Jon Saxton
#	js@triton.vg
#	March 2004
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
# Operating systems report themselves in different ways.  Here I attempt to
# make some rational substitutions.  This list is far from complete and
# encompasses just those systems with which I have direct experience.
#
# One easy way to see how your operating identifies itself is:
#	set | grep OS
# Of course that assumes you have a fairly standard shell and a working
# grep utility.  Without grep, the following should work on OS/2 and
# Windows.
#	set | find "OS"
# In the case of OS/2 either method will generate lots of output you may
# want to pipe the output into less or more.
#	set | find "OS" | more

.IF $(OS)
  .IF $(OS) == ecs				# eComStation 1.1
    OS != os2
    __OS__ = __OS2__
  .ELIF $(OS) == Windows_NT			# Windows 2000
    OS != win32
    __OS__ = __WIN32__
  .ELIF $(OS) == sunos || $(OS) == SOLARIS	# Solaris
    OS != sun
    __OS__ = __UNIX__
  .ENDIF
.ELIF $(OSTYPE)
  .IF $(OSTYPE) == linux-gnu			# Gentoo linux
     OS = linux
     __OS__ = __UNIX__
  .ENDIF
.ELSE
  Error: OS not defined in environment.
.ENDIF

# In all environments I like to keep the directory containing my primary
# sources clear of all generated files.  To this end I usually put inter-
# mediate files in a subdirectory and final files in the parent directory.
# Here I set up the defaults.  Obviously these defaults can be overridden
# by subordinate configuration files.

# Subdirectory for intermediate files
OBJ	= obj

# Directory for final (binary) files
B	= ..
