/* -------------------------------------------------------------------

	Project: General utility classes

	Objective-C interface file for the class file

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.2
	1995-Jul-12			___

 */

#ifndef _FILE_H_
#define _FILE_H_
/*====================================================================
                       Interface of class file                        
====================================================================*/
#include <objc/Object.h>
#include <stdlib.h>

@interface File : Object
{
  FILE *handle;
  char *fileName;
  long  recordSize;
  long  recordCount;
  long  currentRecord;
}

/* -------------------------- Initialize -------------------------- */
-init;
-initForReading: (char *) string recordSize: (long) aRecSize;
-initForWriting: (char *) string recordSize: (long) aRecSize;
-createForWriting: (char *) string recordSize: (long) aRecSize;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-(char *) fileName;
-(long) recordSize;
-(long) recordCount;
-(long) currentRecord;
-setFileName: (char *) string;
-setRecordSize: (long) size;

/* ------------------------ Public methods ------------------------ */
-(long) append: (void *) record;
-(void *) fetch: (void *) record;
-(void *) fetch: (void *) record index: (long) index;
-(void *) first: (void *) record;
-(void *) next: (void *) record;
-(long) replace: (void *) record;
-(long) replace: (void *) record index: (long) index;

@end
#endif
