/* -------------------------------------------------------------------

	Project: 

	Objective-C interface file for the class BTree

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev:
	1995-Oct-04			___

 */

#ifndef _BTREE_H_
#define _BTREE_H_

/*====================================================================
                       Interface of class BTree                       
====================================================================*/
#include <util/OrganizedFile.h>

@interface BTree : OrganizedFile
{
  unsigned long  keySize;
  unsigned long  dataSize;
  unsigned short minitems;
  unsigned short maxitems;

  void *splitKey;
  void *splitData;
  void *splitKey2;
  void *splitData2;
  long  splitPage;

  void *foundData;

  int (*cmpFunc) (void *,void *,unsigned long);
}

/* -------------------------- Initialize -------------------------- */
-initForFile: (char *) string keySize: (unsigned long) ks dataSize: (unsigned long) ds;
-createForFile: (char *) string keySize: (unsigned long) ks dataSize: (unsigned long) ds;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-printOrder;
-printOrderPage: (unsigned long) page;
-printTree;
-printPage: (unsigned long) page;

-setCmpFnc: (int (void *,void *,unsigned long)) aFunc;

-(void *) data;

/* ------------------------ Public methods ------------------------ */
-(BOOL) find: (void *) key;
-(BOOL) insert: (void *) key data: (void *) data;
-(BOOL) deleteKey: (void *) key;

/* ----------------------- Private methods ------------------------ */
-(BOOL) find: (void *) key in: (long) page;
-(BOOL) insert: (void *) key data: (void *) data in: (long) page;
-insert: (void *) key data: (void *) data atIndex: (unsigned short) index into: (void *) p;
-(BOOL) deleteKey: (void *) key in: (unsigned long) page;
-deleteNodeItemFrom: (unsigned long) page;
-deleteUnderflowForIndex: (unsigned long) index from: (void *) p;

-(BOOL) findIndex: (unsigned short *) index forKey: (void *) k inPage: (void *) p;

//- (int) compare: (void *) key1 with: (void *) key2;

/* ---------------------- Archiving methods ----------------------- */

@end
#endif

