/* -------------------------------------------------------------------

	Project: Objective C PM class library

	Objective-C interface file for the class profile

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.1
	1995-Jul-19			___

 */

/*====================================================================
                      Interface of class profile                      
====================================================================*/

#ifndef _PROFILE_H_
#define _PROFILE_H_

#ifndef _OS2EMX_H
#include <objc/os2.h>
#endif

#ifndef _STDAPP_H_
#include <pm/stdapp.h>
#endif

@interface Profile : Object
{
  HINI profileHandle;
}

/* -------------------------- Initialize -------------------------- */
-init;
-init: (char *) name forApp: (StdApp *) app;
-initUserProfile;
-initSystemProfile;
/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */

/* ------------------------ Public methods ------------------------ */
-deleteKey: (char *) key section: (char *) section;
-(void *) readData: (void *) data key: (char *) key section: (char *) section;
-(void *) readData: (void *) data size: (long) size key: (char *) key section: (char *) section;
-(char *) readString: (char *) data key: (char *) key section: (char *) section;
-(char *) readString: (char *) data size: (long) size key: (char *) key section: (char *) section;
-(long) sizeForKey: (char *) key section: (char *) section;
-writeData: (void *) data size: (long) size key: (char *) key section: (char *) section;
-writeString: (char *) data key: (char *) key section: (char *) section;

/* ----------------------- Private methods ------------------------ */

@end

#endif
