/* -------------------------------------------------------------------

	Project:

	Objective-C interface file for the class mle

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev:
	1995-Aug-13			___

 */

#ifndef _MLE_H_
#define _MLE_H_

#ifndef _FACTORYWINDOW_H_
#include <pm/FactoryWindow.h>
#endif

#ifndef _SELECTION_H_
#include <pm/Selection.h>
#endif

/*====================================================================
                        Interface of class mle                        
====================================================================*/

@interface MultiLineEntryField : FactoryWindow <Archiving,Selection>
{
}

/* -------------------------- Initialize -------------------------- */
- initWithId: (ULONG) anId andFlags: (ULONG) flags in: (Window *) parent;

/* ----------------------------- Free ----------------------------- */

/* ----------- Methods for access to Instance Variables ----------- */

/* -------------------------- Selection --------------------------- */
-clearSelection: sender;
-copySelection: sender;
-cutSelection: sender;
-pasteSelection: sender;

/* ------------------------ Public methods ------------------------ */
-(long) indexForLine: (long) line;
-delete: (unsigned long) count at: (long) index;
-insertText: (char *) aText;
-insertText: (char *) aText at: (long) index;
-appendText: (char *) aText;

-clearAll: sender;

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */
- read: (TypedStream *) aStream;
- write: (TypedStream *) aStream;
- awake;

- createInPMWindow: (HWND) window;

@end

#endif
