/* list1603.cmd */
IF LoadRexxUtil() THEN
  EXIT

CALL CharOut 'CON:', '1B'x || '[37;40m'
CALL SysCls
CALL CharOut 'CON:', Center('Simple Menu', 80)

menu.0 = 3
menu.1.row = 5; menu.1.col = 34
menu.1.txt = 'First line'
menu.1.act = 'CALL Line1'

menu.2.row = 6; menu.2.col = 34
menu.2.txt = 'Second line'
menu.2.act = 'CALL Line2'

menu.3.row = 7; menu.3.col = 34
menu.3.txt = 'Exit'
menu.3.act = 'RETURN'

CALL DoMenu

CALL SysCurState 'ON'
'cls'
EXIT

/* Procedure for menu line 1 */
Line1: PROCEDURE
  CALL SysCurPos 24, 1
  text = Left('First line of menu selected', 60)
  CALL CharOut 'CON:', text
  RETURN

/* Procedure for menu line 2 */
Line2: PROCEDURE
  CALL SysCurPos 24, 1
  text = Left('Second line of menu selected', 60)
  CALL CharOut 'CON:', text
  RETURN

/*********************************************************/
/* Display and process the menu.			 */
/*********************************************************/
DoMenu: PROCEDURE EXPOSE menu.
  colorNormal = '1B'x || '[37;40m'
  colorReverse = '1B'x || '[30;47m'
  keyEnter = '0D'x
  keyUp = '48'x
  keyDown = '50'x
  keyPrefix1 = '00'x
  keyPrefix2 = 'E0'x

  CALL SysCurState 'OFF'
  CALL CharOut 'CON:', colorNormal
  DO i = 1 TO menu.0
    CALL SysCurPos menu.i.row, menu.i.col
    CALL CharOut 'CON:', menu.i.txt
  END
  i = 1
  DO FOREVER
    CALL SysCurPos menu.i.row, menu.i.col
    CALL CharOut 'CON:', colorReverse || menu.i.txt
    CALL CharOut 'CON:', colorNormal
    key = SysGetKey('NOECHO')
    next = i
    SELECT
      WHEN key == keyEnter THEN
	INTERPRET menu.i.act
      WHEN key == keyPrefix1 | key == keyPrefix2 THEN
	DO
	key = SysGetKey('NOECHO')
	SELECT
	  WHEN key == keyUp THEN
	    IF i > 1 THEN
	      next = i - 1
	  WHEN key == keyDown THEN
	    IF i < menu.0 THEN
	      next = i + 1
	  OTHERWISE
	    NOP;
	END
	END
      OTHERWISE
	NOP;
    END
    IF next >< i THEN
      DO
      CALL SysCurPos menu.i.row, menu.i.col
      CALL CharOut 'CON:', menu.i.txt
      i = next
      END
  END
  RETURN

/* Load the RexxUtil library */
LoadRexxUtil: PROCEDURE
  IF RxFuncQuery('SysLoadFuncs') THEN
    DO
    IF RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') THEN
      DO
      SAY "Error: Couldn't load RexxUtil library."
      RETURN 1
      END
    CALL SysLoadFuncs
    END
  RETURN 0
