
/*
 *	This file was generated by the SOM Compiler.
 *	Generated using:
 *	   SOM incremental update: 2.24
 */


/*******************************************************************************
* FILE NAME: sdbmeta.cpp													   *
*																			   *
* DESCRIPTION:																   *
*	Class implementation of the class:										   *
*	  SdbMeta- Metaclass for Sdb											   *
*******************************************************************************/

/*
 *	This file was generated by the SOM Compiler and Emitter Framework.
 *	Generated using:
 *		SOM Emitter emitxtm: 2.42
 */

#ifndef SOM_Module_sdbmeta_Source
#define SOM_Module_sdbmeta_Source
#endif
#define SdbMeta_Class_Source

#include "sdbmeta.xih"
#include "general.h"
#include "isam.hpp"


//------------------------------------------------------------------------------
// SdbMeta :: setLocking
//
// Operation: Set locking parameters.
//------------------------------------------------------------------------------
SOM_Scope void	SOMLINK setLocking(SdbMeta *somSelf,  Environment *ev,
								   short tries, long delay,
								   long timeout)
{
	SdbMetaData *somThis = SdbMetaGetData(somSelf);
	SdbMetaMethodDebug("SdbMeta","setLocking");

	somThis->iLockTryCount = tries;
	somThis->iLockDelayMs = delay;
	somThis->iLockTimeoutMs = timeout;
	ISAM::setRetry(tries, delay, timeout);
	return;
}

//------------------------------------------------------------------------------
// SdbMeta :: setBuffers
//
// Operation: Set buffer parameters.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setBuffers(SdbMeta *somSelf,  Environment *ev,
									  short numBufs, short bufSize)
{
	SdbMetaData *somThis = SdbMetaGetData(somSelf);
	SdbMetaMethodDebug("SdbMeta","setBuffers");

	somThis->iBufferCount = numBufs;
	somThis->iBufferSize = bufSize;
	int result = ISAM::init(numBufs, bufSize);
	return (result == I_OK);
}

//------------------------------------------------------------------------------
// SdbMeta :: lockTries
//
// Operation: Return number of lock tries.
//------------------------------------------------------------------------------
SOM_Scope short  SOMLINK lockTries(SdbMeta *somSelf,  Environment *ev)
{
	SdbMetaData *somThis = SdbMetaGetData(somSelf);
	SdbMetaMethodDebug("SdbMeta","lockTries");

	return (somThis->iLockTryCount);
}

//------------------------------------------------------------------------------
// SdbMeta :: lockDelay
//
// Operation: Return lock delay.
//------------------------------------------------------------------------------
SOM_Scope long	SOMLINK lockDelay(SdbMeta *somSelf,  Environment *ev)
{
	SdbMetaData *somThis = SdbMetaGetData(somSelf);
	SdbMetaMethodDebug("SdbMeta","lockDelay");

	return (somThis->iLockDelayMs);
}

//------------------------------------------------------------------------------
// SdbMeta :: lockTimeout
//
// Operation: Return lock timeout.
//------------------------------------------------------------------------------
SOM_Scope long	SOMLINK lockTimeout(SdbMeta *somSelf,  Environment *ev)
{
	SdbMetaData *somThis = SdbMetaGetData(somSelf);
	SdbMetaMethodDebug("SdbMeta","lockTimeout");

	return (somThis->iLockTimeoutMs);
}

//------------------------------------------------------------------------------
// SdbMeta :: renameDb
//
// Operation: Rename a database.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK renameDb(SdbMeta *somSelf,  Environment *ev,
									string oldName, string newName)
{
	SdbMetaData *somThis = SdbMetaGetData(somSelf);
	SdbMetaMethodDebug("SdbMeta","renameDb");

	int result = ISAM::rename(oldName, newName);
	return (result == I_OK);
}

//------------------------------------------------------------------------------
// SdbMeta :: somDefaultInit
//
// Operation: Initialize class object
//------------------------------------------------------------------------------

/*
 * SOM_Scope void SOMLINK somDefaultInit(SdbMeta *somSelf, somInitCtrl* ctrl)
 */

/*
 * The prototype for somDefaultInit was replaced by the following prototype:
 */
SOM_Scope void SOMLINK somDefaultInit(SdbMeta *somSelf, som3InitCtrl* ctrl)
{
	SdbMetaData *somThis; /* set in BeginInitializer */
	somInitCtrl globalCtrl;
	somBooleanVector myMask;
	SdbMetaMethodDebug("SdbMeta","somDefaultInit");
	SdbMeta_BeginInitializer_somDefaultInit;

	SdbMeta_Init_SOMClass_somDefaultInit(somSelf, ctrl);

	/*
	 * local SdbMeta initialization code added by programmer
	 */

	somThis->iBufferCount = DEFAULT_BUFCNT;
	somThis->iBufferSize = DEFAULT_BUFSIZE;
	somThis->iLockTryCount = DEFAULT_LOCK_TRY;
	somThis->iLockDelayMs = DEFAULT_LOCK_DELAY;
	somThis->iLockTimeoutMs = DEFAULT_LOCK_TIMEOUT;
}

//------------------------------------------------------------------------------
// SdbMeta :: somDestruct
//
// Operation: Destroy class object
//------------------------------------------------------------------------------

/*
 * SOM_Scope void SOMLINK somDestruct(SdbMeta *somSelf, octet doFree,
 *									  somDestructCtrl* ctrl)
 */

/*
 * The prototype for somDestruct was replaced by the following prototype:
 */
SOM_Scope void SOMLINK somDestruct(SdbMeta *somSelf, octet doFree,
								   som3DestructCtrl* ctrl)
{
	SdbMetaData *somThis; /* set in BeginDestructor */
	somDestructCtrl globalCtrl;
	somBooleanVector myMask;
	SdbMetaMethodDebug("SdbMeta","somDestruct");
	SdbMeta_BeginDestructor;

	/*
	 * local SdbMeta deinitialization code added by programmer
	 */

	SdbMeta_EndDestructor;
}
