
/*
 * This file was generated by the SOM Compiler.
 * FileName: myfolder.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

/******************************************************************************
*
*  Module Name: MYFOLDER.C
*
*  OS/2 Work Place Shell Sample Program
*
*  Copyright (C) 1994, 1995 IBM Corporation
*
*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
*      sample code created by IBM Corporation. This sample code is not
*      part of any standard or IBM product and is provided to you solely
*      for  the purpose of assisting you in the development of your
*      applications.  The code is provided "AS IS", without
*      warranty of any kind.  IBM shall not be liable for any damages
*      arising out of your use of the sample code, even if they have been
*      advised of the possibility of such damages.
*
*  Entry Points:
*
*     Class Methods:
*
*        myfoldM_clsQueryModuleHandle
*
*     Overridden Class Methods:
*
*        myfoldM_wpclsInitData
*        myfoldM_wpclsQueryTitle
*        myfoldM_wpclsQueryIconData
*        myfoldM_wpclsQueryIconDataN
*        myfoldM_wpclsQueryDefaultView
*        myfoldM_wpclsQueryDefaultHelp
*        myfoldM_wpclsQueryStyle
*
*     Instance Methods:
*
*        myfold_closeViews
*        myfold_queryFirstViewHandle
*        myfold_setFirstViewHandle
*
*     Overridden Instance Methods:
*
*        myfold_wpOpen
*        myfold_wpClose
*        myfold_wpMenuItemHelpSelected
*        myfold_wpMenuItemSelected
*        myfold_wpModifyPopupMenu
*        myfold_wpDragOver
*        myfold_wpDrop
*        myfold_wpDeleteFromObjUseList
*        myfold_wpQueryConcurrentView
*        myfold_wpInitData
*        myfold_wpPrintObject
*        myfold_wpAddToContent
*        myfold_wpDeleteFromContent
*
*     Non-Method Functions:
*
*
******************************************************************************/

#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <string.h>

#define MYFOLDER_Class_Source
#define M_MYFOLDER_Class_Source
#include "myfolder.ih"
/* CSC2IDL:  REMOVED after .csc -> .idl conversion:   #include "myfolder.ph" */

/***************** GLOBAL/STATIC (NON-INSTANCE) DATA SECTION ******************
*****                                                                     *****
*****    This data shouldn't be changed by instance methods or it will    *****
*****    effect all instances!  Any variables that are specific (unique   *****
*****    values) for each instance of this object should be declared as   *****
*****  instance data or dynamically allocated and stored as window data.  *****
*****                                                                     *****
*****      This global data should be declared as class instance data     *****
*****    if it will change after initialization.  In this case, it will   *****
*****                  be accessed through class methods.                 *****
*****                                                                     *****
******************************************************************************/

   UCHAR      szMYFOLDERClassTitle[CCHMAXPATH] = "";
   CHAR       szHelpLibrary[] =          "myfolder.hlp";
   HMODULE    hmod = NULLHANDLE;

/*
 *  METHOD: closeViews                                     ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Close all but the first of the currently open views of a myfolder object.
 *
 *  NOTE: There is a "Close Views" option on the context menu, that will
 *         call this method
 */
SOM_Scope void   SOMLINK myfold_closeViews(MYFOLDER *somSelf)
{
    PUSEITEM  pUseItem, pUseItemNext;
    PVIEWITEM pViewItem;
    HWND      hwndView;
    typedef struct _HANDLENODE
    {
       LHANDLE handle;
       struct _HANDLENODE * pNextHandle;
    } HANDLENODE;
    HANDLENODE *pHandles = NULL;
    HANDLENODE *pTemp = NULL;

    /* MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
    MYFOLDERMethodDebug("MYFOLDER","myfold_closeViews");


    /* go through use list looking for OPENVIEW use items, as you
     * find one, add view item's handle to a list
     */
    for ( pUseItem = _wpFindUseItem(somSelf , USAGE_OPENVIEW, NULL);
          pUseItem;
          pUseItem = _wpFindUseItem(somSelf , USAGE_OPENVIEW, pUseItem) )
    {
       if (pTemp = (HANDLENODE*)_wpAllocMem(somSelf,sizeof(HANDLENODE),NULL))
       {
          pViewItem = (PVIEWITEM)(pUseItem + 1);
          pTemp->handle = pViewItem->handle;       /* hwnd of view */
          pTemp->pNextHandle = pHandles;
          pHandles = pTemp;
       }
    }

    /* go through list of handles we just found and close any
     * views other than the first one
     */
    pTemp = pHandles;
    while (pTemp)
    {
       if (_queryFirstViewHandle(somSelf) != (HWND)pTemp->handle )
       {
          WinSendMsg( (HWND)pTemp->handle, WM_CLOSE, 0, 0);
       }
       pTemp = pTemp->pNextHandle;
    }

    /* free our list */
    while (pHandles)
    {
       pTemp = pHandles;
       pHandles = pTemp->pNextHandle;
       _wpFreeMem(somSelf,(PBYTE)pTemp);
    }

}

/*
 *
 *   METHOD: queryFirstViewHandle                           ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     return the handle of the view that was opened first of the
 *     currently open views of this myfolder object.
 *
 */
SOM_Scope HWND   SOMLINK myfold_queryFirstViewHandle(MYFOLDER *somSelf)
{
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    MYFOLDERMethodDebug("MYFOLDER","myfold_queryFirstViewHandle");

    return _hwndFirstView;
}

/*
 *
 *   METHOD: setFirstViewHandle                             ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     Do special processing on first open of folder
 *
 *   PARAMETERS:
 *
 *      HWND - hwnd of the first of multiple currently opened
 *             views of this object
 *
 *   RETURNS:
 *
 *      TRUE - hwnd set successfully
 *      FALSE - first hwnd wasn't set successfully
 *
 */
SOM_Scope BOOL   SOMLINK myfold_setFirstViewHandle(MYFOLDER *somSelf,
                HWND hwndView)
{
    BOOL rc = TRUE;
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    MYFOLDERMethodDebug("MYFOLDER","myfold_setFirstViewHandle");

    if (hwndView != NULLHANDLE)
    {
      if (_hwndFirstView == NULLHANDLE)  /* no current first view */
      {
         _hwndFirstView = hwndView;     /* setting to a first view handle */
      }
      else
      {
         /* a non-null _hwndFirstView can only be wiped out by resetting it
          * to NULLHANDLE, not to another handle.  This prevents a
          * misuse of this method
          */
         rc = FALSE;
      }

    }
    else      /* wiping out first view handle */
    {
       _hwndFirstView = NULLHANDLE;
    }

    return rc;
}

/*
 *  METHOD: wpOpen                                         ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Do special processing on first open of folder
 */
SOM_Scope HWND   SOMLINK myfold_wpOpen(MYFOLDER *somSelf,
                HWND hwndCnr,
                ULONG ulView,
                ULONG param)
{
    HWND        hwndFromParentOpen = NULLHANDLE;
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpOpen");

    if (_queryFirstViewHandle(somSelf) == NULLHANDLE)
    {

       /* we ONLY want to do this on the FIRST open of the folder.
        */
       if (_wpPopulate(somSelf, NULLHANDLE, NULL, FALSE))
        {
           WPObject *Obj;
           WPObject *LastFoundObj = NULL;

           /* loop through the contents of the folder, checking each to
            * see if it is an instance of a WPFolder, we'll delete any
            * WPFolders as a cleanup step
            */
           for ( Obj = _wpQueryContent(somSelf,NULL,(ULONG)QC_First);
                 Obj;
                 Obj = _wpQueryContent(somSelf, Obj, (ULONG) QC_Next ))
           {
              /* delete the last object found on the previous iteration
               * of the loop (we couldn't delete it then, because we
               * needed it at the top of the loop for this iteration)
               */
              if (LastFoundObj)
              {
                 _wpDelete(LastFoundObj,0);
                 LastFoundObj = NULL;
              }

              /* we want to make sure that all previously
               * existing folders are deleted
               */
              if (_somIsA(Obj, _WPFolder))
              {
                 LastFoundObj = Obj;
              }

           }  /* end for */


           /* if there is still one object left to delete, do it now
            */
           if (LastFoundObj)
           {
              _wpDelete(LastFoundObj,0);
              LastFoundObj = NULL;
           }
       } /* end if populate */
    } /* end if first open */

    /* now, show the opened folder */
    hwndFromParentOpen = parent_wpOpen(somSelf, hwndCnr, ulView, param);

    /* if this is the first open, set our global flag
     */
    if (_queryFirstViewHandle(somSelf) == NULLHANDLE)
    {
        _setFirstViewHandle(somSelf, hwndFromParentOpen);
    }

    return hwndFromParentOpen;
}

/*
 *
 *   METHOD: wpInitData                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     Set object's detail class to be MYFILE
 *
 */

SOM_Scope VOID   SOMLINK myfold_wpInitData(MYFOLDER *somSelf)
{
    SOMClass * pClass;
    somId      ClassId;
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpInitData");

    parent_wpInitData(somSelf);
    ClassId = SOM_IdFromString( "MYFILE" );
    pClass = _somFindClass( SOMClassMgrObject, ClassId, 1, 1);
    SOMFree(ClassId);         /* always free somIds */
    _wpSetFldrDetailsClass(somSelf, pClass);
    _wpSetFldrSortClass(somSelf, pClass);
}
/*
 * METHOD: wpModifyPopupMenu                              ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   Add our extra option to the context menu to close all but first view
 */
SOM_Scope BOOL   SOMLINK myfold_wpModifyPopupMenu(MYFOLDER *somSelf,
                HWND hwndMenu,
                HWND hwndCnr,
                ULONG iPosition)
{
    HMODULE    hmod = NULLHANDLE;
    zString    zsPathName;

    /* MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpModifyPopupMenu");

    hmod = _clsQueryModuleHandle(_MYFOLDER);
    if (hmod)
    {
       _wpInsertPopupMenuItems( somSelf, hwndMenu, 0, hmod, ID_CLOSEVIEWSMENU, 0);
    }

    return (parent_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition));

}

/*
 * METHOD: wpMenuItemSelected                             ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   Process extra menu option that we added.
 */
SOM_Scope BOOL   SOMLINK myfold_wpMenuItemSelected(MYFOLDER *somSelf,
                HWND hwndFrame,
                ULONG ulMenuId)
{
    /* MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpMenuItemSelected");

    if (ulMenuId == IDM_CLOSEVIEWS)
    {
       _closeViews(somSelf);
       return(TRUE);
    }
    else
    {
       return (parent_wpMenuItemSelected(somSelf,hwndFrame,ulMenuId));
    }
}


/*
 *
 *  METHOD: wpMenuItemHelpSelected                         ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Process help for the extra menu option that we added.
 *
 */
SOM_Scope BOOL   SOMLINK myfold_wpMenuItemHelpSelected(MYFOLDER *somSelf,
                ULONG MenuId)
{
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpMenuItemHelpSelected");

    switch( MenuId )
    {
       case IDM_CLOSEVIEWS:

          return(_wpDisplayHelp(somSelf,ID_HELP_CLOSEVIEWS,szHelpLibrary));
          break;

       default:
          break;
    }

     return (parent_wpMenuItemHelpSelected(somSelf,MenuId));
}

/*
 *
 *  METHOD: wpClose                                        ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    When a folder object is closed, we will zero out its first view
 *    instance variable, so that the next time it has a first view opened,
 *    we can keep track of that.
 *
 */
SOM_Scope BOOL   SOMLINK myfold_wpClose(MYFOLDER *somSelf)
{
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    BOOL          rcParentClose;
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpClose");

    rcParentClose = parent_wpClose(somSelf);
    _setFirstViewHandle(somSelf, NULLHANDLE);
    return(rcParentClose);
}

/*
 * METHOD: wpDragOver                                     ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   Instances of class MYFOLDER are the only folders that accept a drop
 *   of a MYFILE object.  This override returns DOR_DROP when a MYFILE
 *   object is dragged over a MYFOLDER object.  The default meaning of
 *   a drag will be changed to perform a COPY (instead of the default
 *   being to MOVE the object)
 */
SOM_Scope MRESULT   SOMLINK myfold_wpDragOver(MYFOLDER *somSelf,
                HWND hwndCnr,
                PDRAGINFO pdrgInfo)
{
    MRESULT   mr;
    PDRAGITEM pDragItem;
    ULONG     i;
    ULONG     ulOurs = 0;

    /* MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpDragOver");

    for (i = 0; i < pdrgInfo->cditem ; i++)
    {
       pDragItem = DrgQueryDragitemPtr(pdrgInfo,i);

       if (DrgVerifyRMF(pDragItem,"DRM_OUROWNSPECIAL","DRF_OBJECT"))
       {
          ulOurs++;
       }
    }

    if (ulOurs == 0)
    {
       mr = (parent_wpDragOver(somSelf,hwndCnr,pdrgInfo));
    }
    else
    {
       if (ulOurs == pdrgInfo->cditem)
       {
          mr = MRFROM2SHORT(DOR_DROP,
                           (SHORT)((pdrgInfo->usOperation == DO_DEFAULT)
                                   ? DO_COPY : pdrgInfo->usOperation));
       }
       else
       {
          mr = MRFROM2SHORT(DOR_NEVERDROP,DO_DEFAULT);
       }
    }
    return mr;
}

/*
 * METHOD: wpDrop                                         ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   This override will be called after a drop of a MYFILE object, so that
 *   the drop can actually be processed.
 */
SOM_Scope MRESULT   SOMLINK myfold_wpDrop(MYFOLDER *somSelf,
                HWND hwndCnr,
                PDRAGINFO pdrgInfo,
                PDRAGITEM pdrgItem)
{
    ULONG     i;
    PDRAGITEM pDragItem;

    /* MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpDrop");

    for (i = 0; i < pdrgInfo->cditem ; i++)
    {
       pDragItem = DrgQueryDragitemPtr(pdrgInfo,i);

       if (DrgVerifyRMF(pDragItem,"DRM_OUROWNSPECIAL","DRF_OBJECT"))
       {
          DrgDeleteStrHandle(pDragItem->hstrRMF);
          pDragItem->hstrRMF = DrgAddStrHandle("<DRM_OBJECT,DRF_OBJECT>");
       }
    }

    return (parent_wpDrop(somSelf,hwndCnr,pdrgInfo,pdrgItem));
}

/*
 * METHOD: wpDeleteFromObjUseList                         ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   When a the last view of a MYFOLDER object is closed, we will zero out
 *   its "first view" instance variable, so that the next time it has a first
 *   view opened, we can keep track of that.
 */
SOM_Scope BOOL  SOMLINK myfold_wpDeleteFromObjUseList(MYFOLDER *somSelf,
                       PUSEITEM  pUseItem )
{
   MYFOLDERData *somThis   = MYFOLDERGetData(somSelf);
   PUSEITEM      pItem;
   BOOL          rcParentCall;
   MYFOLDERMethodDebug("MYFOLDER","myfold_wpDeleteFromObjUseList");

   rcParentCall = parent_wpDeleteFromObjUseList(somSelf, pUseItem);

   pItem = _wpFindUseItem(somSelf, USAGE_OPENVIEW, NULL);
   if (!pItem)
   {
      _setFirstViewHandle(somSelf, NULLHANDLE);
   }
   return(rcParentCall);
}

/*
 * METHOD: wpQueryConcurrentView                          ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   Objects of MYFOLDER class have concurrent views set to ON
 *   by default
 */
SOM_Scope ULONG  SOMLINK myfold_wpQueryConcurrentView(MYFOLDER *somSelf )
{
/* MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
   MYFOLDERMethodDebug("MYFOLDER","myfold_wpQueryConcurrentView");

   return CCVIEW_ON;
}

/*
 *  METHOD: wpPrintObject                                  ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    We will simply beep when a MYFOLDER object is "printed"
 */
SOM_Scope BOOL   SOMLINK myfold_wpPrintObject(MYFOLDER *somSelf,
                PPRINTDEST pPrintDest,
                ULONG ulReserved)
{
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpPrintObject");

    WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                   (PSZ) "(just pretend!)",
                   (PSZ) "Folder Contents Printing",
                    20,
                    MB_OK | MB_INFORMATION | MB_MOVEABLE);

    return TRUE;
}

/*
 * METHOD: wpAddToContent                                 ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   We will put up a dialog containing the title of
 *   the newly added object whenever one is added to a MYFOLDER
 *   object
 */
SOM_Scope BOOL   SOMLINK myfold_wpAddToContent(MYFOLDER *somSelf,
                                               WPObject *pObject)
{
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    BOOL  rc = FALSE;
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpAddToContent");

    rc = parent_wpAddToContent(somSelf, pObject);
    if (rc)
    {
       WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                      (PSZ) _wpQueryTitle(pObject),
                      (PSZ) "Notification of added object",
                       20,
                       MB_OK | MB_INFORMATION | MB_MOVEABLE);
    }
    return(rc);

}

/*
 * METHOD: wpDeleteFromContent                            ( ) PRIVATE
 *                                                        (X) PUBLIC
 * DESCRIPTION:
 *
 *   We will put up a dialog containing the title of
 *   the newly removed object whenever one is removed from a MYFOLDER
 *   object
 */
SOM_Scope BOOL   SOMLINK myfold_wpDeleteFromContent(MYFOLDER *somSelf,
                                                    WPObject *pObject)
{
    MYFOLDERData *somThis = MYFOLDERGetData(somSelf);
    BOOL rc = FALSE;
    MYFOLDERMethodDebug("MYFOLDER","myfold_wpDeleteFromContent");

    rc = parent_wpDeleteFromContent(somSelf, pObject);
    if (rc)
    {
       WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                      (PSZ) _wpQueryTitle(pObject),
                      (PSZ) "Notification of removed object",
                       20,
                       MB_OK | MB_INFORMATION | MB_MOVEABLE);
    }
    return(rc);

}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta

/*
 *
 *  METHOD: clsQueryModuleHandle                           ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method returns the module handle of this class.  If this is the
 *    first invocation, DosQueryModuleHandle is called to save the handle
 *    for future invocations.
 *
 *  RETURN:
 *
 *    0              Unsuccessful
 *    non-zero       module handle
 *
 */
SOM_Scope HMODULE   SOMLINK myfoldM_clsQueryModuleHandle(M_MYFOLDER *somSelf)
{

    /* M_MYFOLDERData *somThis = M_MYFOLDERGetData(somSelf); */
    APIRET rc;
    M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_clsQueryModuleHandle");

   /*
    *   Make sure we already have module handle
    */

    if (hmod == NULLHANDLE)
    {
     zString zsPathName;
       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       zsPathName =
       _somLocateClassFile( SOMClassMgrObject, SOM_IdFromString("MYFOLDER"),
                            MYFOLDER_MajorVersion, MYFOLDER_MinorVersion);
       rc = DosQueryModuleHandle( zsPathName, &hmod);
       if (rc)
       {
          DebugBox("myfoldM_wpclsInitData", "Failed to load module");
          return;
       }

    }   /* end if (hmod == NULLHANDLE) */

    return (hmod);

}

/*
 *
 *  METHOD: wpclsInitData
 *
 *  DESCRIPTION:
 *
 *    Initalize the class data
 *
 */
SOM_Scope void   SOMLINK myfoldM_wpclsInitData(MYFOLDER *somSelf)
{
/*    MYFOLDERData *somThis = MYFOLDERGetData(somSelf); */
    MYFOLDERMethodDebug("MYFOLDER","myfoldM_wpclsInitData");

    parent_wpclsInitData(somSelf);

    /*
     *   Get class title
     */
    if (!WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle(somSelf), ID_TITLE,
                         sizeof(szMYFOLDERClassTitle), szMYFOLDERClassTitle))
                              /* Load string failed: use the parent's string */
       strcpy(szMYFOLDERClassTitle, parent_wpclsQueryTitle(somSelf));

}

/*
 *
 *  METHOD: wpclsQueryDefaultHelp                          ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Define help for objects of our class.
 *
 */
SOM_Scope BOOL SOMLINK myfoldM_wpclsQueryDefaultHelp(M_MYFOLDER *somSelf,
                PULONG pHelpPanelId,
                PSZ pszHelpLibrary)
{
 /* M_MYFOLDERData *somThis = M_MYFOLDERGetData(somSelf); */
    M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_wpclsQueryDefaultHelp");

    if (pHelpPanelId)                           /* set default help panel id */
       *pHelpPanelId   = ID_HELP_DEFAULT;

    if (pszHelpLibrary)                                /* copy help filename */
       strcpy(pszHelpLibrary, szHelpLibrary);

    return (TRUE);

}

/*
 *
 *  METHOD: wpclsQueryDefaultView                          ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    MYFOLDER objects open in OPEN_DETAILS by default
 *
 */
SOM_Scope ULONG SOMLINK myfoldM_wpclsQueryDefaultView(M_MYFOLDER *somSelf)
{
 /* M_MYFOLDERData *somThis = M_MYFOLDERGetData(somSelf); */
    M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_wpclsQueryDefaultView");

    return OPEN_DETAILS;

}

/*
 *
 *  METHOD: wpclsQueryTitle
 *
 *  DESCRIPTION:
 *
 *    Return class title for MYFOLDER class
 *
 */
SOM_Scope PSZ   SOMLINK myfoldM_wpclsQueryTitle(M_MYFOLDER *somSelf)
{
    /* M_MYFOLDERData *somThis = M_MYFOLDERGetData(somSelf); */
    M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_wpclsQueryTitle");

    if (*szMYFOLDERClassTitle )
       return( szMYFOLDERClassTitle );
    else
       return( parent_wpclsQueryTitle(somSelf));
}

/*
 *
 *  METHOD: wpclsQueryIconData                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Return the class icon
 *
 */
SOM_Scope ULONG SOMLINK myfoldM_wpclsQueryIconData(M_MYFOLDER *somSelf,
                  PICONINFO pIconInfo)
{
   APIRET rc;
   M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_wpclsQueryIconData");

   if (pIconInfo)
   {
      /*
       *   fill in icon information
       */
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod= _clsQueryModuleHandle(somSelf);
      pIconInfo->resid= ID_ICON;
   }

   return (sizeof(ICONINFO));

}

/*
 *
 *  METHOD: wpclsQueryIconDataN                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Return the class open icon
 *
 */
SOM_Scope ULONG SOMLINK myfoldM_wpclsQueryIconDataN(M_MYFOLDER *somSelf,
                  PICONINFO pIconInfo, ULONG ulIconIndex)
{
   APIRET rc;

   M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_wpclsQueryIconDataN");

   if (pIconInfo)
   {
      if (ulIconIndex == 1)
      {
         /*
          *   fill in open icon information
          */
         pIconInfo->fFormat = ICON_RESOURCE;
         pIconInfo->hmod= _clsQueryModuleHandle(somSelf);
         pIconInfo->resid= ID_OPENICON;

      }
      else
         return parent_wpclsQueryIconDataN(somSelf, pIconInfo, ulIconIndex);
   }

   return (sizeof(ICONINFO));

}

/*
 *  METHOD: wpclsQueryStyle                                ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Change default class style so that MYFOLDER objects have can
 *    be "printed" (we'll just beep), and so that this class is not
 *    templated.
 */

SOM_Scope ULONG   SOMLINK myfoldM_wpclsQueryStyle(M_MYFOLDER *somSelf)
{
    /* M_MYFOLDERData *somThis = M_MYFOLDERGetData(somSelf); */
    M_MYFOLDERMethodDebug("M_MYFOLDER","myfoldM_wpclsQueryStyle");

    return ((parent_wpclsQueryStyle(somSelf) & ~CLSSTYLE_NEVERPRINT)
            | CLSSTYLE_PRIVATE);
}



