#define INCL_WIN

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "geod.h"

/****** Declarations ******/

MRESULT EXPENTRY MainDlgProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY AboutDlgProc(HWND, ULONG, MPARAM, MPARAM);
VOID CenterWindow(HWND);
size_t commafmt(CHAR *, INT, LONG);

#define NUL '\0'

/****** Globals *******/

HAB   hab;
HWND  hwndFrame, hwndMenu;
CHAR  szBuff[DEF_BUFF];

/****** Main Procedure ******/

int main(void)
{
    HMQ   hmq;
    QMSG  qmsg;

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);

    hwndFrame = WinLoadDlg(HWND_DESKTOP, HWND_DESKTOP,
                           MainDlgProc, 0, GEOD_DIALOG, NULL);

    hwndMenu = WinLoadMenu(hwndFrame, 0, GEOD_DIALOG);
    WinSendMsg(hwndFrame, WM_UPDATEFRAME, 0L, 0L);

    while (WinGetMsg(hab, &qmsg, 0, 0, 0))
        WinDispatchMsg(hab, &qmsg);

    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);

    return 0;
}

MRESULT EXPENTRY MainDlgProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    BOOL    bHandled = TRUE;
    MRESULT mReturn  = 0;
    double  xFrac, xInt;
    CHAR    xBuff[DEF_BUFF], FracBuff[10];
    static USHORT usMeasure = GEOD_NM, usEllipsoid = GEOD_AIRY;

    switch (msg)
    {           
        case WM_INITDLG:
            CenterWindow(hWnd);
            WinLoadString(hab, 0, GEOD_NM, DEF_BUFF, szBuff);
            WinSetWindowText(WinWindowFromID(hWnd, GEOD_CURRMEASURE), szBuff);
            WinLoadString(hab, 0, GEOD_AIRY, DEF_BUFF, szBuff);
            WinSetWindowText(WinWindowFromID(hWnd, GEOD_CURRELLIPSOID), szBuff);
            WinPostMsg(hWnd, WM_COMMAND, MPFROMSHORT(usEllipsoid), 0L);
            break;

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1))
            {
                case GEOD_AIRY:
                case GEOD_AUSNSA1969:
                case GEOD_BESSEL:
                case GEOD_CLARKE1866:
                case GEOD_CLARKE1880:
                case GEOD_EVEREST:
                case GEOD_FISCHER1960:
                case GEOD_FISCHER1960SA:
                case GEOD_FISCHER1968:
                case GEOD_HOUGH:
                case GEOD_INTL:
                case GEOD_IAU1968:
                case GEOD_KRASSOVSKIY:
                case GEOD_WGS1972:
                    /* Update the ellipsoid (title) selected */
                    WinCheckMenuItem(hwndMenu, usEllipsoid, FALSE);
                    usEllipsoid = SHORT1FROMMP(mp1);
                    WinCheckMenuItem(hwndMenu, usEllipsoid, TRUE);
                    WinLoadString(hab, 0, SHORT1FROMMP(mp1), DEF_BUFF, szBuff);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_CURRELLIPSOID),
                                     szBuff);

                    /* Update the equatorial radius */
                    /* I *WISH* I knew an easier way to do this */
                    xFrac = modf(el[SHORT1FROMMP(mp1) - GEOD_AIRY].EquatorialRadius[usMeasure - GEOD_NM], &xInt);
                    commafmt(xBuff, DEF_BUFF, xInt);
                    sprintf(FracBuff, "%0.3lf", xFrac);
                    sprintf(szBuff, "%s.%s", xBuff, FracBuff+2);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_EQRAD), szBuff);

                    /* Update the polar radius */
                    xFrac = modf(el[SHORT1FROMMP(mp1) - GEOD_AIRY].PolarRadius[usMeasure - GEOD_NM], &xInt);
                    commafmt(xBuff, DEF_BUFF, xInt);
                    sprintf(FracBuff, "%0.3lf", xFrac);
                    sprintf(szBuff, "%s.%s", xBuff, FracBuff+2);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_POLRAD), szBuff);

                    /* Update the mean radius */
                    xFrac = modf(el[SHORT1FROMMP(mp1) - GEOD_AIRY].MeanRadius[usMeasure - GEOD_NM], &xInt);
                    commafmt(xBuff, DEF_BUFF, xInt);
                    sprintf(FracBuff, "%0.3lf", xFrac);
                    sprintf(szBuff, "%s.%s", xBuff, FracBuff+2);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_MEANRAD), szBuff);

                    /* Update the flattening */
                    sprintf(szBuff, "%1.9lf",
                        el[SHORT1FROMMP(mp1) - GEOD_AIRY].Flattening);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_FLAT), szBuff);

                    /* Update the eccentricity */
                    sprintf(szBuff, "%1.9lf",
                        el[SHORT1FROMMP(mp1) - GEOD_AIRY].Eccentricity);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_ECC), szBuff);

                    /* Update the eccentricity squared */
                    sprintf(szBuff, "%1.9lf",
                        el[SHORT1FROMMP(mp1) - GEOD_AIRY].Eccentricity2);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_ECC2), szBuff);
                    return (MRESULT)TRUE;

                case GEOD_NM:
                case GEOD_METERS:
                    if (usMeasure == SHORT1FROMMP(mp1))
                       return (MRESULT)TRUE;
                    WinCheckMenuItem(hwndMenu, usMeasure, FALSE);
                    usMeasure = SHORT1FROMMP(mp1);
                    WinCheckMenuItem(hwndMenu, SHORT1FROMMP(mp1), TRUE);
                    WinLoadString(hab, 0, SHORT1FROMMP(mp1), DEF_BUFF, szBuff);
                    WinSetWindowText(WinWindowFromID(hWnd, GEOD_CURRMEASURE),
                                     szBuff);
                    /* Force an update of the information */
                    WinPostMsg(hWnd, WM_COMMAND, MPFROMSHORT(usEllipsoid), 0L);
                    return (MRESULT)TRUE;

                case GEOD_ABOUT:
                    WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, AboutDlgProc,
                              0, GEOD_ABOUTDIALOG, NULL);
                    return (MRESULT)TRUE;

                case GEOD_EXIT:
                    WinPostMsg(hWnd, WM_QUIT, 0L, 0L);
                    break;

                default:
                    return (MRESULT)TRUE;
            }

        case WM_SYSCOMMAND:
            /* Because this is a dialog and not a standard window (per se), */
            /* we have to process this to ensure that the program is        */
            /* exited properly (i.e. DBLCLK on the SysMenu). */
            switch(SHORT1FROMMP(mp1))
            {
                case SC_CLOSE:
                    WinPostMsg(hWnd, WM_QUIT, 0L, 0L);
                    break;
            }

        default:
            bHandled = FALSE;
            break;
    }

    if (!bHandled)
        mReturn = WinDefDlgProc(hWnd, msg, mp1, mp2);

    return (mReturn);
}

MRESULT EXPENTRY AboutDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch (msg)
    {
        case WM_INITDLG:
            CenterWindow(hwnd);
            break;

        case WM_COMMAND:
        case WM_SYSCOMMAND:
            WinDismissDlg(hwnd, 0L);
            break;
    }
    return(WinDefDlgProc(hwnd, msg, mp1, mp2));
}

VOID CenterWindow(HWND hwnd)
{
    ULONG   ulScrWidth, ulScrHeight;
    RECTL   Rectl;

    ulScrWidth  = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
    ulScrHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);

    WinQueryWindowRect(hwnd, &Rectl);
    WinSetWindowPos(hwnd, HWND_TOP,
                        (ulScrWidth - Rectl.xRight) / 2,
                        (ulScrHeight - Rectl.yTop) / 2,
                        0, 0, SWP_MOVE | SWP_ACTIVATE);
}


size_t commafmt(char   *buf,            /* Buffer for formatted string  */
                int     bufsize,        /* Size of buffer               */
                long    N)              /* Number to convert            */
{
        int len = 1, posn = 1, sign = 1;
        char *ptr = buf + bufsize - 1;

        if (2 > bufsize)
        {
ABORT:          *buf = NUL;
                return 0;
        }

        *ptr-- = NUL;
        --bufsize;
        if (0L > N)
        {
                sign = -1;
                N = -N;
        }

        for ( ; len <= bufsize; ++len, ++posn)
        {
                *ptr-- = (char)((N % 10L) + '0');
                if (0L == (N /= 10L))
                        break;
                if (0 == (posn % 3))
                {
                        *ptr-- = ',';
                        ++len;
                }
                if (len >= bufsize)
                        goto ABORT;
        }

        if (0 > sign)
        {
                if (0 == bufsize)
                        goto ABORT;
                *ptr-- = '-';
                ++len;
        }

        strcpy(buf, ++ptr);
        return (size_t)len;
}
