/*REXX*/
call rxfuncadd 'IniLoadFuncs', 'REXXINI', 'IniLoadFuncs'
call IniLoadFuncs

wfile = 'C:\OS2\MDOS\WINOS2\WIN.INI'

say "The current Windows Wallpaper is" IniGet('Wallpaper', 'Desktop', wFile)

say "The [Desktop] section contains the following fields"
handle = IniOpen('Desktop', wFile)
call IniEnum 'Desktop', handle
do i = 1 to Desktop.0
  say Desktop.i '=' IniGet(Desktop.i, handle)
end

say "Changing Granularity and Spacing"
handle = IniOpen('Desktop', wFile)
call IniSet 'GridGranularity', 10, handle
call IniSet 'IconSpacing', 50, handle
call IniSave handle
call IniClose handle

say ""
say "The [Desktop] section now contains the following:"
call IniLoad 'Desktop', wFile
say "Pattern = " Desktop.Pattern
say "Wallpaper = " Desktop.Wallpaper
say "GridGranularity =" Desktop.GridGranularity
say "IconSpacing =" Desktop.IconSpacing

call IniDropFuncs
say "That's all folks!"

