/* register an application with the event log
 * and write a series of events
 * $Header: C:/ptjm/rexx/w32funcs/RCS/wrevlog.rex 1.2 2003/02/27 18:53:29 ptjm Rel $
 */

call rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'
call w32loadfuncs

/* application name (for the event viewer) */
appname = 'RexxW32Example'

arg rmv

if rmv = 'REMOVE' then do
  key = w32RegOpenKey('Local_Machine', 'SYSTEM\CurrentControlSet\Services\EventLog\Application')
  if key = 0 then do
    say 'error' w32GetError() 'opening registry key'
    exit 1
    end

  if w32RegDeleteKey(key, appname) then do
    say 'error' w32GetError() 'deleting registry key'
    exit 1
    end

  exit 0
  end

/* name of the message catalogue file */
fname = directory() || '\wrevlog.dll'

/* types of return codes (1 = error, 2 = warning, 4 = information) (I have no
 * idea whether this is actually used by the system, but it's conventional to set it)
 */
errtypes = 1 + 2 + 4

/* number of categories defined in this message file */
categories = 2

regkey = 'SYSTEM\CurrentControlSet\Services\EventLog\Application\' || appname

key = w32RegCreateKey('LOCAL_MACHINE', regkey)

if key = 0 then do
  say 'error' w32GetError() 'opening registry key'
  exit 1
  end

val = w32RegQueryValue(key, 'EventMessageFile')

if val \= fname then do
  call w32RegSetValue key, 'EventMessageFile', 'REG_SZ', fname
  call w32RegSetValue key, 'TypesSupported', 'REG_DWORD', errtypes
  end

if categories > 0 then do
  val = w32RegQueryValue(key, 'CategoryMessageFile')
  if val \= fname then do
    call w32RegSetValue key, 'CategoryMessageFile', 'REG_SZ', fname
    call w32RegSetValue key, 'CategoryCount', 'REG_DWORD', categories
    end
  end

call w32RegCloseKey key


/* now log a bunch of events */

/* facility names -- these are application dependent */
runtime = 1
catalogue = 2



/* start message has no arguments and no category */
call w32WriteEventLog , appname, 'Information',, 3

/* here are some category messages with arguments */
call w32WriteEventLog , appname, 'Information',runtime, 1001,, w32SysGetUserName()
call w32WriteEventLog , appname, 'Information',catalogue, 2001,, w32SysGetOSVersion(), w32ClipGet()

/* something has gone wrong, but not too wrong */
call w32WriteEventLog , appname, 'Warning', , 101,, date() time()

/* you might re-use an event number to allow the same thing to be marked an
 * error or a warning at the user's direction, or to distinguish between
 * different severities of the same sort of problem */
call w32WriteEventLog , appname, 'Error', , 101,, date() time()

/* end message has no arguments and no category */
call w32WriteEventLog , appname, 'Information', 0, 4
