/* Test of automation with Word
 * insert a table with 3 columns and 27 rows at the cursor position
 * the first column should be 30 pt wide, the second 70 pt, and the third should take
 * up the rest of the page.
 * the first column should contain the numbers from 1 to 27, right-justified.
 * the second and third are to be filled in by the user.
 * the table should have a double box around it, and no internal borders
 * the first row should have the header property
 * $Header: C:/ptjm/rexx/w32funcs/RCS/wordtab.rex 1.3 2003/12/16 16:26:15 ptjm Rel $
 */


call rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'
call w32loadfuncs

wrd = w32CreateObject("Word.Application")
document = w32getsubobj(wrd, 'ActiveDocument')
range = w32getsubobj(wrd, 'Selection.Range')
tab = w32callfunc(document, 'Tables.Add', 'oII', range, 27, 3)
call w32releaseobject range

/* this was taken from the type lib by undisclosed means */

wdBorderTop = -1
wdBorderLeft = -2
wdBorderBottom = -3
wdBorderRight = -4
wdBorderHorizontal = -5
wdBorderVertical = -6

insideborders = wdBorderVertical wdBorderHorizontal
outsideborders = wdBorderTop wdBorderRight wdBorderBottom wdBorderLeft


wdLineStyleNone = 0
wdLineStyleSingle = 1
wdLineStyleDot = 2
wdLineStyleDashSmallGap = 3
wdLineStyleDashLargeGap = 4
wdLineStyleDashDot = 5
wdLineStyleDashDotDot = 6
wdLineStyleDouble = 7
wdLineStyleTriple = 8
wdLineStyleThinThickSmallGap = 9
wdLineStyleThickThinSmallGap = 10
wdLineStyleThinThickThinSmallGap = 11
wdLineStyleThinThickMedGap = 12
wdLineStyleThickThinMedGap = 13
wdLineStyleThinThickThinMedGap = 14
wdLineStyleThinThickLargeGap = 15
wdLineStyleThickThinLargeGap = 16
wdLineStyleThinThickThinLargeGap = 17
wdLineStyleSingleWavy = 18
wdLineStyleDoubleWavy = 19
wdLineStyleDashDotStroked = 20
wdLineStyleEmboss3D = 21
wdLineStyleEngrave3D = 22

do i = 1 to words(outsideborders)
  border = w32getsubobj(tab, 'Borders', 'I', word(outsideborders, i))
  call w32putproperty border, 'LineStyle', 'I', wdLineStyleDouble
  call w32releaseobject border
  end

do i = 1 to words(insideborders)
  border = w32getsubobj(tab, 'Borders', 'I', word(insideborders, i))
  call w32putproperty border, 'LineStyle', 'I', wdLineStyleNone
  call w32releaseobject border
  end

wdAlignParagraphLeft = 0
wdAlignParagraphCenter = 1
wdAlignParagraphRight = 2
wdAlignParagraphJustify = 3

head.1 = 'No'; head.2 = 'Name'; head.3 = 'Description'

row = w32getsubobj(tab, 'Rows', 'I', 1)
call w32putproperty row, 'HeadingFormat', 'b', 1
do i = 1 to 3
  cell = w32getsubobj(row,  'Cells', 'I', i)
  range = w32getsubobj(cell, 'Range')
  call w32callproc range, 'InsertAfter', 's', head.i

  call w32putproperty range, 'Paragraphs.Alignment', 'I', wdAlignParagraphCenter
  call w32releaseobject range, cell
  end

call w32releaseobject row

col = w32getsubobj(tab, 'Columns', 'I', 1)
call w32putproperty col, 'Width', 'I', 30

do i = 2 to 27
  cell = w32getsubobj(col,  'Cells', 'I', i)
  range = w32getsubobj(cell, 'Range')
  call w32callproc range, 'InsertAfter', 'I', i-1

  call w32putproperty range, 'Paragraphs.Alignment', 'I', wdAlignParagraphRight
  call w32releaseobject range, cell

  end

call w32releaseobject col

col = w32getsubobj(tab, 'Columns', 'I', 2)
call w32putproperty col, 'Width', 'I', 70
call w32releaseobject col

col = w32getsubobj(tab, 'Columns', 'I', 3)
call w32putproperty col, 'Width', 'I', .75 * w32getproperty(document, 'PageSetup.PageWidth') - 100
call w32releaseobject col


call w32releaseobject tab, document, wrd


call w32olecleanup

call w32dropfuncs
