/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         AboutMenu_Click
*/
AboutMenu_Click:
    stem.0 = 4
    stem.1 = "SCAT! 1.0 by Eric Giguere"
    stem.2 = "Copyright 1994 WATCOM International"
    stem.3 = ""
    stem.4 = "Press the icon once to move the windows off," ,
             "press again to move them back."
    call VRMessageStem VRWindow(), 'stem.', 'About SCAT!'
return

/*:VRX         ExitMenu_Click
*/
ExitMenu_Click:
    call Quit
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()

    timer = VRGet( "Timer", "Enabled" )
    left = VRGet( window, "Left" )
    top  = VRGet( window, "Top" )
    tbar = VRGet( window, "TitleBar" )

    call VRSetIni 'SCAT', 'TitleBar', tbar, IniFile, 'noclose'
    call VRSetIni 'SCAT', 'Timer', timer, IniFile, 'noclose'
    call VRSetIni 'SCAT', 'Left', left, IniFile, 'noclose'
    call VRSetIni 'SCAT', 'Top', top, IniFile 

    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         FrontMenu_Click
*/
FrontMenu_Click:
    tofront = 1 - VRGet( 'Timer', 'Enabled' )
    call VRSet 'Timer', 'enabled', tofront
    call VRSet 'FrontMenu', 'checked', tofront
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Get the working directory */

    call VROptions 'NoSyntax'

    ScatMode   = 0
    ScatList.0 = 0

    ScreenWidth = VRGet( 'Screen', 'Width' )
    ScreenHeight = VRGet( 'Screen', 'Height' )

    WorkingDir = VRGet( "Application", "WorkingDirectory" )
    IniFile = WorkingDir || "\scat.ini"

    call VRSet 'FrontMenu', 'Checked', 0

    enabled = VRGetIni( 'SCAT', 'Timer', IniFile, 'NoClose' )
    if( enabled = '1' | enabled = '0' )then do
        call VRSet 'Timer', 'Enabled', enabled
        call VRSet 'FrontMenu', 'Checked', enabled
    end

    window = VRWindow()

    /* Figure out how big the ipb is... */

    ipb = VRCreate( window, "ImagePushButton", "visible", 0 )
    call VRSet ipb, "AutoSize", 1
    ButtonHeight = VRGet( ipb, "Height" )
    ButtonWidth  = VRGet( ipb, "Width" )
    ButtonMargin = 0
    call VRDestroy ipb

    /* Now make the initial height something sensible... */

    h  = VRGet( window, "Height" )
    ih = VRGet( window, "InteriorHeight" )

    NoTitleH = ButtonHeight + 2 * ButtonMargin
    TitleH   = ( h - ih ) + NoTitleH

    call VRSet window, "Height", TitleH

    tbar = VRGetIni( 'SCAT', 'TitleBar', IniFile, 'noclose' )
    if( tbar = 0 )then do
        call ToggleMenu_Click
    end

    /* OK, figure out how many buttons we have and lay
       them out... */

    PredefinedButtons = 1
    NumberButtons     = PredefinedButtons

    ok = VRMethod( window, "ListChildren", "buttons." )

    left = 0
    do i = buttons.0 to 1 by -1
        if( VRGet( buttons.i, 'classname' ) = 'ImagePushButton' )then do
            call VRSet buttons.i, 'Left', left
            left = left + ButtonWidth + ButtonMargin
        end
    end

    width = NumberButtons * ButtonWidth + ButtonMargin * ( NumberButtons - 1 )
    call VRSet window, "Width", width

    left = VRGetIni( 'SCAT', 'Left', IniFile, 'noclose' )
    top  = VRGetIni( 'SCAT', 'Top', IniFile, 'noclose' )

    if( left \= '' & top \= '' )then 
        call VRSet window, 'Left', left, 'Top', top
    else
        call VRMethod window, "CenterWindow"

    call VRSet window, "Visible", 1
    call VRSet window, "SiblingOrder", 1
    drop window

return

/*:VRX         MoveMenu_Click
*/
MoveMenu_Click:
    window = VRWindow()
    frame = VRGet( window, "Hwnd" )
    call VRMethod "Screen", "WinSendMsg", frame, 69, 15, 0 
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ScatButton_Click
*/
ScatButton_Click:
    /* Toggle the state... */

    ScatMode = 1 - ScatMode
    ScatPict = '#' || ( 100 + ScatMode )

    call VRSet 'ScatButton', 'PicturePath', ScatPict

    /* Call the external func */

    call DoScat ScatMode
return

/*:VRX         Timer_Trigger
*/
Timer_Trigger:
    window = VRWindow()
    call VRSet window, "SiblingOrder", 1
return

/*:VRX         ToggleMenu_Click
*/
ToggleMenu_Click:
    window = VRWindow()
    tb = 1 - VRGet( window, "TitleBar" )
 
    call VRSet window, "Painting", 0
    call VRSet window, "TitleBar", tb
    top = VRGet( window, "Top" )
    diff = TitleH - NoTitleH

    if( tb = 1 )then do
        call VRSet window, "Top", top - diff
        call VRSet window, "Height", TitleH
    end; else do
        call VRSet window, "Top", top + diff
        call VRSet window, "Height", NoTitleH
    end

    call VRSet window, "Painting", 1
    call VRSet "ToggleMenu", "Checked", tb
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_ContextMenu
*/
Window1_ContextMenu:
    call VRMethod 'SetupMenu', 'Popup'
return

