/* This creates a Main Window with 2 Groups. The first Group contains 1 ENTRY
   with the END flag set.  The second Group contains 1 SPIN. Whenever the user
   changes the ENTRY's value, RXDLG returns, and we move the SPIN's y position
   to the value typed into the entry (ie, for example -3 moves the SPIN 3 pels
   down).
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is ENTRY */
RXTYPE.1 = 'ENTRY'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Labels for each entry, and Groupbox. Note: 3rd entry has no label */
RXLABEL.1 = 'Move:|Y Position'

/* Variable name where the text "typed into" the entry is stored */
RXVAL.1 = 'TEXT'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 40'

/* Position of Group */
RXX.1 = 65
RXY.1 = 60

/* The text for the entry */
TEXT.1 = '10'

/* Second Group is SPIN */
RXTYPE.2 = 'SPIN'

/* Default */
RXFLAGS.2 = ' '

/* Label for control. No Groupbox */
RXLABEL.2 = '200 40 Width:'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.2 = '1 1 70'

/* initial value of spin */
RXVAL.2 = '64'

/* Position */
RXX.2 = 180
RXY.2 = 10

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ' '

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 2 '"Main Window"' 'RXWIN1'  'NOCLOSE'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Since there is only 1 group and 1 control, we know that it caused RXDLG
    to return. Set spin y position to value typed into the entry. We don't care
    about changing the x position, so specify 0.
*/

RXSET '""' 2 0 'MOVE 0|' TEXT.1
SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
