/* This creates a Main Window with a Group of 1 single-select LIST with the
   END flag set.  Whenever the user makes a selection in the LIST, RXDLG
   returns, and we force the selection to the "hello" item.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is LIST */
RXTYPE.1 = 'LIST'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Label for control. No Groupbox */
RXLABEL.1 = 'Type Here:'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 90 6'

/* REXX variable where initial text stored */
RXVAL.1 = 'STRS'

/* Position */
RXX.1 = 10
RXY.1 = 10

/* Text */
STRS.1 = 'some stuff'
STRS.2 = 'hi'
STRS.3 = 'hello'
STRS.4 = 'blort'
STRS.5 = ' '

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Since there is only 1 group and 1 control, we know that it caused RXDLG
    to return. Force selection of 'hello' item
*/

RXSET '""' 1 1 'VAL' 'hello|' 1
SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
