/* rexx */
signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

'cls'
say
say 'G2CLOB --- Testing REXXGDB2.DLL CLOB function(s)'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., November 1996'
say

sq5 = "SELECT resume from emp_resume where empno = '000130' and translate(resume_format) = 'ASCII'"

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'

say
say  'SQ5='sq5
say

call time 'R'
say  'G2SELECTCLOB RESULT 1 (SQ5 Value)='g2selectclob(sq5,   'RESUM1.ASC')
say  '---elapse   ='time('R')
say
say  'G2SELECTCLOB RESULT 2 (SQ5)......='g2selectclob('sq5', 'RESUM2.ASC')
say  '---elapse   ='time('R')
say
say  'G2SELECTCLOB RESULT 3 (value)....='g2selectclob("SELECT resume from emp_resume where empno = '000130' and translate(resume_format) = 'ASCII'", 'RESUM3.ASC')
say  '---elapse   ='time('R')
say
say  'Retrieving (using SQ5 Value) 100 times...'
do 100
   call g2selectclob sq5, 'RESUM4.ASC'
   end
elapse = time('R')
say  '---elapse   ='elapse '(total),  'elapse / 100 '(per call on average)'

say
say 'Commiting...'
call g2commit
return 0



error:
say 'Error detected at line' SIGL
return 10

syntax:
say 'Syntax error detected at line' SIGL
return 20
