/*
 * prepc -- Massage a .C file generated by the SOM compiler into something
 *          we like better and copy it into the C directory if it doesn't
 *          exist there already...
 */

    call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
    call SysLoadFuncs

    vxodk = value( 'VXODK',, 'OS2ENVIRONMENT' )
    if( vxodk = '' )then do
        vxodk = '..\..'
    end

    som = 'SOM1'
    if( words( arg(1) ) > 1 )then do
        som = 'SOM2'
    end

    infile  = word( arg(1), 1 )
    outfile = '..\..\' || translate( infile )

    parse var infile fname'.'ext

    /* Figure out if the parent class is a virtual class... */

    clsfile = '..\' || fname || '.CLS'
    parent_is_virtual = 0

    do while( parent_is_virtual = 0 & lines( clsfile ) > 0 )
        line = linein( clsfile )
        if( pos( 'parent_is_virtual', line ) \= 0 )then do
            parent_is_virtual = 1
        end
    end

    call stream clsfile, 'c', 'close'

    /* If file exits, insert any new methods... */

    if( stream( infile, 'c', 'query exists' ) = '' )then do
        exit 0
    end

    if( stream( outfile, 'c', 'query exists' ) \= '' )then do
        call ModifyClassFile infile, outfile
        exit 0
    end

    /* Otherwise... */

    call lineout outfile, '/*'
    call lineout outfile, ' *' infile
    call lineout outfile, ' *'
    call lineout outfile, ' * This class definition file has been generated from the file'
    call lineout outfile, ' * ..\SOM\SC\' || infile || ' in preparation for compiling.  New'
    call lineout outfile, ' * methods will be appended at the end only.'
    call lineout outfile, ' */'
    call lineout outfile, ''
    call lineout outfile, '#define INCL_PM'
    call lineout outfile, ''
    call lineout outfile, '#include "vxrexx.h"'
    call lineout outfile, '#include "vxfuncs.h"'
    call lineout outfile, ''

    classname = ''
    do while( classname = '' & lines( infile ) > 0 )
        line = linein( infile )
        if( pos( 'Class_Source', line ) \= 0 )then do
            parse var line '#define' classname'_Class_Source' other
            call lineout outfile, line
        end
    end

    classname = strip( classname )

    if( classname = '' )then do
        say "Could not find classname -- file preparation aborted."
        exit 1
    end

    call linein infile /* skip next line... */

    call lineout outfile, '#include "'fname'.ih"'
    call lineout outfile, '#include "'fname'.ph"'
    call lineout outfile, '#include "vxcdata.h"'

    if( parent_is_virtual = 1 )then do
        call lineout outfile, ''
        call lineout outfile, '#define PARENT_IS_VIRTUAL'
    end

    call lineout outfile, ''
    call lineout outfile, 'extern PSZ' classname || 'PicturePath;'
    call lineout outfile, ''

    meta = 0
    do while( meta = 0 & lines( infile ) > 0 )
        line = linein( infile )

        if( parent_is_virtual = 1 & pos( 'Instance_vrLocalCreateWindow', line ) \= 0 )then do

            do while( pos( 'MethodDebug', line ) = 0 )
                call lineout outfile, line
                line = linein( infile )
            end

            call lineout outfile, '    HWND     hWnd = hNULL;'
            call lineout outfile, '    SWP      swp;'
            call lineout outfile, '    LONG     flags;'
            call lineout outfile, '    SOMAny   *pobj;'
            call lineout outfile, '    HWND     parent;'
            call lineout outfile, ''
            call lineout outfile, line
            call lineout outfile, ''
            call lineout outfile, '    pobj = get_parent_object( somSelf );'
            call lineout outfile, '    if( !pobj ) goto leave;'
            call lineout outfile, ''
            call lineout outfile, '    parent = _vrGetInnerWindow( pobj );'
            call lineout outfile, '    if( !parent ) goto leave;'
            call lineout outfile, ''
            call lineout outfile, '    _vrGetWindowPos( somSelf, &swp, VR_PIXELS, TRUE );'
            call lineout outfile, ''
            call lineout outfile, '    flags = _vrGetWindowFlags( somSelf );'
            call lineout outfile, '    *visible = ( ( flags & WS_VISIBLE ) != 0 );'
            call lineout outfile, '    flags &= ~WS_VISIBLE;'
            call lineout outfile, ''
            call lineout outfile, '    hWnd = WinCreateWindow( parent,'
            call lineout outfile, '                            _vrGetWindowClass( SOM_GetClass( somSelf ) ),'
            call lineout outfile, '                            "",'
            call lineout outfile, '                            flags,'
            call lineout outfile, '                            swp.x, swp.y,'
            call lineout outfile, '                            swp.cx, swp.cy,'
            call lineout outfile, '                            parent,'
            call lineout outfile, '                            HWND_TOP,'
            call lineout outfile, '                            _vrGetNewWindowID( somSelf ),'
            call lineout outfile, '                            NULL, NULL );'
            call lineout outfile, ''
            call lineout outfile, '  leave:'
            call lineout outfile, '    return( hWnd );'

            line = '    return( hWnd );'

            line = strip( linein( infile ) )
            do while( left( line, 1 ) \= '}' )
                line = strip( linein( infile ) )
            end

        end; else if( pos( 'Class_vrLocalClassInit', line ) \= 0 )then do
            meta = 1
        end
        call lineout outfile, line
    end

    call lineout outfile, ''

    call lineout outfile, ' * Note: The vrLocalClassInit function is defined '
    call lineout outfile, ' * in the .ph file for this class....           '
    call lineout outfile, ' */'
    call lineout outfile, ''

    /* Delete the LocalClassInit section... */

    line = strip( linein( infile ) )
    do while( lines( infile ) > 0 & left( line, 1 ) \= '}' )
        line = strip( linein( infile ) )
    end

    if( som = 'SOM2' )then do

        mac = 'parent_' || classname || 'Class_somInit'
        call lineout outfile, '#undef' mac
        call lineout outfile, '#define' mac || '(somSelf) \'
        call lineout outfile, '    ((SOM_ParentNumResolve(SOMObject, 1, M_' || classname || 'CClassData.parentMtab, somInit)) \'
        call lineout outfile, '     (somSelf))'
        call lineout outfile, ''

        mac = 'parent_' || classname || 'Class_somUninit'
        call lineout outfile, '#undef' mac
        call lineout outfile, '#define' mac || '(somSelf) \'
        call lineout outfile, '    ((SOM_ParentNumResolve(SOMObject, 1, M_' || classname || 'CClassData.parentMtab, somUninit)) \'
        call lineout outfile, '     (somSelf))'
        call lineout outfile, ''

        call lineout outfile, '#undef SOM_CurrentClass'
        call lineout outfile, '#define SOM_CurrentClass SOMMeta'
        call lineout outfile, ''
    end

    /* Copy the rest verbatim... sort of */

    do while( lines( infile ) > 0 )
        line = linein( infile )

        if( parent_is_virtual = 1 & pos( 'parent_vrLocalWindowClassInit', line ) \= 0 )then do
            line = '    return( VRRegisterWindowClass( somSelf, NULL, "'classname'" ) );'
        end

        if( pos( '_vrShowHelp', line ) \= 0 )then do
            call lineout outfile, line
            found = 0
            do while( found = 0 & lines( infile ) > 0 )
                line = linein( infile )
                if( pos( 'return', line ) \= 0 )then do
                    line  = '    WinMessageBox( HWND_DESKTOP, 0, "No help installed.", _somGetName( somSelf ), 0, MB_OK | MB_MOVEABLE );'
                    call lineout outfile, line
                    line = ''
                    found = 1
                end
                call lineout outfile, line
            end
            line = '    return( TRUE );'
        end

        call lineout outfile, line

        if( som \= 'SOM2' & pos( 'parent_somInit', line ) \= 0 )then do
            call lineout outfile, ''
            call lineout outfile, '    get_picturepath( somSelf ) =' classname || 'PicturePath;'
            call lineout outfile, ''
            call lineout outfile, '    if( VRQueryRunMode() == VR_DESIGN_MODE ){'
            call lineout outfile, '        VRInstallHelp( somSelf );'
            call lineout outfile, '    }'
        end; else if( som = 'SOM2' & pos( 'parent_' || classname || 'Class_somInit', line ) \= 0 )then do
            call lineout outfile, ''
            call lineout outfile, '    get_picturepath( somSelf ) =' classname || 'PicturePath;'
            call lineout outfile, ''
            call lineout outfile, '    if( VRQueryRunMode() == VR_DESIGN_MODE ){'
            call lineout outfile, '        VRInstallHelp( somSelf );'
            call lineout outfile, '    }'
        end
    end

    call stream infile, 'c', 'close'
    call stream outfile, 'c', 'close'

    /* Now modify SOMINIT.C if appropriate... first we copy it into the
       current dir and modify it here, then copy it back... */

    infile  = '..\..\SOMINIT.C'

    if( stream( infile, 'c', 'query exists' ) \= '' )then do
        modified = 0
        outfile  = 'sominit.tmp'

        do while( lines( infile ) > 0 )
            line = linein( infile )

            if( pos( ':sominit:hfiles:', line ) \= 0 )then do
                call lineout outfile, '#include "' || fname || '.h"'
                modified = 1
            end; else if( pos( ':sominit:icons:', line ) \= 0 )then do
                parse var line . ':icons:'number':' .
                line = 'PSZ ' || classname || 'PicturePath = "#' || number || ':" DLLNAME ;'
                call lineout outfile, line
                call AddToRCFile fname, number
                number = number + 1
                line = '/* :sominit:icons:'number': */'
                modified = 1
            end; else if( pos( ':sominit:init:', line ) \= 0 )then do
                call lineout outfile, '    ' || classname || 'NewClass( majorVersion, minorVersion );'
                modified = 1
            end; else if( pos( ':sominit:uninit:', line ) \= 0 )then do
                call lineout outfile, '    UnClass( ' || classname || ' );'
                modified = 1
            end

            call lineout outfile, line
        end

        call stream infile, 'c', 'close'
        call stream outfile, 'c', 'close'

        if( modified = 1 )then do
            address cmd '@copy' outfile infile '2>&1 >nul'
        end

        '@del' outfile
    end

    outfile  = '..\..\PROPS.C'
    if( stream( outfile, 'c', 'query exists' ) \= '' )then do
        call lineout outfile, '#include "' || fname || '.prp"'
    end

    exit 0

AddToRCFile: procedure expose vxodk
    parse arg fname, number

    ifname  = fname || '.ICO'
    defico = vxodk || '\bin\default.ico'
    newico = '..\..\' || ifname

    if( stream( defico, 'c', 'query exists' ) \= '' )then do
        address cmd '@copy' defico newico '2>&1 >nul'
    end

    call sysfiletree '..\..\' || fname || '.RC', 'files', 'fo'
    if( files.0 \= 1 ) then return

    call lineout files.1, 'ICON' number ifname
    call stream files.1, 'c', 'close'
    return

/*
 * ModifyClassFile
 */

ModifyClassFile: procedure
    parse arg infile, outfile

    inlist  = MethodList( infile )
    outlist = MethodList( outfile )

    inline  = 0
    str     = ''

    do while( inlist \= '' )
        parse var inlist func':'line inlist
        if( pos( func, outlist ) = 0 & pos( '_vrLocalClassInit', func ) = 0 )then do

            do while( inline < line )
                str = linein( infile )
                inline = inline + 1
            end

            say "Appending method" func "to" infile

            call lineout outfile, ''
            call lineout outfile, '#undef SOM_CurrentClass'

            if( pos( 'Instance_', func ) \= 0 )then do
                call lineout outfile, '#define SOM_CurrentClass SOMInstance'
            end; else do
                call lineout outfile, '#define SOM_CurrentClass SOMMeta'
            end

            call lineout outfile, ''
            call lineout outfile, '/*'
            call lineout outfile, ' *' func
            call lineout outfile, ' */'
            call lineout outfile, ''
            call lineout outfile, str

            do while( left( strip( str ), 1 ) \= '}' )
                str = linein( infile )
                inline = inline + 1
                call lineout outfile, str
            end
        end
    end

    return

/*
 * MethodList -- Get the list of methods in a file
 */

MethodList: procedure
    parse arg file

    list    = ''
    linenum = 0

    do while( lines( file ) > 0 )
        line    = strip( linein( file ) )
        linenum = linenum + 1

        if( pos( 'SOM_Scope', line ) \= 0 & pos( 'SOMLINK', line ) \= 0 )then do
            parse var line 'SOM_Scope' . 'SOMLINK' funcname'(' .
            list = list funcname':'linenum
        end
    end

    call stream file, 'c', 'close'
    return list
