.**********************************************************************
.*
.* $Author:   KANIS  $
.* $Workfile:   PRTGRAFC.IPF  $
.* $Revision:   1.0  $
.* $Date:   04 May 1996 21:10:42  $
.*
.* $Log:   M:\prtgraph\prtgrafc.ipv  $
.* 
.*    Rev 1.0   04 May 1996 21:10:42   KANIS
.* First VCS store for v2.2
.* 
.**********************************************************************

:userdoc.
:docprof toc=123.
:title.PrtGraph v2.0 C/C++ Programming Reference

.***** Introduction *****************************************************

:h1 res=100.PrtGraph C Library
:i1.PrtGraph C Library
:font facename=Helv size=16x12.

:p.The :hp2.PrtGraph C Library:ehp2. (prtgrafc.dll) gives you high level, application oriented 
access to complex graphic printing functionality.

:p.With this library you will be able to create professional style reports and outputs for your
programs without having to resort to the lengthy and tedious process of programming the OS/2 Gpi
interface. You can create reports and documents with text in up to 25 different font faces that
can be justified, right or left aligned or centred. You can include bitmap images and boxes and
print tables with or without running headers.

:p.The :hp2.PrtGraph C Library:ehp2. allows you to define page headers and footers and gives you 
access to a list of the printers connected to your work-station and their :hp2.Job Properties:ehp2. 
dialogs as well as to the font dialog for the chosen printer.

:h2 res=101.Whats new in version 2.0
:i2 refid=INTRO.Whats new in version 2.0
:font facename=Helv size=16x12.

:p.The :hp2.PrtGraph C Library:ehp2. has been aligned with the :hp2.PrtGraph REXX Library:ehp2., 
the :hp2.VRPrinter Object:ehp2. for :hp2.VX-REXX:ehp2. and the :hp2.PrtGraph Class Library:ehp2..

:p.In version 2.0 we have introduced properties which are all accessed through the same 
functions.

:p.The memory usage of the library has been reduced and the code efficiency improved.

.***** Shareware Software ***********************************************

:h2 res=300.Shareware Software
:i2 refid=INTRO.Shareware Software
:font facename=Helv size=16x12.

:p.:hp2.DEFINITION OF SHAREWARE SOFTWARE:ehp2.

:p.Shareware Software distribution gives users a chance to try software before buying it. If 
you try a Shareware software program and continue using it, you are expected to register.  
Individual programs differ on details -- some request registration while others require it, 
some specify a maximum trial period.  With registration, you  get anything from the simple 
right to continue using the software to an updated program with printed manual. 

:p.Copyright laws apply to both Shareware and commercial software, and the copyright holder 
retains all rights, with a few specific exceptions as stated below. Shareware software authors 
are accomplished programmers, just like commercial authors, and the programs are of comparable 
quality. (In both cases, there are good programs and bad ones!)  The main difference is in the 
method of distribution. The author specifically grants the right to copy and distribute the 
software, either to all and sundry or to a specific group. For example, some authors require 
written permission before a commercial disk vendor may copy their Shareware software. 

:p.Shareware software is a distribution method, not a type of software. You should find 
software that suits your needs and pocketbook, whether it's commercial or Shareware software.  
The Shareware software system makes fitting your needs easier, because you can try before you 
buy. And because the overhead is low, prices are low also. Shareware software has the ultimate 
money-back guarantee -- if you don't use the product, you don't pay for it. 

:p.When you :link reftype=hd res=310.register:elink. the :hp2.PrtGraph C Library:ehp2. you will be 
sent a registered version of the DLL by e-mail. This version has the "nag" popup removed and you 
have the right to freely distribute software that includes the DLL.

:p.If you are satisfied with the :hp2.PrtGraph C Library:ehp2. we ask you to freely distribute the 
shareware version to your freinds and colleagues.

:p.If you have any suggestions for enhancements or find any bugs in the software please 
contact us at one of our :link reftype=hd res=600.Contact Addresses:elink.

.***** Registering  *****************************************************

:h2 res=310.Registering your license
:i2 refid=INTRO.Registering your license
:font facename=Helv size=16x12.

:p.Printer is a "Shareware software program" and is provided at no charge to the user for 
evaluation. Feel free to share it with your friends, but please do not give it away altered or 
as part of another system. The essence of "user-supported" software is to provide personal 
computer users with quality software without high prices, and yet to provide incentive for 
programmers to continue to develop new products. If you find this program useful and find 
that you are using Printer and continue to use Printer after a reasonable trial period 
of 30  days, you must make a registration payment of $45.00 to ADD Consulting (CH).
:p.If you have already registered either PrtGraph for REXX or VRPrinter you can 
register for $20.00. :p.You can register through the :hp2.CompuServe:ehp2. Shareware 
Registration facility&colon.
:lm margin=5.
:p.GO SWREG registration Number 6201 for new registrations
:p.GO SWREG registration Number 6202 for registered users of another ADD Consulting printing library
:lm margin=1.

:p.The registration fee will license one copy for use on any one computer at any one time. You 
must treat this software just like a book. An example is that this software may be used by 
any number of people and may be freely moved from one computer location to another, so long 
as there is no possibility of it being used at one location while it's being used at another. 
Just as a book cannot be read by two different persons at the same time. 

:p.Payment of the registration fee gives you the right to distribute programs that include 
the object and the DLL without paying any other "run-time" licenses.

:p.Site-License arrangements may be made by :link reftype=hd res=600.contacting:elink. 
ADD Consulting (CH). 

.***** Distributing *****************************************************

:h2 res=420.Distributing the PrtGraph C Library
:i2 refid=INTRO.Distributing the PrtGraph C Library
:font facename=Helv size=16x12.

:p.Anyone distributing the :hp2.PrtGraph C Library:ehp2. for any kind of remuneration must first contact 
ADD Consulting (CH) at our :link reftype=hd res=600.address:elink. below for authorization. 
This authorization will be automatically granted to distributors recognized by the (ASP) as 
adhering to its guidelines for shareware distributors, and such distributors may begin 
offering Printer immediately, however ADD Consulting (CH) should still be advised so that 
the distributor can be kept up-to-date with the latest version of Printer. 

:p.Registered users are free to distribute programs that use the the :hp2.PrtGraph C Library:ehp2. with 
no additional run-time fees.

.***** Address **********************************************************

:h2 res=600.Contact Address
:i2 refid=INTRO.Contact Address
:font facename=Helv size=16x12.

:p.You can contact ADD Consulting at the addresses below&colon.
:lm margin=5.
:lines.:font facename=Courier size=18x12.
ADD Consulting (CH)
Mr. Peter Kanis
Via Suro 9
CH-7403 Rhzns
Switzerland

Tel&colon. +41 (0)81 630 2011
Fax&colon. +41 (0)81 630 2015
CompuServe&colon. 100275,350 (Peter Kanis)
INTERNET&colon. kanis@ibm.net

ADD Consulting (RUS)
Mr. Michael V. Schelkin
18-29 Molodezhnaya Street
Jukovsky 
140160 Moscow Region
Russia

Tel&colon. +7 095 556 8533
Internet&colon. michael@schelkin.msk.ru

:elines.:font facename=default.

:h2 res=430.Rights And Limitations
:i2 refid=INTRO.Rights and Limitations
:font facename=Helv size=16x12.

:p.ADD Consulting makes no warranties as to the information in this guide. Additionally, 
ADD Consulting is not responsible or liable for any loss or damage of any kind resulting from 
use of this product. 

:p.The Software is protected by international copyright laws. All rights reserved. No part of 
the computer program, documentation or related files may be reproduced photocopied, stored 
on a retrieval system, or transmitted except as provided by copyright law or by express 
permission of the copyright owner.

:p.DISCLAIMER - AGREEMENT 

:p.Users of the :hp1.PrtGraph C Library:ehp1. shall accept this disclaimer of warranty&colon.

:p.ADD CONSULTING SUPPLIES THIS PRODUCT AS IS WITHOUT WARANTY OF ANY KIND, EITHER EXPRESS OR 
IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARANTIES OF MERCANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE. ADD CONSULTING ASSUMES NO LIABILITY FOR DAMAGES, DIRECT OR CONSEQUENTIAL, 
WHICH MAY RESULT FROM THE USE OF THE PRODUCT.

:p.Some jurisdictions do not allow the exclusion or limitations for consequential or 
incidental damages, so the above may not apply to you.

.***** Demo program *****************************************************

:h1 res=105.The DEMO program
:i1 id=DEMO.Demo Program
:font facename=Helv size=16x12.

:p.Included in this package is a demonstration program written in C and its source code.
The demo shows you many of the possibilities offered by the DLL, but the limits are set by your
imagination.
:p.:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\democ.bmp' align=left.
:p.:hp2.Figure&colon. Demo Program.:ehp2.

.***** Setting up a print job *******************************************

:h1.Setting up a print job
:i1.Setting up a print job
:font facename=Helv size=16x12.

:p.Setting up a print job requires several steps&colon.
:ul compact.
:li.Link the library with your executable or DLL using :hp2.PRTGRAFC.LIB:ehp2.
:li.Intialise the printing environment with :link reftype=hd res=1018.PrtGInit:elink.
:li.Choose a printer with either :link reftype=hd res=1024.PrtGPrinterDlg:elink. or
:link reftype=hd res=1025.PrtGPrinterList:elink. and :link reftype=hd res=1030.PrtGSetPrinter:elink.
:li.If necessary set the job properties with :link reftype=hd res=1019.PrtGJobProps:elink.
:li.Set the page margins with :link reftype=hd res=1029.PrtGSetMargins:elink.
:li.Set up any header text with :link reftype=hd res=1008.PrtGDefineHeader:elink., :link reftype=hd res=1002.PrtGAddHeaderLine:elink. and :link reftype=hd res=1027.PrtGSetHeader:elink.
:li.Set up any footer with :link reftype=hd res=1007.PrtGDefineFooter:elink. and :link reftype=hd res=1026.PrtGSetFooter:elink.
:li.Open the print job with :link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:li.Print your texts, tables, bitmaps etc..
:li.Close the print job with :link reftype=hd res=1006.PrtGClosePrintJob:elink.
:eul.
:p.Since headers and footers often contain constants like the date or the document title and 
variables like the page number, the texts defined for these can contain special 
:link reftype=hd res=130.formatting characters:elink..
:p.:hp2.NOTE:ehp2.
:p.All the input parameters that denote positions are by default in millimetres  or 1/10 inch 
depending on the Measures property. You can convert from 
inches using the formula&colon.
:lm margin=5.
:p.mm = 254 * inch
:lm margin=1.
:p.All the line widths are defined in TWIPS&colon.
:lm margin=5.
:p.1 Point = 20 TWIPS
.br
1 mm = 56.7 TWIPS (rounded to 57 for internal calculation)
:lm margin=1.
:warning.
.br
If you wish to print several documents concurrently (i.e. in parrallel threads) you must 
initialise and terminate the environment for each thead with :link 
reftype=hd res=1018.PrtGInit:elink. and :link reftype=hd res=1035.PrtGTerm:elink..
:ewarning.

.***** Formatting Characters ********************************************

:h1 res=130.Formatting Characters
:i1 id=FRC.Formatting Characters
:font facename=Helv size=16x12.

:p.To help define header and footer texts with :link reftype=hd res=1008.PrtGDefineHeader:elink. and 
:link reftype=hd res=1007.PrtGDefineFooter:elink. the following special formatting flags are 
defined&colon.

:font facename=Courier size=16x12.
:table cols='8 56' rules=both frame=box.
:row.
:c.$
:c.If followed by one of the other characters in this table it indicates a formatting 
character follows, otherwise it is taken as a literal '$'
:row.
:c.l
:c.Left align the following text
:row.
:c.r
:c.Right align the following text
:row.
:c.c
:c.Centre the following text
:row.
:c.@
:c.Insert the current date formatted acording to the system settings. This is read every time 
a job is started; so you can change the date format from job to job in the same sesssion.
:row.
:c.#
:c.insert the current page number (always arabic)
:row.
:c. or |
:c.Insert the title of the document (see :link reftype=hd res=1023.PrtGOpenPrintJob:elink.)
:etable.

:font facename=Helv size=16x12.
:p.:hp2.Example:ehp2.
:p.'$$rpage $#' would give&colon.
:p.:hp2.Document Title                                        page 1:ehp2.
:p.'$r@ page $#' would give (where date is defined as ISO with '/' separator)&colon.
:p.:hp2.                                                          1995/03/18 page 1:ehp2.

:warning.
.br
:hp2.Formatting characters only apply to the page and table header and page footer texts.:ehp2.
:ewarning.


.***** Fill Styles ******************************************************

:h1 res=135.Fill Styles
:i1 id=STYL.Fill Styles
:font facename=Helv size=16x12.

:p.Several of the PrtGraph C Library refer to a fill style. You can see the effect of a style for 
any printer by running the :link reftype=hd res=105.DEMO program:elink. and printing the 
:hp2.box styles:ehp2. option. The  you pass to any of these functions are translated into 
:hp2.PATSYM_?????:ehp2. constants, and the output is, to a certain extent, device dependent.
For an idea of what you will obtain see the pictures below (see also .
:p.
:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\styles1.bmp' align=left.
:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\styles2.bmp' align=left.


.***** Return constants *************************************************

:h1 res=400.Returns
:i1 id=RET.Returns
:font facename=Helv size=16x12.

:p.Many of the PrtGraph C Library functions return a USHORT value. These will be one of the 
following&colon.
:font facename=Courier size=16x12.
:table cols='23 4 40' rules=both frame=box.
:row.
:c.Constant
:c.Val
:c.Explanation
:row.
:c.PRTGR_OK
:c.0
:c.Operation completed successfully.
:row.:c.PRTGR_ERR_INV_HANDLE
:c.1
:c.An invalid handle passed to a function.
:row.:c.PRTGR_ERR_NO_PRINTER
:c.2
:c.No printer has been defined on the work-station.
:row.:c.PRTGR_ERR_PARAMETER
:c.3
:c.A parameter passed to the function was out of range.
:row.
:c.PRTGR_ERR_INV_BITMAP
:c.4
:c.The bitmap read from a file was not a valid bitmap.
:row.
:c.PRTGR_ERR_INV_FILENAME
:c.5
:c.The file opened to read a bitmap either did not exist or an I/O error occured.
:row.
:c.PRTGR_ERR_INV_FONT
:c.6
:c.The font requested for a write operation could not be loaded. This could be because there are too many fonts declared for the job or the face name is invalid.
:row.
:c.PRTGR_ERR_JOB_OPEN
:c.7
:c.Failed to open the print job. Usually caused by an invalid device context being selected when using :link reftype=hd res=1030.PrtGSetPrinter:elink.. Using :link reftype=hd res=1024.PrtGPrinterDlg:elink. to set the printer context is always safer.
:row.
:c.PRTGR_ERR_NOT_TABLE
:c.8
:c.A call was made to a table related function outside of a :link reftype=hd res=1033.PrtGStartTable:elink., :link reftype=hd res=1014.PrtGEndTable:elink. pair.
:row.
:c.PRTGR_ERR_TABLE_HEADER
:c.9
:c.An error occured trying to print a running header for a table, check the definition.
:row.
:c.PRTGR_ERR_NO_JOB
:c.10
:c.A printing function was called when no job had been opened.
:row.
:c.PRTGR_ERR_PRINTING
:c.9
:c.A print setup function was called when a job was running.
:row.
:c.PRTGR_ERR_READONLY
:c.12
:c.You tried setting a read only property.
:row.
:c.PRTGR_ERR_INV_PROP
:c.13
:c.An invalid property was requested requested
:row.
:c.PRTGR_ERR_INV_VALUE
:c.14
:c.You tried setting a property to an invalid value
:etable.

.***** Defined constants ************************************************

:h1 res=410.Constants
:i1 id=CONST.Constants
:font facename=Helv size=16x12.
:p.Constants are described in the following sections&colon.
:ul compact.
:li.:link reftype=hd res=1106.Lines and Fill Styles:elink.
:li.:link reftype=hd res=1107.Print Styles for Files:elink.
:li.:link reftype=hd res=1108.Printer Properties:elink.
:eul.

:h2 res=1106.Lines and Fill Styles
:i2 refid=CONST.Lines and Fill Styles

:font facename=Helv size=16x12.
:p.The following constants define :link reftype=hd res=135.Fill Styles:elink. and line 
thicknesses&colon.
:font facename=Courier size=16x12.
:table cols='17 10 40' rules=both frame=box.
:row.
:c.Constant
:c.Value
:c.Description
:row.
:c.FILL_NONE
:c.(ULONG)0
:c.No fill for a box, header, footer or table
:row.
:c.FILL_FULL
:c.(ULONG)1
:c.full fill for a box, header, footer or table
:row.
:c.FILL_90
:c.(ULONG)2
:c.90% tone fill for a box, header, footer or table
:row.
:c.FILL_80
:c.(ULONG)3
:c.80% fill for a box, header, footer or table
:row.
:c.FILL_75
:c.(ULONG)4
:c.75% fill for a box, header, footer or table
:row.
:c.FILL_70
:c.(ULONG)5
:c.70% fill for a box, header, footer or table
:row.
:c.FILL_60
:c.(ULONG)6
:c.60% fill for a box, header, footer or table
:row.
:c.FILL_HALF
:c.(ULONG)7
:c.Half tone fill for a box, header, footer or table
:row.
:c.FILL_LIGHT
:c.(ULONG)8
:c.Light tone fill for a box, header, footer or table
:row.
:c.FILL_VERT
:c.(ULONG)9
:c.Vertical line fill for a box, header, footer or table
:row.
:c.FILL_HORIZ
:c.(ULONG)10
:c.Horizontal line fill for a box, header, footer or table
:row.
:c.FILL_DIAGR45
:c.(ULONG)11
:c.45 Diagonal left to right line fill for a box, header, footer or table
:row.
:c.FILL_DIAGR33
:c.(ULONG)12
:c.33 Diagonal left to right line fill for a box, header, footer or table
:row.
:c.FILL_DIAGL45
:c.(ULONG)13
:c.45 Diagonal right to left line fill for a box, header, footer or table
:row.
:c.FILL_DIAGL33
:c.(ULONG)14
:c.33 Diagonal right to left line fill for a box, header, footer or table
:row.
:c.LINE_NONE
:c.(ULONG)0
:c.No line for a box, header, footer or table
:row.
:c.LINE_THIN
:c.(ULONG)14
:c.Thin line 0.25mm thick for a box, header, footer or table
:row.
:c.LINE_MEDIUM
:c.(ULONG)28
:c.Medium line 0.5mm thick for a box, header, footer or table
:row.
:c.LINE_THICK
:c.(ULONG)56
:c.Thick line 1mm thick for a box, header, footer or table
:etable.

:h2 res=1107.Print Styles for Files
:i2 refid=CONST.Print Styles for Files
:font facename=Helv size=16x12.
:p.The following constants define printing styles for printing files&colon.
:font facename=Courier size=16x12.
:table cols='23 4 40' rules=both frame=box.
:row.
:c.Constant
:c.Val
:c.Description
:row.
:c.PRT_CENTER
:c.0
:c.Print the lines from the file centered beween the margins
:row.
:c.PRT_JUSTIFIED
:c.1
:c.Print the lines from the file justified between the margins
:row.
:c.PRT_RIGHT
:c.2
:c.Print the lines from the file right aligned
:row.
:c.PRT_LEFT
:c.3
:c.Print the lines from the file left aligned
:etable.

:h2 res=1108.Printer Properties
:i2 refid=CONST.Printer Properties
:font facename=Helv size=16x12.
:p.The following constants define measurement types&colon.
:font facename=Courier size=16x12.
:table cols='17 10 40' rules=both frame=box.
:row.
:c.Constant
:c.Value
:c.Description
:row.
:c.MSR_METRIC
:c."Metric"
:c.Defines all measures to be in millimetres
:row.
:c.MSR_INCH
:c."Inch"
:c.Defines all measures to be in units of 1/10th inch
:etable.

:font facename=Helv size=16x12.
:p.The following constants are used to access the printer properties&colon.
:font facename=Courier size=16x12.
:table cols='23 4 40' rules=both frame=box.
:row.
:c.Constant
:c.Val
:c.See property
:row.
:c.PRT_LEFTMARGIN
:c.0
:c.:link reftype=hd res=3304.LeftMargin:elink.
:row.
:c.PRT_RIGHTMARGIN
:c.1
:c.:link reftype=hd res=3309.RightMargin:elink.
:row.
:c.PRT_TOPMARGIN
:c.2
:c.:link reftype=hd res=3310.TopMargin:elink.
:row.
:c.PRT_BOTTOMMARGIN
:c.3
:c.:link reftype=hd res=3301.BottomMargin:elink.
:row.
:c.PRT_PAGEWIDTH
:c.4
:c.:link reftype=hd res=3307.PageWidth:elink.
:row.
:c.PRT_PAGEHEIGHT
:c.5
:c.:link reftype=hd res=3306.PageHeight:elink.
:row.
:c.PRT_PRINTING
:c.6
:c.:link reftype=hd res=3308.Printing:elink.
:row.
:c.PRT_CURRENTPRINTER
:c.7
:c.:link reftype=hd res=3303.CurrentPrinter:elink.
:row.
:c.PRT_CURRENTDEVICE
:c.8
:c.:link reftype=hd res=3302.CurrentDevice:elink.
:row.
:c.PRT_DEFAULTPRINTER
:c.9
:c.:link reftype=hd res=3704.DefaultPrinter:elink.
:row.
:c.PRT_LINESPACE
:c.10
:c.:link reftype=hd res=3305.LineSpace:elink.
:row.
:c.PRT_VERSION
:c.11
:c.:link reftype=hd res=3311.Version:elink.
:row.
:c.PRT_PRINTCOLOR
:c.12
:c.:link reftype=hd res=3312.PrintColor:elink.
:row.
:c.PRT_COLORENABLED
:c.13
:c.:link reftype=hd res=3313.ColorEnabled:elink.
:row.
:c.PRT_MEASURES
:c.14
:c.:link reftype=hd res=3314.Measures:elink.
:row.
:c.PRT_PAGENUM
:c.15
:c.:link reftype=hd res=3316.PageNum:elink.
:row.
:c.PRT_JOBNAME
:c.16
:c.:link reftype=hd res=3317.JobName:elink.
:row.
:c.PRT_MINLEFTMAR
:c.17
:c.:link reftype=hd res=3706.MinLeftMar:elink.
:row.
:c.PRT_MINRIGHTMAR
:c.18
:c.:link reftype=hd res=3707.MinRightMar:elink.
:row.
:c.PRT_MINTOPMAR
:c.19
:c.:link reftype=hd res=3708.MinTopMar:elink.
:row.
:c.PRT_MINBOTTOMMAR
:c.20
:c.:link reftype=hd res=3705.MinBottomMar:elink.
:row.
:c.PRT_FORMNAME
:c.21
:c.:link reftype=hd res=3710.FormName:elink.
:row.
:c.PRT_FORMWIDTH
:c.22
:c.:link reftype=hd res=3711.FormWidth:elink.
:row.
:c.PRT_FORMHEIGHT
:c.23
:c.:link reftype=hd res=3709.FormHeight:elink.
:row.
:c.PRT_WORDBREAK
:c.24
:c.:link reftype=hd res=3713.WordBreak:elink.
:row.
:c.PRT_SHOWPROGRESS
:c.25
:c.:link reftype=hd res=3712.ShowProgress:elink.
:etable.

.***** Data Types ********************************************************

:h1 res=500.Data Types
:i1 id=DATA.Data Types
:font facename=Helv size=16x12.
:p.The following sections describe the data types exported by the :hp2.PrtGraph C Library:ehp2..
:ul compact.
:li.:link reftype=hd res=501.HFOOTER:elink.
:li.:link reftype=hd res=502.HGRPRT:elink.
:li.:link reftype=hd res=503.HHEADER:elink.
:li.:link reftype=hd res=504.HTABLE:elink.
:li.:link reftype=hd res=510.PFNNP:elink.
:li.:link reftype=hd res=1109.PROP_TYPE:elink.
:eul.

:h2 res=501.HFOOTER
:i2 refid=DATA.HFOOTER
:xmp.
typedef LHANDLE   HFOOTER;
:exmp.
:font facename=Helv size=16x12.
:p.Handle to a footer definition. This definition is independent of :link reftype=hd 
res=502.HGRPRT:elink. and the object is only merged with the print job definition after 
a call to :link reftype=hd res=1026.PrtGSetFooter:elink.. The Object can, therefore, be used 
in several print jobs in an application. The object is destroyed by calling :link reftype=hd res=1010.PrtGDestroyFtrDef:elink.

:h2 res=502.HGRPRT
:i2 refid=DATA.HGRPRT
:xmp.
typedef LHANDLE   HGRPRT;
:exmp.
:font facename=Helv size=16x12.
:p.Handle to the graphics printing environment. All printing operations require a variable of this
type to have been previously initialised by a call to :link reftype=hd res=1018.PrtGInit:elink..

:h2 res=503.HHEADER
:i2 refid=DATA.HHEADER
:xmp.
typedef LHANDLE   HHEADER;
:exmp.
:font facename=Helv size=16x12.
:p.Handle to a page header definition. This definition is independent of :link reftype=hd 
res=502.HGRPRT:elink. and the object is only merged with the print job definition after 
a call to :link reftype=hd res=1027.PrtGSetHeader:elink.. The Object can, therefore, be used 
in several print jobs in an application. The object is destroyed by calling :link reftype=hd res=1011.PrtGDestroyHdrDef:elink.

:h2 res=504.HTABLE
:i2 refid=DATA.HTABLE
:xmp.
typedef LHANDLE   HTABLE;
:exmp.
:font facename=Helv size=16x12.
:p.Handle to a table definition. This definition is independent of :link reftype=hd 
res=502.HGRPRT:elink. and the object is only merged with the print job definition after 
a call to :link reftype=hd res=1033.PrtGStartTable:elink.. The Object can, therefore, be used 
in several print jobs in an application. The object is destroyed by calling :link reftype=hd res=1012.PrtGDestroyTblDef:elink.

:h2 res=510.PFNNP
:i2 refid=DATA.PFNNP
:xmp.
typedef BOOL (APIENTRY FNNP)(HGRPRT, USHORT, BOOL);
typedef FNNP *PFNNP;
:exmp.
:font facename=Helv size=16x12.
:p.Hook function for new page. A call will be made to this function every time a new page is created 
internally by the library and before the page is printed. The format of the function is&colon.
:font facename=Courier size=16x12.
:xmp.
VOID MyNewPageFunc( HGRPRT    hp,
                    USHORT    page_num,
                    BOOL      in_table);
:exmp.
:font facename=Helv size=16x12.
:p.:hp2.Parameters:ehp2.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink.
:pt.page_num
:pd.The number of the page that is about to be printed
:pt.in_table
:pd.is set to true if a table is being printed that will continue over to the new page.
:eparml.
:p.:p.:hp2.Description:ehp2.
:p.This function is supplied so that you can modify page headers or column headers when a new 
page is printed.

:h2 res=1109.PROP_TYPE
:i2 refid=DATA.PROP_TYPE
:xmp.
typedef union
    {
    BOOL    flag;
    ULONG   numeric;
    PSZ     string;
    } PROP_TYPE;
:exmp.
:font facename=Helv size=16x12.
:p.This union type is used to set or get the value of a printer property.

.***** Properties ********************************************************

:h1 res=3000.Properties
:i1 id=PROPS.Properties
:font facename=Helv size=16x12.
:p.The following sections describe the properties of a printer in the :hp2.PrtGraph C Library:ehp2. 
and which can be accessed using  with the relevannt :link reftype=hd res=1108.Printer Properties 
Constant:elink.&colon.
:ul compact.
:li.:link reftype=hd res=3301.BottomMargin:elink.
:li.:link reftype=hd res=3313.ColorEnabled:elink.
:li.:link reftype=hd res=3302.CurrentDevice:elink.
:li.:link reftype=hd res=3303.CurrentPrinter:elink.
:li.:link reftype=hd res=3704.DefaultPrinter:elink.
:li.:link reftype=hd res=3709.FormHeight:elink.
:li.:link reftype=hd res=3710.FormName:elink.
:li.:link reftype=hd res=3711.FormWidth:elink.
:li.:link reftype=hd res=3317.JobName:elink.
:li.:link reftype=hd res=3304.LeftMargin:elink.
:li.:link reftype=hd res=3305.LineSpace:elink.
:li.:link reftype=hd res=3314.Measures:elink.
:li.:link reftype=hd res=3705.MinBottomMar:elink.
:li.:link reftype=hd res=3706.MinLeftMar:elink.
:li.:link reftype=hd res=3707.MinRightMar:elink.
:li.:link reftype=hd res=3708.MinTopMar:elink.
:li.:link reftype=hd res=3306.PageHeight:elink.
:li.:link reftype=hd res=3316.PageNum:elink.
:li.:link reftype=hd res=3307.PageWidth:elink.
:li.:link reftype=hd res=3308.Printing:elink.
:li.:link reftype=hd res=3312.PrintColor:elink.
:li.:link reftype=hd res=3309.RightMargin:elink.
:li.:link reftype=hd res=3712.ShowProgress:elink.
:li.:link reftype=hd res=3310.TopMargin:elink.
:li.:link reftype=hd res=3311.Version:elink.
:li.:link reftype=hd res=3713.WordBreak:elink.
:eul.

.***** BottomMargin ************************************************
 
:h2 res=3301.BottomMargin
:i2 refid=PROPS.BottomMargin
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3716.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3717.

:h2 hide res=3716.BottomMargin - List
:font facename=Helv size=16x12.

:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3304.LeftMargin:elink.
:li.:link reftype=hd res=3309.RightMargin:elink.
:li.:link reftype=hd res=3310.TopMargin:elink.
:li.:link reftype=hd res=3306.PageHeight:elink.
:li.:link reftype=hd res=3307.PageWidth:elink.
:eul.

:h2 hide res=3717.BottomMargin - Description
:xmp.
ulong = PrtGGet( printer, PRT_BOTTOMMARGIN);
:exmp.
:font facename=Helv size=16x12.
:p.The distance of the bottom margin from the lower edge of the page. The measure is in mm or 
1/10 inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** ColorEnabled *****************************************************

:h2 res=3313.ColorEnabled
:i2 refid=PROPS.ColorEnabled
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3718.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3719.

:h2 hide res=3718.ColorEnabled - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.BOOL
:esl.
:p.:hp2.Possible Values:ehp2.
:sl compact.
:li.1 (TRUE)
:li.0 (FALSE)
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3312.PrintColor:elink.
:eul.

:h2 hide res=3719.ColorEnabled - Description
:xmp.
flag = PrtGGet( printer, PRT_COLORENABLED);
:exmp.
:font facename=Helv size=16x12.
:p.Boolean property indicating whether color printing is enabled or not.

.***** CurrentDevice ************************************************
 
:h2 res=3302.CurrentDevice
:i2 refid=PROPS.CurrentDevice
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3720.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3721.

:h2 hide res=3720.CurrentDevice - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3303.CurrentPrinter:elink.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:eul.

:h2 hide res=3721.CurrentDevice - Description
:xmp.
psz = PrtGGet( printer, PRT_CURRENTDEVICE);
:exmp.
:font facename=Helv size=16x12.
:p.The name of the printer device selected for the printer object. This is the same as the 
Physical Name seen in printer settings notebook.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** CurrentPrinter ************************************************
 
:h2 res=3303.CurrentPrinter
:i2 refid=PROPS.CurrentPrinter
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3722.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3723.

:h2 hide res=3722.CurrentPrinter - list
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3302.CurrentDevice:elink.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:eul.

:h2 hide res=3723.CurrentPrinter - Description
:xmp.
psz = PrtGGet( printer, PRT_CURRENTPRINTER);
:exmp.
:font facename=Helv size=16x12.
:p.The name of the printer selected for the printer object. This is the same as the name seen on 
the desktop printer object.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** DefaultPrinter ***************************************************

:h2 res=3704.DefaultPrinter
:i2 refid=PROPS.DefaultPrinter
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3724.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3725.


:h2 hide res=3724.DefaultPrinter - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3302.CurrentDevice:elink.
:li.:link reftype=hd res=3303.CurrentPrinter:elink.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:eul.

:h2 hide res=3725.DefaultPrinter - Description
:xmp.
psz = PrtGGet( printer, PRT_DEFAULTPRINTER);
:exmp.
:font facename=Helv size=16x12.
:p.The name of the default system printer. This is the same as the name seen on the desktop 
printer object.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** FormHeight *********************************************************

:h2 res=3709.FormHeight
:i2 refid=PROPS.FormHeight
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3726.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3727.


:h2 hide res=3726.FormHeight - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3710.FormName:elink.
:li.:link reftype=hd res=3711.FormWidth:elink.
:eul.

:h2 hide res=3727.FormHeight - Description
:xmp.
ulong = PrtGGet( printer, PRT_FORMHEIGHT);
:exmp.
:font facename=Helv size=16x12.
:p.The height of the currently selected form for the current printer in mm or 1/10 inch 
depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** FormName *********************************************************

:h2 res=3710.FormName
:i2 refid=PROPS.FormName
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3728.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3729.

:h2 hide res=3728.FormName - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3709.FormHeight:elink.
:li.:link reftype=hd res=3711.FormWidth:elink.
:eul.


:h2 hide res=3729.FormName - Description
:xmp.
psz = PrtGGet( printer, PRT_FORMNAME);
:exmp.
:font facename=Helv size=16x12.
:p.The name of the currently selected form for the current printer.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** FormWidth *********************************************************

:h2 res=3711.FormWidth
:i2 refid=PROPS.FormWidth
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3730.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3731.

:h2 hide res=3730.FormWidth - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3709.FormHeight:elink.
:li.:link reftype=hd res=3710.FormName:elink.
:eul.

:h2 hide res=3731.FormWidth - Description
:xmp.
ulong = PrtGGet( printer, PRT_FORMWIDTH);
:exmp.
:font facename=Helv size=16x12.
:p.The width of the currently selected form for the current printer in mm or 1/10 inch 
depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** JobName **********************************************************

:h2 res=3317.JobName
:i2 refid=PROPS.JobName
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3732.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3733.

:h2 hide res=3732.JobName - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.

:h2 hide res=3733.JobName - Description
:xmp.
psz = PrtGGet( printer, PRT_JOBNAME);
:exmp.
:font facename=Helv size=16x12.
:p.The document name of the current print job.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** LeftMargin ************************************************
 
:h2 res=3304.LeftMargin
:i2 refid=PROPS.LeftMargin
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3734.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3735.

:h2 hide res=3734.LeftMargin - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3301.BottomMargin:elink.
:li.:link reftype=hd res=3309.RightMargin:elink.
:li.:link reftype=hd res=3310.TopMargin:elink.
:li.:link reftype=hd res=3306.PageHeight:elink.
:li.:link reftype=hd res=3307.PageWidth:elink.
:eul.

:h2 hide res=3735.LeftMargin - Description
:xmp.
ulong = PrtGGet( printer, PRT_LEFTMARGIN);
:exmp.
:font facename=Helv size=16x12.
:p.The distance of the left margin from the left edge of the page. The measure is in mm or 1/10 
inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** LineSpace ******************************************************
 
:h2 res=3305.LineSpace
:i2 refid=PROPS.LineSpace
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3736.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3737.

:h2 hide res=3736.LineSpace - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:eul.

:h2 hide res=3737.LineSpace - Description
:xmp.
ulong = PrtGGet( printer, PRT_LINESPACE);
:exmp.
:font facename=Helv size=16x12.
:p.Line spacing as a percentage of the font size. The default value is set to single space = 120%. 
All writes following this call will use this inter-line spacing.

.***** Measures ********************************************************

:h2 res=3314.Measures
:i2 refid=PROPS.Measures
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3738.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3739.

:h2 hide res=3738.Measures - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.
:p.:hp2.Possible Values:ehp2.
:sl compact.
:li."Metric" (MSR_METRIC)
:li."Inch" (MSR_INCH)
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1026.PrtGSetFooter:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:li.:link reftype=hd res=1053.PrtGSetHeaderLineFont:elink.
:li.:link reftype=hd res=1029.PrtGSetMargins:elink.
:eul.

:h2 hide res=3739.Measures - Description
:xmp.
psz = PrtGGet( printer, PRT_MEASURES);
:exmp.
:font facename=Helv size=16x12.
:p.The units to use for distances on the printing page. These can be either mm (the default) 
or in 1/10 inch units.

.***** MinBottomMar ************************************************

:h2 res=3705.MinBottomMar
:i2 refid=PROPS.MinBottomMar
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3740.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3741.

:h2 hide res=3740.MinBottomMar - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3706.MinLeftMar:elink.
:li.:link reftype=hd res=3707.MinRightMar:elink.
:li.:link reftype=hd res=3708.MinTopMar:elink.
:eul.

:h2 hide res=3741.MinBottomMar - Description
:xmp.
ulong = PrtGGet( printer, PRT_MINBOTTOMMAR);
:exmp.
:font facename=Helv size=16x12.
:p.The minimum bottom margin allowed for the selected printer. The measure is in mm or 1/10 
inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** MinLeftMar ************************************************

:h2 res=3706.MinLeftMar
:i2 refid=PROPS.MinLeftMar
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3742.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3743.

:h2 hide res=3742.MinLeftMar - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3705.MinBottomMar:elink.
:li.:link reftype=hd res=3707.MinRightMar:elink.
:li.:link reftype=hd res=3708.MinTopMar:elink.
:eul.

:h2 hide res=3743.MinLeftMar - Description
:xmp.
ulong = PrtGGet( printer, PRT_MINLEFTMAR);
:exmp.
:font facename=Helv size=16x12.
:p.The minimum left margin allowed for the selected printer. The measure is in mm or 1/10 
inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** MinRightMar ************************************************

:h2 res=3707.MinRightMar
:i2 refid=PROPS.MinRightMar
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3744.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3745.

:h2 hide res=3744.MinRightMar - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3705.MinBottomMar:elink.
:li.:link reftype=hd res=3706.MinLeftMar:elink.
:li.:link reftype=hd res=3708.MinTopMar:elink.
:eul.

:h2 hide res=3745.MinRightMar - Description
:xmp.
ulong = PrtGGet( printer, PRT_MINRIGHTMAR);
:exmp.
:font facename=Helv size=16x12.
:p.The minimum right margin allowed for the selected printer. The measure is in mm or 1/10 
inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** MinTopMar ************************************************

:h2 res=3708.MinTopMar
:i2 refid=PROPS.MinTopMar
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3746.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3747.

:h2 hide res=3746.MinTopMar - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3705.MinBottomMar:elink.
:li.:link reftype=hd res=3706.MinLeftMar:elink.
:li.:link reftype=hd res=3707.MinRightMar:elink.
:eul.

:h2 hide res=3747.MinTopMar - Description
:xmp.
ulong = PrtGGet( printer, PRT_MINTOPMAR);
:exmp.
:font facename=Helv size=16x12.
:p.The minimum top margin allowed for the selected printer. The measure is in mm or 1/10 inch 
depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** PageHeight ************************************************
 
:h2 res=3306.PageHeight
:i2 refid=PROPS.PageHeight
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3748.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3749.

:h2 hide res=3748.PageHeight - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3301.BottomMargin:elink.
:li.:link reftype=hd res=3304.LeftMargin:elink.
:li.:link reftype=hd res=3309.RightMargin:elink.
:li.:link reftype=hd res=3310.TopMargin:elink.
:li.:link reftype=hd res=3307.PageWidth:elink.
:eul.

:h2 hide res=3749.PageHeight - Decsription
:xmp.
ulong = PrtGGet( printer, PRT_PAGEHEIGHT);
:exmp.
:font facename=Helv size=16x12.
:p.The height of the printing area of the page (bottom to top margin) in mm or 1/10 inch 
depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** PageNum **********************************************************

:h2 res=3316.PageNum
:i2 refid=PROPS.PageNum
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3750.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3751.


:h2 hide res=3750.PageNum - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3317.JobName:elink.
:eul.

:h2 hide res=3751.PageNum - Description
:xmp.
ulong = PrtGGet( printer, PRT_PAGENUM);
:exmp.
:font facename=Helv size=16x12.
:p.This property contains the number of the page that is currently being printed.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** PageWidth ************************************************
 
:h2 res=3307.PageWidth
:i2 refid=PROPS.PageWidth
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3752.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3753.

:h2 hide res=3752.PageWidth - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3301.BottomMargin:elink.
:li.:link reftype=hd res=3304.LeftMargin:elink.
:li.:link reftype=hd res=3309.RightMargin:elink.
:li.:link reftype=hd res=3310.TopMargin:elink.
:li.:link reftype=hd res=3306.PageHeight:elink.
:eul.

:h2 hide res=3753.PageWidth - Description
:xmp.
ulong = PrtGGet( printer, PRT_PAGEWIDTH);
:exmp.
:font facename=Helv size=16x12.
:p.The width of the printing area of the page (left to right margin) in mm or 1/10 inch depending 
on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** Printing ************************************************
 
:h2 res=3308.Printing
:i2 refid=PROPS.Printing
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3754.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3755.

:h2 hide res=3754.Printing - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.BOOL
:esl.
:p.:hp2.Possible Values:ehp2.
:sl compact.
:li.1 (TRUE)
:li.0 (FALSE)
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1006.PrtGClosePrintJob:elink.
:li.:link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:eul.

:h2 hide res=3755.Printing - Description
:xmp.
bool = PrtGGet( printer, PRT_PRINTING);
:exmp.
:font facename=Helv size=16x12.
:p.This property is set to 1 when a print job is open on the printer object. Otherwise this 
property is set to 0.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** PrintColor *******************************************************

:h2 res=3312.PrintColor
:i2 refid=PROPS.PrintColor
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3756.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3757.

:h2 hide res=3756.PrintColor - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.LONG
:esl.
:p.:hp2.Possible Values:ehp2.
:sl compact.
:li.See Description
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3313.ColorEnabled:elink.
:eul.

:h2 hide res=3757.PrintColor - Description
:xmp.
long = PrtGGet( printer, PRT_PRINTCOLOR);
:exmp.
:font facename=Helv size=16x12.
:p.This property is only relevant for colour printers. It contains the current colour being used 
for printing. This color can be any of the standard GPI color constants&colon.
:font facename=Courier size=16x12.
:table cols='15 15 15' rules=none frame=none.
:row.
:c.CLR_WHITE
:c.CLR_BLACK
:c.CLR_BLUE
:row.
:c.CLR_RED
:c.CLR_PINK
:c.CLR_GREEN
:row.
:c.CLR_CYAN
:c.CLR_YELLOW
:c.CLR_DARKGRAY
:row.
:c.CLR_DARKBLUE
:c.CLR_DARKRED
:c.CLR_DARKPINK
:row.
:c.CLR_DARKGREEN
:c.CLR_DARKCYAN
:c.CLR_BROWN
:row.
:c.CLR_PALEGREY
:c.CLR_DEFAULT
:etable.

.***** RightMargin ************************************************
 
:h2 res=3309.RightMargin
:i2 refid=PROPS.RightMargin
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3758.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3759.

:h2 hide res=3758.RightMargin - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3301.BottomMargin:elink.
:li.:link reftype=hd res=3304.LeftMargin:elink.
:li.:link reftype=hd res=3310.TopMargin:elink.
:li.:link reftype=hd res=3306.PageHeight:elink.
:li.:link reftype=hd res=3307.PageWidth:elink.
:eul.

:h2 hide res=3759.RightMargin - Description
:xmp.
ulong = PrtGGet( printer, PRT_RIGHTMARGIN);
:exmp.
:font facename=Helv size=16x12.
:p.The distance of the right margin from the right edge of the page. The measure is in mm or 
1/10 inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** ShowProgress *****************************************************

:h2 res=3712.ShowProgress
:i2 refid=PROPS.ShowProgress
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3760.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3761.

:h2 hide res=3760.ShowProgress - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.BOOL
:esl.
:p.:hp2.Possible Values:ehp2.
:sl compact.
:li.1 (TRUE)
:li.0 (FALSE)
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.
:eul.

:h2 hide res=3761.ShowProgress - Description
:xmp.
bool = PrtGGet( printer, PRT_SHOWPROGRESS);
:exmp.
:font facename=Helv size=16x12.
:p.This is boolean property that when set enables the progress dialog to pop up when a 
job is printing.
:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\progress.bmp' align=left.
:p.:hp2.Figure&colon. Default Progress Dialog.:ehp2.

.***** TopMargin ************************************************
 
:h2 res=3310.TopMargin
:i2 refid=PROPS.TopMargin
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3762.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3763.

:h2 hide res=3762.TopMargin - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.ULONG
:esl.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=3301.BottomMargin:elink.
:li.:link reftype=hd res=3304.LeftMargin:elink.
:li.:link reftype=hd res=3309.RightMargin:elink.
:li.:link reftype=hd res=3306.PageHeight:elink.
:li.:link reftype=hd res=3307.PageWidth:elink.
:eul.

:h2 hide res=3763.TopMargin - Description
:xmp.
ulong = PrtGGet( printer, PRT_TOPMARGIN);
:exmp.
:font facename=Helv size=16x12.
:p.The distance of the top margin from the upper edge of the page. The measure is in mm or 1/10 
inch depending on the :link reftype=hd res=3314.Measures:elink. property.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** Version ************************************************
 
:h2 res=3311.Version
:i2 refid=PROPS.Version
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3764.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3765.

:h2 hide res=3764.Version - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.PSZ
:esl.
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.Numeric
:esl.

:h2 hide res=3765.Version - Description
:xmp.
psz = PrtGGet( printer, PRT_VERSION);
:exmp.
:font facename=Helv size=16x12.
:p.Version number of the object.
:warning.
This property is read only and cannot be set with a call to :link reftype=hd res=4409.PrtGSet:elink..
:ewarning.

.***** WordBreak ********************************************************

:h2 res=3713.WordBreak
:i2 refid=PROPS.WordBreak
:link reftype=hd auto split group=1 vpx=left vpy=top vpcx=30% vpcy=100% scroll=vertical titlebar=none rules=border res=3766.
:link reftype=hd auto split group=2 vpx=right vpy=top vpcx=70% vpcy=100% scroll=vertical titlebar=yes rules=border res=3767.

:h2 hide res=3766.WordBreak - List
:font facename=Helv size=16x12.
:p.:hp2.Data Type:ehp2.
:sl compact.
:li.BOOL
:esl.
:p.:hp2.Possible Values:ehp2.
:sl compact.
:li.1 (TRUE)
:li.0 (FALSE)
:esl.

:h2 hide res=3767.WordBreak - Description
:xmp.
bool = PrtGGet( printer, PRT_WORDBREAK);
:exmp.
:font facename=Helv size=16x12.
:p.The :hp2.WordBreak:ehp2. property allows you to control the way the :hp2.Printer 
Object:ehp2. performs word wrapping on a block of text. By default this property is set to 
1 (TRUE) so that the breaks occur between words. By setting this property off (0), line 
wrapping will occur with breaks between characters.

.***** Functions ********************************************************

:h1 res=1000.Functions
:i1 id=FUNC.Functions
:font facename=Helv size=16x12.
:p.The following sections describe the functions exported by :hp2.PrtGraph C Library:ehp2.. 
In the following list, the names of the old functions are given where applicacable. These 
old function names are maintained for backward compatibility.
:ul compact.
:li.:link reftype=hd res=1100.PrtGAbortPrintJob:elink.
:li.:link reftype=hd res=1001.PrtGAddColumn:elink.
:li.:link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:li.:link reftype=hd res=1006.PrtGClosePrintJob:elink.
:li.:link reftype=hd res=1007.PrtGDefineFooter:elink.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1051.PrtGDefineFtrColors:elink.
:li.:link reftype=hd res=1052.PrtGDefineHdrColors:elink.
:li.:link reftype=hd res=1050.PrtGDefineTableColors:elink.
:li.:link reftype=hd res=1010.PrtGDestroyFtrDef:elink.
:li.:link reftype=hd res=1011.PrtGDestroyHdrDef:elink.
:li.:link reftype=hd res=1012.PrtGDestroyTblDef:elink.
:li.:link reftype=hd res=1013.PrtGEndRow:elink.
:li.:link reftype=hd res=1014.PrtGEndTable:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink. PrtGFontDlg
:li.:link reftype=hd res=4399.PrtGGet:elink.
:li.:link reftype=hd res=1017.PrtGGoto:elink.
:li.:link reftype=hd res=1018.PrtGInit:elink.
:li.:link reftype=hd res=1019.PrtGJobProperties:elink. PrtGJobProps
:li.:link reftype=hd res=1022.PrtGNewPage:elink.
:li.:link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:li.:link reftype=hd res=1003.PrtGPrintBitmap:elink. PrtGBitMap and PrtGBitMapColor
:li.:link reftype=hd res=1004.PrtGPrintBox:elink. PrtGBox and PrtGBoxColor
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink. PrtGPrinterDlg
:li.:link reftype=hd res=1025.PrtGPrinterList:elink.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink. PrtGCentre
:li.:link reftype=hd res=4419.PrtGPrintFile:elink.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink. PrtGJustified
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink. PrtGWrite
:li.:link reftype=hd res=1038.PrtGPrintLine:elink. PrtGWriteln
:li.:link reftype=hd res=1021.PrtGPrintRight:elink. PrtGJustRight
:li.:link reftype=hd res=4409.PrtGSet:elink.
:li.:link reftype=hd res=1105.PrtGSetDlgButtonTexts:elink.
:li.:link reftype=hd res=1026.PrtGSetFooter:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:li.:link reftype=hd res=1053.PrtGSetHdrLineFont:elink.
:li.:link reftype=hd res=1029.PrtGSetMargins:elink.
:li.:link reftype=hd res=1054.PrtGSetPrintColors:elink.
:li.:link reftype=hd res=1030.PrtGSetPrinter:elink.
:li.:link reftype=hd res=1031.PrtGStartCol:elink.
:li.:link reftype=hd res=1032.PrtGStartRow:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:li.:link reftype=hd res=1034.PrtGTab:elink.
:li.:link reftype=hd res=1035.PrtGTerm:elink.
:eul.

.***** PrtGAbortPrintJob ************************************************

:h2 res=1100.PrtGAbortPrintJob
:i2 refid=FUNC.PrtGAbortPrintJob
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4000.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4001.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4002.

:h2 hide res=4000.PrtGAbortPrintJob - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4001.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4002.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1006.PrtGClosePrintJob:elink.
:li.:link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:eul.

:h2 hide res=4002.PrtGAbortPrintJob - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.htbl
:pd.Handle to the table definition created with :link reftype=hd res=1009.PrtGDefineTable:elink.
:eparml.

:h2 hide res=4001.PrtGAbortPrintJob - Description
:xmp.
USHORT PrtGAbortPrintJob( :link reftype=hd res=504.HTABLE:elink.  htbl);
:exmp.
:font facename=Helv size=16x12.
:p.Aborts the print job and deletes the document from the print queue.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid job handle was passed
:pt.PRTGR_ERR_NO_JOB
:pd.There is no job running to abort
:eparml.

.***** PrtGAddColumn *******************************************************

:h2 res=1001.PrtGAddColumn
:i2 refid=FUNC.PrtGAddColumn
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4010.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4011.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4012.

:h2 hide res=4010.PrtGAddColumn - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4011.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4012.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1055.PrtGResetColHeader:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:eul.

:h2 hide res=4011.PrtGAddColumn - Description
:xmp.
USHORT PrtGAddColumn( :link reftype=hd res=504.HTABLE:elink.  htbl,
                      USHORT  usCol,
                      ULONG   ulLeft,
                      ULONG   ulWide,
                      PSZ     pszTtile);
:exmp.
:font facename=Helv size=16x12.
:p.Adds a column definition to a table definition.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid table handle was passed
:eparml.


:h2 hide res=4012.PrtGAddColumn - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.htbl
:pd.Handle to the table definition created with :link reftype=hd res=1009.PrtGDefineTable:elink.
:pt.usCol
:pd.Number of the column. The Column numbering is in real world numbers i.e. starting at 1
:pt.ulLeft
:pd.The distance of the left edge of the column from the left margin in mm
:pt.ulWide
:pd.The width of the cells in the column in mm
:pt.pszTitle
:pd.A pointer to a NULL terminated string containing the column header text
:eparml.

.***** PrtGAddHeaderLine ***************************************************

:h2 res=1002.PrtGAddHeaderLine
:i2 refid=FUNC.PrtGAddHeaderLine
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4020.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4021.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4022.

:h2 hide res=4020.PrtGAddHeaderLine - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4021.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4022.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:li.:link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:eul.

:h2 hide res=4021.PrtGAddHeaderLine - Description
:xmp.
USHORT PrtGAddHeaderLine( :link reftype=hd res=503.HHEADER:elink.     hhdr,
                          USHORT      usLine,
                          PSZ         pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Defines a text line in the page header.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid header handle is passed
:pt.PRTGR_ERR_PARAMETER
:pd.usLine is out of range i.e. greater than 5 or less than 1
:eparml.

:h2 hide res=4022.PrtGAddHeaderLine - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hhdr
:pd.Handle to a header definition returned by :link reftype=hd res=1008.PrtGDefineHeader:elink.
:pt.usLine
:pd.The number of the line in the header. Line numbers are in real world numbers i.e. 1 to 5
:pt.pszString
:pd.Pointer to a NULL terminated string with the text to appear on the line. This text can
contain :link reftype=hd res=130.Formatting Characters:elink.
:eparml.

.***** PrtGClosePrintJob ***************************************************

:h2 res=1006.PrtGClosePrintJob
:i2 refid=FUNC.PrtGClosePrintJob
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4060.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4061.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4062.

:h2 hide res=4060.PrtGClosePrintJob - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4061.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4062.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:li.:link reftype=hd res=1018.PrtGInit:elink.
:li.:link reftype=hd res=1035.PrtGTerm:elink.
:eul.

:h2 hide res=4061.PrtGClosePrintJob - Description
:xmp.
USHORT PrtGClosePrintJob( :link reftype=hd res=502.HGRPRT:elink.   hp);
:exmp.
:font facename=Helv size=16x12.
:p.Closes the current job and resets all the internal variables associated with the 
presentation space.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4062.PrtGClosePrintJob - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink.
:eparml.

.***** PrtGDefineFooter ****************************************************

:h2 res=1007.PrtGDefineFooter
:i2 refid=FUNC.PrtGDefineFooter
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4070.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4071.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4072.

:h2 hide res=4070.PrtGDefineFooter - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4071.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4072.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1026.PrtGSetFooter:elink.
:li.:link reftype=hd res=1010.PrtGDestroyFtrDef:elink.
:eul.

:h2 hide res=4071.PrtGDefineFooter - Description
:xmp.
:link reftype=hd res=501.HFOOTER:elink. PrtGDefineFooter( BOOL     bPrint,
                          PSZ      pszFont,
                          ULONG    ulPts,
                          ULONG    ulFill,
                          ULONG    ulLine,
                          PSZ      pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Builds an internal structure used to define the footer for the pages in a print job. This structure is available for re-use untill it is explicitly destroyed with :link reftype=hd res=1010.PrtGDestroyFtrDef:elink.
:p.:hp2.Return:ehp2.
:p.Handle to a footer description that can then be passed to :link reftype=hd res=1026.PrtGSetFooter:elink.

:h2 hide res=4072.PrtGDefineFooter - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.bPrint
:pd.Boolean flag (TRUE = Print footers, FALSE = do not print footers)
:pt.pszFont
:pd.Font name to print the footer
:pt.ulPts
:pd.Point size for the footer font
:pt.ulFill
:pd.The fill style for the box containing the footer
:pt.ulLine
:pd.The thickness (in TWIPS) of the line around the box containing the footer.
:pt.pszString
:pd.Text to print in the footer. This text can contain :link reftype=hd res=130.Formatting Characters:elink.
:eparml.

.***** PrtGDefineHeader ****************************************************

:h2 res=1008.PrtGDefineHeader
:i2 refid=FUNC.PrtGDefineHeader
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4080.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4081.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4082.

:h2 hide res=4080.PrtGDefineHeader - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4081.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4082.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:li.:link reftype=hd res=1007.PrtGDefineFooter:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:eul.

:h2 hide res=4081.PrtGDefineHeader - Description
:xmp.
:link reftype=hd res=503.HHEADER:elink. PrtGDefineHeader( BOOL     bPrint,
                          BOOL     bAllPages,
                          PSZ      pszFont,
                          ULONG    ulPts,
                          ULONG    ulFill,
                          ULONG    ulLine,
                          USHORT   usLines);
:exmp.
:font facename=Helv size=16x12.
:p.Builds an internal structure used to define the header for the pages in a print job. This
structure is available for re-use until it is explicitly destroyed with :link reftype=hd
res=1011.PrtGDestroyHdrDef:elink.. Before calling :link reftype=hd res=1027.PrtGSetHeader:elink.
you must set the header texts using calls to :link reftype=hd res=1002.PrtGAddHeaderLine:elink..
:p.:hp2.Return:ehp2.
:p.Handle to a header definition which can be passed to :link reftype=hd res=1027.PrtGSetHeader:elink.

:h2 hide res=4082.PrtGDefineHeader - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.bPrint
:pd.Flag indicating if page headers should be printed.
:pt.bAllPages
:pd.If TRUE the headers are repeated an all the pages, otherwise a header is only printed on the first page.
:pt.pszFont
:pd.Font name to print the header
:pt.ulPts
:pd.Point size for the header font
:pt.ulFill
:pd.The fill style for the box containing the headerer
:pt.ulLine
:pd.The thickness (in TWIPS) of the line around the box containing the header.
:pt.usLines
:pd.The number of lines printed in the header (1 to 5)
:eparml.

.***** PrtGDefineTable *****************************************************

:h2 res=1009.PrtGDefineTable
:i2 refid=FUNC.PrtGDefineTable
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4090.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4091.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4092.

:h2 hide res=4090.PrtGDefineTable - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4091.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4092.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1001.PrtGAddColumn:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:eul.

:h2 hide res=4091.PrtGDefineTable - Description
:xmp.
:link reftype=hd res=504.HTABLE:elink. PrtGDefineTable( BOOL       boxed,
                        BOOL       bHeader,
                        BOOL       bAllPages,
                        ULONG      ulLine,
                        ULONG      ulFill,
                        ULONG      ulHline,
                        ULONG      ulHfill,
                        PSZ        pszFont,
                        ULONG      ulPts,
                        USHORT     usCols);
:exmp.
:font facename=Helv size=16x12.
:p.Builds an internal table definition which is available for re-use until explicitly destroyed 
using :link reftype=hd res=1012.PrtGDestroyTblDef:elink..
:p.:hp2.Return:ehp2.
:p.A handle to a table definition structure wich can then be used to define the columns 
with :link reftype=hd res=1001.PrtGAddColumn:elink. and start printing a table with 
:link reftype=hd res=1033.PrtGStartTable:elink.

:h2 hide res=4092.PrtGDefineTable - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.boxed
:pd.If TRUE the cells will have a box around them
:pt.bHeader
:pd.If TRUE headers are defined for each column
:pt.bAllPages
:pd.If TRUE use running headers i.e. the table header will be printed on each page
:pt.ulLine
:pd.The line thickness around the cells in the table
:pt.ulFill
:pd.The fill style for the cells in the table
:pt.ulHline
:pd.The line thickness around the header cells
:pt.ulHfill
:pd.The fill style for the header cells
:pt.pszFont
:pd.The font used to print the header texts
:pt.ulPts
:pd.The point size for printing the header texts
:pt.usCols
:pd.The number of columns in the table
:eparml.

.***** PrtGDefineFtrColors **********************************************

:h2 res=1051.PrtGDefineFtrColors
:i2 refid=FUNC.PrtGDefineFtrColors
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4100.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4101.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4102.

:h2 hide res=4100.PrtGDefineFtrColors - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4101.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4102.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1007.PrtGDefineFooter:elink.
:li.:link reftype=hd res=1026.PrtGSetFooter:elink.
:eul.

:h2 hide res=4101.PrtGDefineFtrColors - Description
:xmp.
USHORT PrtGDefineFtrColors( :link reftype=hd res=501.HFOOTER:elink.    hftr,
                            LONG       lt_color,
                            LONG       lb_color,
                            LONG       lf_color);
:exmp.
:font facename=Helv size=16x12.
:p.Define the colors used for printing the page footers.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid handle was passed
:eparml.

:h2 hide res=4102.PrtGDefineFtrColors - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hftr
:pd.Handle to a footer definition created with :link reftype=hd res=1007.PrtGDefineFooter:elink.
:pt.lt_color
:pd.Color for printing the text in the footer
:pt.lb_color
:pd.Color for printing the border around the footer
:pt.lf_color
:pd.Color for printing the fill pattern in the footer
:eparml.

.***** PrtGDefineHdrColors **********************************************

:h2 res=1052.PrtGDefineHdrColors
:i2 refid=FUNC.PrtGDefineHdrColors
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4110.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4111.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4112.

:h2 hide res=4110.PrtGDefineHdrColors - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4111.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4112.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:eul.

:h2 hide res=4111.PrtGDefineHdrColors - Description
:xmp.
USHORT PrtGDefineHdrColors( :link reftype=hd res=503.HHEADER:elink.    hhdr,
                            LONG       lt_color,
                            LONG       lb_color,
                            LONG       lf_color);
:exmp.
:font facename=Helv size=16x12.
:p.Define the colors used for printing the page headers.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid handle was passed
:eparml.

:h2 hide res=4112.PrtGDefineHdrColors - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hhdr
:pd.Handle to a header defintion created with :link reftype=hd res=1008.PrtGDefineHeader:elink.
:pt.lt_color
:pd.Color for printing the text in the header
:pt.lb_color
:pd.Color for printing the border around the header
:pt.lf_color
:pd.Color for printing the fill pattern in the header
:eparml.

.***** PrtGDefineTableColors ********************************************

:h2 res=1050.PrtGDefineTableColors
:i2 refid=FUNC.PrtGDefineTableColors
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4120.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4121.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4122.

:h2 hide res=4120.PrtGDefineTableColors - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4121.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4122.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1001.PrtGAddColumn:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:eul.

:h2 hide res=4121.PrtGDefineTableColors - Description
:xmp.
USHORT PrtGDefineTableColors( :link reftype=hd res=504.HTABLE:elink.      htbl,
                              LONG        lct_color,
                              LONG        lcb_color,
                              LONG        lcf_color,
                              LONG        lht_color,
                              LONG        lhb_color,
                              LONG        lhf_color);
:exmp.
:font facename=Helv size=16x12.
:p.Defines the colors for printing a table defined with .
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid handle was passed
:eparml.

:h2 hide res=4122.PrtGDefineTableColors - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.htbl
:pd.Handle to a table definition created with :link reftype=hd res=1009.PrtGDefineTable:elink.
:pt.lct_color
:pd.Color for printing the text in the table cells
:pt.lcb_color
:pd.Color for printing the borders around the table cells
:pt.lcf_color
:pd.Color for printing the fill pattern in the table cells
:pt.lht_color
:pd.Color for printing the text in the table headers
:pt.lhb_color
:pd.Color for printing the borders around the table headers
:pt.lhf_color
:pd.Color for printing the fill pattern in the table headers
:eparml.

.***** PrtGDestroyFtrDef ***************************************************

:h2 res=1010.PrtGDestroyFtrDef
:i2 refid=FUNC.PrtGDestroyFtrDef
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4130.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4131.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4132.

:h2 hide res=4130.PrtGDestroyFtrDef - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4131.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4132.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1007.PrtGDefineFooter:elink.
:eul.

:h2 hide res=4131.PrtGDestroyFtrDef - Description
:xmp.
HFOOTER PrtGDestroyFtrDef( :link reftype=hd res=501.HFOOTER:elink.     hftr);
:exmp.
:font facename=Helv size=16x12.
:p.Destroys the internal structure defining the page footers for a job.
:p.:hp2.Return:ehp2.
:p.NULLHANDLE

:h2 hide res=4132.PrtGDestroyFtrDef - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hftr
:pd.Handle to a footer definition created with :link reftype=hd res=1007.PrtGDefineFooter:elink.
:eparml.

.***** PrtGDestroyHdrDef ***************************************************

:h2 res=1011.PrtGDestroyHdrDef
:i2 refid=FUNC.PrtGDestroyHdrDef
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4140.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4141.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4142.

:h2 hide res=4140.PrtGDestroyHdrDef - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4141.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4142.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:eul.

:h2 hide res=4141.PrtGDestroyHdrDef - Description
:xmp.
HHEADER PrtGDestroyHdrDef( :link reftype=hd res=503.HHEADER:elink.     hhdr);
:exmp.
:font facename=Helv size=16x12.
:p.Destroys the internal structure defining the page headers for a job.
:p.:hp2.Return:ehp2.
:p.NULLHANDLE

:h2 hide res=4142.PrtGDestroyHdrDef - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hhdr
:pd.Handle to a header defintion created with :link reftype=hd res=1008.PrtGDefineHeader:elink.
:eparml.

.***** PrtGDestroyTblDef ***************************************************

:h2 res=1012.PrtGDestroyTblDef
:i2 refid=FUNC.PrtGDestroyTblDef
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4150.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4151.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4152.

:h2 hide res=4150.PrtGDestroyTblDef - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4151.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4152.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1001.PrtGAddColumn:elink.
:eul.

:h2 hide res=4151.PrtGDestroyTblDef - Description
:xmp.
HTABLE PrtGDestroyTblDef( :link reftype=hd res=504.HTABLE:elink.       htbl);
:exmp.
:font facename=Helv size=16x12.
:p.Destroys the internal structure defining a table with its columns.
:p.:hp2.Return:ehp2.
:p.NULLHANDLE

:h2 hide res=4152.PrtGDestroyTblDef - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.htbl
:pd.Handle to a table definition created with :link reftype=hd res=1009.PrtGDefineTable:elink.
:eparml.

.***** PrtGEndRow **********************************************************

:h2 res=1013.PrtGEndRow
:i2 refid=FUNC.PrtGEndRow
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4160.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4161.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4162.

:h2 hide res=4160.PrtGEndRow - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4161.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4162.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1032.PrtGStartRow:elink.
:li.:link reftype=hd res=1031.PrtGStartCol:elink.
:li.:link reftype=hd res=1014.PrtGEndTable:elink.
:eul.

:h2 hide res=4161.PrtGEndRow - Description
:xmp.
USHORT PrtGEndRow( :link reftype=hd res=502.HGRPRT:elink.      hp);
:exmp.
:font facename=Helv size=16x12.
:p.Draws all the cells from the current row and prints all the texts that have been written to the 
columns since the previous call to :link reftype=hd res=1032.PrtGStartRow:elink.. 
if any of the cells is longer than the available space on the page, it will be wrapped over to 
the next page and if running table headers are defined they will be printed.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_NOT_TABLE
:pd.No table has been started
:eparml.

:h2 hide res=4162.PrtGEndRow - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:eparml.

.***** PrtGEndTable ********************************************************

:h2 res=1014.PrtGEndTable
:i2 refid=FUNC.PrtGEndTable
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4170.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4171.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4172.

:h2 hide res=4170.PrtGEndTable - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4171.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4172.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1013.PrtGEndRow:elink.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:eul.

:h2 hide res=4171.PrtGEndTable - Description
:xmp.
USHORT PrtGEndTable( :link reftype=hd res=502.HGRPRT:elink.    hp);
:exmp.
:font facename=Helv size=16x12.
:p.Ends printing to a table. Before calling this function, ensure that you have printed the 
last row with a call to :link reftype=hd res=1013.PrtGEndRow:elink.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_NOT_TABLE
:pd.No table has been started
:eparml.

:h2 hide res=4172.PrtGEndTable - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:eparml.

.***** PrtGFontDlg *********************************************************

:h2 res=1015.PrtGFontDialog
:i2 refid=FUNC.PrtGFontDialog
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4180.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4181.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4182.

:h2 hide res=4180.PrtGFontDialog - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4181.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4182.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:eul.

:h2 hide res=4181.PrtGFontDialog - Description
:xmp.
PSZ PrtGFontDlg( :link reftype=hd res=502.HGRPRT:elink.    hp,
                 PSZ       pszTitle,
                 PSZ       pszOldFace);
:exmp.
:font facename=Helv size=16x12.
:p.Calls the system font dialog with the fonts for the selected printer. If no printer has 
been explicitly defined, the default system printer will be used.
:p.:hp2.Return:ehp2.
:p.The name of the chosen font or a NULL string if the Cancel button was pressed.
:note.
It is the responsibility of the calling process to check the validity of the returned 
pointer and to free it when no longer needed.
:p.
:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\fontdlg.bmp' align=left.
:p.:hp2.Figure&colon. Font Dialog.:ehp2.

:h2 hide res=4182.PrtGFontDialog - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.pszTitle
:pd.The title to appear in the dialog.
:pt.pszOldFace
:pd.The default font family name.
:eparml.

.****** PrtGGet ********************************************************

:h2 res=4399.PrtGGet
:i2 refid=FUNC.PrtGGet
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4400.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4401.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4402.

:h2 hide res=4400.PrtGGet - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4401.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4402.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.
:eul.

:h2 hide res=4401.PrtGGet - Description
:xmp.
PROP_TYPE PrtGGet( :link reftype=hd res=502.HGRPRT:elink.    hp,
                   USHORT     prop,
                   PUSHORT    perror);
:exmp.
:font facename=Helv size=16x12.
:p.Retrieves the value of the given :link reftype=hd res=3000.Property:elink..
:p.:hp2.Return:ehp2.
:p.A string pointer, an unsigned long or a boolean depending on the property.
:p.It also returns an error code in the variable pointed to by perror&colon.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_READONLY
:pd.The property is a read onlz property
:pt.PRTGR_ERR_INV_PROP
:pd.The prop parameter is out of range
:pt.PRTGR_ERR_INV_VALUE
:pd.The value parameter is invalid
:eparml.

:h2 hide res=4402.PrtGGet - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.prop
:pd.One of the :link reftype=hd res=1108.Printer Properties:elink. constants
:pt.perror
:pd.Variable that will contain any error code when the function returns
:eparml.

.***** PrtGGoto ************************************************************

:h2 res=1017.PrtGGoto
:i2 refid=FUNC.PrtGGoto
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4190.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4191.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4192.

:h2 hide res=4190.PrtGGoto - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4191.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4192.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.None
:eul.

:h2 hide res=4191.PrtGGoto - Description
:xmp.
USHORT PrtGGoto( :link reftype=hd res=502.HGRPRT:elink.    hp,
                 ULONG     ulx,
                 ULONG     uly,
                 BOOL      points);
:exmp.
:font facename=Helv size=16x12.
:p.Moves the Gpi cursor to the given position.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4192.PrtGGoto - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.ulx
:pd.x coordinate in mm from left margin
:pt.uly
:pd.y coordinate from the bottom margin
:pt.points
:pd.If TRUE the measures are points otherwise they are mm or 1/10 inch
:eparml.

.***** PrtGInit ************************************************************

:h2 res=1018.PrtGInit
:i2 refid=FUNC.PrtGInit
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4200.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4201.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4202.

:h2 hide res=4200.PrtGInit - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4201.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4202.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1035.PrtGTerm:elink.
:eul.

:h2 hide res=4201.PrtGInit - Description
:xmp.
:link reftype=hd res=502.HGRPRT:elink. PrtGInit( :link reftype=hd res=510.PFNNP:elink.    pnp_func);
:exmp.
:font facename=Helv size=16x12.
:p.Initialises the internal structures needed to handle print jobs and returns a handle which 
is required by all other printing functions.
:p.:hp2.Return:ehp2.
:p.Handle to the printing environment.

:h2 hide res=4202.PrtGInit - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.pnp_func
:pd.Pointer to the new page hook function
:eparml.

.***** PrtGJobProps ********************************************************

:h2 res=1019.PrtGJobProperties
:i2 refid=FUNC.PrtGJobProperties
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4210.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4211.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4212.

:h2 hide res=4210.PrtGJobProperties - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4211.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4212.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:li.:link reftype=hd res=1025.PrtGPrinterList:elink.
:li.:link reftype=hd res=1030.PrtGSetPrinter:elink.
:eul.

:h2 hide res=4211.PrtGJobProperties - Description
:xmp.
USHORT PrtGJobProps( :link reftype=hd res=502.HGRPRT:elink.    hp,
                     HWND      hwndParent);
:exmp.
:font facename=Helv size=16x12.
:p.Shows the job properties dialog for the current printer.
:warning.
:hp2.This functions requires the presence of a PM Queue:ehp2..
:ewarning.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.
:p.:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\jobprops.bmp' align=left.
:p.:hp2.Figure&colon. Printer Job Properties Dialog for a Laserjet IIIP.:ehp2.

:h2 hide res=4212.PrtGJobProperties - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.hwndParent
:pd.Handle to the parent window (calling window)
:eparml.

.***** PrtGNewPage *********************************************************

:h2 res=1022.PrtGNewPage
:i2 refid=FUNC.PrtGNewPage
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4240.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4241.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4242.

:h2 hide res=4240.PrtGNewPage - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4241.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4242.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.None
:eul.

:h2 hide res=4241.PrtGNewPage - Description
:xmp.
USHORT PrtGNewPage( :link reftype=hd res=502.HGRPRT:elink. hp);
:exmp.
:font facename=Helv size=16x12.
:p.Forces a new page to be started. If a header or footer is defined, these will be printed to 
the new page. If a table is being printed and the table has running headers defined, the column 
headers will be printed.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4242.PrtGNewPage - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:eparml.

.***** PrtGOpenPrintJob ****************************************************

:h2 res=1023.PrtGOpenPrintJob
:i2 refid=FUNC.PrtGOpenPrintJob
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4250.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4251.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4252.

:h2 hide res=4250.PrtGOpenPrintJob - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4251.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4252.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1026.PrtGSetFooter:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:li.:link reftype=hd res=1029.PrtGSetMargins:elink.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:li.:link reftype=hd res=1028.PrtGSetLineSpace:elink.
:eul.

:h2 hide res=4251.PrtGOpenPrintJob - Description
:xmp.
USHORT PrtGOpenPrintJob( :link reftype=hd res=502.HGRPRT:elink.    hp,
                         PSZ       pszTitle,
                         USHORT    usPages);
:exmp.
:font facename=Helv size=16x12.
:p.Opens a new print job with the defined header, footer and printer.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_NO_PRINTER
:pd.There are no printers available to the work-station.
:pt.PRTGR_ERR_JOB_OPEN
:pd.failed to greate the print job (Error in Gpi or Dev call)
:eparml.

:h2 hide res=4252.PrtGOpenPrintJob - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.pszTitle
:pd.The Document name which will appear in the spooler
:pt.usPages
:pd.The total number of pages to print.
:eparml.

.***** PrtGBitMap **********************************************************

:h2 res=1003.PrtGPrintBitmap
:i2 refid=FUNC.PrtGPrintBitmap
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4030.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4031.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4032.

:h2 hide res=4030.PrtGPrintBitmap - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4031.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4032.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:eul.

:h2 hide res=4031.PrtGPrintBitmap - Description
:xmp.
USHORT PrtGPrintBitmap( :link reftype=hd res=502.HGRPRT:elink.     hp,
                        PSZ        pszFName,
                        ULONG      ulLeft,
                        ULONG      ulBottom,
                        ULONG      ulRight,
                        ULONG      ulTop,
                        ULONG      ulLine,
                        LONG       lcborder);
:exmp.
:font facename=Helv size=16x12.
:p.Opens a bitmap file (Win or OS/2) and prints it in the defined box with a frame ulLine
TWIPS thick.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_INV_BITMAP
:pd.The file contained an invalid bitmap
:pt.PRTGR_ERR_INV_FILENAME
:pd.There was an I/O error opening the bitmap file or the file does not exist.
:eparml.


:h2 hide res=4032.PrtGPrintBitmap - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink.
:pt.pszFName
:pd.Name of the file to print.
:pt.ulLeft
:pd.Left edge of the box to contain the bitmap in mm from the left margin
:pt.ulBottom
:pd.Bottom edge of the box to contain the bitmap in mm from the bottom margin
:pt.ulRight
:pd.Right edge of the box to contain the bitmap in mm from the left margin
:pt.ulTop
:pd.Top edge of the box to contain the bitmap in mm from the bottom margin
:pt.ulLine
:pd.Thickness of a frame to draw around the bitmap (TWIPS)
:pt.lcborder
:pd.Color for the border drawn around the bitmap
:eparml.

.***** PrtGBox *************************************************************

:h2 res=1004.PrtGPrintBox
:i2 refid=FUNC.PrtGPrintBox
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4040.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4041.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4042.

:h2 hide res=4040.PrtGPrintBox - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4041.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4042.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1003.PrtGPrintBitmap:elink.
:eul.

:h2 hide res=4041.PrtGPrintBox - Description
:xmp.
USHORT PrtGPrintBox( :link reftype=hd res=502.HGRPRT:elink.    hp,
                     ULONG     ulLeft,
                     ULONG     ulBottom,
                     ULONG     ulRight,
                     ULONG     ulTop,
                     ULONG     ulLine,
                     ULONG     ulFill,
                     LONG      lcborder,
                     LONG      lcfill);
:exmp.
:font facename=Helv size=16x12.
:p.Draws a box with the defined line thickness and fill style at the given coordinates.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4042.PrtGPrintBox - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink.
:pt.pszFName
:pd.Name of the file to print.
:pt.ulLeft
:pd.Left edge of the box in mm from the left margin
:pt.ulBottom
:pd.Bottom edge of the box in mm from the bottom margin
:pt.ulRight
:pd.Right edge of the box in mm from the left margin
:pt.ulTop
:pd.Top edge of the box in mm from the bottom margin
:pt.ulLine
:pd.Thickness of a frame to draw around the box (TWIPS)
:pt.ulFill
:pd.Fill style of the box
:pt.lcborder
:pd.Colour for the line around the box
:pt.lcfill
:pd.Colour for the fill pattern of the box
:eparml.

.***** PrtGPrinterDlg ******************************************************

:h2 res=1024.PrtGPrinterDialog
:i2 refid=FUNC.PrtGPrinterDialog
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4260.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4261.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4262.

:h2 hide res=4260.PrtGPrinterDialog - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4261.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4262.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1030.PrtGSetPrinter:elink.
:li.:link reftype=hd res=1025.PrtGPrinterList:elink.
:li.:link reftype=hd res=1019.PrtGJobProperties:elink.
:eul.

:h2 hide res=4261.PrtGPrinterDialog - Description
:xmp.
PSZ PrtGPrinterDlg( :link reftype=hd res=502.HGRPRT:elink.     hp,
                    HWND       hwndParent,
                    PSZ        pszTitle);
:exmp.
:font facename=Helv size=16x12.
:p.Shows a dialog with a list of the available printers for the work-station. The default printer 
will be highlighted. You can set the job properties for any of the printers in the list.
:p.:hp2.Return:ehp2.
:p.Name of the printer chosen or an empty string if the cancel button is pressed.
:warning.
Do not free this pointer as it points to a field in an internal structure.
:ewarning.
:artwork name='w:\addtools\tools\prtgraph\code\bitmaps\prtdlg.bmp' align=left.
:p.:hp2.Figure&colon. Printer Dialog.:ehp2.

:h2 hide res=4262.PrtGPrinterDialog - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.hwndParent
:pd.Handle to the parent window (calling window)
:pt.pszTitle
:pd.The title for the dialog. If this is a NULL pointer then "Choose Printer" will be displayed in the title bar.
:eparml.

.***** PrtGPrinterList *****************************************************

:h2 res=1025.PrtGPrinterList
:i2 refid=FUNC.PrtGPrinterList
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4270.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4271.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4272.

:h2 hide res=4270.PrtGPrinterList - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4271.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4272.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:li.:link reftype=hd res=1030.PrtGSetPrinter:elink.
:eul.

:h2 hide res=4271.PrtGPrinterList - Description
:xmp.
PSZ *PrtGPrinterList( :link reftype=hd res=502.HGRPRT:elink.   hp,
                      BOOL     bRefresh,
                      PUSHORT  pusCount);
:exmp.
:font facename=Helv size=16x12.
:p.Returns a list of the available printers. No printer is selected by this function&colon. if you want to use a printer other than the default, you must use :link reftype=hd res=1030.PrtGSetPrinter:elink..
:p.:hp2.Return:ehp2.
:p.Pointer to an array :hp2.*pusCount:ehp2. long of strings.
:warning.
It is the responsibility of the calling program to free this array.
:ewarning.

:h2 hide res=4272.PrtGPrinterList - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.bRefresh
:pd.If this is set to TRUE the internal list of printers will be refreshed, otherwise the list shown will the one read with :link reftype=hd res=1018.PrtGInit:elink. or the last call to the function
:pt.pusCount
:pd.Pointer to a USHORT that will hold the number of printers found.
:eparml.

.***** PrtGCentre **********************************************************

:h2 res=1005.PrtGPrintCentered
:i2 refid=FUNC.PrtGPrintCentered
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4050.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4051.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4052.

:h2 hide res=4050.PrtGPrintCentered - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4051.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4052.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink.
:eul.

:h2 hide res=4051.PrtGPrintCentered - Description
:xmp.
USHORT PrtGPrintCentered( :link reftype=hd res=502.HGRPRT:elink.     hp,
                          PSZ        pszFont,
                          ULONG      ulPts,
                          PSZ        pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Prints the text centered between the margins. If the text is too long to fit on one line, 
it will be wrapped over several lines. If you are within a table, the text will be written to 
the current column defined by :link reftype=hd res=1031.PrtGStartCol:elink..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_PARAMETER
:pd.pstString is a NULL pointer
:eparml.


:h2 hide res=4052.PrtGPrintCentered - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink..
:pt.pszFont
:pd.Name of the font to use for printing the text. if this is an empty ("") string or a NULL Pointer, the current font is used.
:pt.ulPts
:pd.The point size of the font to use. If this value is 0, the current point size is is used.
:pt.pszString
:pd.The string to print.
:eparml.

.***** PrtGPrintFile *******************************************************

:h2 res=4419.PrtGPrintFile
:i2 refid=FUNC.PrtGPrintFile
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4240.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4421.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4422.

:h2 hide res=4420.PrtGPrintFile - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4421.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4422.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink.
:eul.

:h2 hide res=4421.PrtGPrintFile - Description
:xmp.
USHORT PrtGPrintFile( :link reftype=hd res=502.HGRPRT:elink.     hp,
                      PSZ        pszFont,
                      ULONG      ulPts,
                      USHORT     usStyle
                      PSZ        pszFile);
:exmp.
:font facename=Helv size=16x12.
:p.Prints the text contained in the file in the specified style. If the text is too long to 
fit on one line, it will be wrapped over several lines.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_PARAMETER
:pd.pszFile is a NULL pointer
:pt.PRTGR_ERR_INV_FILENAME
:pd.pszFile does not exist
:eparml.

:h2 hide res=4422.PrtGPrintFile - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink..
:pt.pszFont
:pd.Name of the font to use for printing the text. if this is an empty ("") string or a NULL Pointer, the current font is used.
:pt.ulPts
:pd.The point size of the font to use. If this value is 0, the current point size is is used.
:pt.usStyle
:pd.One of the :link reftype=hd res=1107.Print Styles for Files:elink. constants
:pt.pszFile
:pd.Name of the file to print.
:eparml.

.***** PrtGJustified *******************************************************

:h2 res=1020.PrtGPrintJustified
:i2 refid=FUNC.PrtGPrintJustified
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4220.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4221.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4222.

:h2 hide res=4220.PrtGPrintJustified - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4221.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4222.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink.
:eul.

:h2 hide res=4221.PrtGPrintJustified - Description
:xmp.
USHORT PrtGJustified( :link reftype=hd res=502.HGRPRT:elink.      hp,
                      PSZ         pszFont,
                      ULONG       ulPts,
                      PSZ         pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Prints the text in the requested font and point size justified between the left and right margins. If the text is 
too long to fit on one line, it will be wrapped over several lines. If you are within a table, 
the text will be written to the current column defined by :link reftype=hd res=1031.PrtGStartCol:elink..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_PARAMETER
:pd.pstString is a NULL pointer
:eparml.

:h2 hide res=4222.PrtGPrintJustified - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink..
:pt.pszFont
:pd.Name of the font to use for printing the text. if this is an empty ("") string or a NULL Pointer, the current font is used.
:pt.ulPts
:pd.The point size of the font to use. If this value is 0, the current point size is is used.
:pt.pszString
:pd.The string to print.
:eparml.

.***** PrtGWrite ***********************************************************

:h2 res=1037.PrtGPrintLeft
:i2 refid=FUNC.PrtGPrintLeft
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4410.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4411.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4412.

:h2 hide res=4410.PrtGPrintLeft - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4411.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4412.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink.
:eul.

:h2 hide res=4411.PrtGPrintLeft - Description
:xmp.
USHORT PrtGPrintLeft( :link reftype=hd res=502.HGRPRT:elink.     hp,
                      PSZ        pszFont,
                      ULONG      ulPts,
                      PSZ        pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Write the text in the specified font and point size justified left. If the text is too long 
to fit on one line, it will be wrapped over several lines. If you are within a table, the text 
will be written to the current column defined by :link reftype=hd res=1031.PrtGStartCol:elink..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_PARAMETER
:pd.pstString is a NULL pointer
:eparml.

:h2 hide res=4412.PrtGPrintLeft - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink..
:pt.pszFont
:pd.Name of the font to use for printing the text. if this is an empty ("") string or a NULL Pointer, the current font is used.
:pt.ulPts
:pd.The point size of the font to use. If this value is 0, the current point size is is used.
:pt.pszString
:pd.The string to print.
:eparml.

.***** PrtGWriteln *********************************************************

:h2 res=1038.PrtGPrintLine
:i2 refid=FUNC.PrtGPrintLine
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4430.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4431.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4432.

:h2 hide res=4430.PrtGPrintLine - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4431.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4432.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1021.PrtGPrintRight:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink.
:eul.

:h2 hide res=4431.PrtGPrintLine - Description
:xmp.
USHORT PrtGPrintLine( :link reftype=hd res=502.HGRPRT:elink.     hp,
                      PSZ        pszFont,
                      ULONG      ulPts,
                      PSZ        pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Write the text in the specified font and point size justified left followed by linefeed and 
carriage return. If the text is too long to fit on one line, it will be wrapped over several lines. 
If you are within a table, the text will be written to the current column defined by :link 
reftype=hd res=1031.PrtGStartCol:elink..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_PARAMETER
:pd.pstString is a NULL pointer
:eparml.

:h2 hide res=4432.PrtGPrintLine - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink..
:pt.pszFont
:pd.Name of the font to use for printing the text. if this is an empty ("") string or a NULL Pointer, the current font is used.
:pt.ulPts
:pd.The point size of the font to use. If this value is 0, the current point size is is used.
:pt.pszString
:pd.The string to print.
:eparml.

.***** PrtGJustRight *******************************************************

:h2 res=1021.PrtGPrintRight
:i2 refid=FUNC.PrtGPrintRight
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4230.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4231.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4232.

:h2 hide res=4230.PrtGPrintRight - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4231.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4232.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1005.PrtGPrintCentered:elink.
:li.:link reftype=hd res=1020.PrtGPrintJustified:elink.
:li.:link reftype=hd res=1037.PrtGPrintLeft:elink.
:li.:link reftype=hd res=1038.PrtGPrintLine:elink.
:li.:link reftype=hd res=1015.PrtGFontDialog:elink.
:eul.

:h2 hide res=4231.PrtGPrintRight - Description
:xmp.
USHORT PrtGJustRight( :link reftype=hd res=502.HGRPRT:elink.      hp,
                      PSZ         pszFont,
                      ULONG       ulPts,
                      PSZ         pszString);
:exmp.
:font facename=Helv size=16x12.
:p.Prints the text right justified to the right margin in the specified font and font size. If the 
text is too long to fit on one line, it will be wrapped over several lines. If you are within a 
table, the text will be written to the current column defined by :link reftype=hd 
res=1031.PrtGStartCol:elink..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_PARAMETER
:pd.pstString is a NULL pointer
:eparml.

:h2 hide res=4232.PrtGPrintRight - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink..
:pt.pszFont
:pd.Name of the font to use for printing the text. if this is an empty ("") string or a NULL Pointer, the current font is used.
:pt.ulPts
:pd.The point size of the font to use. If this value is 0, the current point size is is used.
:pt.pszString
:pd.The string to print.
:eparml.

.***** PrtGResetColHeader ***********************************************

:h2 res=1055.PrtGResetColHeader
:i2 refid=FUNC.PrtGResetColHeader
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4280.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4281.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4282.

:h2 hide res=4280.PrtGResetColHeader - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4281.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4282.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1001.PrtGAddColumn:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:eul.

:h2 hide res=4281.PrtGResetColHeader - Description
:xmp.
USHORT PrtGResetColHeader( :link reftype=hd res=502.HGRPRT:elink.   hp,
                           USHORT   usCol,
                           PSZ      pszText)
:exmp.
:font facename=Helv size=16x12.
:p.Changes the header text for a column in a table that is printing. This function can be used 
to modify the the running header text for a table while it is printing. 
:note. 
the original text declared with :link reftype=hd res=1009.PrtGDefineTable:elink. and :link reftype=hd res=1001.PrtGAddColumn:elink. will always be printed when :link reftype=hd res=1033.PrtGStartTable:elink. is called.
:warning.
:p.:hp2.This function will return an error if called before :link reftype=hd res=1033.PrtGStartTable:elink.:ehp2.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_NOT_TABLE
:pd.No table has been started with :link reftype=hd res=1033.PrtGStartTable:elink.
:pt.PRTGR_ERR_PARAMETER
:pd.usCol is out of range i.e. greater than the number of declared columns or less than 1
:eparml.

:h2 hide res=4282.PrtGResetColHeader - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.usCol
:pd.Column number whose header text is to be changed (1..n)
:pt.pszText
:pd.New column header text
:eparml.

.****** PrtGSet ********************************************************

:h2 res=4409.PrtGSet
:i2 refid=FUNC.PrtGSet
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4440.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4441.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4442.

:h2 hide res=4440.PrtGSet - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4441.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4442.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.
:eul.

:h2 hide res=4441.PrtGSet - Description
:xmp.
USHORT PrtGSet( :link reftype=hd res=502.HGRPRT:elink.    hp,
                USHORT     prop,
                PROP_TYPE  value);
:exmp.
:font facename=Helv size=16x12.
:p.Retrieves the value of the given :link reftype=hd res=3000.Property:elink..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_READONLY
:pd.The property is a read onlz property
:pt.PRTGR_ERR_INV_PROP
:pd.The prop parameter is out of range
:pt.PRTGR_ERR_INV_VALUE
:pd.The value parameter is invalid
:eparml.

:h2 hide res=4442.PrtGSet - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.prop
:pd.One of the :link reftype=hd res=1108.Printer Properties:elink. constants
:pt.value
:pd.The new value to set
:eparml.

.***** PrtGSetDlgButtonTexts ********************************************

:h2 res=1105.PrtGSetDlgButtonTexts
:i2 refid=FUNC.PrtGSetDlgButtonTexts
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4290.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4291.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4292.

:h2 hide res=4290.PrtGSetDlgButtonTexts - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4291.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4292.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:eul.

:h2 hide res=4291.PrtGSetDlgButtonTexts - Description
:xmp.
USHORT PrtGSetDlgButtonTexts( :link reftype=hd res=502.HGRPRT:elink.   hp,
                              PSZ      pszBut1, 
                              PSZ      pszBut2, 
                              PSZ      pszBut3);
:exmp.
:font facename=Helv size=16x12.
:p.Change the texts for the buttons on the printer dialog. If any of the parameters is NULL, 
the button remains unchanged.
:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4292.PrtGSetDlgButtonTexts - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.pszBut1
:pd.New text for the :hp2.OK:ehp2. button
:pt.pszBut2
:pd.New text for the :hp2.Job properties...:ehp2. button
:pt.pszBut3
:pd.New text for the :hp2.Cancel:ehp2. button
:eparml.

.***** PrtGSetFooter *******************************************************

:h2 res=1026.PrtGSetFooter
:i2 refid=FUNC.PrtGSetFooter
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4300.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4301.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4302.

:h2 hide res=4300.PrtGSetFooter - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4301.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4302.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1007.PrtGDefineFooter:elink.
:li.:link reftype=hd res=1010.PrtGDestroyFtrDef:elink.
:eul.

:h2 hide res=4301.PrtGSetFooter - Description
:xmp.
USHORT PrtGSetFooter( :link reftype=hd res=502.HGRPRT:elink.   hp,
                      :link reftype=hd res=501.HFOOTER:elink.  hftr);
:exmp.
:font facename=Helv size=16x12.
:p.Sets the footer for the current job from the definition in :hp2.hftr:ehp2.. After this call, you can destroy the footer definition with :link reftype=hd res=1010.PrtGDestroyFtrDef:elink.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4302.PrtGSetFooter - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.hftr
:pd.Handle to a footer definition created with :link reftype=hd res=1007.PrtGDefineFooter:elink.
:eparml.

.***** PrtGSetHeader *******************************************************

:h2 res=1027.PrtGSetHeader
:i2 refid=FUNC.PrtGSetHeader
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4310.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4311.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4312.

:h2 hide res=4310.PrtGSetHeader - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4311.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4312.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:li.:link reftype=hd res=1011.PrtGDestroyHdrDef:elink.
:eul.

:h2 hide res=4311.PrtGSetHeader - Description
:xmp.
USHORT PrtGSetHeader( :link reftype=hd res=502.HGRPRT:elink.       hp,
                      :link reftype=hd res=503.HHEADER:elink.      hhdr);
:exmp.
:font facename=Helv size=16x12.
:p.Sets the page headers for the current job using the definition :hp2.hhdr:ehp2.. After this call you can destroy the header defintion with :link reftype=hd res=1011.PrtGDestroyHdrDef:elink.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4312.PrtGSetHeader - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.hhdr
:pd.Handle to a header definition created with :link reftype=hd res=1008.PrtGDefineHeader:elink. and :link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:eparml.

.***** PrtGSetHdrLineFont  ************************************************

:h2 res=1053.PrtGSetHdrLineFont
:i2 refid=FUNC.PrtGSetHdrLineFont
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4320.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4321.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4322.

:h2 hide res=4320.PrtGSetHdrLineFont - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4321.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4322.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1008.PrtGDefineHeader:elink.
:li.:link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:li.:link reftype=hd res=1011.PrtGDestroyHdrDef:elink.
:eul.

:h2 hide res=4321.PrtGSetHdrLineFont - Description
:xmp.
USHORT PrtGSetHdrLineFont( :link reftype=hd res=503.HHEADER:elink.     hhdr,
                           USHORT      usLine,
                           PSZ         pszFont,
                           ULONG       ulPoints);
:exmp.
:font facename=Helv size=16x12.
:p.Changes the font and/or point size for one line in the header.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid handle was passed.
:eparml.

:h2 hide res=4322.PrtGSetHdrLineFont - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hhdr
:pd.Handle to a header definition created with :link reftype=hd res=1008.PrtGDefineHeader:elink. and :link reftype=hd res=1002.PrtGAddHeaderLine:elink.
:pt.usLine
:pd.The line number (1..5)
:pt.pszFont
:pd.The new font name, if NULL the original font is used
:pt.ulPoints
:pd.The new point size to use. If 0 then the original pointsize is used
:eparml.

.***** PrtGSetMargins ******************************************************

:h2 res=1029.PrtGSetMargins
:i2 refid=FUNC.PrtGSetMargins
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4330.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4331.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4332.

:h2 hide res=4330.PrtGSetMargins - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4331.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4332.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1054.PrtGSetPrintColors:elink.
:li.:link reftype=hd res=1026.PrtGSetFooter:elink.
:li.:link reftype=hd res=1027.PrtGSetHeader:elink.
:li.:link reftype=hd res=1023.PrtGOpenPrintJob:elink.
:eul.

:h2 hide res=4331.PrtGSetMargins - Description
:xmp.
USHORT PrtGSetMargins( :link reftype=hd res=502.HGRPRT:elink.      hp,
                       ULONG       ulLeft,
                       ULONG       ulRight,
                       ULONG       ulTop,
                       ULONG       ulBottom,
                       ULONG       ulBorder,
                       ULONG       ulFill);
:exmp.
:font facename=Helv size=16x12.
:p.Defines the printing margins for the job, whether there is a border and how thick and whether the page has a background fill.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4332.PrtGSetMargins - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.ulLeft
:pd.Distance of left margin from the left edge of the page in mm
:pt.ulRight
:pd.Distance of right margin from the right edge of the page in mm
:pt.ulTop
:pd.Distance of top margin from the top edge of the page in mm
:pt.ulBottom
:pd.Distance of bottom margin from the bottom edge of the page in mm
:pt.ulBorder
:pd.Thickness (in TWIPS) of a border drawn just outside the margins
:pt.ulFill
:pd.Fill style for the page.
:eparml.

.***** PrtGSetPrintColors **********************************************

:h2 res=1054.PrtGSetPrintColors
:i2 refid=FUNC.PrtGSetPrintColors
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4340.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4341.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4342.

:h2 hide res=4340.PrtGSetPrintColors - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4341.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4342.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1051.PrtGDefineFtrColors:elink.
:li.:link reftype=hd res=1052.PrtGDefineHdrColors:elink.
:li.:link reftype=hd res=1029.PrtGSetMargins:elink.
:eul.

:h2 hide res=4341.PrtGSetPrintColors - Description
:xmp.
USHORT PrtGSetPrintColors( :link reftype=hd res=502.HGRPRT:elink.      hp,
                           LONG       lt_color,
                           LONG       lb_color,
                           LONG       lf_color);
:exmp.
:font facename=Helv size=16x12.
:p.Define the colors used for printing.
:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.An invalid handle was passed
:eparml.

:h2 hide res=4342.PrtGSetPrintColors - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.lt_color
:pd.Default color for printing
:pt.lb_color
:pd.Color for printing the border around pages
:pt.lf_color
:pd.Color for printing the fill pattern in pages
:eparml.

.***** PrtGSetPrinter ******************************************************

:h2 res=1030.PrtGSetPrinter
:i2 refid=FUNC.PrtGSetPrinter
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4350.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4351.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4352.

:h2 hide res=4350.PrtGSetPrinter - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4351.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4352.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1025.PrtGPrinterList:elink.
:li.:link reftype=hd res=1024.PrtGPrinterDialog:elink.
:eul.

:h2 hide res=4351.PrtGSetPrinter - Description
:xmp.
USHORT PrtGSetPrinter( :link reftype=hd res=502.HGRPRT:elink.      hp,
                       USHORT      usIdx);
:exmp.
:font facename=Helv size=16x12.
:p.Allows you to select a printer without calling :link reftype=hd res=1024.PrtGPrinterDlg:elink.. Along with :link reftype=hd res=1025.PrtGPrinterList:elink., this function can be used to create yur own printer selection dialog.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4352.PrtGSetPrinter - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.usIdx
:pd.Real world index (1 to n) to the array of printers returned by :link reftype=hd res=1025.PrtGPrinterList:elink.. An index of 0 will select the default system printer.
:eparml.

.***** PrtGStartCol ********************************************************

:h2 res=1031.PrtGStartCol
:i2 refid=FUNC.PrtGStartCol
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4360.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4361.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4362.

:h2 hide res=4360.PrtGStartCol - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4361.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4362.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1032.PrtGStartRow:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:li.:link reftype=hd res=1013.PrtGEndRow:elink.
:eul.

:h2 hide res=4361.PrtGStartCol - Description
:xmp.
USHORT PrtGStartCol( :link reftype=hd res=502.HGRPRT:elink.    hp,
                     USHORT    usCol);
:exmp.
:font facename=Helv size=16x12.
:p.Start sending all following print commands to the specified column in the current table.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:pt.PRTGR_ERR_NOT_TABLE
:pd.No table has been started with :link reftype=hd res=1033.PrtGStartTable:elink.
:pt.PRTGR_ERR_PARAMETER
:pd.Column number is either 0 or greater than the number of columns declared for the table
:eparml.

:h2 hide res=4362.PrtGStartCol - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.usCol
:pd.Column number to start (1 based)
:eparml.

.***** PrtGStartRow ********************************************************

:h2 res=1032.PrtGStartRow
:i2 refid=FUNC.PrtGStartRow
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4370.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4371.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4372.

:h2 hide res=4370.PrtGStartRow - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4371.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4372.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1013.PrtGEndRow:elink.
:li.:link reftype=hd res=1031.PrtGStartCol:elink.
:li.:link reftype=hd res=1033.PrtGStartTable:elink.
:eul.

:h2 hide res=4371.PrtGStartRow - Description
:xmp.
USHORT PrtGStartRow( :link reftype=hd res=502.HGRPRT:elink.    hp);
:exmp.
:font facename=Helv size=16x12.
:p.Start printing a new row in the table. This function clears internal flags on the columns. Failure to call this function can cause unexpected results.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4372.PrtGStartRow - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:eparml.

.***** PrtGStartTable ******************************************************

:h2 res=1033.PrtGStartTable
:i2 refid=FUNC.PrtGStartTable
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4380.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4381.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4382.

:h2 hide res=4380.PrtGStartTable - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4381.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4382.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1009.PrtGDefineTable:elink.
:li.:link reftype=hd res=1001.PrtGAddColumn:elink.
:li.:link reftype=hd res=1032.PrtGStartRow:elink.
:li.:link reftype=hd res=1031.PrtGStartCol:elink.
:li.:link reftype=hd res=1013.PrtGEndRow:elink.
:li.:link reftype=hd res=1014.PrtGEndTable:elink.
:li.:link reftype=hd res=1055.PrtGResetColHeader:elink.
:eul.

:h2 hide res=4381.PrtGStartTable - Description
:xmp.
USHORT PrtGStartTable( :link reftype=hd res=502.HGRPRT:elink.      hp,
                       :link reftype=hd res=504.HTABLE:elink.      htbl);
:exmp.
:font facename=Helv size=16x12.
:p.Start printing the table defined by :hp2.htbl:ehp2..
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised or the table handle is invalid
:pt.PRTGR_ERR_PARAMETER
:pd.The number of columns defines to the table definition in :link reftype=hd res=1009.PrtGDefineTable:elink. is out of range
:eparml.

:h2 hide res=4382.PrtGStartTable - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.htbl
:pd.Handle to a table definition made with :link reftype=hd res=1009.PrtGDefineTable:elink.
:eparml.

.***** PrtGTab *************************************************************

:h2 res=1034.PrtGTab
:i2 refid=FUNC.PrtGTab
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4390.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4391.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4392.

:h2 hide res=4390.PrtGTab - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4391.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4392.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.None
:eul.

:h2 hide res=4391.PrtGTab - Description
:xmp.
USHORT PrtGTab( :link reftype=hd res=502.HGRPRT:elink.     hp);
:exmp.
:font facename=Helv size=16x12.
:p.Move the Gpi cursor to the next tab stop.
:p.:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.PRTGR_OK
:pd.The operation was successful
:pt.PRTGR_ERR_INV_HANDLE
:pd.The printing environment has not been initialised
:eparml.

:h2 hide res=4392.PrtGTab - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:eparml.

.***** PrtGTerm ************************************************************

:h2 res=1035.PrtGTerm
:i2 refid=FUNC.PrtGTerm
:link reftype=hd auto split group=1 scroll=vertical vpx=left vpy=top vpcx=30% vpcy=100% 
titlebar=none rules=border res=4450.
:link reftype=hd auto split group=2 scroll=vertical vpx=right vpy=top vpcx=70% vpcy=60% 
res=4451.
:link reftype=hd auto split group=3 scroll=vertical vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4452.

:h2 hide res=4450.PrtGTerm - List
:font facename=Helv size=16x12.
:p.:hp2.Topics:ehp2.
:ul compact.
:li.:link reftype=hd group=2 scroll=vertical split vpx=right vpy=top vpcx=70% vpcy=60% 
res=4451.Description:elink. 
:li.:link reftype=hd group=3 scroll=vertical split vpx=right vpy=bottom vpcx=70% vpcy=40% 
res=4452.Parameters:elink. 
:eul.
:p.:hp2.See Also:ehp2.
:ul compact.
:li.:link reftype=hd res=1018.PrtGInit:elink.
:eul.

:h2 hide res=4451.PrtGTerm - Description
:xmp.
VOID PrtGTerm( :link reftype=hd res=502.HGRPRT:elink.      hp);
:exmp.
:font facename=Helv size=16x12.
:p.Terminate the printing environment. Thsi deallocates all memory and invalidates the handle.
:warning.
Any calls to PRTGRAFC functions using :hp2.hp:ehp2. made after this call will generate access violations unless :hp2.hp:ehp2. is set to NULLHANDLE.
:ewarning.
:p.:hp2.Return:ehp2.
:p.None

:h2 hide res=4452.PrtGTerm - Parameters
:font facename=Helv size=16x12.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:eparml.



:h1 res=4453.Old Functions Still Maintained
:i1 id=O_FUNC.Old Functions Still Maintained
:font facename=Helv size=16x12.
:p.The following section describes some of the functions from version 1.x that have been 
replaced by :link reftype=hd res=4399.PrtGGet:elink. and :link reftype=hd res=4409.PrtGSet:elink..
:p.For backward compatibility these functions sre maintained as are the old named of printing 
functions.

:ul compact.
:li.:link reftype=hd res=1039.PrtGCurrentPrinter:elink.
:li.:link reftype=hd res=1016.PrtGGetPageSize:elink.
:li.:link reftype=hd res=1028.PrtGSetLineSpace:elink.
:li.:link reftype=hd res=1036.PrtGVersion:elink.
:eul.

.***** PrtGCurrentPrinter ***********************************************

:h2 res=1039.PrtGCurrentPrinter
:i2 refid=O_FUNC.PrtGCurrentPrinter
:xmp.
PSZ PrtGCurrentPrinter( :link reftype=hd res=502.HGRPRT:elink.     hp);
:exmp.
:font facename=Helv size=16x12.
:p.:hp2.Parameters:ehp2.
:parml compact tsize=20 break=none.
:pt.hp
:pd.handle to the printing environment returned by :link reftype=hd res=1018.PrtGInit:elink.
:eparml.
:p.:hp2.Description:ehp2.
:p.Get the name of the current selected printer.
:warning.
The returned string pointer must not be freed by calling application.
:ewarning.
:p.:hp2.Return:ehp2.
:p.Returns the name of the current printer or a NULL pointer if there is an error.

.***** PrtGGetPageSize *****************************************************

:h2 res=1016.PrtGGetPageSize
:i2 refid=O_FUNC.PrtGGetPageSize
:xmp.
USHORT PrtGGetPageSize( :link reftype=hd res=502.HGRPRT:elink.     hp,
                        PULONG     pulWide,
                        PULONG     pulHigh);
:exmp.
:font facename=Helv size=16x12.
:p.:hp2.Parameters:ehp2.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.pulWide
:pd.Pointer to a ULONG that will contain the width of the page in mm
:pt.pulHigh
:pd.Pointer to a ULONG that will contain the height of the page in mm
:eparml.
:p.:hp2.Description:ehp2.
:p.Returns the width of the page from left to right margin and the height of the page from 
bottom to top margin in mm. Use this function to help calculate positions for printing.
:p.
:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.
PRTGR_OK
:pd.
The operation was successful
:pt.
PRTGR_ERR_INV_HANDLE
:pd.
The printing environment has not been initialised
:eparml.
:p.:hp2.Related functions:ehp2.
:lm margin=5.
:ul compact.
:li.
:link reftype=hd res=1017.PrtGGoto:elink.
:eul.
:lm margin=1.

.***** PrtGSetLineSpace ****************************************************

:h2 res=1028.PrtGSetLineSpace
:i2 refid=O_FUNC.PrtGSetLineSpace
:xmp.
USHORT PrtGSetLineSpace( :link reftype=hd res=502.HGRPRT:elink.    hp,
                         USHORT    usPercent);
:exmp.
:font facename=Helv size=16x12.
:p.:hp2.Parameters:ehp2.
:parml compact tsize=20 break=none.
:pt.hp
:pd.Handle to the printing environment returned from :link reftype=hd res=1018.PrtGInit:elink.
:pt.usPercent
:pd.The percentage of the font hight to use for the interline space. The default is 120 = single space
:eparml.
:p.:hp2.Description:ehp2.
:p.Sets the inter line spacing for the following writes as a proportion of the font point size..
:p.
:hp2.Return:ehp2.
:parml compact tsize=30 break=none.
:pt.
PRTGR_OK
:pd.
The operation was successful
:pt.
PRTGR_ERR_INV_HANDLE
:pd.
The printing environment has not been initialised
:eparml.
:p.:hp2.Related functions:ehp2.
:lm margin=5.
:ul compact.
:li.:link reftype=hd res=1005.PrtGCentre:elink.
:li.:link reftype=hd res=1020.PrtGJustified:elink.
:li.:link reftype=hd res=1037.PrtGWrite:elink.
:li.:link reftype=hd res=1038.PrtGWriteln:elink.
:eul.
:lm margin=1.

.***** PrtGVersion *********************************************************

:h2 res=1036.PrtGVersion
:i2 refid=O_FUNC.PrtGVersion
:xmp.
PSZ PrtGVersion( VOID);
:exmp.
:font facename=Helv size=16x12.
:p.:hp2.Parameters:ehp2.
:parml compact tsize=20 break=none.
:pt.None
:pd.
:eparml.
:p.:hp2.Description:ehp2.
:p.Get the version number of the PRTGRAFC DLL.
:p.:hp2.Return:ehp2.
:p.String representation of the DLL version number.
:note.
It is the responsibility of the calling process to free the string when it is no longer needed.
:p.:hp2.Related functions:ehp2.
:lm margin=5.
:ul compact.
:li.None
:eul.
:lm margin=1.

:euserdoc.

.************************************************************************
.*
.*  (c)1996 ADD Consulting
.*
.*  END OF FILE.
.*
.* ***********************************************************************
