/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import netrexx.lang.BadArgumentException;
import netrexx.lang.DivideException;
import netrexx.lang.ExponentOverflowException;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.NotCharacterException;
import netrexx.lang.NotLogicException;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxNode;
import netrexx.lang.RexxOperators;
import netrexx.lang.RexxSet;
import netrexx.lang.RexxUtil;
import netrexx.lang.RexxWords;

public class Rexx
implements RexxOperators,
Serializable {
    private static final Rexx $01 = Rexx.toRexx("Bad binary");
    private static final Rexx $02 = new Rexx(0);
    private static final String $0 = "Rexx.nrx";
    public static final int DefaultDigits = 9;
    public static final byte DefaultForm = 0;
    public static final String Lowers = "abcdefghijklmnopqrstuvwxyz";
    public static final String Uppers = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String Digits09 = "0123456789";
    public static final char[] Hexes = "0123456789ABCDEFabcdef".toCharArray();
    static final byte ispos = 1;
    static final byte iszero = 0;
    static final byte isneg = -1;
    static final byte NotaNum = -2;
    static final int MinExp = -999999999;
    static final int MaxExp = 999999999;
    static final int MinArg = -999999999;
    static final int MaxArg = 999999999;
    char[] chars;
    byte ind;
    byte form;
    char[] mant;
    int exp;
    int dig;
    Hashtable coll;

    Rexx() {
    }

    public Rexx(byte by) {
        this((int)by);
    }

    public Rexx(char c) {
        char[] cArray = new char[]{c};
        Rexx rexx = new Rexx(cArray, true);
        this.chars = rexx.chars;
        this.ind = rexx.ind;
        this.mant = rexx.mant;
        this.exp = rexx.exp;
        this.dig = rexx.dig;
        this.form = rexx.form;
    }

    public Rexx(double d) {
        this(RexxUtil.doubleToRexx(d, 16));
    }

    public Rexx(float f) {
        this(RexxUtil.doubleToRexx(f, 7));
    }

    public Rexx(int n) {
        this.exp = 0;
        this.form = 0;
        if (n <= 9 && n >= -9) {
            this.mant = new char[1];
            if (n > 0) {
                this.mant[0] = (char)(48 + n);
                this.chars = this.mant;
                this.ind = 1;
            } else if (n == 0) {
                this.mant[0] = 48;
                this.chars = this.mant;
                this.ind = 0;
            } else {
                this.chars = new char[2];
                this.chars[0] = 45;
                this.chars[1] = (char)(48 - n);
                this.mant[0] = this.chars[1];
                this.ind = (byte)-1;
            }
            return;
        }
        if (n > 0) {
            this.ind = 1;
            this.mant = Integer.toString(n, 10).toCharArray();
            this.chars = this.mant;
            return;
        }
        this.ind = (byte)-1;
        this.chars = null;
        this.dig = 10;
        if (n == Integer.MIN_VALUE) {
            this.mant = new String("2147483648").toCharArray();
            return;
        }
        n = -n;
        this.mant = Integer.toString(n, 10).toCharArray();
    }

    public Rexx(long l) {
        this(String.valueOf(l).toCharArray(), true);
    }

    public Rexx(String string) {
        this(string.toCharArray(), true);
    }

    public Rexx(Rexx rexx) {
        this.chars = rexx.chars;
        this.ind = rexx.ind;
        this.mant = rexx.mant;
        this.exp = rexx.exp;
        this.dig = rexx.dig;
        this.form = rexx.form;
        this.coll = null;
    }

    public Rexx(short s) {
        this((int)s);
    }

    public Rexx(boolean bl) {
        this.exp = 0;
        this.dig = 9;
        this.form = 0;
        this.mant = new char[1];
        if (bl) {
            this.mant[0] = 49;
            this.ind = 1;
        } else {
            this.mant[0] = 48;
            this.ind = 0;
        }
        this.chars = this.mant;
    }

    public Rexx(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        Rexx rexx = new Rexx(cArray2, true);
        this.chars = rexx.chars;
        this.ind = rexx.ind;
        this.mant = rexx.mant;
        this.exp = rexx.exp;
        this.dig = rexx.dig;
        this.form = rexx.form;
    }

    Rexx(char[] cArray, boolean bl) {
        int n;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        this.chars = cArray;
        this.ind = (byte)-2;
        if (cArray.length == 0) {
            return;
        }
        if (cArray[0] > '9') {
            if (cArray[0] <= '\u007f') {
                return;
            }
            if (!Character.isDigit(cArray[0])) {
                return;
            }
        }
        if (!bl) {
            return;
        }
        int n5 = cArray.length;
        n2 = n5 - 1;
        while (n2 >= 0) {
            if (cArray[n2] != ' ') break;
            if (--n5 == 0) {
                return;
            }
            --n2;
        }
        int n6 = 0;
        int n7 = -1;
        int n8 = n5 - 1;
        n2 = 0;
        while (n2 <= n8) {
            if (cArray[n2] != ' ') {
                if (cArray[n2] == '-') {
                    if (n6 != 0) {
                        return;
                    }
                    n6 = -1;
                } else {
                    if (cArray[n2] != '+') {
                        n7 = n2;
                        break;
                    }
                    if (n6 != 0) {
                        return;
                    }
                    n6 = 1;
                }
            }
            ++n2;
        }
        if (n7 < 0) {
            return;
        }
        boolean bl3 = false;
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        int n12 = n5 - 1;
        n2 = n7;
        while (n2 <= n12) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                n11 = n2;
                ++n9;
            } else if (cArray[n2] == '.') {
                if (n10 >= 0) {
                    return;
                }
                n10 = n2 - n7;
            } else {
                if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                    if (n2 > n5 - 3) {
                        return;
                    }
                    if (n5 - n2 > 11) {
                        return;
                    }
                    if (cArray[n2 + 1] == '-') {
                        bl2 = true;
                    } else if (cArray[n2 + 1] == '+') {
                        bl2 = false;
                    } else {
                        return;
                    }
                    if (n5 - n2 - 2 > 9) {
                        return;
                    }
                    n = n5 - 1;
                    n3 = n2 + 2;
                    while (n3 <= n) {
                        if (cArray[n3] < '0') {
                            return;
                        }
                        if (cArray[n3] > '9') {
                            if (!Character.isDigit(cArray[n3])) {
                                return;
                            }
                            n4 = Character.digit(cArray[n3], 10);
                            if (n4 < 0) {
                                return;
                            }
                        } else {
                            n4 = cArray[n3] - 48;
                        }
                        this.exp = this.exp * 10 + n4;
                        ++n3;
                    }
                    if (!bl2) break;
                    this.exp = -this.exp;
                    break;
                }
                if (!Character.isDigit(cArray[n2])) {
                    return;
                }
                bl3 = true;
                n11 = n2;
                ++n9;
            }
            ++n2;
        }
        if (n9 == 0) {
            return;
        }
        if (n10 >= 0) {
            this.exp = this.exp + n10 - n9;
        }
        n = n11 - 1;
        n2 = n7;
        while (n2 <= n) {
            if (cArray[n2] == '.') {
                ++n7;
            } else if (cArray[n2] == '0') {
                ++n7;
                --n9;
            } else {
                if (cArray[n2] <= '9' || Character.digit(cArray[n2], 10) != 0) break;
                ++n7;
                --n9;
            }
            ++n2;
        }
        if (bl3) {
            this.mant = new char[n9];
            n3 = 0;
            int n13 = n9 - 1;
            n2 = 0;
            while (n2 <= n13) {
                if (cArray[n7 + n2] == '.') {
                    n3 = 1;
                }
                if ((c = cArray[n7 + n2 + n3]) <= '9') {
                    this.mant[n2] = c;
                } else {
                    n4 = Character.digit(c, 10);
                    if (n4 < 0) {
                        return;
                    }
                    this.mant[n2] = (char)(n4 + 48);
                }
                ++n2;
            }
        } else if (n9 == this.chars.length) {
            this.mant = this.chars;
        } else {
            this.mant = new char[n9];
            n3 = 0;
            int n14 = n9 - 1;
            n2 = 0;
            while (n2 <= n14) {
                if (cArray[n7 + n2] == '.') {
                    n3 = 1;
                }
                this.mant[n2] = cArray[n7 + n2 + n3];
                ++n2;
            }
        }
        if (this.mant[0] == '0') {
            this.ind = 0;
            this.exp = 0;
        } else {
            this.ind = n6 < 0 ? (byte)-1 : (byte)1;
        }
    }

    public Rexx(String[] stringArray) {
        this(Rexx.sa2ca(stringArray), true);
    }

    public Rexx OpAdd(RexxSet rexxSet, Rexx rexx) {
        int n;
        int n2 = 0;
        byte by = 0;
        Rexx rexx2 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char[] cArray3 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        char[] cArray4 = null;
        Rexx rexx3 = this;
        if (rexx3.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx3.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        if (rexxSet == null) {
            n2 = 9;
            by = 0;
        } else {
            n2 = rexxSet.digits;
            by = rexxSet.form;
        }
        if (rexx3.ind == 0) {
            rexx2 = new Rexx(rexx);
            rexx2.chars = null;
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        if (rexx.ind == 0) {
            rexx2 = new Rexx(rexx3);
            rexx2.chars = null;
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        if (rexx3.mant.length > n2 + 1) {
            rexx3 = new Rexx(rexx3);
            rexx3.cut(n2);
        }
        if (rexx.mant.length > n2 + 1) {
            rexx = new Rexx(rexx);
            rexx.cut(n2);
        }
        rexx2 = new Rexx();
        rexx2.dig = n2;
        rexx2.form = by;
        if (rexx3.exp == rexx.exp) {
            cArray = rexx3.mant;
            cArray2 = rexx.mant;
            rexx2.exp = rexx3.exp;
        } else if (rexx3.exp > rexx.exp) {
            n3 = rexx3.mant.length + rexx3.exp - rexx.exp;
            if (n3 > rexx.mant.length + n2 + 1) {
                rexx2.mant = rexx3.mant;
                rexx2.exp = rexx3.exp;
                rexx2.ind = rexx3.ind;
                if (rexx2.mant.length < n2) {
                    rexx2.mant = new char[n2];
                    System.arraycopy(rexx3.mant, 0, rexx2.mant, 0, rexx3.mant.length);
                    int n12 = n2 - 1;
                    n4 = rexx3.mant.length;
                    while (n4 <= n12) {
                        rexx2.mant[n4] = 48;
                        ++n4;
                    }
                    rexx2.exp -= n2 - rexx3.mant.length;
                }
                return rexx2.finish(n2, false);
            }
            rexx2.exp = rexx.exp;
            if (n3 > n2 + 1) {
                n5 = n3 - n2 - 1;
                cArray2 = new char[rexx.mant.length - n5];
                System.arraycopy(rexx.mant, 0, cArray2, 0, cArray2.length);
                rexx2.exp += n5;
                n3 = n2 + 1;
            } else {
                cArray2 = rexx.mant;
            }
            if (n3 > rexx3.mant.length) {
                cArray = new char[n3];
                System.arraycopy(rexx3.mant, 0, cArray, 0, rexx3.mant.length);
                n = n3 - 1;
                n4 = rexx3.mant.length;
                while (n4 <= n) {
                    cArray[n4] = 48;
                    ++n4;
                }
            } else {
                cArray = rexx3.mant;
            }
        } else {
            n3 = rexx.mant.length + rexx.exp - rexx3.exp;
            if (n3 > rexx3.mant.length + n2 + 1) {
                rexx2.mant = rexx.mant;
                rexx2.exp = rexx.exp;
                rexx2.ind = rexx.ind;
                if (rexx2.mant.length < n2) {
                    rexx2.mant = new char[n2];
                    System.arraycopy(rexx.mant, 0, rexx2.mant, 0, rexx.mant.length);
                    int n13 = n2 - 1;
                    n4 = rexx.mant.length;
                    while (n4 <= n13) {
                        rexx2.mant[n4] = 48;
                        ++n4;
                    }
                    rexx2.exp -= n2 - rexx.mant.length;
                }
                return rexx2.finish(n2, false);
            }
            rexx2.exp = rexx3.exp;
            if (n3 > n2 + 1) {
                n5 = n3 - n2 - 1;
                cArray = new char[rexx3.mant.length - n5];
                System.arraycopy(rexx3.mant, 0, cArray, 0, cArray.length);
                rexx2.exp += n5;
                n3 = n2 + 1;
            } else {
                cArray = rexx3.mant;
            }
            if (n3 > rexx.mant.length) {
                cArray2 = new char[n3];
                System.arraycopy(rexx.mant, 0, cArray2, 0, rexx.mant.length);
                n = n3 - 1;
                n4 = rexx.mant.length;
                while (n4 <= n) {
                    cArray2[n4] = 48;
                    ++n4;
                }
            } else {
                cArray2 = rexx.mant;
            }
        }
        if (rexx3.ind == rexx.ind) {
            rexx2.mant = Rexx.charaddsub(cArray, cArray2, 1);
            rexx2.ind = rexx3.ind;
            return rexx2.finish(n2, false);
        }
        rexx2.ind = rexx3.ind;
        if (cArray.length <= cArray2.length) {
            if (cArray.length < cArray2.length) {
                cArray3 = cArray;
                cArray = cArray2;
                cArray2 = cArray3;
                rexx2.ind = -rexx2.ind;
            } else {
                n6 = 0;
                n7 = 0;
                n8 = cArray.length - 1;
                n9 = cArray2.length - 1;
                while (true) {
                    if (n6 <= n8) {
                        n10 = cArray[n6];
                    } else {
                        if (n7 > n9) {
                            rexx2.mant = new char[1];
                            rexx2.mant[0] = 48;
                            rexx2.ind = 0;
                            rexx2.exp = 0;
                            return rexx2;
                        }
                        n10 = 48;
                    }
                    n11 = n7 <= n9 ? cArray2[n7] : 48;
                    if (n10 != n11) {
                        if (n10 >= n11) break;
                        cArray3 = cArray;
                        cArray = cArray2;
                        cArray2 = cArray3;
                        rexx2.ind = -rexx2.ind;
                        break;
                    }
                    ++n6;
                    ++n7;
                }
            }
        }
        rexx2.mant = Rexx.charaddsub(cArray, cArray2, -1);
        if (rexx2.mant.length > n2) {
            rexx2.round(n2);
        }
        if (rexx2.mant[0] == '0') {
            n = rexx2.mant.length;
            n4 = 1;
            while (n4 <= n) {
                if (n4 == rexx2.mant.length) {
                    rexx2.mant = new char[1];
                    rexx2.mant[0] = 48;
                    rexx2.ind = 0;
                    rexx2.exp = 0;
                    return rexx2;
                }
                if (rexx2.mant[n4] != '0') {
                    cArray4 = new char[rexx2.mant.length - n4];
                    System.arraycopy(rexx2.mant, n4, cArray4, 0, rexx2.mant.length - n4);
                    rexx2.mant = cArray4;
                    break;
                }
                ++n4;
            }
        }
        return rexx2;
    }

    public boolean OpAnd(RexxSet rexxSet, Rexx rexx) {
        return this.toboolean() & rexx.toboolean();
    }

    public Rexx OpCc(RexxSet rexxSet, Rexx rexx) {
        return this.concat(rexxSet, rexx, 0);
    }

    public Rexx OpCcblank(RexxSet rexxSet, Rexx rexx) {
        return this.concat(rexxSet, rexx, 1);
    }

    public Rexx OpDiv(RexxSet rexxSet, Rexx rexx) {
        return this.dodivide('D', rexxSet, rexx);
    }

    public Rexx OpDivI(RexxSet rexxSet, Rexx rexx) {
        return this.dodivide('I', rexxSet, rexx);
    }

    public boolean OpEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) == 0;
    }

    public boolean OpEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) == 0;
    }

    public boolean OpGt(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) > 0;
    }

    public boolean OpGtEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) >= 0;
    }

    public boolean OpGtEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) >= 0;
    }

    public boolean OpGtS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) > 0;
    }

    public boolean OpLt(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) < 0;
    }

    public boolean OpLtEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) <= 0;
    }

    public boolean OpLtEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) <= 0;
    }

    public boolean OpLtS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) < 0;
    }

    public Rexx OpMinus(RexxSet rexxSet) {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        Rexx rexx = new Rexx(this);
        rexx.ind = -rexx.ind;
        rexx.chars = null;
        if (rexxSet == null) {
            rexx.dig = 9;
            rexx.form = 0;
        } else {
            rexx.dig = rexxSet.digits;
            rexx.form = rexxSet.form;
        }
        return rexx.finish(rexx.dig, false);
    }

    public Rexx OpMult(RexxSet rexxSet, Rexx rexx) {
        int n = 0;
        byte by = 0;
        char[] cArray = null;
        char[] cArray2 = null;
        int n2 = 0;
        int n3 = 0;
        char[] cArray3 = null;
        Rexx rexx2 = this;
        if (rexx2.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx2.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        if (rexxSet == null) {
            n = 9;
            by = 0;
        } else {
            n = rexxSet.digits;
            by = rexxSet.form;
        }
        if (rexx2.mant.length > n + 1) {
            rexx2 = new Rexx(rexx2);
            rexx2.cut(n);
        }
        if (rexx.mant.length > n + 1) {
            rexx = new Rexx(rexx);
            rexx.cut(n);
        }
        Rexx rexx3 = new Rexx();
        rexx3.dig = n;
        rexx3.form = by;
        rexx3.ind = (byte)(rexx2.ind * rexx.ind);
        rexx3.exp = rexx2.exp + rexx.exp;
        if (rexx2.mant.length < rexx.mant.length) {
            cArray = rexx2.mant;
            cArray2 = rexx.mant;
        } else {
            cArray = rexx.mant;
            cArray2 = rexx2.mant;
        }
        char[] cArray4 = new char[]{'0'};
        n2 = cArray.length - 1;
        while (n2 >= 0) {
            n3 = cArray[n2] - 48;
            if (n3 > 0) {
                cArray4 = Rexx.charaddsub(cArray4, cArray2, n3);
            }
            if (n2 == 0) break;
            cArray3 = new char[cArray2.length + 1];
            System.arraycopy(cArray2, 0, cArray3, 0, cArray2.length);
            cArray3[cArray2.length] = 48;
            cArray2 = cArray3;
            --n2;
        }
        rexx3.mant = cArray4;
        return rexx3.finish(n, false);
    }

    public boolean OpNot(RexxSet rexxSet) {
        return this.toboolean() ^ true;
    }

    public boolean OpNotEq(RexxSet rexxSet, Rexx rexx) {
        return this.docompare(rexxSet, rexx) != 0;
    }

    public boolean OpNotEqS(RexxSet rexxSet, Rexx rexx) {
        return this.docomparestrict(rexxSet, rexx) != 0;
    }

    public boolean OpOr(RexxSet rexxSet, Rexx rexx) {
        return this.toboolean() | rexx.toboolean();
    }

    public Rexx OpPlus(RexxSet rexxSet) {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        Rexx rexx = new Rexx(this);
        rexx.chars = null;
        if (rexxSet == null) {
            rexx.dig = 9;
            rexx.form = 0;
        } else {
            rexx.dig = rexxSet.digits;
            rexx.form = rexxSet.form;
        }
        return rexx.finish(rexx.dig, false);
    }

    public Rexx OpPow(RexxSet rexxSet, Rexx rexx) {
        int n = 0;
        int n2 = 0;
        RexxSet rexxSet2 = null;
        int n3 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        n = rexxSet == null ? 9 : rexxSet.digits;
        if (rexx.mant.length > n) {
            rexx = new Rexx(rexx);
            rexx.round(n);
        }
        if (rexx.mant.length + rexx.exp > n) {
            throw new BadArgumentException("Too many digits: " + rexx.toString());
        }
        int n4 = rexx.intcheck(-999999999, 999999999);
        Rexx rexx2 = this;
        if (rexx2.mant.length > n + 1) {
            rexx2 = new Rexx(rexx2);
            rexx2.cut(n);
        }
        Rexx rexx3 = new Rexx(1);
        n2 = rexx.exp == 0 ? rexx.mant.length : new Rexx(n4).length().toint();
        rexxSet2 = rexxSet == null ? new RexxSet(9 + n2 + 1) : new RexxSet(rexxSet.digits + n2 + 1, rexxSet.form);
        Rexx rexx4 = rexx3;
        if (n4 == 0) {
            return rexx4;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        boolean bl = false;
        n3 = 1;
        while (true) {
            if ((n4 += n4) < 0) {
                bl = true;
                rexx4 = rexx4.OpMult(rexxSet2, rexx2);
            }
            if (n3 == 31) break;
            if (bl) {
                rexx4 = rexx4.OpMult(rexxSet2, rexx4);
            }
            ++n3;
        }
        if (rexx.ind < 0) {
            rexx4 = rexx3.OpDiv(rexxSet2, rexx4);
        }
        return rexx4.OpDiv(rexxSet, rexx3);
    }

    public Rexx OpRem(RexxSet rexxSet, Rexx rexx) {
        return this.dodivide('R', rexxSet, rexx);
    }

    public Rexx OpSub(RexxSet rexxSet, Rexx rexx) {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        Rexx rexx2 = new Rexx(rexx);
        rexx2.ind = -rexx2.ind;
        return this.OpAdd(rexxSet, rexx2);
    }

    public boolean OpXor(RexxSet rexxSet, Rexx rexx) {
        return this.toboolean() ^ rexx.toboolean();
    }

    public Rexx abbrev(Rexx rexx) {
        return this.abbrev(rexx, new Rexx(rexx.intlength()));
    }

    public Rexx abbrev(Rexx rexx, Rexx rexx2) {
        int n = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.abbrev(this.chars, rexx.chars, n));
    }

    public Rexx abs() throws NumberFormatException {
        RexxSet rexxSet = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        rexxSet = this.mant.length > 9 ? new RexxSet(this.mant.length) : null;
        if (this.ind >= 0) {
            return this.OpPlus(rexxSet);
        }
        return this.OpMinus(rexxSet);
    }

    public Rexx b2x() {
        int n = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("No digits");
        }
        char[] cArray = new char[(this.chars.length + 3) / 4];
        int n2 = cArray.length - 1;
        int n3 = 0;
        int n4 = 1;
        n = this.chars.length - 1;
        while (n >= 0) {
            if (this.chars[n] != '0') {
                if (this.chars[n] == '1') {
                    n3 += n4;
                } else {
                    throw new BadArgumentException(Rexx.toString($01.OpCcblank(null, this)));
                }
            }
            if ((n4 += n4) == 16 | n == 0) {
                cArray[n2] = Hexes[n3];
                --n2;
                n3 = 0;
                n4 = 1;
            }
            --n;
        }
        return new Rexx(cArray);
    }

    public Rexx c2d() {
        return new Rexx((int)this.padcheck());
    }

    public Rexx c2x() {
        int n = this.padcheck();
        char[] cArray = "0000".toCharArray();
        cArray[3] = Hexes[n % 16];
        if ((n /= 16) == 0) {
            return new Rexx(cArray).right(new Rexx(1));
        }
        cArray[2] = Hexes[n % 16];
        if ((n /= 16) == 0) {
            return new Rexx(cArray).right(new Rexx(2));
        }
        cArray[1] = Hexes[n % 16];
        if ((n /= 16) == 0) {
            return new Rexx(cArray).right(new Rexx(3));
        }
        cArray[0] = Hexes[n % 16];
        n /= 16;
        return new Rexx(cArray);
    }

    public Rexx center(Rexx rexx) {
        return this.center(rexx, Rexx.toRexx(" "));
    }

    public Rexx center(Rexx rexx, Rexx rexx2) {
        return this.centre(rexx, rexx2);
    }

    public Rexx centre(Rexx rexx) {
        return this.centre(rexx, Rexx.toRexx(" "));
    }

    public Rexx centre(Rexx rexx, Rexx rexx2) {
        int n = rexx.intcheck(0, 999999999);
        char c = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.centre(this.chars, n, c));
    }

    public Rexx changestr(Rexx rexx, Rexx rexx2) {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (rexx2.chars == null) {
            rexx2.chars = rexx2.layout();
        }
        return Rexx.toRexx(RexxWords.changestr(rexx.chars, this.chars, rexx2.chars));
    }

    public char charAt(int n) {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return this.chars[n];
    }

    private static char[] charaddsub(char[] cArray, char[] cArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray2.length - 1;
        int n5 = cArray.length - 1;
        int n6 = n5;
        if (n4 > n6) {
            n6 = n4;
        }
        char[] cArray3 = new char[n6 + 1];
        int n7 = 0;
        n2 = n6;
        while (n2 >= 0) {
            n3 = n7;
            if (n5 >= 0) {
                n3 = n3 + cArray[n5] - 48;
                --n5;
            }
            if (n4 >= 0) {
                n3 += (cArray2[n4] - 48) * n;
                --n4;
            }
            if (n3 < 0) {
                n7 = (n3 += 100) / 10 - 10;
                cArray3[n2] = (char)(n3 % 10 + 48);
            } else if (n3 > 9) {
                n7 = n3 / 10;
                cArray3[n2] = (char)(n3 % 10 + 48);
            } else {
                n7 = 0;
                cArray3[n2] = (char)(n3 + 48);
            }
            --n2;
        }
        if (n7 == 0) {
            return cArray3;
        }
        char[] cArray4 = new char[n6 + 2];
        cArray4[0] = (char)(n7 + 48);
        System.arraycopy(cArray3, 0, cArray4, 1, n6 + 1);
        return cArray4;
    }

    public Rexx compare(Rexx rexx) {
        return this.compare(rexx, Rexx.toRexx(" "));
    }

    public Rexx compare(Rexx rexx, Rexx rexx2) {
        char c = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.compare(this.chars, rexx.chars, c));
    }

    private Rexx concat(RexxSet rexxSet, Rexx rexx, int n) {
        int n2 = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray = new char[this.chars.length + rexx.chars.length + n];
        System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
        if (n > 0) {
            int n3 = this.chars.length + n - 1;
            n2 = this.chars.length;
            while (n2 <= n3) {
                cArray[n2] = 32;
                ++n2;
            }
        }
        System.arraycopy(rexx.chars, 0, cArray, this.chars.length + n, rexx.chars.length);
        return new Rexx(cArray, true);
    }

    public Rexx copies(Rexx rexx) throws BadArgumentException {
        int n = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        int n2 = this.chars.length;
        char[] cArray = new char[n * n2];
        int n3 = 0;
        int n4 = n;
        while (n4 > 0) {
            System.arraycopy(this.chars, 0, cArray, n3, n2);
            n3 += n2;
            --n4;
        }
        return new Rexx(cArray, true);
    }

    public synchronized Rexx copyIndexed(Rexx rexx) {
        Enumeration enumeration = null;
        Rexx rexx2 = null;
        RexxNode rexxNode = null;
        if (rexx.coll == null) {
            return this;
        }
        Hashtable hashtable = rexx.coll;
        synchronized (hashtable) {
            enumeration = rexx.coll.keys();
            while (enumeration.hasMoreElements()) {
                rexx2 = (Rexx)enumeration.nextElement();
                rexxNode = (RexxNode)rexx.coll.get(rexx2);
                if (rexxNode.leaf == null || rexxNode.leaf == rexxNode.initleaf) continue;
                this.getnode((Rexx)rexx2).leaf = rexxNode.leaf;
            }
        }
        return this;
    }

    public Rexx countstr(Rexx rexx) {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.countstr(rexx.chars, this.chars));
    }

    private void cut(int n) {
        int n2 = this.mant.length - n - 1;
        if (n2 <= 0) {
            return;
        }
        this.exp += n2;
        char[] cArray = new char[n + 1];
        System.arraycopy(this.mant, 0, cArray, 0, n + 1);
        this.mant = cArray;
        this.chars = null;
    }

    public Rexx d2c() {
        int n = this.toint();
        if (n < 0 | n > 65535) {
            throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Encoding bad").OpCcblank(null, this)));
        }
        return new Rexx((char)n);
    }

    public Rexx d2x() throws BadArgumentException, NumberFormatException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.d2x(this, -1));
    }

    public Rexx d2x(Rexx rexx) throws BadArgumentException, NumberFormatException {
        int n = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.d2x(this, n));
    }

    public Rexx datatype(Rexx rexx) throws BadArgumentException {
        int n = 0;
        RexxSet rexxSet = null;
        char c = rexx.optioncheck("ABDLMNSUWX");
        if (this.intlength() == 0) {
            n = 0;
        } else if (c == 'A') {
            n = this.verify(Rexx.toRexx("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789")).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'B') {
            n = this.verify(Rexx.toRexx("01")).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'D') {
            n = this.verify(Rexx.toRexx(Digits09)).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'L') {
            n = this.verify(Rexx.toRexx(Lowers)).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'M') {
            n = this.verify(Rexx.toRexx("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'N') {
            n = this.ind != -2 ? 1 : 0;
        } else if (c == 'S') {
            n = this.verify(Rexx.toRexx("_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789")).OpEqS(null, $02) & this.left(new Rexx(1)).verify(Rexx.toRexx(Digits09)).OpNotEqS(null, $02) ? 1 : 0;
        } else if (c == 'U') {
            n = this.verify(Rexx.toRexx(Uppers)).OpEqS(null, $02) ? 1 : 0;
        } else if (c == 'W') {
            if (this.ind == -2) {
                n = 0;
            } else {
                rexxSet = this.mant.length > 9 ? new RexxSet(this.mant.length) : null;
                n = this.OpDiv(rexxSet, new Rexx('1')).pos(new Rexx('.')).OpEqS(null, $02) ? 1 : 0;
            }
        } else if (c == 'X') {
            n = this.verify(Rexx.toRexx(Hexes)).OpEqS(null, $02) ? 1 : 0;
        } else {
            throw new NoOtherwiseException();
        }
        return new Rexx(n);
    }

    public Rexx delstr(Rexx rexx) throws BadArgumentException {
        return this.delstr(rexx, new Rexx(this.intlength()));
    }

    public Rexx delstr(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = rexx.intcheck(1, 999999999);
        int n2 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.delstr(this.chars, n, n2));
    }

    public Rexx delword(Rexx rexx) throws BadArgumentException {
        return this.delword(rexx, new Rexx(this.intwords()));
    }

    public Rexx delword(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = rexx.intcheck(1, 999999999);
        int n2 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.delword(this.chars, n, n2));
    }

    private final int docompare(RexxSet rexxSet, Rexx rexx) {
        int n = 0;
        int n2 = 0;
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        char c = '\u0000';
        char c2 = '\u0000';
        if (this.ind != -2 && rexx.ind != -2) {
            if (this.ind == rexx.ind & this.exp == rexx.exp) {
                n = this.mant.length;
                if (n < rexx.mant.length) {
                    return -this.ind;
                }
                if (n > rexx.mant.length) {
                    return this.ind;
                }
                this.dig = 9;
                if (rexxSet != null) {
                    this.dig = rexxSet.digits;
                }
                if (n <= this.dig) {
                    int n3 = n - 1;
                    n2 = 0;
                    while (n2 <= n3) {
                        if (this.mant[n2] < rexx.mant[n2]) {
                            return -this.ind;
                        }
                        if (this.mant[n2] > rexx.mant[n2]) {
                            return this.ind;
                        }
                        ++n2;
                    }
                    return 0;
                }
            } else {
                if (this.ind < rexx.ind) {
                    return -1;
                }
                if (this.ind > rexx.ind) {
                    return 1;
                }
            }
            rexx2 = new Rexx(rexx);
            rexx2.ind = -rexx2.ind;
            rexx3 = this.OpAdd(rexxSet, rexx2);
            return rexx3.ind;
        }
        if (this.chars == null) {
            this.chars = this.layout();
        }
        char[] cArray = this.chars;
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray2 = rexx.chars;
        int n4 = 0;
        int n5 = 0;
        int n6 = cArray.length - 1;
        int n7 = cArray2.length - 1;
        while (n6 >= 0) {
            if (cArray[n6] != ' ') break;
            --n6;
        }
        while (n7 >= 0) {
            if (cArray2[n7] != ' ') break;
            --n7;
        }
        int n8 = n6;
        n4 = 0;
        while (n4 <= n8) {
            if (cArray[n4] != ' ') break;
            ++n4;
        }
        int n9 = n7;
        n5 = 0;
        while (n5 <= n9) {
            if (cArray2[n5] != ' ') break;
            ++n5;
        }
        while (true) {
            if ((c2 = n5 <= n7 ? cArray2[n5] : (char)' ') == (c = n4 <= n6 ? cArray[n4] : (char)' ')) {
                if (c2 == ' ' && n4 > n6 && n5 > n7) break;
                ++n4;
                ++n5;
                continue;
            }
            c = Character.toLowerCase(c);
            if ((c2 = Character.toLowerCase(c2)) != c) {
                if (c < c2) {
                    return -1;
                }
                return 1;
            }
            ++n4;
            ++n5;
        }
        return 0;
    }

    private final int docomparestrict(RexxSet rexxSet, Rexx rexx) {
        char c = '\u0000';
        char c2 = '\u0000';
        if (this.chars == null) {
            this.chars = this.layout();
        }
        char[] cArray = this.chars;
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray2 = rexx.chars;
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = cArray2.length - 1;
        while (true) {
            if (n <= n3) {
                c = cArray[n];
            } else {
                if (n2 > n4) break;
                c = '\u0000';
            }
            c2 = n2 <= n4 ? cArray2[n2] : (char)'\u0000';
            if (c2 != c) {
                if (c < c2) {
                    return -1;
                }
                return 1;
            }
            ++n;
            ++n2;
        }
        return 0;
    }

    private final Rexx dodivide(char c, RexxSet rexxSet, Rexx rexx) throws NumberFormatException, DivideException {
        int n;
        int n2 = 0;
        byte by = 0;
        Rexx rexx2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(rexx.chars));
        }
        if (rexx.ind == 0) {
            throw new DivideException("Divide by 0");
        }
        if (rexxSet == null) {
            n2 = 9;
            by = 0;
        } else {
            n2 = rexxSet.digits;
            by = rexxSet.form;
        }
        Rexx rexx3 = this;
        if (rexx3.ind == 0) {
            return new Rexx(0);
        }
        if (rexx3.mant.length > n2 + 1) {
            rexx3 = new Rexx(rexx3);
            rexx3.cut(n2);
        }
        if (rexx.mant.length > n2 + 1) {
            rexx = new Rexx(rexx);
            rexx.cut(n2);
        }
        if ((n = rexx3.exp - rexx.exp + rexx3.mant.length - rexx.mant.length) < 0 && c != 'D') {
            if (c == 'I') {
                return new Rexx(0);
            }
            rexx2 = new Rexx(rexx3);
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        rexx2 = new Rexx();
        rexx2.ind = (byte)(rexx3.ind * rexx.ind);
        rexx2.exp = n;
        rexx2.dig = n2;
        rexx2.form = by;
        rexx2.mant = new char[n2 + 1];
        int n9 = n2 + n2 + 1;
        char[] cArray5 = new char[n9];
        System.arraycopy(rexx3.mant, 0, cArray5, 0, rexx3.mant.length);
        int n10 = n9 - 1;
        n3 = rexx3.mant.length;
        while (n3 <= n10) {
            cArray5[n3] = 48;
            ++n3;
        }
        char[] cArray6 = new char[n9];
        System.arraycopy(rexx.mant, 0, cArray6, 0, rexx.mant.length);
        int n11 = n9 - 1;
        n3 = rexx.mant.length;
        while (n3 <= n11) {
            cArray6[n3] = 48;
            ++n3;
        }
        int n12 = (cArray6[0] - 48) * 10 + cArray6[1] - 48 + 1;
        int n13 = 0;
        block2: while (true) {
            n4 = 0;
            block3: while (cArray5.length >= cArray6.length) {
                int n14;
                if (cArray5.length == cArray6.length) {
                    block31: {
                        n14 = cArray5.length - 1;
                        n3 = 0;
                        while (n3 <= n14) {
                            if (cArray5[n3] < cArray6[n3]) break block3;
                            if (cArray5[n3] <= cArray6[n3]) {
                                ++n3;
                                continue;
                            }
                            break block31;
                        }
                        if (c != 'R') {
                            rexx2.mant[n13] = (char)(++n4 + 48);
                            ++n13;
                            break block2;
                        }
                    }
                    n5 = cArray5[0] - 48;
                } else {
                    n5 = (cArray5[0] - 48) * 10;
                    if (cArray5.length > 1) {
                        n5 = n5 + cArray5[1] - 48;
                    }
                }
                n6 = n5 * 10 / n12;
                if (n6 == 0) {
                    n6 = 1;
                }
                n4 += n6;
                if ((cArray5 = Rexx.charaddsub(cArray5, cArray6, -n6))[0] != '0') continue;
                n7 = cArray5.length;
                n14 = n7 - 2;
                n8 = 0;
                while (n8 <= n14) {
                    if (cArray5[n8] != '0') break;
                    --n7;
                    ++n8;
                }
                cArray = new char[n7];
                System.arraycopy(cArray5, n8, cArray, 0, n7);
                cArray5 = cArray;
            }
            if (n13 != 0 | n4 != 0) {
                rexx2.mant[n13] = (char)(n4 + 48);
                if (++n13 == n2 + 1 || cArray5[0] == '0') break;
            }
            if (c != 'D' && rexx2.exp <= 0) break;
            --rexx2.exp;
            cArray2 = new char[cArray6.length - 1];
            System.arraycopy(cArray6, 0, cArray2, 0, cArray6.length - 1);
            cArray6 = cArray2;
        }
        if (c == 'I' | c == 'R' && n13 + rexx2.exp > n2) {
            throw new DivideException("Integer overflow");
        }
        if (c != 'R') {
            if (n13 == 0) {
                return new Rexx(0);
            }
            if (n13 == rexx2.mant.length) {
                rexx2.round(n2);
                n13 = n2;
            }
            cArray3 = new char[n13];
            System.arraycopy(rexx2.mant, 0, cArray3, 0, n13);
            rexx2.mant = cArray3;
            return rexx2.finish(n2, true);
        }
        if (n13 == 0) {
            rexx2 = new Rexx(rexx3);
            rexx2.chars = null;
            rexx2.dig = n2;
            rexx2.form = by;
            return rexx2.finish(n2, false);
        }
        if (cArray5[0] == '0') {
            return new Rexx(0);
        }
        rexx2.ind = rexx3.ind;
        int n15 = n2 + n2 + 1 - rexx3.mant.length;
        rexx2.exp = rexx2.exp - n15 + rexx3.exp;
        n7 = cArray5.length;
        n3 = n7 - 1;
        while (n3 >= 1) {
            if (!(rexx2.exp < rexx3.exp & rexx2.exp < rexx.exp) || cArray5[n3] != '0') break;
            --n7;
            ++rexx2.exp;
            --n3;
        }
        if (n7 < cArray5.length) {
            cArray4 = new char[n7];
            System.arraycopy(cArray5, 0, cArray4, 0, n7);
            cArray5 = cArray4;
        }
        rexx2.mant = cArray5;
        return rexx2.finish(n2, false);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Rexx) {
            return this.docomparestrict(null, (Rexx)object) == 0;
        }
        if (object instanceof String) {
            return this.docomparestrict(null, new Rexx((String)object)) == 0;
        }
        if (object instanceof char[]) {
            return this.docomparestrict(null, new Rexx((char[])object)) == 0;
        }
        return false;
    }

    public Rexx exists(Rexx rexx) {
        return new Rexx(this.testnode(rexx));
    }

    private final Rexx finish(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = null;
        int n4 = 0;
        int n5 = 0;
        if (this.mant.length > n) {
            this.round(n);
        }
        if (bl) {
            n2 = this.mant.length;
            n3 = n2 - 1;
            while (n3 >= 1) {
                if (this.mant[n3] != '0') break;
                --n2;
                ++this.exp;
                --n3;
            }
            if (n2 < this.mant.length) {
                cArray = new char[n2];
                System.arraycopy(this.mant, 0, cArray, 0, n2);
                this.mant = cArray;
            }
        }
        int n6 = this.mant.length - 1;
        n3 = 0;
        while (n3 <= n6) {
            block10: {
                block11: {
                    block12: {
                        if (this.mant[n3] == '0') break block10;
                        n4 = this.exp + this.mant.length - 1;
                        if (!(n4 < -999999999 | n4 > 999999999)) break block11;
                        if (this.form != 1) break block12;
                        n5 = n4 % 3;
                        if (n5 < 0) {
                            n5 = 3 + n5;
                        }
                        if ((n4 -= n5) >= -999999999 && n4 <= -999999999) break block11;
                    }
                    throw new ExponentOverflowException(String.valueOf(n4));
                }
                return this;
            }
            ++n3;
        }
        if (this.mant.length == 1 && this.ind == 0 && this.exp == 0) {
            return this;
        }
        return new Rexx(0);
    }

    public Rexx format() throws BadArgumentException, NumberFormatException {
        return this.format(null, null, null, null, null);
    }

    public Rexx format(Rexx rexx) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, null, null, null, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, rexx2, null, null, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, rexx2, rexx3, null, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) throws BadArgumentException, NumberFormatException {
        return this.format(rexx, rexx2, rexx3, rexx4, null);
    }

    public Rexx format(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4, Rexx rexx5) throws BadArgumentException, NumberFormatException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        n = rexx == null ? -1 : rexx.intcheck(1, 999999999);
        n2 = rexx2 == null ? -1 : rexx2.intcheck(0, 999999999);
        n3 = rexx3 == null ? -1 : rexx3.intcheck(1, 999999999);
        n4 = rexx4 == null ? -1 : rexx4.intcheck(0, 999999999);
        string = rexx5 == null ? "S" : String.valueOf(rexx5.optioncheck("SE"));
        return new Rexx(RexxUtil.format(this, n, n2, n3, n4, Rexx.tochar(string)), true);
    }

    public RexxNode getnode(Rexx rexx) {
        RexxNode rexxNode;
        if (this.coll == null) {
            Rexx rexx2 = this;
            synchronized (rexx2) {
                if (this.coll == null) {
                    this.coll = new Hashtable(37, 0.67f);
                }
            }
        }
        if ((rexxNode = (RexxNode)this.coll.get(rexx)) != null && rexxNode.leaf != null) {
            return rexxNode;
        }
        rexxNode = new RexxNode(new Rexx(this));
        this.coll.put(rexx, rexxNode);
        return rexxNode;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        n = this.chars.length < 14 ? (this.chars.length + 1) / 2 : 7;
        int n3 = 0;
        int n4 = n - 1;
        n2 = 0;
        while (n2 <= n4) {
            n3 = n3 * 7 + this.chars[n2] * 2 + this.chars[this.chars.length - n2 - 1];
            ++n2;
        }
        return n3;
    }

    public Rexx insert(Rexx rexx) throws BadArgumentException {
        return this.insert(rexx, new Rexx(0), new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx insert(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        return this.insert(rexx, rexx2, new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx insert(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException {
        return this.insert(rexx, rexx2, rexx3, Rexx.toRexx(" "));
    }

    public Rexx insert(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) throws BadArgumentException {
        int n = rexx2.intcheck(0, 999999999);
        int n2 = rexx3.intcheck(0, 999999999);
        char c = rexx4.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.insert(this.chars, rexx.chars, n, n2, c), true);
    }

    private int intcheck(int n, int n2) throws BadArgumentException {
        int n3 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException("Not a number");
        }
        int n4 = this.mant.length - 1;
        if (this.exp < 0) {
            n3 = this.exp + 1;
            while (n3 <= 0) {
                if (this.mant[n4] == '0') {
                    --n4;
                } else {
                    throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Non-zero decimal part in").OpCcblank(null, this)));
                }
                ++n3;
            }
        }
        if ((n3 = this.toint()) < n) {
            throw new BadArgumentException("Argument " + n3 + " " + "<" + " " + n);
        }
        if (n3 > n2) {
            throw new BadArgumentException("Argument " + n3 + " " + ">" + " " + n2);
        }
        return n3;
    }

    private final int intlength() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return this.chars.length;
    }

    private final int intwords() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return RexxWords.words(this.chars);
    }

    public synchronized Enumeration keys() {
        if (this.coll == null) {
            Rexx rexx = this;
            synchronized (rexx) {
                if (this.coll == null) {
                    this.coll = new Hashtable(37, 0.67f);
                }
            }
        }
        return this.coll.keys();
    }

    public Rexx lastpos(Rexx rexx) throws BadArgumentException {
        int n = this.intlength();
        if (n == 0) {
            n = 1;
        }
        return this.lastpos(rexx, new Rexx(n));
    }

    public Rexx lastpos(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = rexx2.intcheck(1, 999999999) - 1;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (n4 >= this.chars.length) {
            n4 = this.chars.length - 1;
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if ((n = rexx.chars.length) == 0) {
            return new Rexx(0);
        }
        n2 = n4 = n4 - n + 1;
        while (n2 >= 0) {
            block7: {
                int n5 = n - 1;
                n3 = 0;
                while (n3 <= n5) {
                    if (rexx.chars[n3] == this.chars[n2 + n3]) {
                        ++n3;
                        continue;
                    }
                    break block7;
                }
                return new Rexx(n2 + 1);
            }
            --n2;
        }
        return new Rexx(0);
    }

    private char[] layout() {
        int n;
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        char[] cArray = null;
        if (this.ind == -2) {
            RexxIO.Say("Internal error: Rexx missing number " + String.valueOf(this.chars));
        }
        if (this.dig < 0) {
            RexxIO.Say("Internal error: Rexx: bad dig " + this.dig);
            this.dig = 9;
        }
        if ((n = this.exp + this.mant.length) > this.dig | n < -5 && this.form != 2) {
            stringBuffer = new StringBuffer(this.mant.length + 15);
            if (this.ind == -1) {
                stringBuffer.append('-');
            }
            n2 = this.exp + this.mant.length - 1;
            if (this.form == 0) {
                stringBuffer.append(this.mant[0]);
                if (this.mant.length > 1) {
                    stringBuffer.append('.').append(this.mant, 1, this.mant.length - 1);
                }
            } else {
                n3 = n2 % 3;
                if (n3 < 0) {
                    n3 = 3 + n3;
                }
                n2 -= n3;
                if (++n3 >= this.mant.length) {
                    stringBuffer.append(this.mant, 0, this.mant.length);
                    int n4 = n3 - this.mant.length;
                    while (n4 > 0) {
                        stringBuffer.append('0');
                        --n4;
                    }
                } else {
                    stringBuffer.append(this.mant, 0, n3).append('.').append(this.mant, n3, this.mant.length - n3);
                }
            }
            if (n2 != 0) {
                if (n2 < 0) {
                    string = "-";
                    n2 = -n2;
                } else {
                    string = "+";
                }
                stringBuffer.append('E').append(string).append(n2);
            }
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return cArray;
        }
        if (this.exp == 0) {
            if (this.ind >= 0) {
                return this.mant;
            }
            cArray = new char[this.mant.length + 1];
            cArray[0] = 45;
            System.arraycopy(this.mant, 0, cArray, 1, this.mant.length);
            return cArray;
        }
        stringBuffer = new StringBuffer(this.mant.length + this.dig + 5 + 3 + 10);
        if (this.ind == -1) {
            stringBuffer.append('-');
        }
        if (n < 1) {
            stringBuffer.append('0').append('.');
            int n5 = -n;
            while (n5 > 0) {
                stringBuffer.append('0');
                --n5;
            }
            stringBuffer.append(this.mant);
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return cArray;
        }
        if (n > this.mant.length) {
            stringBuffer.append(this.mant);
            int n6 = n - this.mant.length;
            while (n6 > 0) {
                stringBuffer.append('0');
                --n6;
            }
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return cArray;
        }
        stringBuffer.append(this.mant, 0, n).append('.').append(this.mant, n, this.mant.length - n);
        cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        return cArray;
    }

    char[] layoutnum() {
        return this.layout();
    }

    public Rexx left(Rexx rexx) {
        return this.left(rexx, Rexx.toRexx(" "));
    }

    public Rexx left(Rexx rexx, Rexx rexx2) {
        return this.substr(new Rexx(1), rexx, rexx2);
    }

    public Rexx length() {
        return new Rexx(this.intlength());
    }

    public Rexx lower() throws BadArgumentException {
        return this.lower(new Rexx(1), this.length());
    }

    public Rexx lower(Rexx rexx) throws BadArgumentException {
        return this.lower(rexx, this.length());
    }

    public Rexx lower(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = rexx.intcheck(1, 999999999) - 1;
        int n4 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length) == 0) {
            return new Rexx("");
        }
        char[] cArray = new char[n];
        if (n4 < n | n3 > 0) {
            System.arraycopy(this.chars, 0, cArray, 0, n);
        }
        int n5 = n - 1;
        int n6 = n4;
        n2 = n3;
        while (n2 <= n5 && n6 > 0) {
            cArray[n2] = Character.toLowerCase(this.chars[n2]);
            --n6;
            ++n2;
        }
        return new Rexx(cArray, true);
    }

    public Rexx max(Rexx rexx) throws NumberFormatException {
        Rexx rexx2 = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        int n = 9;
        if (this.mant.length > n) {
            n = this.mant.length;
        }
        if (rexx.mant.length > n) {
            n = rexx.mant.length;
        }
        rexx2 = this.docompare(new RexxSet(n), rexx) < 0 ? rexx : this;
        n = 9;
        if (rexx2.mant.length > n) {
            n = rexx2.mant.length;
        }
        return rexx2.OpPlus(new RexxSet(n));
    }

    public Rexx min(Rexx rexx) throws NumberFormatException {
        Rexx rexx2 = null;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (rexx.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        int n = 9;
        if (this.mant.length > n) {
            n = this.mant.length;
        }
        if (rexx.mant.length > n) {
            n = rexx.mant.length;
        }
        rexx2 = this.docompare(new RexxSet(n), rexx) > 0 ? rexx : this;
        n = 9;
        if (rexx2.mant.length > n) {
            n = rexx2.mant.length;
        }
        return rexx2.OpPlus(new RexxSet(n));
    }

    private char optioncheck(String string) throws BadArgumentException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("Null option string");
        }
        char c = this.chars[0];
        char c2 = Character.toUpperCase(c);
        if (string.indexOf(c2, 0) < 0) {
            throw new BadArgumentException("Bad Option character " + String.valueOf(c) + " " + "[" + String.valueOf(c2) + "]");
        }
        return c2;
    }

    public Rexx overlay(Rexx rexx) throws BadArgumentException {
        return this.overlay(rexx, new Rexx(1), new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx overlay(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        return this.overlay(rexx, rexx2, new Rexx(rexx.intlength()), Rexx.toRexx(" "));
    }

    public Rexx overlay(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException {
        return this.overlay(rexx, rexx2, rexx3, Rexx.toRexx(" "));
    }

    public Rexx overlay(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) throws BadArgumentException {
        int n = rexx2.intcheck(1, 999999999);
        int n2 = rexx3.intcheck(0, 999999999);
        char c = rexx4.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.overlay(this.chars, rexx.chars, n, n2, c), true);
    }

    private char padcheck() throws NotCharacterException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length != 1) {
            throw new NotCharacterException(String.valueOf(this.chars));
        }
        return this.chars[0];
    }

    public Rexx pos(Rexx rexx) throws BadArgumentException {
        return this.pos(rexx, new Rexx(1));
    }

    public Rexx pos(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = rexx2.intcheck(1, 999999999) - 1;
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (rexx.chars.length == 0) {
            return new Rexx(0);
        }
        if (this.chars == null) {
            this.chars = this.layout();
        }
        int n4 = this.chars.length - rexx.chars.length;
        n = n3;
        while (n <= n4) {
            block6: {
                int n5 = rexx.chars.length - 1;
                n2 = 0;
                while (n2 <= n5) {
                    if (rexx.chars[n2] == this.chars[n + n2]) {
                        ++n2;
                        continue;
                    }
                    break block6;
                }
                return new Rexx(n + 1);
            }
            ++n;
        }
        return new Rexx(0);
    }

    public Rexx reverse() {
        int n;
        int n2 = 0;
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length) == 0) {
            return new Rexx("");
        }
        char[] cArray = new char[n];
        int n3 = n - 1;
        n2 = 0;
        while (n2 <= n3) {
            cArray[n2] = this.chars[--n];
            ++n2;
        }
        return new Rexx(cArray, true);
    }

    public Rexx right(Rexx rexx) throws NotCharacterException, BadArgumentException {
        return this.right(rexx, Rexx.toRexx(" "));
    }

    public Rexx right(Rexx rexx, Rexx rexx2) throws NotCharacterException, BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length - n3) >= 0) {
            return this.substr(new Rexx(n + 1));
        }
        char c = rexx2.padcheck();
        char[] cArray = new char[n3];
        int n4 = -n - 1;
        n2 = 0;
        while (n2 <= n4) {
            cArray[n2] = c;
            ++n2;
        }
        System.arraycopy(this.chars, 0, cArray, n2, cArray.length - n2);
        return new Rexx(cArray, true);
    }

    private void round(int n) {
        char[] cArray = null;
        int n2 = this.mant.length - n;
        if (n2 <= 0) {
            return;
        }
        this.exp += n2;
        if (n2 > 1) {
            cArray = new char[n + 1];
            System.arraycopy(this.mant, 0, cArray, 0, n + 1);
        } else {
            cArray = this.mant;
        }
        char[] cArray2 = new char[]{'5'};
        char[] cArray3 = Rexx.charaddsub(cArray, cArray2, 1);
        if (cArray3.length > n + 1) {
            ++this.exp;
        }
        char[] cArray4 = new char[n];
        System.arraycopy(cArray3, 0, cArray4, 0, n);
        this.mant = cArray4;
        this.chars = null;
    }

    private static char[] sa2ca(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = stringArray.length - 1;
        if (n3 < 0) {
            return new char[0];
        }
        int n4 = n3;
        int n5 = n3;
        n = 0;
        while (n <= n5) {
            n4 += stringArray[n].length();
            ++n;
        }
        char[] cArray = new char[n4];
        int n6 = 0;
        int n7 = n3;
        n = 0;
        while (n <= n7) {
            n2 = stringArray[n].length();
            stringArray[n].getChars(0, n2, cArray, n6);
            if (n == n3) break;
            n6 = n6 + n2 + 1;
            cArray[n6 - 1] = 32;
            ++n;
        }
        return cArray;
    }

    public Rexx sequence(Rexx rexx) throws BadArgumentException, NotCharacterException {
        char c;
        int n = 0;
        char c2 = this.padcheck();
        char c3 = rexx.padcheck();
        int n2 = c3 - (c = c2) + 1;
        if (n2 <= 0) {
            throw new BadArgumentException("final<start");
        }
        char[] cArray = new char[n2];
        int n3 = n2 - 1;
        n = 0;
        while (n <= n3) {
            cArray[n] = (char)(n + c);
            ++n;
        }
        return new Rexx(cArray, true);
    }

    public Rexx sign() throws NumberFormatException {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        return new Rexx(this.ind);
    }

    public int significance() {
        if (this.ind == -2) {
            return 0;
        }
        return this.mant.length;
    }

    public Rexx space() {
        return this.space(new Rexx(1), Rexx.toRexx(" "));
    }

    public Rexx space(Rexx rexx) {
        return this.space(rexx, Rexx.toRexx(" "));
    }

    public Rexx space(Rexx rexx, Rexx rexx2) {
        int n = rexx.intcheck(0, 999999999);
        char c = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.space(this.chars, n, c));
    }

    public Rexx strip() throws BadArgumentException {
        return this.strip(Rexx.toRexx("B"), Rexx.toRexx(" "));
    }

    public Rexx strip(Rexx rexx) throws BadArgumentException {
        return this.strip(rexx, Rexx.toRexx(" "));
    }

    public Rexx strip(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n = 0;
        int n2 = 0;
        char c = rexx.optioncheck("BLT");
        char c2 = rexx2.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            return new Rexx("");
        }
        if (c == 'T') {
            n = 0;
        } else {
            int n3 = this.chars.length - 1;
            n = 0;
            while (n <= n3) {
                if (this.chars[n] != c2) break;
                ++n;
            }
            if (n == this.chars.length) {
                return new Rexx("");
            }
        }
        if (c == 'L') {
            n2 = this.chars.length - 1;
        } else {
            n2 = this.chars.length - 1;
            while (n2 >= 0) {
                if (this.chars[n2] != c2) break;
                --n2;
            }
            if (n2 < 0) {
                return new Rexx("");
            }
        }
        if (n == 0 && n2 == this.chars.length - 1) {
            return new Rexx(this);
        }
        int n4 = n2 - n + 1;
        char[] cArray = new char[n4];
        System.arraycopy(this.chars, n, cArray, 0, n4);
        return new Rexx(cArray, true);
    }

    public Rexx substr(Rexx rexx) throws NotCharacterException, BadArgumentException {
        return this.substr(rexx, new Rexx(this.intlength() + 1 - rexx.toint()).max(new Rexx(0)), Rexx.toRexx(" "));
    }

    public Rexx substr(Rexx rexx, Rexx rexx2) throws NotCharacterException, BadArgumentException {
        return this.substr(rexx, rexx2, Rexx.toRexx(" "));
    }

    public Rexx substr(Rexx rexx, Rexx rexx2, Rexx rexx3) throws NotCharacterException, BadArgumentException {
        int n = 0;
        int n2 = rexx.intcheck(1, 999999999) - 1;
        int n3 = rexx2.intcheck(0, 999999999);
        char c = rexx3.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        int n4 = this.chars.length;
        char[] cArray = new char[n3];
        if (n2 + n3 <= n4) {
            System.arraycopy(this.chars, n2, cArray, 0, n3);
        } else {
            if (n2 < n4) {
                System.arraycopy(this.chars, n2, cArray, 0, n4 - n2);
            } else {
                n2 = n4;
            }
            int n5 = n3 - 1;
            n = n4 - n2;
            while (n <= n5) {
                cArray[n] = c;
                ++n;
            }
        }
        return new Rexx(cArray, true);
    }

    public Rexx subword(Rexx rexx) {
        return this.subword(rexx, this.length());
    }

    public Rexx subword(Rexx rexx, Rexx rexx2) {
        int n = rexx.intcheck(1, 999999999);
        int n2 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxWords.subword(this.chars, n, n2));
    }

    public boolean testnode(Rexx rexx) {
        if (this.coll == null) {
            return false;
        }
        RexxNode rexxNode = (RexxNode)this.coll.get(rexx);
        if (rexxNode == null) {
            return false;
        }
        if (rexxNode.leaf == null) {
            return false;
        }
        return rexxNode.leaf != rexxNode.initleaf;
    }

    public char[] toCharArray() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        char[] cArray = new char[this.chars.length];
        System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
        return cArray;
    }

    public static final Rexx toRexx(String string) {
        if (string == null) {
            return null;
        }
        return new Rexx(string.toCharArray(), true);
    }

    public static final Rexx toRexx(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return new Rexx(cArray2, true);
    }

    public String toString() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new String(this.chars);
    }

    public static final String toString(Rexx rexx) {
        if (rexx == null) {
            return null;
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new String(rexx.chars);
    }

    public boolean toboolean() throws NotLogicException {
        if (this.ind == 0) {
            return false;
        }
        if (this.ind == 1 && this.mant.length == 1 && this.mant[0] == '1') {
            return true;
        }
        throw new NotLogicException("Boolean must be 0 or 1.  Found: " + this.toString());
    }

    public byte tobyte() throws NumberFormatException {
        int n = this.toint();
        if (n > 127 | n < -128) {
            throw new NumberFormatException("Conversion overflow");
        }
        return (byte)n;
    }

    public char tochar() throws NotCharacterException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length != 1) {
            throw new NotCharacterException(String.valueOf(this.chars));
        }
        return this.chars[0];
    }

    public static char tochar(String string) throws NotCharacterException {
        if (string.length() != 1) {
            throw new NotCharacterException(string);
        }
        return string.charAt(0);
    }

    public static char tochar(char[] cArray) throws NotCharacterException {
        if (cArray.length != 1) {
            throw new NotCharacterException(String.valueOf(cArray));
        }
        return cArray[0];
    }

    public static char[] tochararray(char c) {
        char[] cArray = new char[]{c};
        return cArray;
    }

    public static final char[] tochararray(Rexx rexx) {
        if (rexx == null) {
            return null;
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        char[] cArray = new char[rexx.chars.length];
        System.arraycopy(rexx.chars, 0, cArray, 0, rexx.chars.length);
        return cArray;
    }

    public double todouble() throws NumberFormatException {
        double d;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (Double.isInfinite(d = Double.valueOf(new String(this.chars)).doubleValue())) {
            throw new NumberFormatException("Overflow");
        }
        return d;
    }

    public float tofloat() throws NumberFormatException {
        double d = this.todouble();
        if (d > 3.402823466E38 | d < -3.402823466E38) {
            throw new NumberFormatException("Overflow");
        }
        return (float)d;
    }

    public int toint() throws NumberFormatException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (this.ind == 0) {
            return 0;
        }
        int n7 = this.mant.length - 1;
        if (this.exp < 0) {
            n3 = (n7 += this.exp) < 0 ? 0 : n7 + 1;
            n2 = this.mant.length - 1;
            n4 = n3;
            while (n4 <= n2) {
                if (this.mant[n4] != '0') {
                    throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Decimal part non-zero:").OpCcblank(null, this)));
                }
                ++n4;
            }
            if (n7 < 0) {
                return 0;
            }
            n5 = 0;
        } else {
            if (this.exp + this.mant.length > 10) {
                throw new NumberFormatException("Conversion overflow");
            }
            n5 = this.exp;
        }
        int n8 = n = 0;
        n2 = n7 + n5;
        n6 = 0;
        while (n6 <= n2) {
            n *= 10;
            if (n6 <= n7) {
                n += this.mant[n6] - 48;
            }
            if (n < n8) {
                if (this.ind == -1 && n == Integer.MIN_VALUE && n6 == n7 + n5) {
                    return n;
                }
                throw new NumberFormatException("Conversion overflow");
            }
            n8 = n;
            ++n6;
        }
        if (this.ind > 0) {
            return n;
        }
        return -n;
    }

    public long tolong() throws NumberFormatException {
        long l;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        if (this.ind == 0) {
            return 0L;
        }
        int n6 = this.mant.length - 1;
        if (this.exp < 0) {
            n2 = (n6 += this.exp) < 0 ? 0 : n6 + 1;
            n = this.mant.length - 1;
            n3 = n2;
            while (n3 <= n) {
                if (this.mant[n3] != '0') {
                    throw new NumberFormatException(Rexx.toString(Rexx.toRexx("Decimal part non-zero:").OpCcblank(null, this)));
                }
                ++n3;
            }
            if (n6 < 0) {
                return 0L;
            }
            n4 = 0;
        } else {
            if (this.exp + this.mant.length >= 20) {
                throw new NumberFormatException("Conversion overflow");
            }
            n4 = this.exp;
        }
        long l2 = l = 0L;
        n = n6 + n4;
        n5 = 0;
        while (n5 <= n) {
            l *= 10L;
            if (n5 <= n6) {
                l += (long)(this.mant[n5] - 48);
            }
            if (l < l2) {
                if (this.ind < 0 && l == Long.MIN_VALUE && n5 == n6 + n4) {
                    return l;
                }
                throw new NumberFormatException("Conversion overflow");
            }
            l2 = l;
            ++n5;
        }
        if (this.ind > 0) {
            return l;
        }
        return -l;
    }

    public short toshort() throws NumberFormatException {
        int n = this.toint();
        if (n > Short.MAX_VALUE | n < Short.MIN_VALUE) {
            throw new NumberFormatException("Conversion overflow");
        }
        return (short)n;
    }

    public Rexx translate(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        return this.translate(rexx, rexx2, Rexx.toRexx(" "));
    }

    public Rexx translate(Rexx rexx, Rexx rexx2, Rexx rexx3) throws BadArgumentException {
        char c = rexx3.padcheck();
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (rexx2.chars == null) {
            rexx2.chars = rexx2.layout();
        }
        return Rexx.toRexx(RexxUtil.translate(this.chars, rexx.chars, rexx2.chars, c));
    }

    public Rexx trunc() throws BadArgumentException, NumberFormatException {
        return this.trunc(new Rexx(0));
    }

    public Rexx trunc(Rexx rexx) throws BadArgumentException, NumberFormatException {
        if (this.ind == -2) {
            throw new NumberFormatException(String.valueOf(this.chars));
        }
        int n = rexx.intcheck(0, 999999999);
        return new Rexx(RexxUtil.trunc(this, n));
    }

    public Rexx upper() throws BadArgumentException {
        return this.upper(new Rexx(1), this.length());
    }

    public Rexx upper(Rexx rexx) throws BadArgumentException {
        return this.upper(rexx, this.length());
    }

    public Rexx upper(Rexx rexx, Rexx rexx2) throws BadArgumentException {
        int n;
        int n2 = 0;
        int n3 = rexx.intcheck(1, 999999999) - 1;
        int n4 = rexx2.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if ((n = this.chars.length) == 0) {
            return new Rexx("");
        }
        char[] cArray = new char[n];
        if (n4 < n | n3 > 0) {
            System.arraycopy(this.chars, 0, cArray, 0, n);
        }
        int n5 = n - 1;
        int n6 = n4;
        n2 = n3;
        while (n2 <= n5 && n6 > 0) {
            cArray[n2] = Character.toUpperCase(this.chars[n2]);
            --n6;
            ++n2;
        }
        return new Rexx(cArray, true);
    }

    public Rexx verify(Rexx rexx) {
        return this.verify(rexx, Rexx.toRexx("N"), new Rexx(1));
    }

    public Rexx verify(Rexx rexx, Rexx rexx2) {
        return this.verify(rexx, rexx2, new Rexx(1));
    }

    public Rexx verify(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        char c = rexx2.optioncheck("NM");
        int n = rexx3.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        if (c == 'N') {
            return new Rexx(RexxWords.verifyn(this.chars, rexx.chars, n));
        }
        return new Rexx(RexxWords.verifym(this.chars, rexx.chars, n));
    }

    public Rexx word(Rexx rexx) {
        return this.subword(rexx, new Rexx(1));
    }

    public Rexx wordindex(Rexx rexx) {
        int n = rexx.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new Rexx(RexxWords.wordindex(this.chars, n));
    }

    public Rexx wordlength(Rexx rexx) {
        int n = rexx.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return new Rexx(RexxWords.wordlength(this.chars, n));
    }

    public Rexx wordpos(Rexx rexx) {
        return this.wordpos(rexx, new Rexx(1));
    }

    public Rexx wordpos(Rexx rexx, Rexx rexx2) {
        int n = rexx2.intcheck(1, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (rexx.chars == null) {
            rexx.chars = rexx.layout();
        }
        return new Rexx(RexxWords.wordpos(rexx.chars, this.chars, n));
    }

    public Rexx words() {
        return new Rexx(this.intwords());
    }

    public Rexx x2b() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("No digits");
        }
        return new Rexx(RexxUtil.x2b(this));
    }

    public Rexx x2c() {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        if (this.chars.length == 0) {
            throw new BadArgumentException("No digits");
        }
        return new Rexx(RexxUtil.x2c(this));
    }

    public Rexx x2d() throws BadArgumentException {
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.x2d(this, -1));
    }

    public Rexx x2d(Rexx rexx) throws BadArgumentException {
        int n = rexx.intcheck(0, 999999999);
        if (this.chars == null) {
            this.chars = this.layout();
        }
        return Rexx.toRexx(RexxUtil.x2d(this, n));
    }
}

