/* Rexx */
/* ----------------------------------------------------------------| */
/*  LanXCopy receiver program by Craig Park                        | */
/* ----------------------------------------------------------------| */
/*  YY/MM/DD  USER                     COMMENTS                  | */
/* ----------------------------------------------------------------| */
/*  96/01/01  CP    Creation date                                | */
/*    /  /                                                       | */
/* ----------------------------------------------------------------| */

/* Initialize the REXXUTIL functions */
CALL RXFUNCADD 'SYSLOADFUNCS','REXXUTIL','SYSLOADFUNCS'
CALL SYSLOADFUNCS

/* Set up the locations of the log file and receive directory */
Log_File    = "E:\USER\UTILITY\LANXCOPY.LOG"
Receive_Dir = "E:\LANXCOPY.RCV"

/* Main loop keeps going forever until the session is killed */
DO FOREVER
 rc = SysFileDelete(Log_File)     /* Delete the log before starting */
 Who = ''
 /* This is the actual LANXCOPY command (rexx program waits for it to
    finish executing then continues with next instruction           */
 ADDRESS "CMD" "LANXCopy From:* "||Receive_Dir||" /r /c /x"
 CALL SysSleep 3      /* Give the system time to close the log file */
 a = 0
 /* Process the log file to extract user name and file names */
 DO UNTIL LINES(Log_File) = 0
  l = LINEIN(Log_File)
  IF TRANSLATE(LEFT(l,28)) = 'FILE TRANSFER BEGINNING FROM' THEN
   Who = WORD(l,WORDS(l))
  IF TRANSLATE(LEFT(l,3)) = 'RCV' THEN DO
   a = a + 1
   PARSE VAR l . File.a .
  END
 END
 /* Close the file so that it can be deleted and reallocated */
 rc = STREAM(Log_File,'c','Close')
 /* Build the message string for the notify program */
 Msg = "New files From "||Who||" -"
 DO b = 1 TO a
  IF b = 11 THEN Msg = Msg||'...'
  IF b < 11 THEN Msg = Msg||' '||File.b
 END
 /* Use the NOTIFY program to tell the user the files came in */
 ADDRESS "CMD" "START Notify BEEP=YES TITLE=LANXCopy MESSAGE="Msg
 /* Immediately clear screen and start the LANXCOPY again */
 ADDRESS "CMD" "Cls"
END
