/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if( argCount >= 1 ) then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         ChkError
*/
/*  Check for a database system error.

    If Globals.!Abort is not set and any of these errors have occurred, then
    display a message, call Quit and set Globals.!Abort.

    If Globals.!Abort is set, then an error has already occurred and we are
    winding down so do not display a message.

    Return 0 if there is an error and 1 if all is okay.
*/
ChkError: procedure expose Globals. SQLCA. SQLMSG
    parse arg msg

    ok = 1
    if( Globals.!Abort ) then do
        ok = 0
        signal ChkErrorQuit
    end

    i = 1
    if( Globals.!DBtype = 'WSQL' ) then do
        if( SQLCA.SQLCODE < 0 ) then do
                ok = 0
                i = i + 1
                stem.i = ""
                i = i + 1
                stem.i = SQLCA.SQLCODE || ": " || SQLMSG
        end
    end
    else do /* DB2 */
        if( SQLCA.SQLCODE \= 0 ) then do
            ok = 0
            i = i + 1
            stem.i = ""
            i = i + 1
            stem.i = "IBM DB2/2 Error Code:  " || SQLCA.SQLCODE
        end
    end

    if( \ok ) then do
        stem.0 = i
        stem.1 = msg
        call VRMessageStem VRWindow(), "stem.", "Error", "Error"
    end

ChkErrorQuit:
return ok

/*:VRX         Commit
*/
Commit: procedure expose Globals.
    call SQLEXEC "COMMIT"
    ok = ChkError( "Error committing transaction." )
    if( \ok ) then do
        signal CTDone
    end
    ok = StartQuery( 0 )
    if( \ok ) then do
        signal CTDone
    end
CTDone:
return ok

/*:VRX         Confirm
*/
/*  Ask for confirmation before performing an operation.
    Return 1 if it is okay to continue and 0 otherwise.
*/
Confirm: procedure
    parse arg change, msg
    if( \change ) then do
        ok = 1
    end
    else do
        buttons.1 = "~OK"
        buttons.2 = "Cancel"
        buttons.0 = 2
        ok = VRMessage( VRWindow(), msg, "Employee database", "W", "buttons.", 2, 2 ) = 1
    end
return ok
/*:VRX         EF_Comm_Change
*/
EF_Comm_Change:
    Globals.!Change = 1
return

/*:VRX         EF_Dept_Change
*/
EF_Dept_Change:
    Globals.!Change = 1
return

/*:VRX         EF_Id_Change
*/
EF_Id_Change:
    Globals.!Change = 1
return

/*:VRX         EF_Job_Change
*/
EF_Job_Change:
    Globals.!Change = 1
return

/*:VRX         EF_Name_Change
*/
EF_Name_Change:
    Globals.!Change = 1
return

/*:VRX         EF_Salary_Change
*/
EF_Salary_Change:
    Globals.!Change = 1
return

/*:VRX         EF_Years_Change
*/
EF_Years_Change:
    Globals.!Change = 1
return

/*:VRX         EmployeeInfo_Close
*/
EmployeeInfo_Close:
    if( Confirm( Globals.!Change, "Changes made to the current employee will not be saved." ) ) then do
        call Quit
    end
return

/*:VRX         Fetch
*/

/*  Fetch the next or previous record from the STAFF table.
*/
Fetch: procedure expose Globals.
    parse arg next

    if( Globals.!DBType = "WSQL" ) then do
        if( next ) then do 
            direction = 1
        end
        else do
            direction = -1
        end
        call sqlexec "FETCH RELATIVE" direction "c1 INTO :Globals.!Emp.!name :ind.1,",
                                   ":Globals.!Emp.!id :ind.2,",
                                   ":Globals.!Emp.!job :ind.3,",
                                   ":Globals.!Emp.!dept.!value :ind.4,",
                                   ":Globals.!Emp.!salary :ind.5,",
                                   ":Globals.!Emp.!comm :ind.6,",
                                   ":Globals.!Emp.!years :ind.7"
        if( SQLCA.SQLCODE = 100 ) then do
            call sqlexec "FETCH RELATIVE" (-direction) "c1 INTO :Globals.!Emp.!name :ind.1,",
                                   ":Globals.!Emp.!id :ind.2,",
                                   ":Globals.!Emp.!job :ind.3,",
                                   ":Globals.!Emp.!dept.!value :ind.4,",
                                   ":Globals.!Emp.!salary :ind.5,",
                                   ":Globals.!Emp.!comm :ind.6,",
                                   ":Globals.!Emp.!years :ind.7"
        end
    end
    else do /* DB2/2 - NB only forward fetch */
        call sqlexec "FETCH c1 INTO :Globals.!Emp.!name :ind.1,",
                                   ":Globals.!Emp.!id :ind.2,",
                                   ":Globals.!Emp.!job :ind.3,",
                                   ":Globals.!Emp.!dept.!value :ind.4,",
                                   ":Globals.!Emp.!salary :ind.5,",
                                   ":Globals.!Emp.!comm :ind.6,",
                                   ":Globals.!Emp.!years :ind.7"
    end

    ok = ChkError( "Error fetching record." )
    Globals.!Change = ok
    if( ind.1 < 0 ) then do
        Globals.!Emp.!name = ""
    end
    if( ind.2 < 0 ) then do
        Globals.!Emp.!id = ""
    end
    if( ind.3 < 0 ) then do
        Globals.!Emp.!job = ""
    end
    if( ind.4 < 0 ) then do
        Globals.!Emp.!dept.!value = ""
    end
    if( ind.5 < 0 ) then do
        Globals.!Emp.!salary = ""
    end
    if( ind.6 < 0 ) then do
        Globals.!Emp.!comm = ""
    end
    if( ind.7 < 0 ) then do
        Globals.!Emp.!years = ""
    end
return ok

/*  Position the cursor to a specified employee.
*/
PosCursor: procedure expose Globals.
    parse arg empid
    if( \StartQuery( 0 ) ) then do
        signal PCDone
    end
    if( empid = "" ) then do
        ok = Fetch( 1 )
    end
    else do
        do until( ( Globals.!Emp.!id = empid ) | \ok )
            ok = Fetch( 1 )
        end
    end
    if( ok ) then do
        call SetFields
    end
PCDone:
return ok
/*:VRX         Fini
*/
Fini:
    call VRSet VRWindow(), "Visible", 0
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
/*  Assume called as empform( <parent> ).

    Allow employee records of the STAFF table in the SAMPLE database
    supplied with IBM Database Manager to be viewed, modified, deleted
    and created.
*/
Init: procedure expose Globals.

/*  Global variables

    Abort               1 if shutting down after an error
    Change              1 if a value on the window has changes
    CommitRequired      1 if changes pending
    DBType              NONE, WSQL, DB2/2
    Emp.                Current employee info
*/
    Globals. = 0

    window = VRWindow()

    /* Determine type of database access the user wants.
    */
    Globals.!DBType = DBSelect( window )
    if( Globals.!DBType = "NONE") then do
        call Quit
        signal InitDone
    end
    
    /* If we are using DB2/2, disable the Previous button
    */
    if( Globals.!DBType = "DB2/2" ) then do
        call VRSet "PB_Prev", "Enabled", 0
    end

    /*  Make the main window visible and active.
    */
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    /*  Load the appropriate REXX API library
    */
    call RxFuncDrop 'SQLDBS'
    call RxFuncDrop 'SQLEXEC'
    if( Globals.!DBtype = 'WSQL' ) then do
        call RxFuncAdd 'SQLDBS', 'WSQLCAL2', 'WSQLEXECREXX'
        call RxFuncAdd 'SQLEXEC', 'WSQLCAL2', 'WSQLEXECREXX'
    end
    else do /* DB2/2 */
        call RxFuncAdd 'SQLDBS', 'SQLAR', 'SQLDBS'
        call RxFuncAdd 'SQLEXEC', 'SQLAR', 'SQLEXEC'
    end

    /*  Connect to the database program of choice.
    */
    if( \DBInit() ) then do
        signal InitDone
    end

    /*  Begin viewing records in the STAFF table.
    */
    if( \StartQuery( 1 ) ) then do
        signal InitDone
    end
    if( \Fetch( 1 ) ) then do
        signal InitDone
    end
    call SetFields

InitDone:
return


/*  Connect to the database and watch for syntax errors which result from
    unloaded DLLs
*/
DBInit: procedure expose Globals.
    signal on SYNTAX name DBInitFailed
    signal on FAILURE name DBInitFailed

    /*  Start the database engine
    */
    call sqldbs "START DATABASE MANAGER"
    if( SQLCA.SQLCODE \= -1026  &  SQLCA.SQLCODE \= -1063 ) then do
        if( \ChkError( "Error starting" Globals.!DBtype ) ) then do
            Globals.!Abort = 1
            signal DBInitDone
        end
    end

    /*  Open the database
    */
    if( Globals.!DBtype = "WSQL" ) then do
        call sqldbs "START USING DATABASE DB22SAMP USER DBA IDENTIFIED BY SQL"
    end
    else do /* DB2/2 */
        call sqldbs "START USING DATABASE SAMPLE"
    end
    if( \ChkError( "Error connecting to the database." ) ) then do
        Globals.!Abort = 1
        signal DBInitDone
    end
return 1

DBInitDone:
return 0

DBInitFailed:
    /* Display message indicating that the DLL was not loaded
    */
    call VRMessage VRWindow(), "Cannot load or invalid DLL.", "Startup", "Error"
    call VRSet VRWindow(), "Shutdown", 1
return 0

/*:VRX         PB_Delete_Click
*/
/*  Delete the record for the current employee.
*/
PB_Delete_Click:
    if( \Confirm( 1, "This employee record will be deleted." ) ) then do
        signal PB_Delete_Click_Quit
    end

    stmt = "DELETE FROM STAFF WHERE ID=" || Globals.!Emp.!id
    call SQLEXEC "EXECUTE IMMEDIATE :stmt"

    if( \ChkError( "Error deleting employee record." ) ) then do
        signal PB_Delete_Click_Quit
    end

    Globals.!CommitRequired = 1
    call PosCursor ""

PB_Delete_Click_Quit:
return
/*:VRX         PB_First_Click
*/
PB_First_Click:
    if( Confirm( Globals.!Change, "All changes to the current employee will be lost." ) ) then do
        call PosCursor ""
    end
return

/*:VRX         PB_New_Click
*/
/*  Insert a new record into the STAFF table using
    the current field values.
*/
PB_New_Click:
    if( \Globals.!Change ) then do
        buttons.1 = "~Yes"
        buttons.2 = "~No"
        buttons.0 = 2
        if( VRMessage( VRWindow(), "Duplicate this employee record?",,
                "Employee database", "W", "buttons.", 2, 2 ) = 2 ) then do
            signal NCDone
        end        
    end

    if( VRGet( "EF_Id", "Value" ) = "" ) then do
        call VRMessage VRWindow(), "The employee ID cannot be null.", "Update", "Warning"
        call VRSet "EF_Id", "Value", Globals.!Emp.!id
        call VRMethod "EF_Id", "SetFocus"
        signal NCDone
    end

    empid = Globals.!Emp.!id
    call GetFields
 
    stmt = "INSERT INTO staff (name,id,job,dept,salary,comm,years) VALUES ('" ,
            || Globals.!Emp.!name || "'," || Globals.!Emp.!id || ",'" ,
            || Globals.!Emp.!job || "'," || Globals.!Emp.!dept.!value || "," ,
            || Globals.!Emp.!salary || "," || Globals.!Emp.!comm || "," ,
            || Globals.!Emp.!years || ")"
    call SQLEXEC "EXECUTE IMMEDIATE :stmt"

    if( \ChkError( "Error creating record." ) ) then do
        signal NCDone
    end
    Globals.!CommitRequired = 1
    call PosCursor Globals.!Emp.!id

NCDone:
return
/*:VRX         PB_Next_Click
*/
PB_Next_Click:
    if( Confirm( Globals.!Change, "All changes to the current employee will be lost." ) ) then do
        if( Fetch( 1 ) ) then do
            call SetFields
        end
    end
return

/*:VRX         PB_Prev_Click
*/
PB_Prev_Click:
    if( Confirm( Globals.!Change, "All changes to the current employee will be lost." ) ) then do
        if( Fetch( 0 ) ) then do
            call SetFields
        end
    end
return

/*:VRX         PB_Quit_Click
*/
PB_Quit_Click:
    if( Confirm( Globals.!Change, "Changes made to the current employee will not be saved." ) ) then do
        call Quit
    end
return

/*:VRX         PB_Update_Click
*/
/*  Update the current employee data with the values
    in the entry fields.
*/
PB_Update_Click:
    if( \Globals.!Change ) then do
        call VRMessage VRWindow(), "No changes have been made.", "Update"
        signal PB_Update_Click_Quit
    end

    if( VRGet( "EF_Id", "Value" ) = "" ) then do
        call VRMessage VRWindow(), "The employee ID cannot be null.", "Update", "Warning"
        call VRSet "EF_Id", "Value", Globals.!Emp.!id
        call VRMethod "EF_Id", "SetFocus"
        signal PB_Update_Click_Quit
    end

    empid = Globals.!Emp.!id
    call GetFields

    stmt = "UPDATE staff SET " ,
            || "name='" || Globals.!Emp.!name || "'," ,
            || "id=" || Globals.!Emp.!id || "," ,
            || "job='" || Globals.!Emp.!job || "'," ,
            || "dept=" || Globals.!Emp.!dept.!value || "," ,
            || "salary=" || Globals.!Emp.!salary || "," ,
            || "comm=" || Globals.!Emp.!comm || "," ,
            || "years=" || Globals.!Emp.!years || " where id=" || empid
    call SQLEXEC "EXECUTE IMMEDIATE :stmt"

    if( \ChkError( "Error executing SQL Update." ) ) then do
        signal PB_Update_Click_Quit
    end
    Globals.!CommitRequired = 1
    call PosCursor Globals.!Emp.!id

PB_Update_Click_Quit:
return

/*:VRX         Quit
*/
Quit:
    if( Confirm( Globals.!CommitRequired, "You have made changes to the database.",
                        "To commit the changes you have made, click on OK.",
                        "To exit without saving your changes, click on Cancel." ) ) then do
        if( Globals.!CommitRequired ) then do
            call Commit
        end
    end
    else do
        call Rollback
    end

    /*  Close the database
    */
    if( Globals.!DBtype = "WSQL" ) then do
        call sqldbs "STOP USING DATABASE ALL"
        call ChkError "Error disconnecting from database."
    end
    else if( Globals.!DBType = "DB2/2" ) then do
        call sqldbs "STOP USING DATABASE"
        call ChkError "Error disconnecting from database."
        call sqldbs "STOP DATABASE MANAGER"
        call ChkError "Error stopping DB2/2."
    end

    call VRSet VRWindow(), "Shutdown", 1
return

/*:VRX         Rollback
*/
Rollback: procedure expose Globals.
    call SQLEXEC "ROLLBACK"
return ChkError( "Error rolling back transaction." )

/*:VRX         SetFields
*/
/*  Display the data for the current employee record.
*/
SetFields: procedure expose Globals.
    
    /*  Do some additional formatting if using DB2/2
    */
    if( Globals.!DBType = "DB2/2" ) then do
        if( Globals.!Emp.!salary \= "" ) then do
            Globals.!Emp.!salary = FORMAT( Globals.!Emp.!salary, , 2 )
        end
        if( Globals.!Emp.!comm \= "" ) then do
            Globals.!Emp.!comm = FORMAT( Globals.!Emp.!comm, , 2 )
        end
    end

    /*  Set the field values
    */
    call VRSet "EF_Name", "Value", Globals.!Emp.!name
    call VRSet "EF_Id", "Value", Globals.!Emp.!id
    call VRSet "EF_Job", "Value", Globals.!Emp.!job
    call VRSet "EF_Dept", "Value", Globals.!Emp.!dept.!value
    call VRSet "EF_Salary", "Value", Globals.!Emp.!salary
    call VRSet "EF_Comm", "Value", Globals.!Emp.!comm
    call VRSet "EF_Years", "Value", Globals.!Emp.!years
    call FlushEvents
    Globals.!Change = 0
return

/*  Get the data for the current employee record.
*/
GetFields: procedure expose Globals.
    Globals.!Emp.!name = VRGet( "EF_Name", "Value" )
    Globals.!Emp.!id = VRGet( "EF_Id", "Value" )
    Globals.!Emp.!job = VRGet( "EF_Job", "Value" )
    Globals.!Emp.!dept = VRGet( "EF_Dept", "Value" )
    Globals.!Emp.!salary = VRGet( "EF_Salary", "Value" )
    Globals.!Emp.!comm = VRGet( "EF_Comm", "Value" )
    Globals.!Emp.!years = VRGet( "EF_Years", "Value" )

    /*  Replace empty numeric field values with NULL.
    */
    if( Globals.!Emp.!dept = "" ) then do
        Globals.!Emp.!dept = "NULL"
    end
    if( Globals.!Emp.!salary = "" ) then do
        Globals.!Emp.!salary = "NULL"
    end
    if( Globals.!Emp.!comm = "" ) then do
        Globals.!Emp.!comm = "NULL"
    end
    if( Globals.!Emp.!years = "" ) then do
        Globals.!Emp.!years = "NULL"
    end
return

/*  Flush all events from the queue.
*/
FlushEvents: procedure
    do until( Translate( VREvent( "N" ) ) = "NOP" )
    end
return

/*:VRX         StartQuery
*/
/*  Start the SQL statement which will allow records in the STAFF table
    to be viewed.
*/
StartQuery: procedure expose Globals.
    arg closed

    ok = 0

    /*  If the cursor is still open, close it now
    */
    if( closed = 0 ) then do
        call sqlexec "CLOSE c1"
        if( \ChkError( "Error closing cursor." ) ) then do
            signal SQDone
        end
    end

    /*  Prepare the query
    */
    stmt = "SELECT name, id, job, dept, salary, comm, years",
           "FROM staff ",
           "ORDER BY name"
    call sqlexec "PREPARE s1 FROM :stmt"   
    if( \ChkError( "Error preparing statement." ) ) then do
        signal SQDone
    end

    /*  Declare the cursor
    */
    call sqlexec "DECLARE c1 CURSOR FOR s1"
    if( \ChkError( "Error declaring cursor." ) ) then do
        signal SQDone
    end

    /*  Open the cursor 
    */
    call sqlexec "OPEN c1"
    if( \ChkError( "Error opening cursor." ) ) then do
        signal SQDone
    end

    ok = 1

SQDone:
return ok

