/* REXX *********************************************/
/*                                                  */
/* Program name: RSTRFNC                            */
/* Function    : Restore Backup after the failing   */
/*               installation                       */
/*               example for the post-install-      */
/*               failure exit                       */
/*                                                  */
/* Syntax      : Call from the INSTALL.DAT via:     */
/*         START_REXX_IF_FAILURE=RESTOREP dest_path */
/*                                                  */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  21 May 1996 / 21:22:36   JRK */
/****************************************************/
Parse Arg destPath
/*-------------(Write lines into file)--------------*/
filename    = destPath'\install.log'
rc = LineOut( filename, 'Destination Directory:' destPath)

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

/*--------------(Save directory)---------------*/
directory = destPath||'\SAVEPREV'
/*-----------(Find file/Set attributes)-------------*/
rc = SysFileTree( directory||'\*.*', fileList, 'FO' )
Do i = 1 To fileList.0
  /*------------------(copy file)-------------------*/
  a = "unpack" fileList.i destPath||"\"
  "unpack" fileList.i destPath||"\ >>NUL"
  If rc = 0 Then delRC = SysFileDelete( fileList.i )
  Queue Date( S ) Time() a || ', RC='rc
End /* If ... */

/*================(End this program)================*/
Return

CLEARUP:
Return
