#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/orb/RCS/Connection.py,v $
# Version:      @(#)$RCSfile: Connection.py,v $ $Revision: 1.2 $
#
#############################################################################
""" Abstract Connection class. """


class Connection:
    """ Abstract Connection class. """

    def connect(self):
	""" Connect to the remote object. """
	
	pass

    def disconnect(self):
	""" Disconnect from the remote object. """
	
	pass

    def send(self, data):
	""" Send as much of the data as we can.

	Returns the number of bytes actually sent.

	"""
	pass

    def recv(self, n):
	""" Receive at most 'n' bytes of data.

	Returns the data received.

	"""
	pass

    def is_connected(self):
	""" Are we connected to the remote object? """

	pass

    def blocking(self, blocking):
	""" Set the connection to blocking (1) or non-blocking (0). """

	pass

    def handle(self):
	""" Return my underlying I/O handle. """

	pass

#############################################################################
