#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/cos/interface_repository/RCS/IFR.py,v $
# Version:      @(#)$RCSfile: IFR.py,v $ $Revision: 1.4 $
#
#############################################################################
""" The Fnorb Interface Repository. """


# Standard/built-in modules.
import getopt, sys

# Fnorb modules.
from Fnorb.orb import BOA, CORBA

# Interface Repository modules.
import IntRepImpl


class IFR:
    """ The Fnorb Interface Repository. """

    def __init__(self, argv):
	""" Constructor. """

	# Process command line options.
	#
	# The only options currently allowed are:-
	#
	# '-?, -h, --help'  to print the usage message on stdout.
	# '--ior'           to print the IOR of the root context on stdout.
	options = self.__get_options(argv)

	# Create an object reference.
	boa = BOA.BOA_init()
	obj = boa.create('Fnorb IFR', IntRepImpl.RepositoryImpl._FNORB_ID)

	# Create an instance of the implementation class.
	impl = IntRepImpl.RepositoryImpl()

	# Activate the implementation.
	boa.obj_is_ready(obj, impl)

	# If requested (via a command line option) then print the stringified
	# IOR of the interface repository on stdout.
	if options.has_key('--ior'):
	    orb = CORBA.ORB_init()
	    sys.stdout.write(orb.object_to_string(obj))
	    sys.stdout.write('\n')
	    sys.stdout.flush()

    	return

    #########################################################################
    # Internal interface.
    #########################################################################

    def __get_options(self, argv):
	""" Get the command line options. """

	# Parse the command line options.
	try:
	    (options, rest) = getopt.getopt(argv[1:],
					    '?h',
					    ['help', 'ior'])
	except getopt.error:
	    self.__usage()

	# Put the options in a dictionary for convenience.
	dictionary = {}
	for (name, value) in options:
	    dictionary[name] = value

	# If the help option was specified then just print the usage and exit!
	if dictionary.has_key('-?') \
	   or dictionary.has_key('-h') \
	   or dictionary.has_key('--help'):
	    self.__usage()

	return dictionary

    def __usage(self):
	""" Print the 'usage' message on stdout and exit! """

	print 'Usage: fnifr [options]'
	print 
	print 'Options:'
	print '-?, -h, --help    ',
	print 'Show this message.'
	print '--ior             ',
	print 'Print the IOR of the interface repository on stdout.'

	sys.exit(0)

#############################################################################
