#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/script/RCS/cpp.py,v $
# Version:      @(#)$RCSfile: cpp.py,v $ $Revision: 1.2 $
#
#############################################################################
""" Module to determine the command to run the C/C++ pre-processor. """


# Standard/built-in modules.
import commands, sys


# Commands to run the C/C++ pre-processor on Unixen and Windows 95/NT.
if sys.platform == 'win32':
    # By default, we use the pre-processor that comes with MS Visual C/C++.
    COMMAND = 'cl /nologo /E %s %s'
    
    # If you use 'gcc' then uncomment this instead!
##    COMMAND = 'gcc -x c -E %s %s'

# OS/2
elif sys.platform == 'os2':
    # By default, we use the pre-processor that comes with IBM VisualAge C/C++.
    COMMAND = 'icc /Q /W0 /Pc+ /Pd+ /Pe+ %s %s'
    
    # If you use 'gcc' then uncomment this instead!
##    COMMAND = 'gcc -x c -E %s %s'

# Unixen.
else:
    # Look for the forces of goodness and light first ;^)
    (result, output) = commands.getstatusoutput('which gcc')
    if result == 0:
	COMMAND = 'gcc -x c -E %s %s'

    # And then the other stuff!
    else:
	(result, output) = commands.getstatusoutput('which cpp')
	if result == 0:
	    COMMAND = 'cpp %s %s'

	else:
	    raise "No C/C++ pre-processor on your $PATH!"

#############################################################################
