#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/orb/RCS/GIOPClientManager.py,v $
# Version:      @(#)$RCSfile: GIOPClientManager.py,v $ $Revision: 1.4 $
#
#############################################################################
""" GIOP Client Manager module. """


# Fnorb modules.
import fnorb_thread, CORBA, GIOPClient


def GIOPClientManager_init():
    """ Initialise the GIOP Client Manager.

    This is a factory function for the GIOPClientManager class (the
    GIOPClientManager is a singleton (ie. there can only be one
    GIOPClientManager instance per process)).

    """
    GIOPClientManager._lk.acquire()
    try:
	gcm = GIOPClientManager()

    except GIOPClientManager, gcm:
	pass
    GIOPClientManager._lk.release()

    return gcm


class GIOPClientManager:
    """ The GIOPClientManager object.

    The GIOPClientManager is a singleton (ie. there can only be one
    GIOPClientManager instance per process).

    """
    # Singleton instance.
    __instance = None

    # Mutex to make access via the factory function thread-safe.
    _lk = fnorb_thread.allocate_lock()

    def __init__(self):
	""" Constructor. """

	# The GIOPClientManager is a singleton (ie. there can only be one
	# GIOPClientManager instance per process).
	if GIOPClientManager.__instance is not None:
	    raise GIOPClientManager.__instance

	GIOPClientManager.__instance = self

	# A dictionary of GIOP clients that are connected to remote objects.
	self.__clients = {} # {Address: (GIOPClient, ReferenceCount)}

	# A mutex to make access to the client dictionary thread-safe.
	self.__lk = fnorb_thread.allocate_lock()

	return

    #########################################################################
    # GIOPClientManager interface.
    #########################################################################

    def get_client(self, ior, protocol=None):
	""" Get a client for the specified IOR. """

	# If no particular protocol was specified then we use the first one
	# that we can get an address from.
	if protocol is None:
	    for protocol in CORBA.ORB_init()._fnorb_protocols():
		address = protocol.get_address(ior)
		if address is not None:
		    break

	    else:
		address = None

	# Otherwise, we get the address from the specified protocol.
	else:
	    address = protocol.get_address(ior)

	# If no address was found then barf!
	if address is None:
	    raise CORBA.INV_OBJREF() # System exception.

	# The dictionary of clients is keyed on the address.
	self.__lk.acquire()
	try:
	    # If we already have a client connected to this address then use
	    # that.
	    if self.__clients.has_key(address):
		(client, refcount) = self.__clients[address]
		self.__clients[address] = (client, refcount + 1)

	    # Else create a new client and connect it to the remote object.
	    else:
		client = GIOPClient.GIOPClient(protocol, address)
		self.__clients[address] = (client, 1)
		
	finally:
	    self.__lk.release()

	return client

    def delete_client(self, ior, protocol=None):
	""" Delete the client for the specified IOR. """

	# If no particular protocol was specified then we use the first one
	# that we can get an address from.
	if protocol is None:
	    for protocol in CORBA.ORB_init()._fnorb_protocols():
		address = protocol.get_address(ior)
		if address is not None:
		    break

	    else:
		address = None

	# Otherwise, we get the address from the specified protocol.
	else:
	    address = protocol.get_address(ior)

	# If no address was found then barf!
	if address is None:
	    raise CORBA.INV_OBJREF() # System exception.

	# The dictionary of clients is keyed on the address.
	self.__lk.acquire()
	try:
	    (client, refcount) = self.__clients[address]
	    if refcount == 1:
		# Remove the client from our table.
		del self.__clients[address]

		# Call the pseudo destructor to clean up circular references.
		client.pseudo__del__()

	    else:
		self.__clients[address] = (client, refcount - 1)
		
	finally:
	    self.__lk.release()

	return

#############################################################################
