#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/orb/RCS/Fixed.py,v $
# Version:      @(#)$RCSfile: Fixed.py,v $ $Revision: 1.2 $
#
#############################################################################
""" Implementation of CORBA 'fixed' type (fixed point decimals).

** Warning **

This is just a start - it is in nowhere near complete, and is just intended to
get the IDL parsed - the Fnorb runtime does not handle the 'fixed' type. Even
arithmetic for constant expressions isn't handled!!!!!!

*************

"""

# Standard/built-in modules.
import string

# Fnorb modules.
import CORBA


class Fixed:
    """ Implementation of CORBA 'fixed' type (fixed point decimals). """

    def __init__(self, precision, decimals, value=None):
	""" Constructor.
	
	'precision' is the number of significant digits.
	'decimals'  is the number of decimals.
	'value'     is an integer value containing the significant digits.

	"""
	self.__precision = digits
	self.__decimals = scale

	if value is not None:
	    self.__value = value

	return

    #########################################################################
    # Methods for arithmetic operations!
    #########################################################################

    def __add__(self, other):
	""" Addition ;^) """

	if not isinstance(other, Fixed):
	    raise TypeError, "Mixed mode arithmetic not allowed."

	raise 'Fixed point arithmetic not supported by Fnorb.'

    def __sub__(self, other):
	""" Subtraction ;^) """

	if not isinstance(other, Fixed):
	    raise TypeError, "Mixed mode arithmetic not allowed."

	raise 'Fixed point arithmetic not supported by Fnorb.'

    def __mul__(self, other):
	""" Multiplication ;^) """

	if not isinstance(other, Fixed):
	    raise TypeError, "Mixed mode arithmetic not allowed."

	raise 'Fixed point arithmetic not supported by Fnorb.'

    def __div__(self, other):
	""" Division ;^) """

	if not isinstance(other, Fixed):
	    raise TypeError, "Mixed mode arithmetic not allowed."

	raise 'Fixed point arithmetic not supported by Fnorb.'

    def __neg__(self):
	""" Unary '-' """

	raise 'Fixed point arithmetic not supported by Fnorb.'

    def __pos__(self):
	""" Unary '+' """

	raise 'Fixed point arithmetic not supported by Fnorb.'

    #########################################################################
    # CORBA interface.
    #########################################################################

    def value(self):
	""" Return the significant digits as an integer. """

	return self.__value

    def precision(self):
	""" Return the number of significant digits. """

	return self.__precision

    def decimals(self):
	""" Return the number of decimals. """

	return self.__decimals

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_from_literal(self, literal):
	""" Initialise the instance from a literal. """

	# Is there a decimal point?
	point = string.find(literal, '.')

	# Nope!
	if point == -1:
	    significant = literal[:-1] # The '-1' drops the 'd' or 'D'.
	    fraction = ''

	# Yep!
	else:
	    significant = literal[:point]
	    fraction = literal[point+1:-1] # The '-1' drops the 'd' or 'D'.

	# Concatenate all of the (possibly!) significant digits.
	significant = significant + fraction

	# Count the leading and trailing zeroes.
	leading = self.__count_leading_zeroes(significant)
	trailing = self.__count_trailing_zeroes(significant)

	# Strip the leading and trailing zeroes and evalute the string to get
	# the integer representation.
	self.__value = eval(significant[leading:len(significant) - trailing])

	# Set the number of significant digits.
	self.__precision = len(str(self.__value))

	# Set the number of decimals.
	self.__decimals = len(fraction) - trailing

	return

    def _fnorb_typecode(self):
	""" Return a typecode for the instance. """

	return CORBA.FixedTypeCode(self.__precision, self.__decimals)

    def _fnorb_marshal(self, cursor):
	""" Marshal myself onto an octet stream. """

	raise "Can't marshal fixed point decimals!"

    def _fnorb_unmarshal(self, cursor):
	""" Unmarshal myself from an octet stream. """

	raise "Can't unmarshal fixed point decimals!"

    #########################################################################
    # Private interface.
    #########################################################################

    def __count_leading_zeroes(self, s):
	""" Count the leading zeroes in the string 's'. """

	count = 0
	for i in range(len(s)):
	    if s[i] != '0':
		break

	    count = count + 1

	return count

    def __count_trailing_zeroes(self, s):
	""" Count the trailing zeroes in the string 's'. """

	count = 0
	for i in range(len(s) - 1, -1, -1):
	    if s[i] != '0':
		break

	    count = count + 1

	return count

#############################################################################

# Testing.
if __name__ == '__main__':

    import new, sys

    f = new.instance(Fixed, {})
    f._fnorb_from_literal(sys.argv[1])

    print 'Typecode:', f._fnorb_typecode().__dict__

#############################################################################
