#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/cos/interface_repository/RCS/IntRepImpl.py,v $
# Version:      @(#)$RCSfile: IntRepImpl.py,v $ $Revision: 1.11 $
#
#############################################################################
""" Implementation of the Interface Repository interfaces. """


# Fnorb modules.
from Fnorb.orb import BOA, CORBA, Util

# Stubs and skeletons.
import IntRep, IntRep_skel


class IRObjectImpl(IntRep_skel.IRObject_skel):
    """ Interface: IDL:omg.org/CORBA/IRObject:1.0 """

    def __init__(self, def_kind):
	""" Constructor. """

	# Definition kind.
	self._def_kind = def_kind

	return

    #########################################################################
    # IRObject interface.
    #########################################################################

    def _get_def_kind(self):
        """ Attribute: IDL:omg.org/CORBA/IRObject/def_kind:1.0 """

	return self._def_kind

    def destroy(self):
        """ Operation: IDL:omg.org/CORBA/IRObject/destroy:1.0 """

	raise 'IRObjectImpl.destroy: called!'

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_register_impl(self, object_key, intrep_id, impl):
	""" Register an implementation with the object adapter. """

	# Get a reference to the BOA.
	boa = BOA.BOA_init()

	# Create an object reference for the implementation.
	objref = boa.create(object_key, intrep_id)

	# Connect the object reference to the implementation.
	boa.obj_is_ready(objref, impl)

	return


class IDLTypeImpl(IntRep_skel.IDLType_skel, IRObjectImpl):
    """ Interface: IDL:omg.org/CORBA/IDLType:1.0 """

    def __init__(self, def_kind):
	""" Constructor. """

	# Base class constructor.
	IRObjectImpl.__init__(self, def_kind)

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	raise 'This method should be overridden!'


class ContainedImpl(IntRep_skel.Contained_skel, IRObjectImpl):
    """ Interface: IDL:omg.org/CORBA/Contained:1.0 """

    # fixme: Can't instantiate.
    def __init__(self, def_kind, id, name, version, defined_in):
	""" Constructor. """

	# Base class constructor.
	IRObjectImpl.__init__(self, def_kind)

	# Attributes specific to this class.
	self._id = id
	self._name = name
	self._version = version
	self._defined_in = defined_in

	return

    #########################################################################
    # IRObject interface.
    #########################################################################

    def destroy(self):
        """ Operation: IDL:omg.org/CORBA/IRObject/destroy:1.0 """

	# Delete myself from from my container.
	self._defined_in._delete(self._name)

	return

    #########################################################################
    # Contained interface.
    #########################################################################

    def _get_id(self):
        """ Attribute: IDL:omg.org/CORBA/Contained/id:1.0 """

	return self._id

    def _set_id(self, id):
        """ Attribute: IDL:omg.org/CORBA/Contained/id:1.0 """

	self._id = id
	return

    def _get_name(self):
        """ Attribute: IDL:omg.org/CORBA/Contained/name:1.0 """

	return self._name

    def _set_name(self, name):
        """ Attribute: IDL:omg.org/CORBA/Contained/name:1.0 """

	self._name = name
	return

    def _get_version(self):
        """ Attribute: IDL:omg.org/CORBA/Contained/version:1.0 """

	return self._version

    def _set_version(self, version):
        """ Attribute: IDL:omg.org/CORBA/Contained/version:1.0 """

	self._version = version

	if self._id[:4] == 'IDL:':
	    # Create an interface repository id instance from the string.
	    ifr_id = Util.RepositoryId(self._id)

	    # Set the version.
	    ifr_id.set_version(version)

	    # Update the id.
	    self._id = str(ifr_id)

	return

    def _get_defined_in(self):
        """ Attribute: IDL:omg.org/CORBA/Contained/defined_in:1.0 """

	return self._defined_in

    def _get_absolute_name(self):
        """ Attribute: IDL:omg.org/CORBA/Contained/absolute_name:1.0 """

	# If the object is defined within a 'Repository', then the 'absolute
	# name' is the concatenation of '::' and the object's name attribute.
	if self._defined_in._get_def_kind() == IntRep.dk_Repository:
	    # fixme: The spec. says that all absolute names should start with
	    # '::', but OmniBroker puts no prefix on top level names!
##	    prefix = '::'
	    prefix = ''

	# Otherwise, the 'absolute name' is the concatentation of the
	# 'absolute name' of the containing object and the object's name
	# attribute.
	else:
	    prefix = self._defined_in._get_absolute_name() + '::'

	return prefix + self._name

    def _get_containing_repository(self):
        """ Attribute: IDL:omg.org/CORBA/Contained/containing_repository:1.0"""

	# Find the repository that we are defined in.
	defined_in = self._defined_in
	while defined_in._get_def_kind() != IntRep.dk_Repository:
	    defined_in = defined_in._get_defined_in()

        return defined_in

    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	raise 'Contained: describe called!', self, self.__class__
    
    def move(self, new_container, new_name, new_version):
        """ Operation: IDL:omg.org/CORBA/Contained/move:1.0 """

	# The OmniBroker utility 'irfeed' actually passes an Interface
	# Repository Id as the 'new_name', when the spec. says it should just
	# be an 'Identifier' (ie. a simple name).
	#
	# This hack checks for a repository id and extracts the last component
	# of its scoped name to use as the 'new_name'.
	if new_name[:4] == 'IDL:':
	    # Create an interface repository id instance from the string.
	    intrep_id = Util.RepositoryId(new_name)

	    # Get the scoped name from the repository id.
	    scoped_name = intrep_id.scoped_name()

	    # The new name is actually just the *last* component of the scoped
	    # name.
	    new_name = scoped_name[-1]

	# Add myself to the new container.
	new_container._contents.append(self)

	# Delete myself from from the old container.
	self._defined_in._delete(self._name)

	# Update the details.
	self._defined_in = new_container
	self._name = new_name
	self._version = new_version

	return

    #########################################################################
    # Internal methos.
    #########################################################################

    def _get_defined_in_id(self):
	""" Get the repository id of the container that we are defined in. """

	if self._defined_in._is_a('IDL:omg.org/CORBA/Repository:1.0'):
	    id = ''

	else:
	    id = self._defined_in._get_id()

	return id


class ContainerImpl(IntRep_skel.Container_skel, IRObjectImpl):
    """ Interface: IDL:omg.org/CORBA/Container:1.0

    This is an abstract interface (ie. it should not be instantiated). There
    are currently 3 concrete 'Container' interfaces:-

    1) Repository
    2) ModuleDef
    3) InterfaceDef

    """
    def __init__(self, def_kind):
	""" Constructor. """

	# Base class constructor.
	IRObjectImpl.__init__(self, def_kind)
 
	# A list of definitions ('Contained' instances) contained in this
	# container.
	self._contents = []

	return

    #########################################################################
    # Container interface.
    #########################################################################

    def lookup(self, search_name):
        """ Operation: IDL:omg.org/CORBA/Container/lookup:1.0

	This method is inherited by 'ModuleDefImpl' and 'InterfaceDefImpl', and
	and is overridden by 'RepositoryImpl'.

	"""
	# Create a ScopedName instance from the string.
	scoped_name = Util.ScopedName(search_name)

	# If the first component of the scoped name is empty then the name is
	# an 'absolute scoped name' and resolution is relative to the
	# enclosing repository.
	if len(scoped_name[0]) == 0:
	    # Delete the component.
	    del scoped_name[0]

	    # Get a reference to the 'Repository' that I am contained in.
	    repository = self._get_containing_repository()

	    # Start the resolution from the repository.
	    definition = repository.lookup(str(scoped_name))

	# Otherwise, the scoped name is relative to this container.
	else:
	    # Lookup the first component of the scoped name.
	    definition = self._lookup(scoped_name[0])

	    # If a definition with that name *was* found.
	    if definition is not None:
		# Delete the component.
		del scoped_name[0]

		# If there are still some components of the scoped name left.
		if len(scoped_name) > 0:
		    # Make sure that the definition is a 'Container'!
		    if definition._is_a('IDL:omg.org/CORBA/Container:1.0'):
			# Continue the resolution.
			definition = definition.lookup(str(scoped_name))

		    # Otherwise, the definition is *not* a 'Container', so it
		    # obviously can't contain anything to lookup!
		    else:
			definition = None
			    
	return definition

    def contents(self, limit_type, exclude_inherited):
        """ Operation: IDL:omg.org/CORBA/Container/contents:1.0

	This method is inherited by 'RepositoryImpl' and 'ModuleDefImpl', and
	is overridden by 'InterfaceDefImpl'.

	"""
	# Return all definitions.
	if limit_type == IntRep.dk_all:
	    contents = self._contents

	# Only return the definitions of the appropriate kind.
	else:
	    contents = []
	    for contained in self._contents:
		if contained._get_def_kind() == limit_type:
		    contents.append(contained)

	return contents

    def lookup_name(self, search_name, levels_to_search, limit_type,
		    exclude_inherited):
        """ Operation: IDL:omg.org/CORBA/Container/lookup_name:1.0

	This method is inherited by 'RepositoryImpl' and 'ModuleDefImpl', and
	is overridden by 'InterfaceDefImpl'.

	"""
	# Look in the current container first.
	definition = self._lookup(search_name)
	
	# If a definition with the name 'search_name' was found then make sure
	# it is of the appropriate 'limit_type'.
	if definition is not None:
	    # If the definition is not of the same type as 'limit_type'
	    if limit_type != IntRep.dk_all \
	       and definition._get_def_kind() != limit_type:
		definition = None

	# Search in contained objects?
	if definition is None and levels_to_search != 1:
	    for contained in self._contents:
		# Only search in other containers ;^)
		if contained._is_a('IDL:omg.org/CORBA/Container'):
		    definition = contained.lookup_name(search_name,
						       levels_to_search,
						       limit_type,
						       exclude_inherited)

		    # If the definition was found then stop looking!
		    if definition is not None:
			break
	    else:
		definition = None

	return definition

    def describe_contents(self,limit_type,exclude_inherited,max_returned_objs):
        """ Operation: IDL:omg.org/CORBA/Container/describe_contents:1.0 """

	# Get the contents.
	contents = self.contents(limit_type, exclude_inherited)

	# Only produce the requested number of descriptions.
	if max_returned_objs != -1:
	    contents = contents[:max_returned_objs]

	# Return a list of descriptions.
	return map(lambda contained: contained.describe(), contents)

    def create_module(self, id, name, version):
        """ Operation: IDL:omg.org/CORBA/Container/create_module:1.0 """

	# Create the definition.
	definition = ModuleDefImpl(self, id, name, version)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, ModuleDefImpl._FNORB_ID, definition)

	return definition

    def create_constant(self, id, name, version, type_def, value):
        """ Operation: IDL:omg.org/CORBA/Container/create_constant:1.0 """

	# Create the definition.
	definition = ConstantDefImpl(self, id, name, version, type_def, value)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, ConstantDefImpl._FNORB_ID, definition)

	return definition

    def create_struct(self, id, name, version, members):
        """ Operation: IDL:omg.org/CORBA/Container/create_struct:1.0 """

	# Create the definition.
	definition = StructDefImpl(self, id, name, version, members)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, StructDefImpl._FNORB_ID, definition)

	return definition

    def create_union(self, id, name, version, discriminator_type_def, members):
        """ Operation: IDL:omg.org/CORBA/Container/create_union:1.0 """

	# Create the definition.
	definition = UnionDefImpl(self, id, name, version,
				  discriminator_type_def, members)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, UnionDefImpl._FNORB_ID, definition)

	return definition

    def create_enum(self, id, name, version, members):
        """ Operation: IDL:omg.org/CORBA/Container/create_enum:1.0 """

	# Create the definition.
	definition = EnumDefImpl(self, id, name, version, members)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, EnumDefImpl._FNORB_ID, definition)

	return definition

    def create_alias(self, id, name, version, original_type):
        """ Operation: IDL:omg.org/CORBA/Container/create_alias:1.0 """

	# Create the definition.
	definition = AliasDefImpl(self, id, name, version, original_type)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, AliasDefImpl._FNORB_ID, definition)

	return definition
	
    def create_interface(self, id, name, version, base_interfaces):
        """ Operation: IDL:omg.org/CORBA/Container/create_interface:1.0 """

	# Create the definition.
	definition = InterfaceDefImpl(self, id, name, version, base_interfaces)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, InterfaceDefImpl._FNORB_ID, definition)

	return definition

    def create_exception(self, id, name, version, members):
        """ Operation: IDL:omg.org/CORBA/Container/create_exception:1.0 """

	# Create the definition.
	definition = ExceptionDefImpl(self, id, name, version, members)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, ExceptionDefImpl._FNORB_ID, definition)

	return definition

    #########################################################################
    # Protected interface.
    #########################################################################

    def _lookup(self, search_name):
	""" Return the 'Contained' instance named by 'search_name'. 

	If we don't have a definition with that name, return 'None'.

	"""
	for contained in self._contents:
	    if contained._get_name() == search_name:
		break
	else:
	    contained = None

	return contained

    def _delete(self, search_name):
	""" Delete the 'Contained' instance named by 'search_name'.

	If we don't have a definition with that name, do nuthin'!

	"""
	for i in range(len(self._contents)):
	    if self._contents[i]._get_name() == search_name:
		del self._contents[i]
		break

	return


class RepositoryImpl(IntRep_skel.Repository_skel, ContainerImpl):
    """ Interface: IDL:omg.org/CORBA/Repository:1.0 """

    # Used to generate unique object keys for PrimtiveDef, StringDef,
    # SequenceDef, and ArrayDef implementations.
    __unique_key = 0

    def __init__(self):
	""" Constructor. """

	# Base class constructor.
	ContainerImpl.__init__(self, CORBA.dk_Repository)

	# Create definitions for 'CORBA.TRUE' and 'CORBA.FALSE'.
	self.create_constant('IDL:omg.org/CORBA/TRUE:1.0',
			     'TRUE',
			     '1.0',
			     self.get_primitive(CORBA.pk_boolean),
			     CORBA.Any(CORBA.TC_boolean, 1))

	self.create_constant('IDL:omg.org/CORBA/FALSE:1.0',
			     'FALSE',
			     '1.0',
			     self.get_primitive(CORBA.pk_boolean),
			     CORBA.Any(CORBA.TC_boolean, 0))
	return

    #########################################################################
    # Container interface.
    #########################################################################

    def lookup(self, search_name):
        """ Operation: IDL:omg.org/CORBA/Container/lookup:1.0 """

	# Create a ScopedName instance from the string.
	scoped_name = Util.ScopedName(search_name)

	# If the first component of the scoped name is empty then the name is
	# an 'absolute scoped name' and resolution is relative to the
	# enclosing repository, which in this case is lil' ol' me ;^)
	if len(scoped_name[0]) == 0:
	    # Skip over the first component.
	    scoped_name = scoped_name[1:]

	# Lookup the first component of the scoped name.
	definition = self._lookup(scoped_name[0])

	# If a definition with that name *was* found.
	if definition is not None:
	    # Delete the component.
	    del scoped_name[0]

	    # If there are still some components of the scoped name left.
	    if len(scoped_name) > 0:
		# Make sure that the definition is a 'Container'!
		if definition._is_a('IDL:omg.org/CORBA/Container:1.0'):
		    # Continue the resolution.
		    definition = definition.lookup(str(scoped_name))

		# Otherwise, the definition is *not* a 'Container', so it
		# obviously can't contain anything to lookup!
	        else:
		    definition = None
			    
	return definition

    #########################################################################
    # Repository interface.
    #########################################################################

    def lookup_id(self, id):
        """ Operation: IDL:omg.org/CORBA/Repository/lookup_id:1.0 """

	# Search recursively through all containers.
	#
	# fixme: This could be made a whole lot simpler (not to mention
	# faster) by just keeping a dictionary keyed on interface repository
	# id! Ah, well, later... ;^)
	return self.__lookup_id(self, id)

    def get_primitive(self, kind):
        """ Operation: IDL:omg.org/CORBA/Repository/get_primitive:1.0 """

	# Create the definition.
	definition = PrimitiveDefImpl(kind)

	# Create an object object key for the implementation.
	key = PrimitiveDefImpl._FNORB_ID + self.__unique_suffix()

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(key, PrimitiveDefImpl._FNORB_ID, definition)

	return definition

    def create_string(self, bound):
        """ Operation: IDL:omg.org/CORBA/Repository/create_string:1.0 """

	# Create the definition.
	definition = StringDefImpl(bound)

        # Create an object object key for the implementation.
	key = StringDefImpl._FNORB_ID + self.__unique_suffix()

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(key, StringDefImpl._FNORB_ID, definition)

	return definition

    def create_wstring(self, bound):
        """ Operation: IDL:omg.org/CORBA/Repository/create_wstring:1.0 """

	# Create the definition.
	definition = WstringDefImpl(bound)

        # Create an object object key for the implementation.
	key = WstringDefImpl._FNORB_ID + self.__unique_suffix()

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(key, WstringDefImpl._FNORB_ID, definition)

	return definition

    def create_sequence(self, bound, element_type):
        """ Operation: IDL:omg.org/CORBA/Repository/create_sequence:1.0 """

	# Create the definition.
	definition = SequenceDefImpl(bound, element_type)

        # Create an object object key for the implementation.
	key = SequenceDefImpl._FNORB_ID + self.__unique_suffix()

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(key, SequenceDefImpl._FNORB_ID, definition)

	return definition

    def create_array(self, length, element_type):
        """ Operation: IDL:omg.org/CORBA/Repository/create_array:1.0 """

	# Create the definition.
	definition = ArrayDefImpl(length, element_type)

        # Create an object object key for the implementation.
	key = ArrayDefImpl._FNORB_ID + self.__unique_suffix()

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(key, ArrayDefImpl._FNORB_ID, definition)

	return definition

    def create_fixed(self, digits, scale):
        """ Operation: IDL:omg.org/CORBA/Repository/create_fixed:1.0 """

	# Create the definition.
	definition = FixedDefImpl(digits, scale)

        # Create an object object key for the implementation.
	key = FixedDefImpl._FNORB_ID + self.__unique_suffix()

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(key, FixedDefImpl._FNORB_ID, definition)

	return definition

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_dump(self, container, i=0):
	""" Print the id's of all objects in the repository. """

	for c in container._contents:
	    print '  ' * i, c._get_id()
	    if c._is_a('IDL:omg.org/CORBA/Container:1.0'):
		self._fnorb_dump(c, i + 1)

	return
		
    #########################################################################
    # Private interface.
    #########################################################################

    def __unique_suffix(self):
	""" Generate a unique suffix for object keys. """

	# The object key only has to be unique within *this* repository, so
	# this is good enough!
	RepositoryImpl.__unique_key = RepositoryImpl.__unique_key + 1

	return ':' + str(RepositoryImpl.__unique_key)

    def __lookup_id(self, container, id):
	""" Recursively search for the specified repository id. """

	for contained in container.contents(IntRep.dk_all, 1):
	    if contained._get_id() == id:
		result = contained
		break
	    
	    elif contained._is_a('IDL:omg.org/CORBA/Container:1.0'):
		result = self.__lookup_id(contained, id)
		if result is not None:
		    break
	else:
	    result = None

	return result
	
	
class ModuleDefImpl(IntRep_skel.ModuleDef_skel, ContainerImpl, ContainedImpl):
    """ Interface: IDL:omg.org/CORBA/ModuleDef:1.0 """

    def __init__(self, defined_in, id, name, version):
	""" Constructor. """

	# Base class constructors.
	ContainerImpl.__init__(self, IntRep.dk_Module)
	ContainedImpl.__init__(self, IntRep.dk_Module, id, name, version,
			       defined_in)
	return

    #########################################################################
    # Contained interface.
    #########################################################################
    
    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create the description.
	description = self._fnorb_describe()

	# Get the typecode for the description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/ModuleDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Module, value)
	
    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_describe(self):
        """ Create an 'ModuleDescription' for the module. """

	# Return the description.
	return IntRep.ModuleDescription(self._name,
					self._id,
					self._get_defined_in_id(),
					self._version)


class ConstantDefImpl(IntRep_skel.ConstantDef_skel, ContainedImpl):
    """ Interface: IDL:omg.org/CORBA/ConstantDef:1.0 """

    def __init__(self, defined_in, id, name, version, type_def, value):
	""" Constructor. """

	# Base class constructor.
	ContainedImpl.__init__(self, IntRep.dk_Constant, id, name, version,
			       defined_in)

	# Attributes specific to this class.
	self._type_def = type_def
	self._value = value

	return

    #########################################################################
    # Contained interface.
    #########################################################################

    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create the description.
	description = self._fnorb_describe()

	# Get the typecode for the description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/ConstantDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Constant, value)

    #########################################################################
    # ConstantDef interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/ConstantDef/type:1.0 """

	return self._type_def._get_type()

    def _get_type_def(self):
        """ Attribute: IDL:omg.org/CORBA/ConstantDef/type_def:1.0 """

	return self._type_def

    def _set_type_def(self, type_def):
        """ Attribute: IDL:omg.org/CORBA/ConstantDef/type_def:1.0 """

	self._type_def = type_def
	return

    def _get_value(self):
        """ Attribute: IDL:omg.org/CORBA/ConstantDef/value:1.0 """

	return self._value

    def _set_value(self, value):
        """ Attribute: IDL:omg.org/CORBA/ConstantDef/value:1.0 """

	 # The value must be of the current type!
	if value.typecode() != self._type_def._get_type():
	    raise CORBA.BAD_PARAM() # System exception.

	self._value = value
	return

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_describe(self):
        """ Create a 'ConstantDescription' for the constant. """

	# Return the constant description.
	return IntRep.ConstantDescription(self._name,
					  self._id,
					  self._get_defined_in_id(),
					  self._version,
					  self._get_type(),
					  self._value)


class TypedefDefImpl(IntRep_skel.TypedefDef_skel, ContainedImpl, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/TypedefDef:1.0 """

    def __init__(self, defined_in, id, name, version, def_kind):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, def_kind)
	ContainedImpl.__init__(self, def_kind, id, name, version, defined_in)

	return

    #########################################################################
    # Contained interface.
    #########################################################################
    
    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create the description.
	description = self._fnorb_describe()

	# Get the typecode for the description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/TypeDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Typedef, value)

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_describe(self):
        """ Create a 'TypeDescription' for the type definition. """

	# Return the type description.
	return IntRep.TypeDescription(self._name,
				      self._id,
				      self._get_defined_in_id(),
				      self._version,
				      self._get_type())


class StructDefImpl(IntRep_skel.StructDef_skel, TypedefDefImpl, ContainerImpl):
    """ Interface: IDL:omg.org/CORBA/StructDef:1.0 """

    def __init__(self, defined_in, id, name, version, members):
	""" Constructor. """

	# Base class constructors.
	TypedefDefImpl.__init__(self, defined_in, id, name, version,
				IntRep.dk_Struct)
	ContainerImpl.__init__(self, IntRep.dk_Struct)

	# Attributes specific to this class.
	self._members = members

	return

    #########################################################################
    # IDLType interface (inherited via TypedefDef).
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	# Create the structure typecode.
	return CORBA.StructTypeCode(self._id,
				    self._name,
				    self._members)

    #########################################################################
    # StructDef interface.
    #########################################################################

    def _get_members(self):
        """ Attribute: IDL:omg.org/CORBA/StructDef/members:1.0 """

	return self._members

    def _set_members(self, members):
        """ Attribute: IDL:omg.org/CORBA/StructDef/members:1.0 """

	# Update the list of members.
	self._members = members

	return


class UnionDefImpl(IntRep_skel.UnionDef_skel, TypedefDefImpl, ContainerImpl):
    """ Interface: IDL:omg.org/CORBA/UnionDef:1.0 """

    def __init__(self, defined_in, id, name, version, discriminator_type_def,
		 members):
	""" Constructor. """

	# Base class constructor.
	TypedefDefImpl.__init__(self, defined_in, id, name, version,
				IntRep.dk_Union)
	ContainerImpl.__init__(self, IntRep.dk_Union)

	# Attributes specific to this class.
	self._discriminator_type_def = discriminator_type_def
	self._members = members

	return

    #########################################################################
    # IDLType interface (inherited via TypedefDef).
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	# Create the union typecode.
	return CORBA.UnionTypeCode(self._id,
				   self._name,
				   self._discriminator_type_def._get_type(),
				   self._members)

    #########################################################################
    # UnionDef interface.
    #########################################################################

    def _get_discriminator_type(self):
        """ Attribute: IDL:omg.org/CORBA/UnionDef/discriminator_type:1.0 """

	return self._discriminator_type_def._get_type()

    def _get_discriminator_type_def(self):
        """ Attribute: IDL:omg.org/CORBA/UnionDef/discriminator_type_def:1.0 """

	return self._discriminator_type_def

    def _set_discriminator_type_def(self, type_def):
        """ Attribute: IDL:omg.org/CORBA/UnionDef/discriminator_type_def:1.0 """
	self._discriminator_type_def = type_def

	return

    def _get_members(self):
        """ Attribute: IDL:omg.org/CORBA/UnionDef/members:1.0 """

	return self._members

    def _set_members(self, members):
        """ Attribute: IDL:omg.org/CORBA/UnionDef/members:1.0 """

	self._members = members

	return


class EnumDefImpl(IntRep_skel.EnumDef_skel, TypedefDefImpl):
    """ Interface: IDL:omg.org/CORBA/EnumDef:1.0 """

    def __init__(self, defined_in, id, name, version, members):
	""" Constructor. """

	# Base class constructor.
	TypedefDefImpl.__init__(self, defined_in, id, name, version,
				IntRep.dk_Enum)

	# Attributes specific to this class.
	self._members = members

	return

    #########################################################################
    # IDLType interface (inherited via TypedefDef).
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	# Create the enum typecode.
	return CORBA.EnumTypeCode(self._id, self._name, self._members)

    #########################################################################
    # EnumDef interface.
    #########################################################################

    def _get_members(self):
        """ Attribute: IDL:omg.org/CORBA/EnumDef/members:1.0 """

	return self._members

    def _set_members(self, members):
        """ Attribute: IDL:omg.org/CORBA/EnumDef/members:1.0 """

	self._members = members
	return


class AliasDefImpl(IntRep_skel.AliasDef_skel, TypedefDefImpl):
    """ Interface: IDL:omg.org/CORBA/AliasDef:1.0 """

    def __init__(self, defined_in, id, name, version, original_type_def):
	""" Constructor. """

	# Base class constructor.
	TypedefDefImpl.__init__(self, defined_in, id, name, version,
				IntRep.dk_Alias)

	# Attributes specific to this class.
	self._original_type_def = original_type_def

	return

    #########################################################################
    # IDLType interface (inherited via TypedefDef).
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	# Create the alias typecode.
	return CORBA.AliasTypeCode(self._id,
				   self._name,
				   self._original_type_def._get_type())

    #########################################################################
    # AliasDef interface.
    #########################################################################

    def _get_original_type_def(self):
        """ Attribute: IDL:omg.org/CORBA/AliasDef/original_type_def:1.0 """
	
	return self._original_type_def

    def _set_original_type_def(self, type_def):
        """ Attribute: IDL:omg.org/CORBA/AliasDef/original_type_def:1.0 """

	self._original_type_def = type_def
	return


class PrimitiveDefImpl(IntRep_skel.PrimitiveDef_skel, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/PrimitiveDef:1.0 """

    TYPECODE_MAP = {IntRep.pk_null:       CORBA.TC_null,
		    IntRep.pk_void:       CORBA.TC_void,
		    IntRep.pk_short:      CORBA.TC_short,
		    IntRep.pk_long:       CORBA.TC_long,
		    IntRep.pk_ushort:     CORBA.TC_ushort,
		    IntRep.pk_ulong:      CORBA.TC_ulong,
		    IntRep.pk_float:      CORBA.TC_float,
		    IntRep.pk_double:     CORBA.TC_double,
		    IntRep.pk_boolean:    CORBA.TC_boolean,
		    IntRep.pk_char:       CORBA.TC_char,
		    IntRep.pk_octet:      CORBA.TC_octet,
		    IntRep.pk_any:        CORBA.TC_any,
		    IntRep.pk_TypeCode:   CORBA.TC_TypeCode,
		    IntRep.pk_Principal:  CORBA.TC_Principal,
		    IntRep.pk_string:     CORBA.TC_string,
		    IntRep.pk_objref:     CORBA.TC_Object,
		    IntRep.pk_longlong:   CORBA.TC_longlong,
		    IntRep.pk_ulonglong:  CORBA.TC_ulonglong,
		    IntRep.pk_longlong:   CORBA.TC_longlong,
		    IntRep.pk_longdouble: CORBA.TC_longdouble,
		    IntRep.pk_wchar:      CORBA.TC_wchar,
		    IntRep.pk_wstring:    CORBA.TC_wstring
		  }
		    
    def __init__(self, kind):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, IntRep.dk_Primitive)

	# Attributes specific to this class.
	self._kind = kind

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return PrimitiveDefImpl.TYPECODE_MAP[self._kind]

    #########################################################################
    # PrimitiveDef interface.
    #########################################################################

    def _get_kind(self):
        """ Attribute: IDL:omg.org/CORBA/PrimitiveDef/kind:1.0 """

	return self._kind # This is the 'PrimitiveKind'!


class StringDefImpl(IntRep_skel.StringDef_skel, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/StringDef:1.0 """

    def __init__(self, bound):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, IntRep.dk_String)

	# Attributes specific to this class.
	self._bound = bound

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return CORBA.StringTypeCode(self._bound)

    #########################################################################
    # StringDef interface.
    #########################################################################

    def _get_bound(self):
        """ Attribute: IDL:omg.org/CORBA/StringDef/bound:1.0 """

	return self._bound

    def _set_bound(self, bound):
        """ Attribute: IDL:omg.org/CORBA/StringDef/bound:1.0 """

	self._bound = bound
	return


class WstringDefImpl(IntRep_skel.WstringDef_skel, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/WstringDef:1.0 """

    def __init__(self, bound):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, IntRep.dk_Wstring)

	# Attributes specific to this class.
	self._bound = bound

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return CORBA.WstringTypeCode(self._bound)

    #########################################################################
    # StringDef interface.
    #########################################################################

    def _get_bound(self):
        """ Attribute: IDL:omg.org/CORBA/WstringDef/bound:1.0 """

	return self._bound

    def _set_bound(self, bound):
        """ Attribute: IDL:omg.org/CORBA/WstringDef/bound:1.0 """

	self._bound = bound
	return


class SequenceDefImpl(IntRep_skel.SequenceDef_skel, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/SequenceDef:1.0 """

    def __init__(self, bound, element_type_def):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, IntRep.dk_Sequence)

	# Attributes specific to this class.
	self._bound = bound
	self._element_type_def = element_type_def

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return CORBA.SequenceTypeCode(self._bound,
				      self._element_type_def._get_type())

    #########################################################################
    # SequenceDef interface.
    #########################################################################

    def _get_element_type(self):
        """ Attribute: IDL:omg.org/CORBA/SequenceDef/element_type:1.0 """

	return self._element_type_def._get_type()

    def _get_element_type_def(self):
        """ Attribute: IDL:omg.org/CORBA/SequenceDef/element_type_def:1.0 """

	return self._element_type_def

    def _set_element_type_def(self, element_type_def):
        """ Attribute: IDL:omg.org/CORBA/SequenceDef/element_type_def:1.0 """

	self._element_type_def = element_type_def
	return

    def _get_bound(self):
        """ Attribute: IDL:omg.org/CORBA/SequenceDef/bound:1.0 """

	return self._bound

    def _set_bound(self, bound):
        """ Attribute: IDL:omg.org/CORBA/SequenceDef/bound:1.0 """

	self._bound = bound
	return


class ArrayDefImpl(IntRep_skel.ArrayDef_skel, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/ArrayDef:1.0 """

    def __init__(self, length, element_type_def):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, IntRep.dk_Array)

	# Attributes specific to this class.
	self._length = length
	self._element_type_def = element_type_def

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return CORBA.ArrayTypeCode(self._length,
				   self._element_type_def._get_type())

    #########################################################################
    # ArrayDef interface.
    #########################################################################

    def _get_element_type(self):
        """ Attribute: IDL:omg.org/CORBA/ArrayDef/element_type:1.0 """

	return self._element_type_def._get_type()

    def _get_element_type_def(self):
        """ Attribute: IDL:omg.org/CORBA/ArrayDef/element_type_def:1.0 """

	return self._element_type_def

    def _set_element_type_def(self, element_type_def):
        """ Attribute: IDL:omg.org/CORBA/ArrayDef/element_type_def:1.0 """

	self._element_type_def = element_type_def

    def _get_length(self):
        """ Attribute: IDL:omg.org/CORBA/ArrayDef/length:1.0 """

	return self._length

    def _set_length(self, length):
        """ Attribute: IDL:omg.org/CORBA/ArrayDef/length:1.0 """

	self._length = length
	return


class FixedDefImpl(IntRep_skel.FixedDef_skel, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/FixedDef:1.0 """

    def __init__(self, digits, scale):
	""" Constructor. """

	# Base class constructors.
	IDLTypeImpl.__init__(self, IntRep.dk_Fixed)

	# Attributes specific to this class.
	self._digits = digits
	self._scale = scale

	return

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return CORBA.FixedTypeCode(self._digits, self._scale)

    #########################################################################
    # StringDef interface.
    #########################################################################

    def _get_digits(self):
        """ Attribute: IDL:omg.org/CORBA/FixedDef/digits:1.0 """

	return self._digits

    def _set_digits(self, digits):
        """ Attribute: IDL:omg.org/CORBA/StringDef/digits:1.0 """

	self._digits = digits
	return

    def _get_scale(self):
        """ Attribute: IDL:omg.org/CORBA/FixedDef/scale:1.0 """

	return self._digits

    def _set_scale(self, scale):
        """ Attribute: IDL:omg.org/CORBA/StringDef/scale:1.0 """

	self._scale = scale
	return


class ExceptionDefImpl(IntRep_skel.ExceptionDef_skel, ContainedImpl,
		       ContainerImpl):
    """ Interface: IDL:omg.org/CORBA/ExceptionDef:1.0 """

    def __init__(self, defined_in, id, name, version, members):
	""" Constructor. """

	# Base class constructor.
	ContainedImpl.__init__(self, IntRep.dk_Exception, id, name, version,
				defined_in)
	ContainerImpl.__init__(self, IntRep.dk_Exception)

	# Attributes specific to this class.
	self._members = members

	return

    #########################################################################
    # Contained interface.
    #########################################################################

    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create the description.
	description = self._fnorb_describe()

	# Get the typecode for the description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/ExceptionDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Exception, value)

    #########################################################################
    # ExceptionDef interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/ExceptionDef/type:1.0 """

	# Create the structure typecode.
	return CORBA.ExceptionTypeCode(self._id, self._name, self._members)
    
    def _get_members(self):
        """ Attribute: IDL:omg.org/CORBA/ExceptionDef/members:1.0 """

	return self._members

    def _set_members(self, members):
        """ Attribute: IDL:omg.org/CORBA/ExceptionDef/members:1.0 """

	self._members = members
	return

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_describe(self):
        """ Create an 'ExceptionDescription' for the exception. """

	# Return the exception description.
	return IntRep.ExceptionDescription(self._name,
					   self._id,
					   self._get_defined_in_id(),
					   self._version,
					   self._get_type())


class AttributeDefImpl(IntRep_skel.AttributeDef_skel, ContainedImpl):
    """ Interface: IDL:omg.org/CORBA/AttributeDef:1.0 """

    def __init__(self, defined_in, id, name, version, type_def, mode):
	""" Constructor. """

	# Base class constructor.
	ContainedImpl.__init__(self, IntRep.dk_Attribute, id, name, version,
				defined_in)

	# Attributes specific to this class.
	self._type_def = type_def
	self._mode = mode

	return

    #########################################################################
    # Contained interface.
    #########################################################################

    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create the description.
	description = self._fnorb_describe()

	# Get the typecode for the description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/AttributeDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Attribute, value)

    #########################################################################
    # AttributeDef interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/AttributeDef/type:1.0 """

	# Create the structure typecode.
	return self._type_def._get_type()

    def _get_type_def(self):
        """ Attribute: IDL:omg.org/CORBA/AttributeDef/type_def:1.0 """

	return self._type_def

    def _set_type_def(self, type_def):
        """ Attribute: IDL:omg.org/CORBA/AttributeDef/type_def:1.0 """

	self._type_def = type_def
	return

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_describe(self):
        """ Create an 'AttributeDescription' for the attribute. """

	# Return the attribute description.
	return IntRep.AttributeDescription(self._name,
					   self._id,
					   self._get_defined_in_id(),
					   self._version,
					   self._get_type(),
					   self._mode)


class OperationDefImpl(IntRep_skel.OperationDef_skel, ContainedImpl):
    """ Interface: IDL:omg.org/CORBA/OperationDef:1.0 """

    def __init__(self, defined_in, id, name, version, result_def, mode,
		 params, exceptions, contexts):
	""" Constructor. """

	# Base class constructor.
	ContainedImpl.__init__(self, IntRep.dk_Operation, id, name, version,
				defined_in)

	# Attributes specific to this class.
	self._result_def = result_def 
	self._mode = mode
	self._params = params
	self._exceptions = exceptions
	self._contexts = contexts

	return

    #########################################################################
    # Contained interface.
    #########################################################################

    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create the description.
	description = self._fnorb_describe()

	# Get the typecode for the description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/OperationDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Operation, value)

    #########################################################################
    # OperationDef interface.
    #########################################################################

    def _get_result(self):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/result:1.0 """

	return self._result_def._get_type()

    def _get_result_def(self):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/result_def:1.0 """

	return self._result_def

    def _set_result_def(self, result_def):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/result_def:1.0 """

	self._result_def = result_def
	return

    def _get_params(self):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/params:1.0 """

	return self._params

    def _set_params(self, params):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/params:1.0 """

	self._params = params
	return

    def _get_mode(self):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/mode:1.0 """

	return self._mode

    def _set_mode(self, mode):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/mode:1.0 """

	self._mode = mode
	return

    def _get_contexts(self):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/contexts:1.0 """

	return self._contexts

    def _set_contexts(self, contexts):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/contexts:1.0 """

	self._contexts = contexts
	return

    def _get_exceptions(self):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/exceptions:1.0 """
	
	return self._exceptions

    def _set_exceptions(self, exceptions):
        """ Attribute: IDL:omg.org/CORBA/OperationDef/exceptions:1.0 """

	self._exceptions = exceptions
	return

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_describe(self):
        """ Create an 'OperationDescription' for the operation. """

	# Get a list of ExceptionDescriptions.
	exceptions = map(lambda e: e._fnorb_describe(), self._exceptions)

	# Return the operation description.
	return IntRep.OperationDescription(self._name,
					   self._id,
					   self._get_defined_in_id(),
					   self._version,
					   self._get_result(),
					   self._mode,
					   self._contexts,
					   self._params,
					   exceptions)


class InterfaceDefImpl(IntRep_skel.InterfaceDef_skel, ContainerImpl,
		       ContainedImpl, IDLTypeImpl):
    """ Interface: IDL:omg.org/CORBA/InterfaceDef:1.0 """

    def __init__(self, defined_in, id, name, version, base_interfaces):
	""" Constructor. """

	# Base class constructors.
	ContainerImpl.__init__(self, IntRep.dk_Interface)
	ContainedImpl.__init__(self, IntRep.dk_Interface, id, name, version,
			       defined_in)
	IDLTypeImpl.__init__(self, IntRep.dk_Interface)

	# Attributes specific to this class.
	self._base_interfaces = base_interfaces

	# Lists of operations and attributes.
	self._operations = []
	self._attributes = []

	return

    #########################################################################
    # Container interface.
    #########################################################################

    def contents(self, limit_type, exclude_inherited):
        """ Operation: IDL:omg.org/CORBA/Container/contents:1.0 """

	# Return all definitions.
	if limit_type == IntRep.dk_all:
	    contents = self._contents

	# Only return the definitions of the appropriate kind.
	else:
	    contents = []
	    for definition in self._contents:
		if definition._get_def_kind() == limit_type:
		    contents.append(definition)

	# If requested return the contents of all of our base interfaces as
	# well!
	if not exclude_inherited:
	    # Get a reference to our containing repository.
	    repository = self_get_containing_repository()

	    for base in self._base_interfaces:
		# Lookup the definition of the base interface.
		interface_def = repository.lookup_id(base)

		# Add its contents!
		contents = contents + interface_def.contents()

	return contents

    def lookup_name(self, search_name, levels_to_search, limit_type,
		    exclude_inherited):
        """ Operation: IDL:omg.org/CORBA/Container/lookup_name:1.0 """

	# Look in the current container first.
	definition = self._lookup(search_name)

	# If a definition with the name 'search_name' was found then make sure
	# it is of the appropriate 'limit_type'.
	if definition is not None:
	    # If the definition is not of the same type as 'limit_type'
	    if limit_type != IntRep.dk_all \
	       and definition._get_def_kind() != limit_type:
		definition = None

	# Search in base interfaces?
	if definition is None and not exclude_inherited:
	    for interface_def in self._base_interfaces:
		definition = interface_def.lookup_name(search_name,
						       levels_to_search,
						       limit_type,
						       exclude_inherited)

		# If the definition was found then stop looking!
		if definition is not None:
		    break
		
	    else:
		definition = None

	# Search in contained objects?
	if definition is None and levels_to_search != 1:
	    for contained in self._contents:
		# Only search in other containers ;^)
		if contained._is_a('IDL:omg.org/CORBA/Container'):
		    definition = contained.lookup_name(search_name,
						       levels_to_search,
						       limit_type,
						       exclude_inherited)

		    # If the definition was found then stop looking!
		    if definition is not None:
			break
	    else:
		definition = None

	return definition

    #########################################################################
    # Contained interface.
    #########################################################################
    
    def describe(self):
        """ Operation: IDL:omg.org/CORBA/Contained/describe:1.0 """

	# Create a list of the repository id's of our base interfaces.
	base_interface_ids = map(lambda b: b._get_id(), self._base_interfaces)

	# Create the interface description.
	description = IntRep.InterfaceDescription(self._name,
						  self._id,
						  self._get_defined_in_id(),
						  self._version,
						  base_interface_ids)

	# Get the typecode for the interface description.
	typecode = CORBA.typecode("IDL:omg.org/CORBA/InterfaceDescription:1.0")

	# Wrap the description in an 'Any'.
	value = CORBA.Any(typecode, description)

	# Return the generic description structure.
	return IntRep.Contained.Description(IntRep.dk_Interface, value)

    #########################################################################
    # IDLType interface.
    #########################################################################

    def _get_type(self):
        """ Attribute: IDL:omg.org/CORBA/IDLType/type:1.0 """

	return CORBA.InterfaceTypeCode(self._id, self._name)

    #########################################################################
    # InterfaceDef interface.
    #########################################################################

    def _get_base_interfaces(self):
        """ Attribute: IDL:omg.org/CORBA/InterfaceDef/base_interfaces:1.0 """

	return self._base_interfaces

    def _set_base_interfaces(self, base_interfaces):
        """ Attribute: IDL:omg.org/CORBA/InterfaceDef/base_interfaces:1.0 """

	self._base_interfaces = base_interfaces
        return

    def is_a(self, interface_id):
        """ Operation: IDL:omg.org/CORBA/InterfaceDef/is_a:1.0 """

	# Create a list of the repository id's of our base interfaces.
	base_interface_ids = map(lambda b: b._get_id(), self._base_interfaces)

	return interface_id in base_interface_ids

    def describe_interface(self):
        """ Operation: IDL:omg.org/CORBA/InterfaceDef/describe_interface:1.0 """
	# Create a list of operation descriptions.
	operations = map(lambda op: op.describe().value.value(), 
			 self._operations)

	# Create a list of attribute descriptions.
	attributes = map(lambda attr: attr.describe().value.value(), 
			 self._attributes)

	# Create a list of the repository id's of our base interfaces.
	base_interface_ids = map(lambda b: b._get_id(), self._base_interfaces)

	# Return the full interface description.
	return IntRep.InterfaceDef.FullInterfaceDescription(self._name,
							    self._id,
							    self._get_defined_in_id(),
							    self._version,
							    operations,
							    attributes,
							    base_interface_ids,
							    self._get_type())

    def create_attribute(self, id, name, version, type_def, mode):
        """ Operation: IDL:omg.org/CORBA/InterfaceDef/create_attribute:1.0 """

	# Create the definition.
	definition = AttributeDefImpl(self, id, name, version, type_def, mode)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Add the definition to our list of attributes.
	self._attributes.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, AttributeDefImpl._FNORB_ID, definition)

	return definition

    def create_operation(self, id, name, version, result_def, mode, params,
			 exceptions, contexts):
        """ Operation: IDL:omg.org/CORBA/InterfaceDef/create_operation:1.0 """

	# Create the definition.
	definition = OperationDefImpl(self, id, name, version, result_def,
				      mode, params, exceptions, contexts)

	# Add the definition to our contents.
	self._contents.append(definition)

	# Add the definition to our list of operations.
	self._operations.append(definition)

	# Register the implementation with the object adapter.
	self._fnorb_register_impl(id, OperationDefImpl._FNORB_ID, definition)

	return definition
    
#############################################################################
