(********************************************************************************************
** PROGRAM     : wRename
** VERSION     : 1.0.0
** DESCRIPTION : Renames a file.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 1998-2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written as an example
** of how to use the Windows common dialog functions 'GetOpenFileName' and 'GetSaveFileName'.
** To make best use of this sample you should have a basic understanding of Pascal as well
** as the Windows API.
**********************************************************************************************)
{$I commdlg.inc}
program wrename;
var
	ofn : OPENFILENAME;
	filter : cstring;
	CurrentName, NewName : cstring;
	title : cstring;
	f : text;

	function ChooseFile(var ofn : OPENFILENAME) : BOOL;
	begin
		fill(ofn, 0);
		filter := 'All Files (*.*)' + chr(0) + '*.*' + chr(0);
		CurrentName := '';
		title := 'Choose file to rename';
		ofn.lStructSize := sizeof(ofn);
		ofn.hwndOwner := 0;
		ofn.lpstrFilter := addr(filter);
		ofn.nFilterIndex := 1;
		ofn.lpstrFile := addr(CurrentName);
		ofn.nMaxFile := 255;
		ofn.lpstrTitle := addr(title);
		ofn.Flags := (OFN_FILEMUSTEXIST or OFN_HIDEREADONLY);
		ChooseFile := GetOpenFileName(ofn);
	end;

	function NewFilename(var ofn : OPENFILENAME) : BOOL;
	begin
		NewName := CurrentName;
		title := 'Choose new name for file';
		ofn.lpstrFile := addr(NewName);
		ofn.Flags := OFN_OVERWRITEPROMPT;
		NewFilename := GetSaveFileName(ofn);
	end;

begin
	if ChooseFile(ofn) <> 0 then
		if NewFilename(ofn) <> 0 then
			if CurrentName = NewName then
				writeln('You must specify a different name')
			else
				begin
   					assign(f, CurrentName);
					rename(f, NewName);
					writeln(CurrentName + ' -> ' + NewName);
				end
end.
