(********************************************************************************************
** PROGRAM     : cdonts
** VERSION     : 1.0.0
** DESCRIPTION : Demonstrates how to use the CDONTS.NewMail COM obect to send email.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to illustrate
** how to use the Microsoft CDONTS.NewMail COM object to send email. To make best use of
** this sample you should have a basic understanding of Pascal.
**
**    The CDONTS.NewMail object was created by Microsoft to make sending email easy. This
** object is distributed with IIS, but not necessarily installed with IIS. If you decide to
** use this object to send email make sure it is installed on the server.
**
**    If you look at the program below you will see that using the CDONTS object is very simple,
** just create an instance, set a few properties, call the "send" method, and then dispose of
** the instance. After you call "send" the instance is invalidated, so don't try calling "send"
** more than once with the same instance.
**********************************************************************************************)
program cdonts;
const
   NORMAL = 1;
   //LOW = 0;
   //HIGH = 2;
var
   objMail : object;
   strFrom, strTo, strSubject, strBody : string;
begin
   //Gather information about the message
   write('Enter email address of person to receive this message: ');
   readln(strTo);
   write('Enter email address of person sending this message: ');
   readln(strFrom);
   write('Enter subject of this message: ');
   readln(strSubject);
   write('Enter body of the message: ');
   readln(strBody);

   //Send the message
   objMail := CreateObject('CDONTS.NewMail');
   objMail.from := strFrom;
   objMail.('to') := strTo;
   objMail.subject := strSubject;
   objMail.Body := strBody;
   objMail.Importance := NORMAL;
   objMail.Send( , , , , );
   dispose(objMail);

   //NOTE: You don't have to set properties to send a message you can
   // do everything in the call to "send", so in the example above
   // the message could have been sent as follows
   (*
   //Send the message
   objMail := CreateObject('CDONTS.NewMail');
   objMail.Send(objFrom , objTo, objSubject, objBody, NORMAL);
   dispose(objMail);
   *)
end.
