IMPLEMENTATION MODULE Terminate;

FROM List IMPORT List;
 
  CLASS Terminator;

    METHOD Register;
      BEGIN
      Handler.Register (THIS);
      END Register;

    METHOD UnRegister;
      BEGIN
      Handler.UnRegister(THIS);
      END UnRegister;
  END Terminator;

--------------------------------

  ONCE CLASS Handler;
    VAR
      TermList: List(Terminator);

    REDEFINE METHOD CREATE;
      BEGIN
      TermList.CREATE;
      END CREATE;

    METHOD Register (Term: Terminator);
      BEGIN
      UnRegister(Term);
      TermList.Append(Term);
      END Register;

    METHOD UnRegister(Term: Terminator);
      VAR
        Exit: BOOLEAN;
      BEGIN
      FOR i := 0 TO TermList.Size - 1 WHILE NOT Exit DO
        IF TermList.Get(i) = Term THEN
          TermList.Delete (i);
          Exit := TRUE;     
          END;
        END;
      END UnRegister;  

  PRAGMA
    CallBack(Close, "yafl_terminate");
      
    METHOD Close;
      VAR
        TempList: List(Terminator);
        BEGIN
      IF TermList <> VOID THEN
        TempList := TermList;
        TermList := VOID;
        ASSERT TempList <> VOID;
        FOR i := 0 TO TempList.Size - 1 DO
          TempList.Get(i).Close;
          END;
        END;
      END Close;

    END Handler;
  
END Terminate;
