IMPLEMENTATION MODULE Set;

IMPORT Bag;

  CLASS Set(Element);
    INHERITS Bag(Element);
    
    REDEFINE METHOD Remove (El: Element);
      BEGIN
      RemoveAll (El);
      END Remove;
      
    REDEFINE METHOD Cardinality (El: Element): INTEGER;
      BEGIN
      RESULT := BASE (El);
      IF RESULT > 1 THEN
        RESULT := 1;
        END;
      END Cardinality;
      
    REDEFINE METHOD Add(El: Element);
      BEGIN
      IF Cardinality(El) = 0 THEN
        BASE(El);
        END;
      END Add;
      
    REDEFINE METHOD Intersection (Other: Bag(Element)): Set(Element);
      BEGIN
      WHAT BASE (Other) OF
        IN Set(Element):
          RESULT := TAG;
          END;
        END;       
      END Intersection;
      
    REDEFINE METHOD Union (Other: Bag(Element)): Set(Element);
      BEGIN
      WHAT BASE (Other) OF
        IN Set(Element):
          RESULT := TAG;
          END;
        END;       
      END Union;
      
  END Set;
  
END Set;
