#ifndef DBX_MODULE_H
#define DBX_MODULE_H 1

/* this module defines both the module structure and the module table */
/* structure (which is unique in the system) */

dbx_module *new_module YARGS((void));
int module_count YARGS((VOID));

/* now in the YAFL runtime */
#ifndef XNEWSYS

dbx_module *first_module YARGS((void));
dbx_module *last_module YARGS((void));
dbx_module *next_module YARGS((dbx_module * pm));
dbx_module *prev_module YARGS((dbx_module * pm));
char *module_name YARGS((dbx_module * pm));
unsigned module_beginline YARGS((dbx_module * pm));
unsigned module_endline YARGS((dbx_module * pm));
char *file_name YARGS((dbx_module * pm));
struct dbx_class *first_class YARGS((dbx_module * pm)); /* _of_module */
struct dbx_class *last_class YARGS((dbx_module * pm)); /* _of_module */
int is_statement YARGS((dbx_module *  pm,
                        unsigned      line));
dbx_class *line_in_class YARGS((dbx_module *pm,unsigned line));                        

dbx_method *line_in_method YARGS((dbx_module *pm,unsigned line));

#endif

dbx_module *find_next_module YARGS((dbx_module *pm,char *pattern));
dbx_module *find_prev_module YARGS((dbx_module *pm,char *pattern));

void init_dbx_modu YARGS((void));
void term_dbx_modu YARGS((void));

#ifdef XDEBUG
void dump_modules YARGS((void));
#endif

#endif
