#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <yafl_rnt.h>


#ifdef YAFL_ANSI

FIELD_INFO *add_field (char *        name,
                minimal_dual* type,
                unsigned      level,
                VOID*         once,
                unsigned      offset,
                minimal_dual* dual,
                int visible)
                
#else                                                       

FIELD_INFO *add_field (name,type,level,once,offset,dual,visible)
char *name;
minimal_dual* type;
unsigned level;
VOID *once;
unsigned offset;
minimal_dual* dual;
int visible;

#endif
                       
{
  FIELD_INFO *p,*cur_field;
  assertp(name);
  assertp(dual);
/*  
  assertp(type);
*/  
/*
  printf ("Adding field: %s (%s)\n", dual->class_name, name);
*/
  p = (FIELD_INFO *)malloc(sizeof(FIELD_INFO));
  memset(p,0,sizeof(FIELD_INFO));
  cur_field = dual->last_field;
  if (cur_field == NULL)
  {
    dual->first_field = p;
  }
  else
  {
    cur_field->next = p;
    p->prev = cur_field;
  }
  dual->last_field = p;
  p->dual = dual;
  p->name = name;
  p->field_dual = type;
  p->level = level;
  p->once = once;
  p->offset = offset;
  p->visible = visible;
  p->next = NULL;
  return p;
}

/*********************************************************************/
static unsigned field_dummy_state[FIELD_DUMMY_SIZE];

static void dump_field_dummy_state YPARAMS0
{
  int i;
  static char buffer[20];
  for (i = 0; i < FIELD_DUMMY_SIZE; i++)
  {
    sprintf(buffer, "%d", field_dummy_state[i]);
    emit_stdout(buffer);
  }
  emit_stdout("\n");
  emit_stdout("\n");
}

void reserve_field_dummy YPARAMS4(unsigned, offset, 
                                unsigned, size)
{
  int i;
  int ok;
  ok = 1;
  assert (offset + size <= FIELD_DUMMY_SIZE);
  for (i = 0; i < size; i++)
  {
    if (field_dummy_state[offset + i] > 0)
      ok = 0;
    field_dummy_state[offset + i]++;
  }
  if (!ok)
  {
    dump_field_dummy_state();
    assert(0);
  }
}

void put_field_dummy YPARAMS8(FIELD_INFO *, field,
                            unsigned, offset,
                            unsigned, size,
                            obj_ptr, data)
{    
  if(field != NULL)   /* The assertion has been replaced by a test so that
                         the code gets more robust, even if it should have
                         little impact in normal circumstances */
    {
      assertp(data);
      assert (offset + size <= FIELD_DUMMY_SIZE);
      memcpy((field->dummy) + offset, data, size);
    }
}

void get_field_dummy YPARAMS8(FIELD_INFO *, field,
                            unsigned, offset,
                            unsigned, size,
                            obj_ptr, data)
{
  if(field != NULL)
    {
      assertp(data);
      assert (offset + size <= FIELD_DUMMY_SIZE);
      memcpy(data, (field->dummy) + offset, size);
    }
}


