#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <yafl_rnt.h>
#include "dbx_list.h"
#include "dbx_rnt.h"
#include "dbx_type.h"
#include "dbx_vari.h"
#include "dbx_fiel.h"
#include "dbx_call.h"
#include "dbx_loca.h"
#include "dbx_fram.h"
#include "dbx_ctxt.h"
#include "dbx_watc.h"
#include "dbx_stri.h"

dbx_list *watch_list = NULL; /* visible outside */

dbx_watch *current_watch YPARAMS0
{
  if (current_elem(watch_list))
    return (elem_info(current_elem(watch_list)));
  else
    return NULL;
}


dbx_watch *new_watch YPARAMS0
{
  dbx_watch *p;
  p = (dbx_watch *)malloc(sizeof(dbx_watch));
  assertp(p);
  memset(p,0,sizeof(dbx_watch));
  return p;
}

void dispose_watch YPARAMS2(dbx_watch *,  pw)
{
  assertp(pw);
  free(pw->text);
  free(pw);
}
  

  
char *watch_expression YPARAMS2(dbx_watch *,  pw)
{
  assertp(pw);
  return (pw->text);
}

dbx_variable *watch_value YPARAMS2(dbx_watch *,  pw)
{
  dbx_context *pc;
  int error;
  dbx_variable *pv;
  assertp(pw);
  pc = new_context();
  error = apply_descriptor(pc,watch_expression(pw));
  if (error)
  {
    pv = NULL;
  }
  else
  {
    pv = create_variable(pc);

  }
  reset_context(pc);
  dispose_context(pc);
  return(pv);
} 

/*
dbx_elem *find_welem YPARAMS2(char *,  name)
{
   dbx_elem *pe;
   dbx_elem *pele = NULL;
   dbx_watch *pw;
   pe = first_elem(watch_list);
   while (pe)
   {
     pw = elem_info(pe);
     if (streq(watch_name(pw),name))
     {
       pele = pe;
       pe = NULL;
     }
     else
        pe = next_elem(pe);
   }
   return pele;
}
*/

void add_watch YPARAMS2(char *,  text)
{
  dbx_watch *pw;
  pw = new_watch();
  pw->text = text;
  insert(watch_list,last_elem(watch_list),NULL,pw);
}

void sub_watch YPARAMS2(unsigned,  n)
{
  dbx_watch *pw;
  dbx_elem *pe;
  pe = nth_elem(watch_list,n);
  pw = suppress(watch_list,pe);
  dispose_watch(pw);
}
  
				
dbx_watch *find_watch YPARAMS2(unsigned,  n)
{
  dbx_elem *pe;
  pe = nth_elem(watch_list,n);
  if (pe)
    return elem_info(pe);
  else
    return NULL;
}

/*
int search_watch YPARAMS4(dbx_module *,  pm,
                              unsigned,  line)
{
  dbx_elem *pe;
  dbx_watch *pw;
  pe = first_elem(watch_list);
  while (pe)
  {
    pw = elem_info(pe);
    if ((watch_module(pw)==pm)&&(watch_line(pw)==line))
      return 1;
    pe = next_elem(pe);
  }
  return 0;
}  
*/
			      								
void init_dbx_watc YPARAMS0
{
  watch_list = new_list();
}

void term_dbx_watc YPARAMS0
{
}
