#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_stri.h"

/* set of functions for manipulating dynamic strings;they differ of the */
/* standard ones in that they always allocate a new string for the result */
/* instead of copying to an existing area;so overwriting cannot happen */
/* but the user has to check that he correctly frees all strings created */

/* return a copy of a string */
char *strclone YPARAMS2(char *,  s)
{
  char *r;  
  assertp(s);
  r = (char *)malloc(strlen(s)+1);
  assertp(r);
  strcpy(r,s);
  assert(strlen(r) == strlen(s));
  return(r);
}

/* return a new string which is equal to a concatenation of the n others */
/* it is useful to be able to join more than two strings in one operation */
/* so that you don't have to free intermediate strings */
char *strjoin YPARAMS4(char *,  s,
                      char *,  t)
                      
{
  char *r;
  assertp(s);
  assertp(t);
  r = (char *)malloc(strlen(s)+strlen(t)+1);
  assertp(r);
  strcpy(r,s);
  strcat(r,t);
  assert(strlen(r) == strlen(s) + strlen(t));
  return(r);
}

char *strjoin3 YPARAMS6(char *,  s,
                       char *,  t,
                       char *,  u)
                      
{
  char *r;
  assertp(s);
  assertp(t);
  assertp(u);
  r = (char *)malloc(strlen(s)+strlen(t)+strlen(u)+1);
  assertp(r);
  strcpy(r,s);
  strcat(r,t);
  strcat(r,u);
  assert(strlen(r) == strlen(s) + strlen(t) + strlen(u));
  return(r);
}


char *strjoin4 YPARAMS8(char *,  s,
                       char *,  t,
                       char *,  u,
                       char *,  v)
{
  char *r;
  assertp(s);
  assertp(t);
  assertp(u);
  assertp(v);
  r = (char *)malloc(strlen(s)+strlen(t)+strlen(u)+strlen(v)+1);
  if (r == NULL)
    return "$";
  assertp(r);
  strcpy(r,s);
  strcat(r,t);
  strcat(r,u);
  strcat(r,v);
  assert(strlen(r) == strlen(s) + strlen(t) + strlen(u) + strlen(v));
  return(r);
}

char *strjoin5 YPARAMS10(char *,  s,
                        char *,  t,
                        char *,  u,
                        char *,  v,
                        char *,  w)
                      
{
  char *r;
  assertp(s);
  assertp(t);
  assertp(u);
  assertp(v);
  assertp(w);
  r = (char *)malloc(strlen(s)+strlen(t)+strlen(u)+strlen(v)+strlen(w)+1);
  if (r == NULL)
    return "$";
  assertp(r);
  strcpy(r,s);
  strcat(r,t);
  strcat(r,u);
  strcat(r,v);
  strcat(r,w);
  assert(strlen(r) == strlen(s) + strlen(t) + strlen(u) + strlen(v) + strlen(w));
  return(r);
}

/* return a new string composed of the n leftmost characters of the string */
char *strleft YPARAMS4(char *,  s,
                      unsigned,  n)
{
  char *t;
  assertp(s);
  assert(n <= strlen(s));
  t = (char *)malloc(n+1);
  assertp(t);
  memcpy(t,s,n); /* ??? a verifier */
  t[n] = 0;
  return(t);
}

/* return a new string composed of the n rightmost characters of the string */
char *strright YPARAMS4(char *,  s,
                       unsigned,  n)
{
   char *t;
   assertp(s);
   assert(n <= strlen(s));
   t = (char *)malloc(n+1);
   assertp(t);
   strcpy(t,s+(strlen(s)-n)); /* ??? a verifier */
   return(t);
}

/* return a string composed of n space characters */
char *strblank YPARAMS2(unsigned,  n)
{
  char *s;
  s = (char *)malloc(n+1);
  assertp(s);
  memset(s,' ',n);
  s[n] = 0;  
  assert(strlen(s) == n);
  return(s);  
}

/* return an empty string */
char *strnew YPARAMS0
{
  char *s;
  s = (char *)malloc(1);
  assertp(s);
  s[0] = 0;
  return(s);
}

/* return the position of the first character found starting at the left */
/* the subscript of this character in the string is one less than the */
/* position */
unsigned strleftchar YPARAMS4(char *,  s,
                             char ,  c)
{
  char *p;
  assertp(s);
  p = strchr(s,c);
  if (p)
    return (p-s)+1;
  else
    assert(0);
  return 0;
}

/* return the position of the first character found starting at the right */
/* the subscript of this character in the string is one less the the */
/* position */
unsigned strrightchar YPARAMS4(char *,  s,
                              char ,  c)
{
  char *p;
  assertp(s);
  p = strrchr(s,c);
  if (p)
    return (p-s)+1;
  else
    assert(0);
  return 0;
}                                                                                                   

char *strupper YPARAMS2(char *, s)
{
  char *r;  
  int i;
  int n;
  assertp(s);
  n = strlen(s);
  r = (char *)malloc(n + 1);
  assertp(r);
  for (i = 0; i <= n; i ++)
  {
    r[i] = toupper(s[i]);
  }
  assert (strlen(r) == strlen(s));
  return(r);
}

char *strlower YPARAMS2(char *, s)
{
  char *r;  
  int i;
  int n;
  assertp(s);
  n = strlen(s);
  r = (char *)malloc(n + 1);
  assertp(r);
  for (i = 0; i <= n; i ++)
  {
    r[i] = tolower(s[i]);
  }
  assert (strlen(r) == strlen(s));
  return(r);
}


