#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <yafl_rnt.h>
#include "dbx_rnt.h"
#include "dbx_matc.h"
#include "dbx_envi.h"
#include "dbx_stri.h"

/* CAUTION: */
/* the usage of the libgen library is causing many portability problems */
/* so we don't use it anymore */

/* function matching a string against a pattern used in various search */
/* functions of the debugger;the pattern is a regular expression; see */
/* UNIX system documentation for more details about the notations */
/* the strings are YAFL identifiers ;no conflicts should happen as these */
/* identifiers cannot contain any characters others than alphanumerical */
/* (upper case or lower case) and underscore */
/* the matching is done in two stages:the pattern is first compiled to an */
/* intermediate form by function regcmp;the compiled form is then executed */
/* on the string by function regex */

/* we consider that an empty pattern always matches */
/* special character ^ matches the beginning of the string */
/* special character $ matches the end of the string */
/* the pattern is enclosed by these two characters to ensure that it */
/* matches the entire string and not only a substring */
/* don't forget to free the intermediate structure */

/*
int dbx_match YPARAMS4(char *,  string,
                  char *,  pattern)
{
  char *compex;
  char *result;
  assertp(string);
  assertp(pattern);
  if (strlen(pattern) == 0)
  {
    return(1);
  }
  else
  {
    compex = regcmp("^",pattern,"$",(char *)0);  
    if (!compex)
    {
      return(0);
    }
    else
    {
      result = regex(compex,string);
      free(compex);
      if (result)
        return(1);
      else
        return(0);  
    }
  }
}
*/

int dbx_match YPARAMS4(char *,  string,
                  char *,  pattern)
{
  int n;
  char *string2;
  char *pattern2;
  int result;
  assertp(string);
  assertp(pattern);
  if (envi_get_case())
  {
    string2 = strclone(string);
    pattern2 = strclone(pattern);
  }
  else
  {
/*
    printf("*****************\n");
    printf("%s\n", string);
    printf("%s\n", pattern);
*/
    string2 = strupper(string);
    pattern2 = strupper(pattern);
/*
    printf("%s\n", string2);
    printf("%s\n", pattern2);
*/
  }
  n = strlen(pattern2);
  if (n == 0)
  {
    result = 1;
  }
  else
  {
    if (pattern2[n - 1] == '*')
    {
/*       result = (strncmp(string2, pattern2, n - 1) == 0); */
    }
    else
    {
      result = (strcmp(string2, pattern2) == 0);
    }
  }
  free(string2);
  free(pattern2);
  return result;
}
