IMPLEMENTATION MODULE YaflMetDefinition;

FROM YaflLex IMPORT LexicalAnalyzer;
IMPORT LookAhead;
FROM YaflSymbols IMPORT SymbolTable;
FROM YaflError IMPORT WarningHandler, MainErrorHandler;
FROM YaflCfg IMPORT YaflCfg;
FROM YaflDeclarations IMPORT SingleDataItem, ConstDeclaration, InheritsClause;
FROM YaflModules IMPORT CompilationUnit;
FROM YaflParamClasses IMPORT ClassFormal;
FROM YaflPredefined IMPORT PredefItems, PredefDataItem, PredefMethod;
FROM YaflStatements IMPORT Statement;
FROM YaflCfg IMPORT CurrentSpot;
FROM Streams IMPORT StdOut;
FROM YaflClasses IMPORT VirtualClassDecl;

----------------------------------------
  CLASS MethodDefinition;
    INHERITS MethodDeclaration(MethDefCodeGenerator);

    REDEFINE METHOD Parse(Lkh: LookAhead);
      BEGIN
      ParseDeclaration (Lkh);
      END Parse;

    METHOD ClassDef: ClassDefinition;
      BEGIN
      WHAT Class OF
        IN ClassDefinition:
          RESULT := TAG;
          END;
        END;
      END ClassDef;

    REDEFINE METHOD WhatAmI: ARRAY OF CHAR;
      BEGIN
      RESULT := "MethodDefinition";
      END WhatAmI;

    REDEFINE METHOD Enter;
      BEGIN
      --------------------------------
      -- THIS should only be stored in the
      -- symbol table if it is not a predefined
      -- method, and if it does not redefine
      -- a previously defined method, which should
      -- then be visible itself.
      --------------------------------
      IF NOT IsPredefined THEN
        IF NOT Redefine THEN
          BASE;
          END;
        END;
      END Enter;
      
    REDEFINE METHOD Public: BOOLEAN;
      BEGIN
      RESULT := TRUE; -- Since a definition is only available for public
                      -- methods...
      END Public;

    REDEFINE METHOD EnterInDictionary;
      BEGIN 
      IF NOT Deferred THEN
        BASE;
        ASSERT Reference <> VOID;
        Reference.SetDeclPos (Id.ColNr, Id.LineNr);
        END; -- IF
      END EnterInDictionary;

  END MethodDefinition;

END YaflMetDefinition;
