/* Rexx -- PLM.CMD                            */
/* Command file for running the PL/M compiler */
/* Usage: PLM <filename[.PLM]>                */
/* Input: <filename> [.PLM]                   */
/* Output: <filename>.HEX in the current directory */
/*         <filename>.PRN  "  "    "        "      */
/* Do not use filenames of the type "fort.n"       */
/*    these are reserved for the quirky f2c IO     */

'@echo off'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Parse Arg Input
Parse Var Input base '.' ext
i = Lastpos('\',base)
If i=0 
Then b=base 
Else b=Substr(base,i+1)

If ext='' Then ext='PLM' 
Input  = base || '.' || ext
Output = b    || '.' || 'HEX'
List   = b    || '.' || 'PRN'

rc = SysFileDelete('fort.1')
rc = SysFileDelete('fort.2')
rc = SysFileDelete('fort.4')
rc = SysFileDelete('fort.7')
rc = SysFileDelete('fort.11')
rc = SysFileDelete('fort.12')
rc = SysFileDelete('fort.16')
rc = SysFileDelete('fort.17')

/**** PASS1 ****/
'copy dummy fort.1'
'copy' Input 'fort.2' 
'PLM81'

/*** PASS2 ****/
'copy fort.16 fort.4'
'copy fort.17 fort.7'
'PLM82'
'copy fort.12' List
'copy fort.17' Output
rc = SysFileDelete('fort.1')
rc = SysFileDelete('fort.2')
rc = SysFileDelete('fort.4')
rc = SysFileDelete('fort.7')
rc = SysFileDelete('fort.11')
rc = SysFileDelete('fort.12')
rc = SysFileDelete('fort.16')
rc = SysFileDelete('fort.17')


Exit
