//=======================================================================
//	videapp.cpp:	Source for videApp class
//=======================================================================

#include "videapp.h"		// Header file
#include <v/vos.h>	// <v/vos.h>

//=========================>>> videApp::videApp <<<==========================
  videApp::videApp(char* name, int sdi, int h, int w) : vApp(name, sdi, h, w)
  {
    // Constructor

     _videCmdWin = 0;
     _videMkFile[0] = 0;
#ifdef DEVEL
     _emulation = See;
#else
     _emulation = Generic;
#endif
  }

//=========================>>> videApp::videApp <<<==========================
  videApp::~videApp()
  {
    // Desstructor
//   if (_videCmdWin)
//	delete _videCmdWin;
  }

//=====================>>> videApp::NewAppWin <<<==========================
  vWindow* videApp::NewAppWin(vWindow* win, char* name,
    int w, int h, vAppWinInfo* winInfo)
  {
    vAppWinInfo* awinfo = winInfo;
    char *appname = name;

    if (!*name)
      {
	 appname = "V Text Editor";		// Default name
      }
	
    UserDebug1(Build,"videApp::NewAppWin(%s)\n",appname);

    // Create the first window using provided CmdWindow if passed

    vWindow* cw = win;	// Pointer to instance of passed window

    if (cw != 0 && _videCmdWin == 0)
        _videCmdWin = (videCmdWindow*) cw;		// remember this first window

    if (!cw)
      {
	cw = new videCmdWindow(appname, w, h);
      }

    if (!awinfo)
	awinfo = new vAppWinInfo(appname);

    vWindow* rv = vApp::NewAppWin(cw, appname, w, h, awinfo);
    return rv;
  }

//============================>>> videApp::Exit <<<===========================
  void videApp::Exit(void)
  {
    // This is called to close all windows.

    UserDebug(Build,"videApp::Exit()\n");

    vApp::Exit();		// Default behavior
  }

//============================>>> videApp::SetMkFile <<<===========================
  void videApp::SetMkFile(char* mkf)
  {
    // update our global variable CWD and update any open windows
    vOS vos;
    BOOL hadpath = false;
    char temp[maxFileNameSize + 2];

    if (strlen(mkf) < maxFileNameSize)
      {
	for (char* cp = mkf ; *cp ; ++cp)
	    if (*cp == '/' || *cp == '\\')
	      {
		hadpath = true;
		break;
	      }
	if (hadpath)
	    strcpy(_videMkFile, mkf);
	else
	  {
	    vos.vGetCWD(temp,maxFileNameSize);
	    strcpy(_videMkFile, temp); strcat(_videMkFile,"/");
	    strcat(_videMkFile,mkf);
	  }
      }
    else
        strcpy(_videMkFile,"Makefile");

    if (hadpath)
      {
    strcpy(temp,_videMkFile);
    int ix = strlen(temp);		// strip Makefile part
    while (ix > 0)
      {
        if (temp[ix] == '/' || temp[ix] == '\\')
          {
            temp[ix] = 0;
            break;
          }
        --ix;
      }

    vos.vChDir(temp);			// we will work out of that directory
      }
    theApp->SendWindowCommandAll(m_updateMkFile, 0, C_Button);
  }

//======================>>> videApp::CloseAppWin <<<===========================
  int videApp::CloseAppWin(vWindow* win)
  {
    // This will be called BEFORE a window has been unregistered or
    // closed.  Default behavior: unregister and close the window.

    videCmdWindow* cw = (videCmdWindow*)win;
    if (cw->CheckClose())
        return vApp::CloseAppWin(win);
    else
        return 0;
  }

//=====================>>> videApp::AppCommand <<<==============================
  void videApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)
  {
    // Commands not processed by the window will be passed here

    UserDebug1(Build,"videApp::AppCmd(ID: %d)\n",id);
    vApp::AppCommand(win, id, val, cType);
  }

//=========================>>> videApp::KeyIn <<<==============================
  void videApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
  {
    // Key strokes not processed by the window will be passed here

    vApp::KeyIn(win, key, shift);
  }

//###########################################################################

  static videApp vide_App("The V VIDE (0.2) for GNU g++");	// The instance of the app

//============================>>> AppMain <<<==============================
  int AppMain(int argc, char** argv)
  {
#if defined (V_VersionX) || defined (V_VersionOS2)
    (((videApp*)theApp)->DefaultFont).SetFontValues(vfFixed,10);	// use Courier rathern than default
#else
    (((videApp*)theApp)->DefaultFont).SetFontValues(vfFixed,10,vfNormal,vfBold);	// use Courier rathern than default
#endif
    // Use AppMain to create the main window
    videCmdWindow* cw = new videCmdWindow("No Makefile Specified", 80, 12);
    (void) theApp->NewAppWin((vWindow*) cw,
                "No Makefile Specified", 80, 12, 0);

    (((videApp*)theApp)->GetMsgWindow())->SetTitle("No Makefile Specified");
    (((videApp*)theApp)->GetMsgWindow())->AddLine("------------ V IDE ------------");
    (((videApp*)theApp)->GetMsgWindow())->SetRdOnly(1);

    if (strstr(argv[0],"vsee") != 0)
	((videApp*)theApp)->SetEmulation(See);

    theApp->CheckEvents();	// make sure window up
    if (argc > 1)
      {
        for (int ix = 1 ; ix < argc ; ++ix)
	  {
	    if (argv[ix][0] == '-' || argv[ix][0] == '/')	// switch
	      {
		switch (argv[ix][1])
		  {
		    case 'e':
		    case 'E':
		      {
			switch (argv[ix][2])
			  {
			    case 's':
			    case 'S':
			      {
				((videApp*)theApp)->SetEmulation(See);
				break;
			      }
			    default:
				break;
			  }
			break;
		      }	// case 'e'

		    default:
			break;
		  }
	      }
	    else	// a file name: project or source
	      {
		// for now, open everything as a file. Evenutally
		// treat .vpjs special

		videCmdWindow* cmdw = (videCmdWindow*)
		theApp->NewAppWin(0,"V Text Editor", 80, 24);
		if (!cmdw)
		    break;
		if (!cmdw->OpenFile(argv[ix]))
		  {
		    delete cmdw;
		    break;
		  }
		else
		  {
		    cmdw->RaiseWindow();
		  }

		cmdw->SetSyntaxType(cmdw,argv[ix],0);
		cmdw->vedCanvas->Verify();
		cmdw->ChangeInsMode(1);
	      }
	  }
      }
    else
      {

      }
//    cw->WindowCommand(M_SetEmulation,
//		(ItemVal)((vedApp*)theApp)->GetEmulation(),(CmdType)0);
    return 0;
  }
